/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.cache.ormrpc;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.bos.service.ORMServiceLocation;
import com.kingdee.shr.compensation.cache.ormrpc.IORMRPCCmpSmsCodeCache;
import com.kingdee.shr.compensation.cache.ormrpc.impl.ORMRPCCmpSmsCodeCache;
import com.kingdee.util.StringUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class CmpSmsCodeCacheService {
    private static final String LICENSE_SERVER_LOCATION = "license";
    private static final Logger logger = Logger.getLogger(CmpSmsCodeCacheService.class);
    private static volatile CmpSmsCodeCacheService instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CmpSmsCodeCacheService getInstance() throws BOSException {
        if (instance != null) return instance;
        Class<CmpSmsCodeCacheService> clazz = CmpSmsCodeCacheService.class;
        synchronized (CmpSmsCodeCacheService.class) {
            if (instance != null) return instance;
            instance = new CmpSmsCodeCacheService();
            String mainInstanceName = instance.getMainInstanceName();
            if (StringUtils.isEmpty((String)mainInstanceName) || mainInstanceName.equals(System.getProperty("EAS_INSTANCE_NAME"))) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
            ScheduledExecutorService expireCodeClearService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("Cmp_SMS_Code_Clear").build());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            calendar.add(6, 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            int dis = (int)((calendar.getTimeInMillis() - System.currentTimeMillis()) / 3600000L);
            expireCodeClearService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    logger.info((Object)"Started cleaning up Cmp_SMS_Code_Clear ");
                    try {
                        instance.clearExpireCode();
                    }
                    catch (BOSException e) {
                        logger.error((Object)"", (Throwable)e);
                    }
                    logger.info((Object)"End clearing Cmp_SMS_Code_Clear");
                }
            }, dis + 1, 24L, TimeUnit.HOURS);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private CmpSmsCodeCacheService() {
    }

    public String putCode(String phonenum, String code, long expireTime) throws BOSException {
        IORMRPCCmpSmsCodeCache cache = this.getCache();
        String result = cache.put(phonenum, code, expireTime);
        if (logger.isDebugEnabled()) {
            System.out.println("---CmpSmsCodeCacheService----server = " + System.getProperty("EAS_INSTANCE_NAME") + "  ; result = " + result);
        }
        return result;
    }

    public String getCode(String phonenum) throws BOSException {
        IORMRPCCmpSmsCodeCache cache = this.getCache();
        String result = cache.get(phonenum);
        if (logger.isDebugEnabled()) {
            System.out.println("---CmpSmsCodeCacheService----server = " + System.getProperty("EAS_INSTANCE_NAME") + "  ; result = " + result);
        }
        return result;
    }

    public int clearExpireCode() throws BOSException {
        IORMRPCCmpSmsCodeCache cache = this.getCache();
        return cache.clearExpireCode();
    }

    public String clearCodeByPhonenum(String phonenum) throws BOSException {
        IORMRPCCmpSmsCodeCache cache = this.getCache();
        return cache.clearCode(phonenum);
    }

    private IORMRPCCmpSmsCodeCache getCache() throws BOSException {
        String url = CmpSmsCodeCacheService.getORMRPCServerURL();
        ORMRPCCmpSmsCodeCache bosObject = null;
        bosObject = url == null || url.trim().equals("") || url.equalsIgnoreCase("tcp://127.0.0.1") ? new ORMRPCCmpSmsCodeCache() : RPCEngineFactory.getEngine((String)url).createObject("com.kingdee.shr.compensation.cache.ormrpc.impl.ORMRPCCmpSmsCodeCache", IORMRPCCmpSmsCodeCache.class);
        IORMRPCCmpSmsCodeCache cache = bosObject;
        return cache;
    }

    private static String getORMRPCServerURL() throws BOSException {
        ORMServiceLocation loc = new ORMServiceLocation(LICENSE_SERVER_LOCATION);
        try {
            return loc.getServiceURL();
        }
        catch (Exception err) {
            throw new BOSException("Invalidate config file! please make sure you have the config item about NetCtrl!", (Throwable)err);
        }
    }

    public String getMainInstanceName() throws BOSException {
        IORMRPCCmpSmsCodeCache cache = this.getCache();
        return cache.getMainInstanceName();
    }
}

