/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.calculate.retrospect;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.CalFormulaCollection;
import com.kingdee.shr.compensation.CalFormulaFactory;
import com.kingdee.shr.compensation.CalFormulaInfo;
import com.kingdee.shr.compensation.CmpItemCollection;
import com.kingdee.shr.compensation.CmpItemDataType;
import com.kingdee.shr.compensation.CmpItemFactory;
import com.kingdee.shr.compensation.CmpItemInfo;
import com.kingdee.shr.compensation.calculate.combine.calData.CmpQueryConfigService;
import com.kingdee.shr.compensation.calculate.helper.CallculateCacheTool;
import com.kingdee.shr.compensation.calculate.retrospect.obj.CalBase;
import com.kingdee.shr.validaterule.FormulaFuncCollection;
import com.kingdee.shr.validaterule.FormulaFuncFactory;
import com.kingdee.shr.validaterule.FormulaFuncInfo;
import com.kingdee.shr.validaterule.FormulaFuncReturnType;
import com.kingdee.shr.validaterule.FormulaVarCollection;
import com.kingdee.shr.validaterule.FormulaVarFactory;
import com.kingdee.shr.validaterule.FormulaVarInfo;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class RetrospectHelper {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.calculate.retrospect.RetrospectHelper");
    private static final String CAL_RETROSPECT_FUNCTION = "CAL_RETROSPECT_FUNCTION";
    private static final String CAL_RETROSPECT_STRUCTURE = "CAL_RETROSPECT_STRUCTURE";
    private static final String CAL_RETROSPECT_CMPQUERYCONFIG = "CAL_RETROSPECT_CMPQUERYCONFIG";

    public static Map<String, CalBase> getCmpItem(Context ctx) throws BOSException {
        HashMap<String, CalBase> itemMap = new HashMap<String, CalBase>();
        CmpItemCollection c = CmpItemFactory.getLocalInstance(ctx).getCmpItemCollection("SELECT FIELDSN, NAME, DATATYPE ");
        for (int i = 0; i < c.size(); ++i) {
            CmpItemInfo cmpItemInfo = c.get(i);
            CalBase b = new CalBase();
            b.setName(cmpItemInfo.getName());
            b.setIsNumeric(cmpItemInfo.getDataType().equals((Object)CmpItemDataType.NUMBER));
            itemMap.put("T_HR_SCMPCALTABLE_S" + cmpItemInfo.getFieldSn(), b);
        }
        return itemMap;
    }

    public static Map<String, CalFormulaInfo> getFormulaContent(Context ctx, String schemeId) throws BOSException {
        HashMap<String, CalFormulaInfo> map = new HashMap<String, CalFormulaInfo>();
        String oql = "select id, name, content, description where calScheme.id = '" + schemeId + "'";
        CalFormulaCollection coll = CalFormulaFactory.getLocalInstance(ctx).getCalFormulaCollection(oql);
        for (int i = 0; i < coll.size(); ++i) {
            map.put(coll.get(i).getId().toString(), coll.get(i));
        }
        return map;
    }

    public static Map<String, String> getCmpCalItem(Context ctx, String schemeId) throws BOSException {
        HashMap<String, String> formulaMap = new HashMap<String, String>();
        CalFormulaCollection c = CalFormulaFactory.getLocalInstance(ctx).getCalFormulaCollection("SELECT id, CALITEM WHERE CALSCHEME.ID = '" + schemeId + "' and calItem is not null ");
        for (int i = 0; i < c.size(); ++i) {
            formulaMap.put(c.get(i).getId().toString(), "T_HR_SCMPCALTABLE_" + c.get(i).getCalItem().toUpperCase());
        }
        return formulaMap;
    }

    /*
     * Unable to fully structure code
     */
    public static Map<String, CalBase> getTempTable(Context ctx, String schemeId) throws BOSException {
        map = new HashMap<String, CalBase>();
        str = new StringBuilder();
        c = CalFormulaFactory.getLocalInstance(ctx).getCalFormulaCollection("select listTable where calScheme.id = '" + schemeId + "' ");
        for (i = 0; i < c.size(); ++i) {
            listTable = c.get(i).getListTable();
            if (StringUtils.isEmpty((String)listTable)) continue;
            str.append("'").append(listTable.split("~")[1]).append("',");
        }
        if (str.length() < 1) {
            return map;
        }
        tempIds = str.substring(0, str.length() - 1);
        define = null;
        params = null;
        names = null;
        types = null;
        sql = "SELECT FID, FDEFINE, FPARAMDEFINES, FPARAMNAMES, FPARAMTYPES FROM T_HR_SFORMULATMPTABLE WHERE FID IN ( " + tempIds + " )";
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        block3: while (true) {
            try {
                if (!rowSet.next()) break;
                define = rowSet.getString("FDEFINE").toUpperCase(ctx.getLocale());
                params = rowSet.getString("FPARAMDEFINES");
                names = rowSet.getString("FPARAMNAMES");
                types = rowSet.getString("FPARAMTYPES");
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            if (StringUtils.isEmpty((String)params)) continue;
            paramArr = params.split(",");
            nameArr = null == names ? new String[]{} : names.split(",");
            typeArr = null == types ? new String[]{} : types.split(",");
            i = 0;
            while (true) {
                if (i < paramArr.length) ** break;
                continue block3;
                b = new CalBase();
                number = define + "_" + paramArr[i].toUpperCase(ctx.getLocale());
                b.setNumber(number);
                b.setName(nameArr.length == paramArr.length ? "[" + number + "]" + nameArr[i] : "[" + number + "]");
                b.setIsNumeric(typeArr.length == paramArr.length ? !"String".equalsIgnoreCase(typeArr[i]) : false);
                map.put(number, b);
                ++i;
            }
            break;
        }
        return map;
    }

    public static Map<String, String> getCmpQueryConfigField(Context ctx) throws BOSException {
        Object data = CallculateCacheTool.getFromCache(CAL_RETROSPECT_CMPQUERYCONFIG);
        if (null != data) {
            return (Map)data;
        }
        Map<String, String> tableMap = CmpQueryConfigService.getClientAndTableMap(ctx);
        String shortCode = LocaleUtils.getShortCode((Context)ctx);
        HashMap<String, String> queryMap = new HashMap<String, String>();
        StringBuilder str = new StringBuilder();
        str.append(" SELECT T0.FALIAS_" + shortCode + " ALIAS, T1.FNUMBER, T2.FCLIENTNUMBER ");
        str.append(" FROM T_HR_SCMPQUERYCONFIGFIELD T0 ");
        str.append(" INNER JOIN T_HR_StructureConfigColumns T1 ON T0.FFACTFIELDID = T1.FID ");
        str.append(" INNER JOIN T_HR_STRUCTURECONFIG T2 ON T1.FSTRUCTURECONFIGID = T2.FID ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        try {
            while (rowSet.next()) {
                String clientNumber = rowSet.getString("FCLIENTNUMBER").toUpperCase();
                String number = rowSet.getString("FNUMBER").toUpperCase();
                queryMap.put(tableMap.get(clientNumber) + "_" + clientNumber + "_" + number, rowSet.getString("ALIAS"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        CallculateCacheTool.addToCache(queryMap, CAL_RETROSPECT_CMPQUERYCONFIG);
        return queryMap;
    }

    public static Map<String, CalBase> getStructureField(Context ctx) throws BOSException {
        HashMap<String, CalBase> structureMap = new HashMap<String, CalBase>();
        ColumnInfo column = null;
        PropertyInfo propertyInfo = null;
        Object data = CallculateCacheTool.getFromCache(CAL_RETROSPECT_STRUCTURE);
        if (null != data) {
            return (Map)data;
        }
        String shortCode = LocaleUtils.getShortCode((Context)ctx).toUpperCase();
        StringBuilder str = new StringBuilder();
        str.append(" SELECT QU.FTABLENAME, CO.FCLIENTNUMBER, CO.FENTITYNAME ");
        str.append(" FROM T_HR_SCMPQUERYCONFIG QU ");
        str.append(" INNER JOIN T_HR_STRUCTURECONFIG CO ON QU.FSTRUCTUREID = CO.FID ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        try {
            while (rowSet.next()) {
                String entity = rowSet.getString("FENTITYNAME");
                String prefix = rowSet.getString("FTABLENAME").toUpperCase() + "_" + rowSet.getString("FCLIENTNUMBER").toUpperCase() + "_";
                EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entity));
                PropertyCollection collection = entityInfo.getInheritedNoDuplicatedProperties();
                int size = collection.size();
                for (int i = 0; i < size; ++i) {
                    propertyInfo = collection.get(i);
                    column = propertyInfo.getMappingField();
                    if (column == null || !(propertyInfo instanceof OwnPropertyInfo)) continue;
                    CalBase b = new CalBase();
                    b.setName(prefix + propertyInfo.getName().toUpperCase());
                    b.setIsNumeric(false);
                    if (((OwnPropertyInfo)propertyInfo).isMultilingual()) {
                        structureMap.put(prefix + propertyInfo.getMappingField().getName().toUpperCase() + "_" + shortCode, b);
                        continue;
                    }
                    structureMap.put(prefix + propertyInfo.getMappingField().getName().toUpperCase(), b);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        CallculateCacheTool.addToCache(structureMap, CAL_RETROSPECT_STRUCTURE);
        return structureMap;
    }

    public static Map<String, CalBase> getCalFunctions(Context ctx) throws BOSException {
        HashMap<String, CalBase> map = new HashMap<String, CalBase>();
        Object data = CallculateCacheTool.getFromCache(CAL_RETROSPECT_FUNCTION);
        if (null != data) {
            return (Map)data;
        }
        FormulaFuncCollection coll = FormulaFuncFactory.getLocalInstance((Context)ctx).getFormulaFuncCollection("select name, description, returnType");
        for (int i = 0; i < coll.size(); ++i) {
            String param;
            FormulaFuncInfo formulaFuncInfo = coll.get(i);
            String name = formulaFuncInfo.getName();
            String desc = formulaFuncInfo.getDescription();
            if (!StringUtils.isEmpty((String)desc)) {
                int index;
                int enIndex = desc.indexOf("(");
                int cnIndex = desc.indexOf("\uff08");
                if (enIndex < 0 && cnIndex < 0) continue;
                int n = enIndex < 0 ? cnIndex : (cnIndex < 0 ? enIndex : (index = enIndex < cnIndex ? enIndex : cnIndex));
                String brackets = enIndex < 0 ? "\uff09" : (cnIndex < 0 ? ")" : (enIndex < cnIndex ? ")" : "\uff09"));
                param = desc.substring(index + 1, desc.indexOf(brackets));
            } else {
                param = "";
            }
            CalBase b = new CalBase();
            b.setName(param);
            b.setIsNumeric(formulaFuncInfo.getReturnType().equals((Object)FormulaFuncReturnType.NUM));
            map.put(name, b);
        }
        CallculateCacheTool.addToCache(map, CAL_RETROSPECT_FUNCTION);
        return map;
    }

    public static Map<String, CalBase> getTempVariable(Context ctx, String calSchemeId) throws BOSException {
        HashMap<String, CalBase> map = new HashMap<String, CalBase>();
        StringBuilder str = new StringBuilder();
        CalFormulaCollection formulaCollection = CalFormulaFactory.getLocalInstance(ctx).getCalFormulaCollection("select id, listVar where calScheme.id = '" + calSchemeId + "' ");
        for (int i = 0; i < formulaCollection.size(); ++i) {
            String[] varArr;
            String varStr = formulaCollection.get(i).getListVar();
            if (StringUtils.isEmpty((String)varStr)) continue;
            for (String s : varArr = varStr.split(";")) {
                str.append(",'").append(s.split("~")[1]).append("'");
            }
        }
        if (str.length() < 1) {
            return map;
        }
        String ids = str.substring(1);
        FormulaVarCollection varCollection = FormulaVarFactory.getLocalInstance((Context)ctx).getFormulaVarCollection("where id in (" + ids + ")");
        for (int i = 0; i < varCollection.size(); ++i) {
            FormulaVarInfo info = varCollection.get(i);
            CalBase calBase = new CalBase();
            calBase.setName(info.getName());
            calBase.setNumber(info.getDefine());
            calBase.setIsNumeric(info.getType().equals((Object)FormulaFuncReturnType.NUM));
            map.put(calBase.getNumber(), calBase);
        }
        return map;
    }
}

