/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.currency.repCurrency;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.compensation.CalSchemeFactory;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.app.currencyReport.CalSchemeReportCollection;
import com.kingdee.shr.compensation.app.currencyReport.CalSchemeReportFactory;
import com.kingdee.shr.compensation.app.currencyReport.CalSchemeReportInfo;
import com.kingdee.shr.compensation.app.currencyReport.RepCalState;
import com.kingdee.shr.compensation.app.currencyReport.ReportCurrencySetFactory;
import com.kingdee.shr.compensation.app.currencyReport.ReportCurrencySetInfo;
import com.kingdee.shr.compensation.currency.repCurrency.RepCurrencyInitHelper;
import com.kingdee.shr.compensation.currency.repCurrency.calRef.ReportDataGenerator;
import com.kingdee.shr.compensation.currency.repCurrency.calRef.ReportDataHelper;
import com.kingdee.shr.compensation.currency.repCurrency.calRef.impl.DiffCurGenerator;
import com.kingdee.shr.compensation.currency.repCurrency.calRef.impl.SameCurGenerator;
import com.kingdee.shr.compensation.util.CmpCacheUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class RepCurrencyManager {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.currency.repCurrency.RepCurrencyManager");
    private static volatile RepCurrencyManager instance = null;

    private RepCurrencyManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RepCurrencyManager getInstance() {
        if (instance != null) return instance;
        Class<RepCurrencyManager> clazz = RepCurrencyManager.class;
        synchronized (RepCurrencyManager.class) {
            if (instance != null) return instance;
            instance = new RepCurrencyManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void initRefData(Context ctx) throws Exception {
        if (!this.checkNessery(ctx)) {
            return;
        }
        CmpCacheUtil.setCacheMap(ctx, "6vS7SKM/TBCPlQIB4S/8Uy3awhY=", null);
        RepCurrencyInitHelper helper = new RepCurrencyInitHelper(ctx);
        helper.initSchemeRepData();
        helper.sysRepTableConstruct();
    }

    public void dowithCheckOut(Context ctx, String cmpSchemeId, int periodYear, int periodMonth, int calTime) throws EASBizException, BOSException {
        if (!this.checkNessery(ctx)) {
            return;
        }
        ReportCurrencySetInfo reportCurrencySetInfo = ReportCurrencySetFactory.getLocalInstance((Context)ctx).getReportCurrencySetInfo((IObjectPK)new ObjectUuidPK("6vS7SKM/TBCPlQIB4S/8Uy3awhY="));
        String periodStr = periodYear + "-" + periodMonth + "-01";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date periodDate = null;
        try {
            periodDate = simpleDateFormat.parse(periodStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (reportCurrencySetInfo.getBeginDate().after(periodDate)) {
            return;
        }
        Object currency = CmpCacheUtil.getCacheMap(ctx, "6vS7SKM/TBCPlQIB4S/8Uy3awhY=");
        if (currency == null) {
            currency = reportCurrencySetInfo.getCurrency();
        }
        CalSchemeInfo calSchemeInfo = CalSchemeFactory.getLocalInstance(ctx).getCalSchemeInfo("select currency,beginDate,endDate where id = '" + cmpSchemeId + "'");
        CalSchemeReportInfo newInfo = new CalSchemeReportInfo();
        newInfo.setCalscheme(calSchemeInfo);
        newInfo.setBeginDate(calSchemeInfo.getBeginDate());
        newInfo.setEndDate(calSchemeInfo.getEndDate());
        newInfo.setCalCurrency(calSchemeInfo.getCurrency());
        newInfo.setRepCurrency((CurrencyInfo)currency);
        newInfo.setRepCalState(RepCalState.NOT_CALCULATED);
        newInfo.setPeriodYear(periodYear);
        newInfo.setPeriodMonth(periodMonth);
        newInfo.setCalTime(calTime);
        this.deleteRefRepData(ctx, cmpSchemeId, periodYear, periodMonth, calTime);
        CalSchemeReportFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)newInfo);
    }

    private void deleteRefRepData(Context ctx, String cmpschemeid, int checkYear, int checkMonth, int checkTime) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("delete from T_HR_SCalSchemeRep ");
        StringBuffer tempSql = new StringBuffer();
        tempSql.append(" where fcalschemeid = '").append(cmpschemeid);
        tempSql.append("' and fperiodyear = ").append(checkYear);
        tempSql.append(" and fperiodmonth = ").append(checkMonth);
        tempSql.append(" and fcaltime = ").append(checkTime);
        sql.append(tempSql);
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("delete from T_HR_SCmpCalTableRep where FCalTableID in (select fid from t_hr_scmpcaltable ");
        sql.append(tempSql).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    public void dowithRevCheckOut(Context ctx, String cmpschemeid, int checkYear, int checkMonth, int checkTime) throws BOSException {
        if (!this.checkNessery(ctx)) {
            return;
        }
        this.deleteRefRepData(ctx, cmpschemeid, checkYear, checkMonth, checkTime);
    }

    public boolean checkNessery(Context ctx) {
        boolean nessery = false;
        Object currency = CmpCacheUtil.getCacheMap(ctx, "6vS7SKM/TBCPlQIB4S/8Uy3awhY=");
        try {
            if (currency == null) {
                ReportCurrencySetInfo reportCurrencySetInfo = ReportCurrencySetFactory.getLocalInstance((Context)ctx).getReportCurrencySetInfo((IObjectPK)new ObjectUuidPK("6vS7SKM/TBCPlQIB4S/8Uy3awhY="));
                if (reportCurrencySetInfo.getCurrency() != null) {
                    CmpCacheUtil.setCacheMap(ctx, "6vS7SKM/TBCPlQIB4S/8Uy3awhY=", reportCurrencySetInfo.getCurrency());
                    nessery = true;
                }
            } else {
                nessery = true;
            }
        }
        catch (EASBizException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
        }
        return nessery;
    }

    public void repCurrencyCaculate(Context ctx, CalSchemeReportCollection coll) throws Exception {
        ReportDataHelper helper = new ReportDataHelper(ctx);
        helper.init();
        SameCurGenerator dataGenerator = new SameCurGenerator(ctx, new DiffCurGenerator(), helper);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            ((ReportDataGenerator)dataGenerator).dataGenerate(coll.get(i));
        }
        dataGenerator.commit();
    }

    public void repCurrencyCaculate(Context ctx, List<String> ids) throws Exception {
        String converCollectionToSql = CmpStrUtil.convertCollectionToSql(ids);
        String ksql = "select calscheme,periodYear,periodMonth,calTime,calCurrency,repCurrency,beginDate,endDate where id in (" + converCollectionToSql + ")";
        CalSchemeReportCollection coll = CalSchemeReportFactory.getLocalInstance((Context)ctx).getCalSchemeReportCollection(ksql);
        this.repCurrencyCaculate(ctx, coll);
    }
}

