/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.dataplatform.budget.bashboard.combine;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.compensation.dataplatform.budget.bashboard.InputParamInfo;
import com.kingdee.shr.compensation.dataplatform.budget.bashboard.OrgUnitBudgetInfo;
import com.kingdee.shr.compensation.dataplatform.budget.bashboard.combine.AbstractCombineData;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;

public abstract class DashBoardForAnnual
extends AbstractCombineData {
    public DashBoardForAnnual(Context ctx, InputParamInfo paramInfo) {
        super(ctx, paramInfo);
    }

    @Override
    public BigDecimal getUsed(Context ctx) throws BOSException {
        return this.getBookSummary(ctx, this.standingItems).add(this.externalUsed);
    }

    @Override
    public BigDecimal getExternalUsed(Context ctx) throws BOSException {
        this.orgExternalUsed = new HashMap();
        BigDecimal sum = new BigDecimal(0);
        BigDecimal zero = new BigDecimal(0);
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        if (CmpStrUtil.isEmpty(this.budgetItems)) {
            return zero;
        }
        String fields = this.budgetItems.substring(0, this.budgetItems.length() - 1).replaceAll("T", "");
        String sql = " select sum(FUsedAmount) amount, org.fid  from T_HR_SCmpUsedAmount am  inner join T_ORG_Admin org on am.FAdminOrgUnitID = org.fid  where FTemplateID = ? and FBudgetYear = ?  and (org.FLongNumber = '" + this.paramInfo.getLongNumber() + "'  or org.FLongNumber like '" + this.paramInfo.getLongNumber() + "!%')  and org.fid in (" + SHRUserOrgPermissionApi.getUserHeadOfDepartmentAdminRangeSQL((Context)ctx, (String)userId, (String)this.paramInfo.getPermId()) + ")  and FCmpBudgetItemID in (select fid from T_HR_SCmpBudgetItem where FieldSn in (" + fields + ")) group by org.fid ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{this.paramInfo.getTemplateId(), this.paramInfo.getYear()});
        try {
            while (rowSet.next()) {
                sum = sum.add(rowSet.getBigDecimal(1));
                this.orgExternalUsed.put(rowSet.getString(2), rowSet.getBigDecimal(1));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return sum;
    }

    @Override
    public BigDecimal getResidue(Context ctx) throws BOSException {
        return this.getBookSummary(ctx, this.balanceItems);
    }

    @Override
    public BigDecimal getMax(Context ctx) throws BOSException {
        return this.getBudgetSummary(ctx, this.budgetItems);
    }

    protected BigDecimal getBookSummary(Context ctx, String items) throws BOSException {
        String sql = " from T_HR_SCmpStandingBook book  inner join T_HR_SBudgetManage man on book.FBudgetManageID = man.fid  inner join T_ORG_Admin adminOrgUnit on man.FAdminOrgUnitID = adminOrgUnit.fid  inner join T_HR_SCmpBudgetScheme sch on man.FBudgetSchemeID = sch.fid  where sch.FTemplateID = ? and man.FBudgetYear = ? ";
        return this.combineSummary(ctx, items, "book", sql, new Object[]{this.paramInfo.getTemplateId(), this.paramInfo.getYear()});
    }

    @Override
    public List<OrgUnitBudgetInfo> getOrgUnitBudgetInfo(Context ctx, boolean isAll) throws BOSException {
        StringBuilder sb = new StringBuilder();
        sb.append(" from T_HR_SBudgetManage man ");
        sb.append(" inner join T_HR_SCmpStandingBook book on man.fid = book.FBudgetManageID ");
        sb.append(" inner join T_HR_SCmpBudgetScheme sch on man.FBudgetSchemeID = sch.fid ");
        sb.append(" inner join T_ORG_Admin adminOrgUnit on man.FAdminOrgUnitID = adminOrgUnit.fid ");
        sb.append(" where sch.FTemplateID = ? and man.FBudgetYear = ? ");
        return this.getOrgUnitBudgetInfo(ctx, isAll, sb.toString(), new Object[]{this.paramInfo.getTemplateId(), this.paramInfo.getYear()});
    }

    protected BigDecimal getBudgetSummary(Context ctx, String budgetItems) throws BOSException {
        String sql = " from T_HR_SBudgetManage man  inner join T_ORG_Admin adminOrgUnit on man.FAdminOrgUnitID = adminOrgUnit.fid  inner join T_HR_SCmpBudgetScheme sch on man.FBudgetSchemeID = sch.fid  where sch.FTemplateID = ? and man.FBudgetYear = ? ";
        return this.combineSummary(ctx, budgetItems, "man", sql, new Object[]{this.paramInfo.getTemplateId(), this.paramInfo.getYear()});
    }
}

