/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.dataplatform.budgetstatistic.factory;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.dto.BudgetItemDTO;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.dto.BudgetItemMappingDTO;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.dto.BudgetServiceParam;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.factory.BaseBudgetDataServiceProcessor;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class SalaryBudgetDataServiceProcessor
extends BaseBudgetDataServiceProcessor {
    public SalaryBudgetDataServiceProcessor(Context ctx, BudgetServiceParam budgetServiceParam) throws BOSException {
        super(ctx, budgetServiceParam);
    }

    @Override
    protected List<BudgetItemMappingDTO> initBudgetItemConfig() throws BOSException {
        HashMap<String, BudgetItemMappingDTO> budgetItemConfig = new HashMap<String, BudgetItemMappingDTO>();
        String l = LocaleUtils.getShortCode((Locale)this.ctx.getLocale());
        String sql = "select distinct cbi.fid as budgetItemId,cbi.fName_" + l + " as budgetItemName,cbi.fieldsn as budgetItemSn, sbi.fid as standingItemId,sbi.fName_" + l + " as standingItemName,sbi.fieldsn as standingItemSn, bli.fid as balanceItemId,bli.fName_" + l + " as balanceItemName,bli.fieldSn as balanceItemSn, bdc.FDeduNode as FDeduNode  from T_HR_SBudgetDeductionConfig bdc  inner join T_HR_SBudgetTemplateSTBItem btstb on bdc.FCmpBudgetItemRelID = btstb.fid  inner join T_HR_SStandingBookItem sbi on btstb.FStandingBookItemID = sbi.fid  inner join T_HR_SCmpBudgetItem cbi on btstb.FCmpBudgetItemId = cbi.fid  inner join T_HR_SStandingBookItem bli on btstb.FBalanceLedgerItemID = bli.fid  where btstb.FTemplateID = ? ";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])new Object[]{this.budgetServiceParam.getTemplateInfo().getId().toString()});
            while (rs.next()) {
                String budgetIemId = rs.getString("budgetItemId");
                BudgetItemMappingDTO budgetItemMappingDTO = (BudgetItemMappingDTO)budgetItemConfig.get(budgetIemId);
                if (budgetItemMappingDTO == null) {
                    budgetItemMappingDTO = new BudgetItemMappingDTO(new BudgetItemDTO(budgetIemId, rs.getInt("budgetItemSn"), rs.getString("budgetItemName")));
                    budgetItemConfig.put(budgetIemId, budgetItemMappingDTO);
                }
                budgetItemMappingDTO.addStandingItem(new BudgetItemDTO(rs.getString("standingItemId"), rs.getInt("standingItemSn"), rs.getString("standingItemName")));
                int deduNode = rs.getInt("FDeduNode");
                if (deduNode != 100) continue;
                budgetItemMappingDTO.setBalanceItem(new BudgetItemDTO(rs.getString("balanceItemId"), rs.getInt("balanceItemSn"), rs.getString("balanceItemName")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return new ArrayList<BudgetItemMappingDTO>(budgetItemConfig.values());
    }
}

