/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.intelligent.biz;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsHeader;
import com.kingdee.shr.compensation.PersonTaxUnitFactory;
import com.kingdee.shr.compensation.PersonTaxUnitInfo;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelCatalogInfo;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelState;
import com.kingdee.shr.compensation.app.intelligent.CmpTaxMatchDataCollection;
import com.kingdee.shr.compensation.app.intelligent.CmpTaxMatchDataFactory;
import com.kingdee.shr.compensation.app.intelligent.CmpTaxMatchDataInfo;
import com.kingdee.shr.compensation.app.tax.TaxUnitInfo;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import java.sql.Date;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CmpTaxMatchProcessHelper {
    private static Logger logger = Logger.getLogger(CmpTaxMatchProcessHelper.class);
    private static final String INCREACE_CATALOG = "yElVXa5TlE6YTVAhnoDKlwB4WXA=";
    public static final int INCREACE = 1;
    private static final String DECREACE_CATALOG = "Ie8njLsRKEm3zedbBZyFnwB4WXA=";
    public static final int DECREACE = 0;
    private static CmpTaxMatchProcessHelper instance = null;

    private CmpTaxMatchProcessHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CmpTaxMatchProcessHelper getInstance() {
        Class<CmpTaxMatchProcessHelper> clazz = CmpTaxMatchProcessHelper.class;
        synchronized (CmpTaxMatchProcessHelper.class) {
            if (instance == null) {
                instance = new CmpTaxMatchProcessHelper();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public BatchMessageTipsHeader doBatchDeal(Context ctx, String ids, int type) throws BOSException, EASBizException {
        String oql = "select person.id,changeDate,taxUnit,handleDate,cmpIntelCatalog,state where id in " + CmpStrUtil.buildInSql(ids) + " order by person.id,changeDate";
        CmpTaxMatchDataCollection coll = CmpTaxMatchDataFactory.getLocalInstance((Context)ctx).getCmpTaxMatchDataCollection(oql);
        return this.doBatchDeal(ctx, coll, type);
    }

    public BatchMessageTipsHeader doBatchDeal(Context ctx, CmpTaxMatchDataCollection coll, int type) throws BOSException, EASBizException {
        BatchMessageTipsHeader batchMessageTipsHeader = new BatchMessageTipsHeader();
        if (coll == null || coll.size() == 0) {
            return batchMessageTipsHeader;
        }
        int success = 0;
        int failure = 0;
        CoreBaseCollection cmpTaxMatchDataColls = new CoreBaseCollection();
        StringBuilder ids = new StringBuilder();
        String m1 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpIntelResource", (String)"label88", (Locale)ctx.getLocale());
        String m2 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpIntelResource", (String)"label89", (Locale)ctx.getLocale());
        String m3 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpIntelResource", (String)"label90", (Locale)ctx.getLocale());
        String m4 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpIntelResource", (String)"label91", (Locale)ctx.getLocale());
        String m5 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpIntelResource", (String)"label92", (Locale)ctx.getLocale());
        for (int i = 0; i < coll.size(); ++i) {
            BatchMessageTipsBody body = new BatchMessageTipsBody();
            CmpTaxMatchDataInfo cmpTaxMatchDataInfo = coll.get(i);
            if (i != 0) {
                ids.append(",");
            }
            ids.append(cmpTaxMatchDataInfo.getId());
            body.setId(cmpTaxMatchDataInfo.getId().toString());
            if (cmpTaxMatchDataInfo.getState() == CmpIntelState.CONFIRMED) {
                ++failure;
                body.setMuitTipsState(Boolean.FALSE.booleanValue());
                body.setMuitTipsMessage(m1);
                batchMessageTipsHeader.addResult(body);
                continue;
            }
            if (cmpTaxMatchDataInfo.getState() == CmpIntelState.ABANDON) {
                ++failure;
                body.setMuitTipsState(Boolean.FALSE.booleanValue());
                body.setMuitTipsMessage(m2);
                batchMessageTipsHeader.addResult(body);
                continue;
            }
            PersonTaxUnitInfo personTaxUnitInfo = null;
            if (type == 0) {
                personTaxUnitInfo = this.doDecreaceTaxDeal(ctx, cmpTaxMatchDataInfo);
            } else if (type == 1) {
                personTaxUnitInfo = this.doIncreaceTaxDeal(ctx, cmpTaxMatchDataInfo);
            }
            if (personTaxUnitInfo != null) {
                PersonTaxUnitFactory.getLocalInstance(ctx).save((CoreBaseInfo)personTaxUnitInfo);
                cmpTaxMatchDataInfo.setState(CmpIntelState.CONFIRMED);
                cmpTaxMatchDataColls.add((CoreBaseInfo)cmpTaxMatchDataInfo);
                ++success;
                body.setMuitTipsState(Boolean.TRUE.booleanValue());
                body.setMuitTipsMessage(m3);
                batchMessageTipsHeader.addResult(body);
                continue;
            }
            ++failure;
            body.setMuitTipsState(Boolean.FALSE.booleanValue());
            String mes = null;
            if (type == 0) {
                mes = m4;
            } else if (type == 1) {
                mes = m5;
            }
            body.setMuitTipsMessage(mes);
            batchMessageTipsHeader.addResult(body);
        }
        CmpTaxMatchDataFactory.getLocalInstance((Context)ctx).update(cmpTaxMatchDataColls);
        batchMessageTipsHeader.setBillId(ids.toString());
        batchMessageTipsHeader.setSuccessCount(success);
        batchMessageTipsHeader.setFailureCount(failure);
        return batchMessageTipsHeader;
    }

    public void doAutomaticalDeal(Context ctx) throws BOSException, EASBizException {
        String oql = "select person.id,changeDate,taxUnit,handleDate,cmpIntelCatalog where dealType = 0 and isHandled = 0 order by person,handleDate,changeDate,cmpIntelCatalog.index";
        CmpTaxMatchDataCollection coll = CmpTaxMatchDataFactory.getLocalInstance((Context)ctx).getCmpTaxMatchDataCollection(oql);
        if (coll == null || coll.size() == 0) {
            return;
        }
        CoreBaseCollection cmpTaxMatchDataColls = new CoreBaseCollection();
        for (int i = 0; i < coll.size(); ++i) {
            CmpTaxMatchDataInfo cmpTaxMatchDataInfo = coll.get(i);
            this.doExcuteTaxDeal(ctx, cmpTaxMatchDataInfo);
            cmpTaxMatchDataColls.add((CoreBaseInfo)cmpTaxMatchDataInfo);
        }
        CmpTaxMatchDataFactory.getLocalInstance((Context)ctx).update(cmpTaxMatchDataColls);
    }

    private void doExcuteTaxDeal(Context ctx, CmpTaxMatchDataInfo cmpTaxMatchDataInfo) throws BOSException, EASBizException {
        CmpIntelCatalogInfo cmpIntelCatalog = cmpTaxMatchDataInfo.getCmpIntelCatalog();
        PersonTaxUnitInfo personTaxUnitInfo = null;
        if (INCREACE_CATALOG.equals(cmpIntelCatalog.getId().toString())) {
            personTaxUnitInfo = this.doIncreaceTaxDeal(ctx, cmpTaxMatchDataInfo);
        } else if (DECREACE_CATALOG.equals(cmpIntelCatalog.getId().toString())) {
            personTaxUnitInfo = this.doDecreaceTaxDeal(ctx, cmpTaxMatchDataInfo);
        }
        cmpTaxMatchDataInfo.setIsHandled(true);
        cmpTaxMatchDataInfo.setState(personTaxUnitInfo != null ? CmpIntelState.CONFIRMED : CmpIntelState.UNCONFIRMED);
        if (personTaxUnitInfo != null) {
            PersonTaxUnitFactory.getLocalInstance(ctx).save((CoreBaseInfo)personTaxUnitInfo);
        }
    }

    private PersonTaxUnitInfo doDecreaceTaxDeal(Context ctx, CmpTaxMatchDataInfo cmpTaxMatchDataInfo) throws BOSException {
        TaxUnitInfo taxUnit = cmpTaxMatchDataInfo.getTaxUnit();
        java.util.Date handleDate = cmpTaxMatchDataInfo.getHandleDate();
        PersonInfo person = cmpTaxMatchDataInfo.getPerson();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)CmpTaxMatchProcessHelper.getDecreaceCheckSql(), (Object[])new Object[]{person.getId().toString(), taxUnit.getId().toString(), handleDate, handleDate});
        try {
            if (rs.next()) {
                PersonTaxUnitInfo personTaxUnitInfo = new PersonTaxUnitInfo();
                personTaxUnitInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                personTaxUnitInfo.setLEFFDT(handleDate);
                return personTaxUnitInfo;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private static String getDecreaceCheckSql() {
        return "select fid,FLEFFDT from T_HR_SPersonTaxUnit where fpersonid = ? and ftaxUnitid = ? and FLEFFDT >= ? and FEFFDT <= ? ";
    }

    private static String getIncreaceCheckSql() {
        return "select fid,fpersonid,FEFFDT,FLEFFDT from T_HR_SPersonTaxUnit where fpersonid = ? and ftaxUnitid = ? and (FLEFFDT >= ? and FEFFDT <= ? or FEFFDT > ?) order by FLEFFDT desc";
    }

    private PersonTaxUnitInfo doIncreaceTaxDeal(Context ctx, CmpTaxMatchDataInfo cmpTaxMatchDataInfo) throws BOSException {
        TaxUnitInfo taxUnit = cmpTaxMatchDataInfo.getTaxUnit();
        java.util.Date handleDate = cmpTaxMatchDataInfo.getHandleDate();
        PersonInfo person = cmpTaxMatchDataInfo.getPerson();
        java.util.Date monthBeginDate = CmpDateUtil.getMonthBeginDate(handleDate);
        java.util.Date monthEndDate = CmpDateUtil.getMonthEndDate(handleDate);
        Date sqlBeginDate = new Date(monthBeginDate.getTime());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)CmpTaxMatchProcessHelper.getIncreaceCheckSql(), (Object[])new Object[]{person.getId().toString(), taxUnit.getId().toString(), sqlBeginDate, sqlBeginDate, sqlBeginDate});
        try {
            while (rs.next()) {
                Date lef = rs.getDate("FLEFFDT");
                Date eff = rs.getDate("FEFFDT");
                if (CmpDateUtil.getMaxEndDate().compareTo(lef) == 0) {
                    return null;
                }
                if (eff.compareTo(monthEndDate) > 0) {
                    return null;
                }
                if (lef.compareTo(monthBeginDate) >= 0 && eff.compareTo(monthEndDate) <= 0) {
                    if (CmpDateUtil.compareMonth(lef, handleDate) == 0) {
                        PersonTaxUnitInfo personTaxUnitInfo = new PersonTaxUnitInfo();
                        personTaxUnitInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                        personTaxUnitInfo.setPerson(person);
                        personTaxUnitInfo.setTaxUnit(taxUnit);
                        personTaxUnitInfo.setEFFDT(eff);
                        personTaxUnitInfo.setLEFFDT(CmpDateUtil.getMaxEndDate());
                        return personTaxUnitInfo;
                    }
                    return null;
                }
                if (lef.compareTo(monthBeginDate) >= 0) continue;
                PersonTaxUnitInfo personTaxUnitInfo = new PersonTaxUnitInfo();
                personTaxUnitInfo.setPerson(person);
                personTaxUnitInfo.setTaxUnit(taxUnit);
                personTaxUnitInfo.setEFFDT(handleDate);
                personTaxUnitInfo.setLEFFDT(CmpDateUtil.getMaxEndDate());
                return personTaxUnitInfo;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        PersonTaxUnitInfo personTaxUnitInfo = new PersonTaxUnitInfo();
        personTaxUnitInfo.setPerson(person);
        personTaxUnitInfo.setTaxUnit(taxUnit);
        personTaxUnitInfo.setEFFDT(handleDate);
        personTaxUnitInfo.setLEFFDT(CmpDateUtil.getMaxEndDate());
        return personTaxUnitInfo;
    }
}

