/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.intelligent.translator;

import com.kingdee.shr.compensation.intelligent.dto.CmpF7FilterData;
import com.kingdee.shr.compensation.intelligent.dto.CmpTreeFilterData;
import com.kingdee.shr.compensation.intelligent.translator.AbstractCmpTrans;
import com.kingdee.shr.compensation.intelligent.util.CmpIntelligentUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CmpTransForTree
extends AbstractCmpTrans {
    protected String compareType = "in";

    @Override
    public String getCompareType() {
        String type = super.getCompareType();
        if (CmpStrUtil.isEmpty(type)) {
            return this.compareType;
        }
        return type;
    }

    @Override
    public String translate(String key, String jsonValue) {
        StringBuilder sb = new StringBuilder();
        String link = this.getCompareType();
        CmpTreeFilterData treeData = new CmpTreeFilterData();
        jsonValue = jsonValue.replaceAll(" ", "");
        treeData = CmpIntelligentUtil.getJsonObj(jsonValue, treeData);
        int isIncludeSub = treeData.getIsIncludeSub();
        List<CmpF7FilterData> data = treeData.getData();
        if (isIncludeSub == 1) {
            Map<String, Object> customParam = this.getParam();
            HashMap longNumberMap = (HashMap)customParam.get("longNumberMap");
            String tableName = (String)customParam.get("tableName");
            String likeStr = "in".equals(link) ? "like" : "not like";
            String longNumberStr = this.includeSubHandle(likeStr, data, longNumberMap, tableName);
            sb.append(key + ".id " + link + " " + longNumberStr);
        } else {
            String idStr = this.notIncludeSubHandle(data);
            sb.append(key + ".id " + link + " " + idStr);
        }
        return sb.toString();
    }

    private String notIncludeSubHandle(List<CmpF7FilterData> data) {
        ArrayList<String> ids = new ArrayList<String>();
        String id = "";
        for (CmpF7FilterData f7Data : data) {
            id = CmpIntelligentUtil.uriDecode(f7Data.getId());
            ids.add(id);
        }
        String idStr = "(" + CmpStrUtil.convertListToString(ids) + ")";
        return idStr;
    }

    private String includeSubHandle(String link, List<CmpF7FilterData> data, Map<String, String> longNumberMap, String tableName) {
        StringBuilder sb = new StringBuilder("(select fid from " + tableName + " where 1=1 ");
        String longNumber = "";
        int i = 0;
        String id = "";
        for (CmpF7FilterData filterData : data) {
            if (i == 0) {
                sb.append("and (");
            }
            id = CmpIntelligentUtil.uriDecode(filterData.getId());
            longNumber = longNumberMap.get(id);
            String filterStr = "flongNumber " + link + " '" + longNumber + "%' ";
            sb.append(filterStr);
            if (i == data.size() - 1) {
                sb.append(")");
            } else {
                sb.append(" or ");
            }
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    private String handlerSpecialSymbol(String src) {
        String dest = src.replace("id=", "id='").replace("}]", "'}]");
        return dest;
    }
}

