/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.record.factory.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.cmpdesign.app.v2.mapping.GenCmpAdjDataFromEmpFacadeFactory;
import com.kingdee.shr.compensation.record.assemble.RecordUtil;
import com.kingdee.shr.compensation.record.dto.RecordDataInfo;
import com.kingdee.shr.compensation.record.factory.AbstractEmpOrgRelation;
import com.kingdee.shr.compensation.record.factory.AbstractRecord;
import com.kingdee.shr.compensation.record.util.RecordInstanceFactory;
import com.kingdee.shr.compensation.sql.record.AdjustRecordSQL;
import com.kingdee.shr.compensation.sql.record.RecordCommonSQL;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.SQLHandleUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AdjustEmpOrgRelation
extends AbstractEmpOrgRelation {
    @Override
    public List<String> createEmpOrgRelations(Context ctx, List<RecordDataInfo> empList) throws BOSException, EASBizException {
        ArrayList<String> list = new ArrayList<String>();
        LinkedList<Object[]> paramsList = new LinkedList<Object[]>();
        String insertCols = "fid,FPersonRecordID,FEmpOrgRelationID,FEmpPostExpHisID,FPersonBURelationID,FUseDefault,FEffectDate,FLeffectDate,FPersonId";
        String creRecordSql = SQLHandleUtil.getInsertSql(ctx, "T_HR_SAdjustEmpORelation", insertCols);
        if (null == empList || empList.size() < 1) {
            return list;
        }
        int size = empList.size();
        for (int i = 0; i < size; ++i) {
            Object[] batchParam = new Object[9];
            RecordDataInfo recordDataInfo = empList.get(i);
            String id = BOSUuid.create((String)"D84472F4").toString();
            String empId = recordDataInfo.getEmpOrgRelationId();
            batchParam[0] = id;
            batchParam[1] = recordDataInfo.getRecordId();
            batchParam[2] = empId;
            batchParam[3] = recordDataInfo.getEmpPostExpHisId();
            batchParam[4] = recordDataInfo.getPersonBURelId();
            batchParam[5] = recordDataInfo.getUseDefault();
            batchParam[6] = recordDataInfo.getEffdt().before(recordDataInfo.getEmpEffdt()) ? recordDataInfo.getEmpEffdt() : recordDataInfo.getEffdt();
            batchParam[7] = recordDataInfo.getEmpFLEffdt();
            batchParam[8] = recordDataInfo.getPersonId();
            paramsList.add(batchParam);
            list.add(id);
        }
        try {
            CmpSQLUtil.executeBatch(ctx, creRecordSql, paramsList);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        String updateSql = AdjustRecordSQL.updatePersonRecord(CmpStrUtil.convertListToString(list));
        CmpSQLUtil.execute(ctx, updateSql);
        this.afterCreateEmpOrgRel(ctx, list);
        return list;
    }

    protected void afterCreateEmpOrgRel(Context ctx, List<String> list) {
        if (null == list || 0 == list.size()) {
            return;
        }
        try {
            String adjEmpORelIds = CmpSQLUtil.createInSql(ctx, list, "T_HR_SAdjustEmpORelation", "FID");
            GenCmpAdjDataFromEmpFacadeFactory.getLocalInstance((Context)ctx).genAdjData(adjEmpORelIds);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void loseEmpRelations(Context ctx, Map<String, Date> pbuMap) throws BOSException, EASBizException {
        LinkedList<Object[]> paramsList = new LinkedList<Object[]>();
        String updateSql = SQLHandleUtil.getUpdateSql("T_HR_SAdjustEmpORelation", "FLeffectDate", "FPersonBURelationID", null);
        for (Map.Entry<String, Date> entry : pbuMap.entrySet()) {
            Object[] batchParam = new Object[]{CmpDateUtil.toSqlDate(entry.getValue()), entry.getKey()};
            paramsList.add(batchParam);
            try {
                CmpSQLUtil.executeBatch(ctx, updateSql, paramsList);
            }
            catch (BOSException e) {
                throw new BOSException((Throwable)e);
            }
        }
        String pbuIds = CmpStrUtil.converMapToString(pbuMap);
        RecordUtil.updatePBUState(ctx, pbuIds, 2, false);
    }

    @Override
    public List<String> disableEmpRelations(Context ctx, List<String> recordList) throws BOSException, EASBizException {
        ArrayList<String> list = new ArrayList<String>();
        LinkedList<Object[]> paramsList = new LinkedList<Object[]>();
        String recordIds = CmpStrUtil.convertListToString(recordList);
        String sqlStr = AdjustRecordSQL.getDisableERByRecordSql(recordIds);
        IRowSet rowSet = CmpSQLUtil.executeQuery(ctx, sqlStr.toString());
        try {
            while (rowSet.next()) {
                Object[] params = new Object[]{rowSet.getDate("FLEFFDT"), rowSet.getString("empFid")};
                paramsList.add(params);
                list.add(rowSet.getString("FPersonBURelationID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String udpateSql = SQLHandleUtil.getUpdateSql("T_HR_SAdjustEmpORelation", "FLeffectDate", "fid", null);
        CmpSQLUtil.executeBatch(ctx, udpateSql, paramsList);
        return list;
    }

    @Override
    public void updateEmpOrgRelations(Context ctx, List<RecordDataInfo> empList) throws BOSException {
        StringBuffer str = new StringBuffer();
        LinkedList<Object[]> paramsList = new LinkedList<Object[]>();
        if (null == empList || empList.size() < 1) {
            return;
        }
        String updateSql = SQLHandleUtil.getUpdateSql("T_HR_SAdjustEmpORelation", "FPersonBURelationID,FUseDefault,FEffectDate", "fid", null);
        int size = empList.size();
        for (int i = 0; i < size; ++i) {
            Date empEffdt;
            RecordDataInfo recordDataInfo = empList.get(i);
            Object[] batchParam = new Object[4];
            batchParam[0] = recordDataInfo.getPersonBURelId();
            batchParam[1] = recordDataInfo.getUseDefault();
            Date date = null == recordDataInfo.getEmpEffdt() ? recordDataInfo.getOldFEffDate() : (empEffdt = recordDataInfo.getEmpEffdt().compareTo(recordDataInfo.getOldFEffDate()) >= 0 ? recordDataInfo.getOldFEffDate() : recordDataInfo.getEmpEffdt());
            batchParam[2] = recordDataInfo.getEffdt() == null ? empEffdt : (empEffdt == null ? recordDataInfo.getEffdt() : (empEffdt.after(recordDataInfo.getEffdt()) ? empEffdt : recordDataInfo.getEffdt()));
            batchParam[3] = recordDataInfo.getCmpEmpid();
            paramsList.add(batchParam);
            str.append("'").append(recordDataInfo.getCmpEmpid()).append("',");
        }
        try {
            CmpSQLUtil.executeBatch(ctx, updateSql, paramsList);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        String cmpEmpIds = str.substring(0, str.length() - 1);
        str = new StringBuffer();
        str.append(" update T_HR_SAdjustEmpORelation tt set FLeffectDate = (");
        str.append(" select FLEFFDT from T_HR_EmpOrgRelation t1 ");
        str.append(" where tt.FEmpOrgRelationID = t1.fid) ");
        str.append(" where tt.fid in (" + cmpEmpIds + ") ");
        CmpSQLUtil.execute(ctx, str.toString());
        str = new StringBuffer();
        str.append(" update T_HR_SAdjustPersonRecord tt set FLeffectDate = {ts '2199-12-31'} ");
        str.append(" where exists (select 1 from T_HR_SAdjustEmpORelation t1 where tt.fid = t1.FPersonRecordID ");
        str.append(" and t1.fid in (" + cmpEmpIds + ")) ");
        str.append(" and FLeffectDate < {ts '2199-12-31'} ");
        CmpSQLUtil.execute(ctx, str.toString());
    }

    @Override
    public void undoRelations(Context ctx, String cmpEmpId) throws BOSException, EASBizException {
        String parentId = "";
        String recordId = "";
        int assignType = 0;
        String sql = AdjustRecordSQL.getReocrdInfoByEmpId(cmpEmpId);
        IRowSet rowSet = CmpSQLUtil.executeQuery(ctx, sql);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            while (rowSet.next()) {
                recordId = rowSet.getString("recFid");
                if (!map.containsKey(recordId)) {
                    map.put(recordId, 1);
                    continue;
                }
                map.put(recordId, (Integer)map.get(recordId) + 1);
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                if (!cmpEmpId.equals(rowSet.getString("empFid"))) continue;
                assignType = rowSet.getInt("FAssignType");
                parentId = rowSet.getString("FParentID");
                recordId = rowSet.getString("recFid");
                if ((Integer)map.get(recordId) <= 1) {
                    AbstractRecord recordImpl = RecordInstanceFactory.getRecordInstance(RecordInstanceFactory.CATEGORY.ADJ);
                    recordImpl.addFixAdjustSalaryRecord(ctx, recordId);
                    recordImpl.deleteRecords(ctx, recordId, true);
                    continue;
                }
                if (0 == assignType) {
                    this.deleteRelations(ctx, cmpEmpId);
                    continue;
                }
                this.deleteRelations(ctx, cmpEmpId);
                if (CmpStrUtil.isEmpty(parentId)) continue;
                String recoverPbuId = null;
                String recoverSql = AdjustRecordSQL.getRecoverEmpSql(parentId, recordId);
                rowSet = CmpSQLUtil.executeQuery(ctx, recoverSql);
                try {
                    while (rowSet.next()) {
                        recoverPbuId = rowSet.getString("FPersonBURelationID");
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                if (CmpStrUtil.isEmpty(recoverPbuId)) {
                    return;
                }
                CmpSQLUtil.executeUpdate(ctx, AdjustRecordSQL.updateRecoverEmpSql(recoverPbuId));
                String recoverPBUSql = RecordCommonSQL.getRecoverPBUSql(recoverPbuId);
                CmpSQLUtil.executeUpdate(ctx, recoverPBUSql);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void deleteRelations(Context ctx, String cmpEmpId) throws BOSException, EASBizException {
        CmpSQLUtil.execute(ctx, "delete from T_HR_PersonBURelation where Fid in (select FPersonBURelationID from T_HR_SAdjustEmpORelation where FEmpOrgRelationID = '" + cmpEmpId + "')");
        CmpSQLUtil.execute(ctx, "delete from T_HR_SAdjustEmpORelation where FEmpOrgRelationID = '" + cmpEmpId + "'");
    }

    @Override
    public void deleteRelations(Context ctx, String empId, String recId) throws BOSException, EASBizException {
        String inPbuSql = " select FPersonBURelationID from T_HR_SAdjustEmpORelation where FEmpOrgRelationID = '" + empId + "' and FPersonRecordID = '" + recId + "' ";
        CmpSQLUtil.execute(ctx, "delete from T_HR_PersonBURelation where Fid in (" + inPbuSql + ")");
        CmpSQLUtil.execute(ctx, "delete from T_HR_SAdjustEmpORelation where FEmpOrgRelationID = '" + empId + "' and FPersonRecordID = '" + recId + "' ");
    }
}

