/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.record.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.record.dto.RecordDataInfo;
import com.kingdee.shr.compensation.record.validator.RecordValidator;
import com.kingdee.shr.compensation.record.validator.RocordValidatorInfo;
import com.kingdee.shr.compensation.sql.record.SocRecordSQL;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SocRecordValidator
extends RecordValidator {
    private Logger logger = Logger.getLogger(SocRecordValidator.class);

    @Override
    public RocordValidatorInfo deleteEmpRelation(Context ctx, String empId) throws BOSException, EASBizException {
        RocordValidatorInfo info = null;
        String sql = SocRecordSQL.beforeDeleteEmpRelation(empId, ctx);
        IRowSet rowSet = CmpSQLUtil.executeQuery(ctx, sql);
        try {
            if (rowSet.next()) {
                info = new RocordValidatorInfo();
                info.setCode(rowSet.getString("personId"));
                info.setMsg(EASResource.getString((String)"com.kingdee.shr.compensation.resource.MessageResource", (String)"label18", (Locale)ctx.getLocale()));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return info;
    }

    @Override
    public RecordDataInfo deletePerson(Context ctx, String personId) throws BOSException, EASBizException {
        RecordDataInfo info = new RecordDataInfo();
        String socSql = SocRecordSQL.beforeDeletePerson(personId, ctx);
        IRowSet socRowSet = CmpSQLUtil.executeQuery(ctx, socSql);
        try {
            while (socRowSet.next()) {
                String message = EASResource.getString((String)"com.kingdee.shr.compensation.resource.MessageResource", (String)"label19", (Locale)ctx.getLocale());
                info.setPersonId(personId);
                info.setMsg(message);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return info;
    }

    @Override
    public List<RocordValidatorInfo> loseRecord(Context ctx, String recordIds, Date leffdt) throws BOSException {
        String recFid;
        RocordValidatorInfo validator;
        recordIds = this.getInnerIds(recordIds);
        HashMap<String, RocordValidatorInfo> map = new HashMap<String, RocordValidatorInfo>();
        String socSql = SocRecordSQL.getMaxFileDateByRecord(recordIds, leffdt, ctx);
        IRowSet r = CmpSQLUtil.executeQuery(ctx, socSql);
        String dateStr = "";
        String dateStr1 = "";
        String dateStr2 = "";
        try {
            while (r.next()) {
                validator = new RocordValidatorInfo();
                recFid = r.getString("recFid");
                dateStr1 = CmpDateUtil.getDateStr(r.getDate("FEffectDay"));
                dateStr2 = CmpDateUtil.getDateStr(r.getDate("FEffectDate"));
                validator.setCode(recFid);
                if (!StringUtils.isEmpty((CharSequence)dateStr1)) {
                    validator.setMsg(r.getString("perName") + EASResource.getString((String)"com.kingdee.shr.compensation.resource.MessageResource", (String)"label20", (Locale)ctx.getLocale()) + "\u3010" + dateStr1 + "\u3011" + EASResource.getString((String)"com.kingdee.shr.compensation.resource.MessageResource", (String)"label21", (Locale)ctx.getLocale()) + "\u3010" + dateStr2 + "\u3011");
                } else {
                    validator.setMsg(r.getString("perName") + EASResource.getString((String)"com.kingdee.shr.compensation.resource.MessageResource", (String)"label22", (Locale)ctx.getLocale()) + "\u3010" + dateStr2 + "\u3011");
                }
                map.put(recFid, validator);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)e.getMessage());
        }
        String empSql = SocRecordSQL.getMaxFileEntryDateByRecord(recordIds, leffdt, ctx);
        IRowSet r1 = CmpSQLUtil.executeQuery(ctx, empSql);
        try {
            while (r1.next()) {
                recFid = r1.getString("recFid");
                dateStr = CmpDateUtil.getDateStr(r1.getDate("FEffectDay"));
                if (map.containsKey(recFid)) {
                    validator = (RocordValidatorInfo)map.get(recFid);
                    validator.appendMsg(r1.getString("perName") + EASResource.getString((String)"com.kingdee.shr.compensation.resource.MessageResource", (String)"label23", (Locale)ctx.getLocale()) + "\u3010" + dateStr + "\u3011");
                    continue;
                }
                validator = new RocordValidatorInfo();
                validator.setCode(recFid);
                validator.appendMsg(r1.getString("perName") + EASResource.getString((String)"com.kingdee.shr.compensation.resource.MessageResource", (String)"label23", (Locale)ctx.getLocale()) + "\u3010" + dateStr + "\u3011");
                map.put(recFid, validator);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)e.getMessage());
        }
        ArrayList<RocordValidatorInfo> list = new ArrayList<RocordValidatorInfo>();
        this.getSocPayMapByRecord(ctx, recordIds, leffdt, map);
        for (Map.Entry entry : map.entrySet()) {
            list.add((RocordValidatorInfo)entry.getValue());
        }
        return list;
    }

    private void getSocPayMapByRecord(Context ctx, String recordIds, Date leffdt, Map<String, RocordValidatorInfo> map) throws BOSException {
        Date realEndDate = null;
        ArrayList<String> recordList = new ArrayList<String>();
        Calendar calendar = Calendar.getInstance();
        String sql = SocRecordSQL.getMaxPayDateByRecord(recordIds, ctx);
        try {
            IRowSet rs = CmpSQLUtil.executeQuery(ctx, sql);
            while (rs.next()) {
                RocordValidatorInfo validator;
                String socRecordId = rs.getString("recFid");
                if (recordList.contains(socRecordId)) continue;
                recordList.add(socRecordId);
                int periodYear = rs.getInt("FPeriodYear");
                int periodMonth = rs.getInt("FPeriodMonth");
                calendar.set(1, periodYear);
                calendar.set(2, periodMonth - 1);
                calendar.set(5, calendar.getActualMaximum(5));
                realEndDate = calendar.getTime();
                if (!leffdt.before(realEndDate)) continue;
                if (map.containsKey(socRecordId)) {
                    validator = map.get(socRecordId);
                    validator.appendMsg(EASResource.getString((String)"com.kingdee.shr.compensation.resource.MessageResource", (String)"label24", (Locale)ctx.getLocale()) + ":\u3010" + CmpDateUtil.getDateStr(realEndDate) + "\u3011");
                    continue;
                }
                validator = new RocordValidatorInfo();
                validator.setCode(socRecordId);
                validator.appendMsg(EASResource.getString((String)"com.kingdee.shr.compensation.resource.MessageResource", (String)"label24", (Locale)ctx.getLocale()) + ":\u3010" + CmpDateUtil.getDateStr(realEndDate) + "\u3011");
                map.put(socRecordId, validator);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)e.getMessage());
        }
    }
}

