/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.hr.ats.app.formula.calculate.data.Tools;
import com.kingdee.eas.hr.compensation.util.CmpDateUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CmpExchangeRuleEnum;
import com.kingdee.shr.compensation.CmpPeriodTypeEnum;
import com.kingdee.shr.compensation.FixAdjustSalaryCollection;
import com.kingdee.shr.compensation.FixAdjustSalaryFactory;
import com.kingdee.shr.compensation.FixAdjustSalaryInfo;
import com.kingdee.shr.compensation.app.formula.SalaryCalFunction;
import com.kingdee.shr.compensation.app.formula.common.FunctionTools;
import com.kingdee.shr.compensation.currency.CurrencyUtil;
import com.kingdee.shr.compensation.util.Base64Utils;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.rpts.ctrlreport.osf.OSFExecutor;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CalFunctionService
extends SalaryCalFunction {
    private static final String ADJ_MONEY_STR = "A";
    private static final String ADJ_STD_STR = "B";
    private static final String ADJ_STD_LEVEL_STR = "C";
    private static final String ADJ_STD_POINT_STR = "D";
    private static final String ADJ_STD_SCOPE_STR = "E";
    private static final String ADJ_STD_FLOAT_STR = "F";
    private static final String ADJ_CURRENCY_STR = "G";
    private static final String ADJ_EFFECTDAY_STR = "H";
    private static final String ADJ_LEFFECTDAY_STR = "I";
    private static final String ADJ_CAUSE_STR = "J";
    private static final String ADJ_REMARK_STR = "K";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.service.CalFunctionService");

    public double getDiffWorkDay(String date1, String date2) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        java.util.Date dt = null;
        try {
            dt = df.parse(date1);
            Calendar cal1 = Calendar.getInstance();
            cal1.setTime(dt);
            dt = df.parse(date2);
            Calendar cal2 = Calendar.getInstance();
            cal2.setTime(dt);
            if (cal1.before(cal2)) {
                return CmpDateUtils.getWorkDayOfMonth((java.util.Date)cal1.getTime(), (java.util.Date)cal2.getTime());
            }
            return CmpDateUtils.getWorkDayOfMonth((java.util.Date)cal2.getTime(), (java.util.Date)cal1.getTime());
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public double getMonths(String beginDate, String endDate) {
        int months = 0;
        if (beginDate.equals("") || endDate.equals("")) {
            return -1.0;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        java.util.Date dt = null;
        java.util.Date endDt = null;
        try {
            dt = df.parse(beginDate);
            endDt = df.parse(endDate);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1.0;
        }
        int beginMonth = dt.getMonth();
        int beginYear = dt.getYear();
        int endMonth = endDt.getMonth();
        int endYear = endDt.getYear();
        months = endYear - beginYear >= 0 ? (endYear - beginYear) * 12 + endMonth - beginMonth : Math.abs(endYear - beginYear) * 12 + beginMonth - endMonth;
        return months;
    }

    public int FunGetDiffWorkDay(String date1, String date2) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        java.util.Date dt = null;
        try {
            dt = df.parse(date1);
            Calendar cal1 = Calendar.getInstance();
            cal1.setTime(dt);
            dt = df.parse(date2);
            Calendar cal2 = Calendar.getInstance();
            cal2.setTime(dt);
            if (cal1.before(cal2)) {
                return CmpDateUtils.getWorkDayOfMonth((java.util.Date)cal1.getTime(), (java.util.Date)cal2.getTime());
            }
            return CmpDateUtils.getWorkDayOfMonth((java.util.Date)cal2.getTime(), (java.util.Date)cal1.getTime());
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public double getWorkDayCount(String date1, String date2, Map<String, Object> paramMap, HashMap<String, Object> tempMap, String mainTableRowFilter) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        java.util.Date dt = null;
        Context ctx = com.kingdee.shr.compensation.app.formula.data.Tools.getInstance().getCtx();
        try {
            if (paramMap.get("T_HR_SCMPCALTABLE_FPERSONID") == null) {
                return 0.0;
            }
            String personid = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
            dt = df.parse(date1);
            Calendar cal1 = Calendar.getInstance();
            cal1.setTime(dt);
            dt = df.parse(date2);
            Calendar cal2 = Calendar.getInstance();
            cal2.setTime(dt);
            if (cal2.before(cal1)) {
                return 0.0;
            }
            String key = "getWorkDayCount_" + personid + date1 + date2;
            if (null == tempMap.get(key)) {
                HashMap params = new HashMap();
                ArrayList<String> beginDates = new ArrayList<String>();
                ArrayList<String> endDates = new ArrayList<String>();
                ArrayList<String> personIds = new ArrayList<String>();
                personIds.add(personid);
                beginDates.add(date1);
                endDates.add(date2);
                params.put("beginDates", beginDates);
                params.put("endDates", endDates);
                params.put("personIds", personIds);
                ArrayList data = (ArrayList)OSFExecutor.executeOSF((Context)ctx, params, (String)"getWorkdayCountOSF");
                tempMap.put(key, data);
            }
            if (null == tempMap.get(key)) {
                return 0.0;
            }
            ArrayList list = (ArrayList)tempMap.get(key);
            double workDayCount = 0.0;
            for (int i = 0; i < list.size(); ++i) {
                Map map = (Map)list.get(i);
                if (!map.containsKey(personid)) continue;
                workDayCount = ((Integer)map.get(personid)).intValue();
                break;
            }
            return workDayCount;
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public double FunGetPeriodDay(HashMap<String, Object> tempMap, CalSchemeInfo calScheme, double periodType, double constant, double dayType) throws Exception {
        double days = 0.0;
        int arg0 = (int)periodType;
        int arg1 = (int)constant;
        int arg2 = (int)dayType;
        String temp = "FunGetPeriodDay" + Double.toString(periodType) + Double.toString(constant) + Double.toString(dayType);
        if (tempMap.get(temp) == null) {
            if (arg0 == 20) {
                days = arg2 == 1 ? (double)CmpDateUtils.getWorkDayOfMonth((java.util.Date)new java.util.Date(), (int)arg1) : (double)CmpDateUtils.getDayOfMonth((java.util.Date)new java.util.Date(), (int)arg1);
            } else if (arg0 == 10) {
                java.util.Date beginDate = new java.util.Date();
                java.util.Date endDate = new java.util.Date();
                if (calScheme.getBeginDate() == null || calScheme.getEndDate() == null) {
                    return days;
                }
                beginDate.setTime(calScheme.getBeginDate().getTime());
                endDate.setTime(calScheme.getEndDate().getTime());
                CmpPeriodTypeEnum cmpPeriodType = calScheme.getCmpPeriodType();
                Calendar cal1 = Calendar.getInstance();
                cal1.setTime(beginDate);
                int currday1 = cal1.get(5);
                int day1 = cal1.getActualMaximum(5);
                boolean isLastDayOfBeginDt = false;
                if (currday1 == day1) {
                    isLastDayOfBeginDt = true;
                }
                Calendar cal2 = Calendar.getInstance();
                cal2.setTime(endDate);
                int currday2 = cal2.get(5);
                int day2 = cal2.getActualMaximum(5);
                boolean isLastDayOfEndDt = false;
                if (currday2 == day2) {
                    isLastDayOfEndDt = true;
                }
                if (cmpPeriodType.getValue() == 3) {
                    cal1.add(2, arg1 * 12);
                    cal2.add(2, arg1 * 12);
                } else if (cmpPeriodType.getValue() == 0) {
                    cal1.add(2, arg1 * 6);
                    cal2.add(2, arg1 * 6);
                } else if (cmpPeriodType.getValue() == 1) {
                    cal1.add(2, arg1 * 3);
                    cal2.add(2, arg1 * 3);
                } else if (cmpPeriodType.getValue() == 2) {
                    cal1.add(2, arg1 * 1);
                    cal2.add(2, arg1 * 1);
                }
                int offsetDay1 = cal1.getActualMaximum(5);
                int offsetDay2 = cal2.getActualMaximum(5);
                if (isLastDayOfBeginDt) {
                    cal1.set(5, offsetDay1);
                }
                if (isLastDayOfEndDt) {
                    cal2.set(5, offsetDay2);
                }
                beginDate = cal1.getTime();
                endDate = cal2.getTime();
                days = arg2 == 1 ? (double)CmpDateUtils.getWorkDayOfMonth((java.util.Date)beginDate, (java.util.Date)endDate) : (double)CmpDateUtils.getDayOfMonth((java.util.Date)beginDate, (java.util.Date)endDate);
            }
            tempMap.put(temp, new Double(days));
        } else {
            days = (Double)tempMap.get(temp);
        }
        return days;
    }

    public double FunGetWorkAge(CalSchemeInfo calScheme, String joinDate, int type, int day) {
        double workAge = 0.0;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            java.util.Date start = sdf.parse(joinDate);
            if (calScheme != null && calScheme.getBeginDate() != null && calScheme.getEndDate() != null) {
                java.util.Date end = new java.util.Date();
                if (day == -1) {
                    end.setTime(calScheme.getBeginDate().getTime());
                } else {
                    end.setTime(calScheme.getEndDate().getTime());
                    if (day > 0 && day <= 31) {
                        end.setDate(day);
                    }
                }
                if (start != null && end != null) {
                    int yearSpan = end.getYear() - start.getYear();
                    int monthSpan = yearSpan * 12 + (end.getMonth() - start.getMonth());
                    workAge = type == 1 ? (double)yearSpan : (type == 2 ? (double)(monthSpan / 12) : (double)(monthSpan / 12 - (monthSpan % 12 == 0 && end.getDate() < start.getDate() ? 1 : 0)));
                }
            }
        }
        catch (Exception e) {
            return 0.0;
        }
        return workAge < 0.0 ? 0.0 : workAge;
    }

    public double getAttendanceData(String attendanceItemNumber, String type, Map<String, Object> paramMap, Map<String, Object> tempMap, CalSchemeInfo calSchemeInfo, String mainTableRowFilter) {
        HashMap data = new HashMap();
        if (!calSchemeInfo.isIsAts()) {
            return 0.0;
        }
        Context ctx = com.kingdee.shr.compensation.app.formula.data.Tools.getInstance().getCtx();
        String key = calSchemeInfo.getNumber() + "-" + attendanceItemNumber + "-" + calSchemeInfo.getPeriodYear() + "-" + calSchemeInfo.getPeriodMonth() + "-" + calSchemeInfo.getCalTime() + "-" + type;
        if (tempMap.get(key) == null) {
            String calschemeid = calSchemeInfo.getId().toString();
            String personSql = "select FPersonID from T_HR_SCmpCalTable where FcalSchemeID = '" + calschemeid + "' and FPeriodYear = " + calSchemeInfo.getPeriodYear() + " and FPeriodMonth = " + calSchemeInfo.getPeriodMonth() + " and FCalTime = " + calSchemeInfo.getCalTime();
            if (mainTableRowFilter != null) {
                personSql = personSql + "and " + mainTableRowFilter;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            personSql = Base64Utils.encodeWithSalt(personSql);
            params.put("personId", personSql);
            params.put("projectNumber", attendanceItemNumber);
            params.put("yearValue", String.valueOf(calSchemeInfo.getPeriodYear()));
            params.put("monthValue", String.valueOf(calSchemeInfo.getPeriodMonth()));
            params.put("time", calSchemeInfo.getCalTime() + "");
            params.put("returnType", type);
            try {
                data = (HashMap)OSFExecutor.executeOSF((Context)ctx, params, (String)"getAttenceProjectSummary");
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0.0;
            }
            tempMap.put(key, data);
        } else {
            data = (HashMap)tempMap.get(key);
        }
        String personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        return data.containsKey(personId) ? Double.parseDouble(data.get(personId).toString()) : 0.0;
    }

    public double getEvaluResultScore(Map<String, Object> paramMap, Map<String, Object> tempMap, CalSchemeInfo calSchemeInfo, String mainTableRowFilter) {
        Context ctx = com.kingdee.shr.compensation.app.formula.data.Tools.getInstance().getCtx();
        if (!calSchemeInfo.isIsPerf()) {
            return 0.0;
        }
        String opType = "2";
        String key = "EvaluResult" + calSchemeInfo.getNumber() + "-" + calSchemeInfo.getPeriodYear() + "-" + calSchemeInfo.getPeriodMonth() + "-" + calSchemeInfo.getCalTime() + "-" + opType;
        if (tempMap.get(key) == null) {
            String calSchemeId = calSchemeInfo.getId().toString();
            StringBuffer personSql = new StringBuffer("select per.FNumber from T_HR_SCmpCalTable as t_hr_scmpcaltable inner join T_BD_Person per on t_hr_scmpcaltable.FPersonId = per.Fid where t_hr_scmpcaltable.FcalSchemeID = '").append(calSchemeId).append("'");
            if (mainTableRowFilter != null) {
                personSql.append(" and ").append(mainTableRowFilter);
            }
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("year", String.valueOf(calSchemeInfo.getPeriodYear()));
            param.put("month", String.valueOf(calSchemeInfo.getPeriodMonth()));
            param.put("times", String.valueOf(calSchemeInfo.getCalTime()));
            param.put("oql", personSql.toString());
            param.put("opType", opType);
            List listData = null;
            listData = (List)OSFExecutor.executeOSF((Context)ctx, param, (String)"getEvaluResult");
            tempMap.put(key, listData);
        }
        String personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        List evaluResultData = (List)tempMap.get(key);
        String evalPersonId = "";
        HashMap evalResultMap = null;
        if (null != evaluResultData) {
            for (HashMap map : evaluResultData) {
                evalPersonId = map.containsKey("personId") ? map.get("personId").toString() : "";
                if (!evalPersonId.equals(personId)) continue;
                evalResultMap = map;
                break;
            }
        }
        if (null != evalResultMap) {
            double score = 0.0;
            if (null != evalResultMap.get("score") && !"".equals(evalResultMap.get("score"))) {
                score = Double.parseDouble(evalResultMap.get("score").toString());
            }
            return score;
        }
        return 0.0;
    }

    public String getEvaluResultRank(Map<String, Object> paramMap, Map<String, Object> tempMap, CalSchemeInfo calSchemeInfo, String mainTableRowFilter) {
        Context ctx = com.kingdee.shr.compensation.app.formula.data.Tools.getInstance().getCtx();
        if (!calSchemeInfo.isIsPerf()) {
            return "";
        }
        String opType = "2";
        String key = "EvaluResult" + calSchemeInfo.getNumber() + "-" + calSchemeInfo.getPeriodYear() + "-" + calSchemeInfo.getPeriodMonth() + "-" + calSchemeInfo.getCalTime() + "-" + opType;
        if (tempMap.get(key) == null) {
            String calSchemeId = calSchemeInfo.getId().toString();
            StringBuffer personSql = new StringBuffer("select per.FNumber from T_HR_SCmpCalTable as t_hr_scmpcaltable inner join T_BD_Person per on t_hr_scmpcaltable.FPersonId = per.Fid where t_hr_scmpcaltable.FcalSchemeID = '").append(calSchemeId).append("'");
            if (mainTableRowFilter != null) {
                personSql.append(" and ").append(mainTableRowFilter);
            }
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("year", String.valueOf(calSchemeInfo.getPeriodYear()));
            param.put("month", String.valueOf(calSchemeInfo.getPeriodMonth()));
            param.put("times", String.valueOf(calSchemeInfo.getCalTime()));
            param.put("oql", personSql.toString());
            param.put("opType", opType);
            List listData = null;
            listData = (List)com.kingdee.eas.rpts.ctrlreport.osf.OSFExecutor.executeOSF((Context)ctx, param, (String)"getEvaluResult");
            tempMap.put(key, listData);
        }
        String personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        List evaluResultData = (List)tempMap.get(key);
        String evalPersonId = "";
        HashMap evalResultMap = null;
        if (null != evaluResultData) {
            for (HashMap map : evaluResultData) {
                evalPersonId = map.containsKey("personId") ? map.get("personId").toString() : "";
                if (!evalPersonId.equals(personId)) continue;
                evalResultMap = map;
                break;
            }
        }
        if (null != evalResultMap) {
            String rank = "";
            if (null != evalResultMap.get("rank") && !"".equals(evalResultMap.get("rank"))) {
                rank = evalResultMap.get("rank").toString();
            }
            return rank;
        }
        return "";
    }

    public double getItemSalary(Map<String, Object> paramMap, HashMap<String, Object> tempMap, Map<String, BigDecimal> currencyMap, CalSchemeInfo calScheme, String cmpItem, double isFixed, String mainTableRowFilter) {
        try {
            String key;
            Map fixPayMap = new HashMap();
            String fixPayMapKey = "getItemSalary_fixPayMap_" + isFixed;
            if (StringUtils.isEmpty((String)cmpItem) || paramMap.get("T_HR_SCMPCALTABLE_FPERSONID") == null) {
                return 0.0;
            }
            if (tempMap.get(fixPayMapKey) == null) {
                tempMap.put(fixPayMapKey, this.initFixPayForMoneyMap(currencyMap, calScheme, isFixed, mainTableRowFilter));
            }
            if ((fixPayMap = (Map)tempMap.get(fixPayMapKey)).containsKey(key = paramMap.get("T_HR_SCMPCALTABLE_FPERSONID") + "_" + cmpItem)) {
                BigDecimal money = fixPayMap.containsKey(key) ? (BigDecimal)fixPayMap.get(key) : new BigDecimal(0);
                double pay = money.doubleValue();
                return pay;
            }
            return 0.0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public String getItemStdLevel(Map<String, Object> paramMap, HashMap<String, Object> tempMap, CalSchemeInfo calScheme, String cmpItem, double isFixed, String mainTableRowFilter) {
        try {
            String key;
            Map fixPayMap = new HashMap();
            String fixPayMapKey = "getItemStdLevel_fixPayMap_" + isFixed;
            if (StringUtils.isEmpty((String)cmpItem) || paramMap.get("T_HR_SCMPCALTABLE_FPERSONID") == null) {
                return "";
            }
            if (tempMap.get(fixPayMapKey) == null) {
                tempMap.put(fixPayMapKey, this.initFixPayMap(calScheme, isFixed, mainTableRowFilter));
            }
            if ((fixPayMap = (Map)tempMap.get(fixPayMapKey)).containsKey(key = paramMap.get("T_HR_SCMPCALTABLE_FPERSONID") + "_" + cmpItem)) {
                Map map = (Map)fixPayMap.get(key);
                String stdLevel = map.get("stdLevel").toString();
                return stdLevel;
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getItemStdPoint(Map<String, Object> paramMap, HashMap<String, Object> tempMap, CalSchemeInfo calScheme, String cmpItem, double isFixed, String mainTableRowFilter) {
        try {
            String key;
            Map fixPayMap = new HashMap();
            String fixPayMapKey = "getItemStdPoint_fixPayMap_" + isFixed;
            if (StringUtils.isEmpty((String)cmpItem) || paramMap.get("T_HR_SCMPCALTABLE_FPERSONID") == null) {
                return "";
            }
            if (tempMap.get(fixPayMapKey) == null) {
                tempMap.put(fixPayMapKey, this.initFixPayMap(calScheme, isFixed, mainTableRowFilter));
            }
            if ((fixPayMap = (Map)tempMap.get(fixPayMapKey)).containsKey(key = paramMap.get("T_HR_SCMPCALTABLE_FPERSONID") + "_" + cmpItem)) {
                Map map = (Map)fixPayMap.get(key);
                String stdLevel = null == map.get("stdPoint") ? "" : map.get("stdPoint").toString();
                return stdLevel;
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getItemFloatRate(Map<String, Object> paramMap, HashMap<String, Object> tempMap, CalSchemeInfo calScheme, String cmpItem, double isFixed, String mainTableRowFilter) {
        try {
            String key;
            Map fixPayMap = new HashMap();
            String fixPayMapKey = "getItemFloatRate_fixPayMap_" + isFixed;
            if (StringUtils.isEmpty((String)cmpItem) || paramMap.get("T_HR_SCMPCALTABLE_FPERSONID") == null) {
                return "";
            }
            if (tempMap.get(fixPayMapKey) == null) {
                tempMap.put(fixPayMapKey, this.initFixPayMap(calScheme, isFixed, mainTableRowFilter));
            }
            if ((fixPayMap = (Map)tempMap.get(fixPayMapKey)).containsKey(key = paramMap.get("T_HR_SCMPCALTABLE_FPERSONID") + "_" + cmpItem)) {
                Map map = (Map)fixPayMap.get(key);
                String stdLevel = map.get("floatRate").toString();
                return stdLevel;
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getItemStdScope(Map<String, Object> paramMap, HashMap<String, Object> tempMap, CalSchemeInfo calScheme, String cmpItem, double isFixed, String mainTableRowFilter) {
        try {
            String key;
            Map fixPayMap = new HashMap();
            String fixPayMapKey = "getItemStdScope_fixPayMap_" + isFixed;
            if (StringUtils.isEmpty((String)cmpItem) || paramMap.get("T_HR_SCMPCALTABLE_FPERSONID") == null) {
                return "";
            }
            if (tempMap.get(fixPayMapKey) == null) {
                tempMap.put(fixPayMapKey, this.initFixPayMap(calScheme, isFixed, mainTableRowFilter));
            }
            if ((fixPayMap = (Map)tempMap.get(fixPayMapKey)).containsKey(key = paramMap.get("T_HR_SCMPCALTABLE_FPERSONID") + "_" + cmpItem)) {
                Map map = (Map)fixPayMap.get(key);
                String stdLevel = map.get("stdScope").toString();
                return stdLevel;
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getItemStandard(Map<String, Object> paramMap, HashMap<String, Object> tempMap, CalSchemeInfo calScheme, String cmpItem, double isFixed, String mainTableRowFilter) {
        try {
            String key;
            Map fixPayMap = new HashMap();
            String fixPayMapKey = "getItemStandard_fixPayMap_" + isFixed;
            if (StringUtils.isEmpty((String)cmpItem) || paramMap.get("T_HR_SCMPCALTABLE_FPERSONID") == null) {
                return "";
            }
            if (tempMap.get(fixPayMapKey) == null) {
                tempMap.put(fixPayMapKey, this.initFixPayMap(calScheme, isFixed, mainTableRowFilter));
            }
            if ((fixPayMap = (Map)tempMap.get(fixPayMapKey)).containsKey(key = paramMap.get("T_HR_SCMPCALTABLE_FPERSONID") + "_" + cmpItem)) {
                Map map = (Map)fixPayMap.get(key);
                String standard = map.get("standard").toString();
                return standard;
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getPeriodEnd(CalSchemeInfo calScheme) {
        if (calScheme == null || calScheme.getEndDate() == null) {
            return "";
        }
        java.util.Date end = calScheme.getEndDate();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(end);
    }

    public String getPeriodStart(CalSchemeInfo calScheme) {
        if (calScheme == null || calScheme.getBeginDate() == null) {
            return "";
        }
        java.util.Date start = calScheme.getBeginDate();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(start);
    }

    public double getPersonTaxBy_EndTaxMoeny(double v1, double startMoeny) {
        double v2 = this.getTaxPreMoney(v1, startMoeny);
        double personTax = 0.0;
        if (v2 - startMoeny <= 1500.0) {
            personTax = (v2 - startMoeny) * 0.03;
        }
        personTax = v2 - startMoeny <= 4500.0 ? (v2 - startMoeny) * 0.1 - 105.0 : (v2 - startMoeny <= 9000.0 ? (v2 - startMoeny) * 0.2 - 555.0 : (v2 - startMoeny <= 35000.0 ? (v2 - startMoeny) * 0.25 - 1005.0 : (v2 - startMoeny <= 55000.0 ? (v2 - startMoeny) * 0.3 - 2755.0 : (v2 - startMoeny <= 80000.0 ? (v2 - startMoeny) * 0.35 - 5505.0 : (v2 - startMoeny) * 0.45 - 13505.0))));
        return personTax;
    }

    public double getTaxPreMoney(double v1, double startMoeny) {
        double v2 = 0.0;
        v2 = v1 - startMoeny <= 0.0 ? v1 : (v1 - startMoeny <= 1455.0 ? (v1 - startMoeny - 0.0) / 0.97 + startMoeny : (v1 - startMoeny <= 4155.0 ? (v1 - startMoeny - 105.0) / 0.9 + startMoeny : (v1 - startMoeny <= 7755.0 ? (v1 - startMoeny - 555.0) / 0.8 + startMoeny : (v1 - startMoeny <= 27255.0 ? (v1 - startMoeny - 1005.0) / 0.75 + startMoeny : (v1 - startMoeny <= 41255.0 ? (v1 - startMoeny - 2755.0) / 0.7 + startMoeny : (v1 - startMoeny <= 57505.0 ? (v1 - startMoeny - 5505.0) / 0.65 + startMoeny : (v1 - startMoeny - 13505.0) / 0.55 + startMoeny))))));
        return v2;
    }

    public double getTaxtSumVal(Map<String, Object> paramMap, HashMap<String, Object> tempMap, CalSchemeInfo calSchemeInfo, Map<String, BigDecimal> currencyMap, String mainTableRowFilter, String cmpItem) throws SQLException {
        Map cnSn;
        String sn;
        String personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        String fid = (String)paramMap.get("T_HR_SCMPCALTABLE_FID");
        if (StringUtils.isEmpty((String)cmpItem) || paramMap.get("T_HR_SCMPCALTABLE_FPERSONID") == null) {
            return 0.0;
        }
        String tempMapKey = "taxt_" + cmpItem;
        String tempMapKey2 = "";
        String tempPersonID = "";
        if (tempMap.get("cnSn") == null) {
            tempMap.put("cnSn", this.getCnSn(calSchemeInfo));
        }
        if (StringUtils.isEmpty((String)(sn = (String)(cnSn = (Map)tempMap.get("cnSn")).get(cmpItem)))) {
            return 0.0;
        }
        String fieldSn = "S" + sn;
        if (tempMap.get(tempMapKey) == null) {
            BigDecimal rate = new BigDecimal(1);
            String sql_B = "select fpersonId,fTaxUnitId,FPeriodYear,FPeriodMonth from T_HR_SCmpCalTable where fid='" + fid + "'";
            if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
                sql_B = "select fpersonId,fTaxUnitId,FPeriodYear,FPeriodMonth from T_HR_SCmpCalTable where " + mainTableRowFilter;
            }
            String sumSql = "select A.fpersonId,A.fTaxUnitId,A.FCurrencyID ," + fieldSn + " from T_HR_SCmpCalTable A inner join (" + sql_B + ") as B  on A.fpersonId=B.fpersonId and A.fTaxUnitId=B.fTaxUnitId and  A.FPeriodYear=B.FPeriodYear and A.FPeriodMonth=B.FPeriodMonth where A.FCalState=20 or A.FCalState=12";
            BigDecimal pay = new BigDecimal(0);
            BigDecimal payTemp = new BigDecimal(0);
            Context ctx = com.kingdee.shr.compensation.app.formula.data.Tools.getInstance().getCtx();
            try {
                IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sumSql);
                while (set.next()) {
                    rate = null == currencyMap.get(set.getString("FCurrencyID")) ? new BigDecimal(1) : currencyMap.get(set.getString("FCurrencyID"));
                    tempPersonID = set.getString(1);
                    tempMapKey2 = "taxt_" + tempPersonID + "_" + cmpItem;
                    payTemp = set.getBigDecimal(4) == null ? new BigDecimal(0) : set.getBigDecimal(4);
                    pay = tempMap.get(tempMapKey2) == null ? payTemp.multiply(rate) : ((BigDecimal)tempMap.get(tempMapKey2)).add(payTemp.multiply(rate));
                    tempMap.put(tempMapKey2, pay);
                }
                tempMap.put(tempMapKey, cmpItem);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        double taxtSumVal = 0.0;
        String resultKey = "taxt_" + personId + "_" + cmpItem;
        if (tempMap.get(resultKey) != null) {
            taxtSumVal = tempMap.get(resultKey) == null ? 0.0 : ((BigDecimal)tempMap.get(resultKey)).doubleValue();
        }
        return taxtSumVal;
    }

    public double getYearBonusTax(double curMonthPay, double yearBonus, double startTaxPay) {
        double startPaySpan = 0.0;
        if (curMonthPay < startTaxPay) {
            startPaySpan = startTaxPay - curMonthPay;
        }
        double avgPay = (yearBonus - startPaySpan) / 12.0;
        double taxRate = 0.0;
        double minus = 0.0;
        if (avgPay <= 1500.0) {
            taxRate = 0.03;
            minus = 0.0;
        } else if (avgPay <= 4500.0) {
            taxRate = 0.1;
            minus = 105.0;
        } else if (avgPay <= 9000.0) {
            taxRate = 0.2;
            minus = 555.0;
        } else if (avgPay <= 35000.0) {
            taxRate = 0.25;
            minus = 1005.0;
        } else if (avgPay <= 55000.0) {
            taxRate = 0.3;
            minus = 2755.0;
        } else if (avgPay <= 80000.0) {
            taxRate = 0.35;
            minus = 5505.0;
        } else {
            taxRate = 0.45;
            minus = 13505.0;
        }
        double tax = (yearBonus - startPaySpan) * taxRate - minus;
        return tax > 0.0 ? tax : 0.0;
    }

    private String getHrOrgUnitId(CalSchemeInfo calSchemeInfo) {
        HROrgUnitInfo hrOrgUnitInfo = calSchemeInfo.getHrOrgUnit();
        String hrOrgId = "";
        if (hrOrgUnitInfo != null) {
            hrOrgId = hrOrgUnitInfo.getId().toString();
        }
        return hrOrgId;
    }

    public Map<String, BigDecimal> initFixPayForMoneyMap(Map<String, BigDecimal> currencyMap, CalSchemeInfo calScheme, double isFixed, String mainTableRowFilter) throws Exception {
        boolean isCurrency;
        Context ctx = com.kingdee.shr.compensation.app.formula.data.Tools.getInstance().getCtx();
        String l = calScheme.getLanType().getValue();
        StringBuilder sb = new StringBuilder();
        String effectDayField = "";
        String key = null;
        String personId = "";
        String cmpItem = "";
        HashMap<String, BigDecimal> fixPayMap = new HashMap<String, BigDecimal>();
        HashSet<String> set = new HashSet<String>();
        boolean bl = isCurrency = null != calScheme.getCurrency();
        effectDayField = isFixed == 0.0 ? "calTable.FBeginDate" : (isFixed == 1.0 ? "calTable.FRealEndDate" : "calTable.FEndDate");
        String calschemeid = calScheme.getId().toString();
        int calTime = calScheme.getCalTime();
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        String hrOrgId = calScheme.getHrOrgUnit().getId().toString();
        String personSql = "select FPersonID from T_HR_SCmpCalTable where FcalSchemeID = '" + calschemeid + "' and FcalTime = " + calTime + " and FperiodYear = " + periodYear + " and FperiodMonth = " + periodMonth;
        sb.append(" SELECT DISTINCT CALTABLE.FPERSONID as personId, FIX.FMONEY MONEY, FIX.FCURRENCYID, ");
        sb.append(" CMPITEM.FNAME_" + l + " CMPITEM,FIX.FEFFECTDAY, ");
        sb.append(" ( case when (fix.fpayhrorgunitid is null or fix.fpayhrorgunitid in ('')) then 0  when ( calTable.FHrOrgUnitID= fix.fpayhrorgunitid) then 1 else 2 end ) as type").append("\r\n");
        sb.append(" FROM T_HR_SCMPCALTABLE CALTABLE ");
        sb.append(" INNER JOIN T_HR_SFIXADJUSTSALARY FIX ON CALTABLE.FPERSONID=FIX.FPERSONID AND (FIX.fpayhrorgunitid = '" + hrOrgId + "' OR FIX.fpayhrorgunitid IS NULL)");
        sb.append(" LEFT JOIN T_HR_SCMPITEM CMPITEM ON CMPITEM.FID=FIX.FCMPITEMID ");
        sb.append(" WHERE FIX.feffectday <= ").append(effectDayField).append(" AND FIX.fleffectday >= ").append(effectDayField);
        sb.append(" AND CALTABLE.FHRORGUNITID='").append(hrOrgId).append("'");
        sb.append(" AND CALTABLE.FCALSCHEMEID = '").append(calschemeid).append("' ");
        sb.append(" AND CALTABLE.FPERIODYEAR=");
        sb.append(periodYear).append(" AND CALTABLE.FPERIODMONTH=").append(periodMonth);
        sb.append(" AND CALTABLE.FCALTIME=").append(calTime);
        if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
            String replace = mainTableRowFilter.replace("t_hr_scmpcaltable.fid", "CALTABLE.fid").replace("t_hr_scmpcaltable.FCalState", "CALTABLE.fcalState");
            sb.append(" AND ").append(replace);
        } else {
            sb.append(" AND CALTABLE.FPERSONID IN ( ").append(personSql).append(" )");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        List<Map<String, Object>> dataList = this.getDataFromExecuteQuery(rs, "5");
        Iterator<Map<String, Object>> it = dataList.iterator();
        if (isCurrency) {
            while (it.hasNext()) {
                Map<String, Object> data = it.next();
                String curencyId = (String)data.get("FCURRENCYID");
                personId = (String)data.get("personId");
                cmpItem = (String)data.get("CMPITEM");
                BigDecimal money = (BigDecimal)data.get("MONEY");
                key = personId + "_" + cmpItem;
                if (set.contains(key)) continue;
                set.add(key);
                if (null != curencyId) {
                    BigDecimal rate = null == currencyMap.get(curencyId) ? new BigDecimal(1) : currencyMap.get(curencyId);
                    money = money.multiply(rate);
                }
                fixPayMap.put(key, money);
            }
        } else {
            while (it.hasNext()) {
                Map<String, Object> data = it.next();
                personId = (String)data.get("personId");
                cmpItem = (String)data.get("CMPITEM");
                key = personId + "_" + cmpItem;
                if (set.contains(key)) continue;
                set.add(key);
                BigDecimal money = (BigDecimal)data.get("MONEY");
                fixPayMap.put(key, money);
            }
        }
        return fixPayMap;
    }

    public Map<String, BigDecimal> initFixPayForMoneyMapNew(Map<String, BigDecimal> currencyMap, CalSchemeInfo calScheme, double isFixed, String mainTableRowFilter) throws Exception {
        Context ctx = com.kingdee.shr.compensation.app.formula.data.Tools.getInstance().getCtx();
        String l = calScheme.getLanType().getValue();
        StringBuilder sb = new StringBuilder();
        String effectDayField = "";
        String key = null;
        String personId = "";
        String cmpItem = "";
        HashMap<String, BigDecimal> fixPayMap = new HashMap<String, BigDecimal>();
        HashSet<String> set = new HashSet<String>();
        boolean isCurrency = null != calScheme.getCurrency();
        effectDayField = isFixed == 0.0 ? "calTable.FBeginDate" : "calTable.FRealEndDate";
        String calschemeid = calScheme.getId().toString();
        int calTime = calScheme.getCalTime();
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        String hrOrgId = calScheme.getHrOrgUnit().getId().toString();
        String personSql = "select FPersonID from T_HR_SCmpCalTable where FcalSchemeID = '" + calschemeid + "' and FcalTime = " + calTime + " and FperiodYear = " + periodYear + " and FperiodMonth = " + periodMonth;
        sb.append(" SELECT DISTINCT CALTABLE.FPERSONID as personId, FIX.FMONEY MONEY, FIX.FCURRENCYID, ");
        sb.append(" CMPITEM.FNAME_" + l + " CMPITEM,FIX.FEFFECTDAY, ");
        sb.append(" ( case when (fix.fpayhrorgunitid is null or fix.fpayhrorgunitid in ('')) then 0  when ( calTable.FHrOrgUnitID= fix.fpayhrorgunitid) then 1 else 2 end ) as type").append("\r\n");
        sb.append(" FROM T_HR_SCMPCALTABLE CALTABLE ");
        sb.append(" INNER JOIN T_HR_SFIXADJUSTSALARY FIX ON CALTABLE.FPERSONID=FIX.FPERSONID AND (FIX.fpayhrorgunitid = '" + hrOrgId + "' OR FIX.fpayhrorgunitid IS NULL)");
        sb.append(" LEFT JOIN T_HR_SCMPITEM CMPITEM ON CMPITEM.FID=FIX.FCMPITEMID ");
        sb.append(" WHERE FIX.feffectday <= ").append("calTable.FRealEndDate").append(" AND FIX.fleffectday >= ").append("calTable.FBeginDate");
        sb.append(" AND CALTABLE.FHRORGUNITID='").append(hrOrgId).append("'");
        sb.append(" AND CALTABLE.FCALSCHEMEID = '").append(calschemeid).append("' ");
        sb.append(" AND CALTABLE.FPERIODYEAR=");
        sb.append(periodYear).append(" AND CALTABLE.FPERIODMONTH=").append(periodMonth);
        sb.append(" AND CALTABLE.FCALTIME=").append(calTime);
        if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
            String replace = mainTableRowFilter.replace("t_hr_scmpcaltable.fid", "CALTABLE.fid").replace("t_hr_scmpcaltable.FCalState", "CALTABLE.fcalState");
            sb.append(" AND ").append(replace);
        } else {
            sb.append(" AND CALTABLE.FPERSONID IN ( ").append(personSql).append(" )");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        List<Map<String, Object>> dataList = this.getDataFromExecuteQuery(rs, "5");
        Iterator<Map<String, Object>> it = dataList.iterator();
        if (isCurrency) {
            while (it.hasNext()) {
                Map<String, Object> data = it.next();
                String curencyId = (String)data.get("FCURRENCYID");
                personId = (String)data.get("personId");
                cmpItem = (String)data.get("CMPITEM");
                BigDecimal money = (BigDecimal)data.get("MONEY");
                key = personId + "_" + cmpItem;
                if (set.contains(key)) continue;
                set.add(key);
                if (null != curencyId) {
                    BigDecimal rate = null == currencyMap.get(curencyId) ? new BigDecimal(1) : currencyMap.get(curencyId);
                    money = money.multiply(rate);
                }
                fixPayMap.put(key, money);
            }
        } else {
            while (it.hasNext()) {
                Map<String, Object> data = it.next();
                personId = (String)data.get("personId");
                cmpItem = (String)data.get("CMPITEM");
                key = personId + "_" + cmpItem;
                if (set.contains(key)) continue;
                set.add(key);
                BigDecimal money = (BigDecimal)data.get("MONEY");
                fixPayMap.put(key, money);
            }
        }
        return fixPayMap;
    }

    public Map<String, Map<String, Object>> initFixPayMap(CalSchemeInfo calScheme, double isFixed, String mainTableRowFilter) throws Exception {
        String effectDayField = "";
        effectDayField = isFixed == 0.0 ? CmpDateUtil.toKSqlDate(calScheme.getBeginDate()) : CmpDateUtil.toKSqlDate(calScheme.getEndDate());
        String calschemeid = calScheme.getId().toString();
        int calTime = calScheme.getCalTime();
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        String hrOrgId = calScheme.getHrOrgUnit().getId().toString();
        String l = calScheme.getLanType().getValue();
        StringBuilder sb = new StringBuilder();
        String personSql = "select FPersonID from T_HR_SCmpCalTable where FcalSchemeID = '" + calschemeid + "' and FcalTime = " + calTime + " and FperiodYear = " + periodYear + " and FperiodMonth = " + periodMonth;
        sb.append(" select calTable.fpersonid as personId, fix.FMoney money, stdpoint.fname_" + l + " stdPoint,stdlevel.FloatRate floatRate, ").append("\r\n");
        sb.append(" stdlevel.fname_" + l + " stdLevel,scope.fname_" + l + " stdScope,standard.fname_" + l + " standard,cmpItem.fname_" + l + " cmpItem,fix.FEffectDay,payHr.FLEFFDT, ").append("\r\n");
        sb.append(" calTable.FRealEndDate, calTable.FBeginDate, ");
        sb.append(" ( case when (payHr.FHrOrgUnitID is null or payHr.FHrOrgUnitID in ('')) then 0  when ( payHr.FHrOrgUnitID = '" + hrOrgId + "') then 1 else 2 end ) as type").append("\r\n");
        sb.append(" from t_hr_scmpcaltable calTable ").append("\r\n");
        sb.append(" inner join T_HR_SFixAdjustSalary fix on calTable.fpersonid=fix.fpersonid ").append("\r\n");
        sb.append(" inner join T_HR_SFixAdjustPayHrRecord payHr on fix.fid = payHr.fsourceid and (payHr.FHrOrgUnitID = '" + hrOrgId + "' or (payHr.FHrOrgUnitID is null or payHr.FHrOrgUnitID in ('')))").append("\r\n");
        sb.append(" left join T_HR_SCmpStdPoint stdpoint on fix.FStdPointID=stdpoint.fid ").append("\r\n");
        sb.append(" left join T_HR_SCmpStdLevel stdlevel on fix.FStdLevelId=stdlevel.fid ").append("\r\n");
        sb.append(" left join T_HR_SCmpStdScope scope on fix.FStdScopeID=scope.fid ").append("\r\n");
        sb.append(" left join T_HR_SCmpStandard standard on fix.FStandardId=standard.fid ").append("\r\n");
        sb.append(" left join t_hr_scmpitem cmpItem on cmpItem.fid=fix.FCmpItemID ").append("\r\n");
        sb.append(" where payHr.FEFFDT <= ").append(effectDayField);
        sb.append(" and calTable.FHrOrgUnitID='");
        sb.append(hrOrgId).append("'");
        sb.append(" and calTable.FCalSchemeId = '").append(calschemeid).append("' ");
        sb.append(" and calTable.FperiodYear=");
        sb.append(periodYear).append(" and calTable.FperiodMonth=").append(periodMonth).append("\r\n");
        sb.append(" and calTable.FcalTime=").append(calTime);
        if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
            String replace = mainTableRowFilter.replace("t_hr_scmpcaltable.fid", "calTable.fid").replace("t_hr_scmpcaltable.FCalState", "calTable.fcalState");
            sb.append(" and ").append(replace);
        } else {
            sb.append(" and calTable.fpersonid in(").append(personSql).append(")");
        }
        sb.append(" order by payHr.FEFFDT desc ");
        Context ctx = com.kingdee.shr.compensation.app.formula.data.Tools.getInstance().getCtx();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        List<Map<String, Object>> dataList = this.getDataFromExecuteQuery(rs, "1");
        Map<String, Object> map = null;
        Iterator<Map<String, Object>> it = dataList.iterator();
        String key = null;
        double money = 0.0;
        String personId = "";
        String cmpItem = "";
        String stdPoint = "";
        String floatRate = "";
        String stdLevel = "";
        String stdScope = "";
        String standard = "";
        HashMap<String, Object> fixMap = null;
        HashMap<String, Map<String, Object>> fixPayMap = new HashMap<String, Map<String, Object>>();
        HashSet<String> set = new HashSet<String>();
        while (it.hasNext()) {
            java.util.Date endDate;
            map = it.next();
            fixMap = new HashMap<String, Object>();
            personId = (String)map.get("personId");
            cmpItem = (String)map.get("cmpItem");
            key = personId + "_" + cmpItem;
            java.util.Date leffdt = (java.util.Date)map.get("FLEFFDT");
            if (leffdt.before(endDate = isFixed == 0.0 ? (java.util.Date)map.get("FBeginDate") : (java.util.Date)map.get("FRealEndDate")) || set.contains(key)) continue;
            set.add(key);
            money = ((BigDecimal)map.get("money")).doubleValue();
            stdPoint = (String)map.get("stdPoint");
            floatRate = (String)map.get("floatRate");
            stdLevel = (String)map.get("stdLevel");
            stdScope = (String)map.get("stdScope");
            standard = (String)map.get("standard");
            fixMap.put("money", money);
            fixMap.put("stdPoint", stdPoint);
            fixMap.put("floatRate", floatRate);
            fixMap.put("stdLevel", stdLevel);
            fixMap.put("stdScope", stdScope);
            fixMap.put("standard", standard);
            fixPayMap.put(key, fixMap);
        }
        return fixPayMap;
    }

    @Deprecated
    public Map<String, Map<String, Object>> initFixPayMapbak(CalSchemeInfo calScheme, double isFixed, String mainTableRowFilter) throws Exception {
        String calschemeid = calScheme.getId().toString();
        java.util.Date beginDate = calScheme.getBeginDate();
        java.util.Date endDate = calScheme.getEndDate();
        int calTime = calScheme.getCalTime();
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        String hrOrgId = this.getHrOrgUnitId(calScheme);
        String personSql = "select FPersonID from T_HR_SCmpCalTable where FcalSchemeID = '" + calschemeid + "' and FcalTime = " + calTime + " and FperiodYear = " + periodYear + " and FperiodMonth = " + periodMonth;
        if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
            personSql = personSql + " and " + mainTableRowFilter;
        }
        Context ctx = com.kingdee.shr.compensation.app.formula.data.Tools.getInstance().getCtx();
        java.util.Date effectDay = beginDate;
        effectDay = isFixed == 0.0 ? beginDate : endDate;
        SelectorItemCollection sels = new SelectorItemCollection();
        sels.add(new SelectorItemInfo("cmpItem.name"));
        sels.add(new SelectorItemInfo("cmpItem.fieldSn"));
        sels.add(new SelectorItemInfo("money"));
        sels.add(new SelectorItemInfo("stdLevel.name"));
        sels.add(new SelectorItemInfo("stdLevel.floatRate"));
        sels.add(new SelectorItemInfo("stdPoint.name"));
        sels.add(new SelectorItemInfo("stdScope.name"));
        sels.add(new SelectorItemInfo("standard.name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personSql, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("effectDay", (Object)effectDay, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("payHrOrgUnit", (Object)hrOrgId, CompareType.EQUALS));
        SorterItemCollection coll = new SorterItemCollection();
        SorterItemInfo sItem = new SorterItemInfo("effectDay");
        sItem.setSortType(SortType.ASCEND);
        SorterItemInfo createTimeItem = new SorterItemInfo("createTime");
        createTimeItem.setSortType(SortType.ASCEND);
        coll.add(sItem);
        coll.add(createTimeItem);
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sels);
        view.setFilter(filter);
        view.setSorter(coll);
        FixAdjustSalaryCollection srs = FixAdjustSalaryFactory.getLocalInstance(ctx).getFixAdjustSalaryCollection(view);
        String key = null;
        FixAdjustSalaryInfo fixAdjustSalaryInfo = null;
        HashMap<String, Map<String, Object>> fixPayMap = new HashMap<String, Map<String, Object>>();
        for (int i = 0; i < srs.size(); ++i) {
            HashMap<String, Object> fixMap = new HashMap<String, Object>();
            fixAdjustSalaryInfo = srs.get(i);
            key = fixAdjustSalaryInfo.getPerson().getId().toString() + "_" + fixAdjustSalaryInfo.getCmpItem().getName();
            fixMap.put("money", null != fixAdjustSalaryInfo.getMoney() ? fixAdjustSalaryInfo.getMoney().doubleValue() : 0.0);
            fixMap.put("stdPoint", null != fixAdjustSalaryInfo.getStdPoint() ? fixAdjustSalaryInfo.getStdPoint().getName() : "");
            fixMap.put("floatRate", null != fixAdjustSalaryInfo.getStdLevel() ? fixAdjustSalaryInfo.getStdLevel().getFloatRate() : "");
            fixMap.put("stdLevel", null != fixAdjustSalaryInfo.getStdLevel() ? fixAdjustSalaryInfo.getStdLevel().getName() : "");
            fixMap.put("stdScope", null != fixAdjustSalaryInfo.getStdScope() ? fixAdjustSalaryInfo.getStdScope().getName() : "");
            fixMap.put("standard", null != fixAdjustSalaryInfo.getStandard() ? fixAdjustSalaryInfo.getStandard().getName() : "");
            fixPayMap.put(key, fixMap);
        }
        return fixPayMap;
    }

    public Map<String, Object> innitPersonSegmentedSalaryInfo(Map<String, BigDecimal> currencyMap, CalSchemeInfo calScheme, String cmpItem, String name, Double standardWorkdays, String mainTableRowFilter) throws Exception {
        Map<String, Object> salaryMap = new HashMap<String, Object>();
        java.util.Date beginDate = calScheme.getBeginDate();
        java.util.Date endDate = calScheme.getEndDate();
        String querySql = this.getSegmentedSalarySQL(cmpItem, calScheme, mainTableRowFilter);
        Context ctx = com.kingdee.shr.compensation.app.formula.data.Tools.getInstance().getCtx();
        try {
            Map fixMap;
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)querySql);
            HashMap map = new HashMap();
            List<Map<String, Object>> dataList = this.getDataFromExecuteQuery(executeQuery, "2");
            Iterator<Map<String, Object>> it = dataList.iterator();
            Map<String, Object> dataListMap = null;
            while (it.hasNext()) {
                dataListMap = it.next();
                fixMap = new HashMap<String, Object>();
                String key = (String)dataListMap.get("personId");
                fixMap.put("personId", (String)dataListMap.get("personId"));
                fixMap.put("money", ((BigDecimal)dataListMap.get("money")).toString());
                fixMap.put("effectDay", (java.util.Date)dataListMap.get("effectDay"));
                fixMap.put("itemName", (String)dataListMap.get("itemName"));
                fixMap.put("currencyId", (String)dataListMap.get("FCURRENCYID"));
                if (map.containsKey(key)) {
                    ((List)map.get(key)).add(fixMap);
                    continue;
                }
                ArrayList<HashMap<String, Object>> fixList = new ArrayList<HashMap<String, Object>>();
                fixList.add((HashMap<String, Object>)fixMap);
                map.put(key, fixList);
            }
            HashMap<String, List<Map<String, Object>>> allMap = new HashMap<String, List<Map<String, Object>>>();
            for (Map.Entry entry : map.entrySet()) {
                String currencyId;
                int i;
                SimpleDateFormat smdf = new SimpleDateFormat("yyyy-MM-dd");
                String tempEnd = null;
                Double money = 0.0;
                String tempBegin = beginDate.toString();
                String personId = ((Map)((List)entry.getValue()).get(0)).get("personId").toString();
                if (smdf.parse(((Map)((List)entry.getValue()).get(0)).get("effectDay").toString()).getTime() - beginDate.getTime() < 0L) {
                    for (i = 0; i < ((List)entry.getValue()).size(); ++i) {
                        fixMap = (Map)((List)entry.getValue()).get(i);
                        money = new BigDecimal(fixMap.get("money").toString()).doubleValue();
                        currencyId = null == fixMap.get("currencyId") ? null : fixMap.get("currencyId").toString();
                        tempEnd = i + 1 < ((List)entry.getValue()).size() ? smdf.format(smdf.parse(((Map)((List)entry.getValue()).get(i + 1)).get("effectDay").toString()).getTime() - 86400000L) : endDate.toString();
                        this.processData(personId, tempBegin, tempEnd, name, money, currencyId, allMap);
                        if (!tempEnd.equals(endDate.toString())) {
                            tempEnd = smdf.format(smdf.parse(tempEnd).getTime() + 86400000L);
                        }
                        tempBegin = tempEnd;
                    }
                    continue;
                }
                for (i = 0; i < ((List)entry.getValue()).size() + 1; ++i) {
                    fixMap = (Map)((List)entry.getValue()).get(i);
                    String string = currencyId = null == fixMap.get("currencyId") ? null : fixMap.get("currencyId").toString();
                    if (i > 0) {
                        money = new BigDecimal(((Map)((List)entry.getValue()).get(i - 1)).get("money").toString()).doubleValue();
                    }
                    tempEnd = i < ((List)entry.getValue()).size() ? smdf.format(smdf.parse(fixMap.get("effectDay").toString()).getTime() - 86400000L) : endDate.toString();
                    this.processData(personId, tempBegin, tempEnd, name, money, currencyId, allMap);
                    if (!tempEnd.equals(endDate.toString())) {
                        tempEnd = smdf.format(smdf.parse(tempEnd).getTime() + 86400000L);
                    }
                    tempBegin = tempEnd;
                }
            }
            salaryMap = this.getPersonSegmentedSalaryInfo(calScheme, allMap, currencyMap, standardWorkdays);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return salaryMap;
    }

    public String getSegmentedSalarySQL(String itemName, CalSchemeInfo calScheme, String mainTableRowFilter) {
        String calschemeid = calScheme.getId().toString();
        int calTime = calScheme.getCalTime();
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        String calSchemeEndDate = CmpDateUtil.toKSqlDate(calScheme.getEndDate());
        String calSchemeBeginDate = CmpDateUtil.toKSqlDate(calScheme.getBeginDate());
        CmpPeriodTypeEnum periodType = calScheme.getCmpPeriodType();
        int month = -1;
        if (CmpPeriodTypeEnum.yeay.equals((Object)periodType)) {
            month = -12;
        } else if (CmpPeriodTypeEnum.half.equals((Object)periodType)) {
            month = -6;
        } else if (CmpPeriodTypeEnum.quarter.equals((Object)periodType)) {
            month = -3;
        }
        Context ctx = com.kingdee.shr.compensation.app.formula.data.Tools.getInstance().getCtx();
        String l = calScheme.getLanType().getValue();
        String beginDateField = "dateAdd(month, " + month + ", calTable.FRealEndDate)";
        String hrOrgId = calScheme.getHrOrgUnit().getId().toString();
        String personSql = "select FPersonID from T_HR_SCmpCalTable where FcalSchemeID = '" + calschemeid + "' and FcalTime = " + calTime + " and FperiodYear = " + periodYear + " and FperiodMonth = " + periodMonth;
        String replace = null;
        if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
            replace = mainTableRowFilter.replace("t_hr_scmpcaltable.fid", "calTable.fid").replace("t_hr_scmpcaltable.FCalState", "calTable.fcalState");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT distinct fix.FMoney as money,fix.FEffectDay effectDay,fix.FPersonId personId,item.FName_" + l + " itemName, fix.FCurrencyID ");
        sb.append(" FROM t_hr_scmpcaltable calTable ");
        sb.append(" left join T_HR_SFixAdjustSalary fix on calTable.fpersonid=fix.fpersonid  ");
        sb.append(" left join T_HR_SFixAdjustPayHrRecord payHr on fix.fpersonid=payHr.fpersonid and fix.FCmpItemID=payHr.FCmpItemID ");
        sb.append(" left join T_HR_SCmpItem item on item.fid=fix.FCmpItemID  ");
        sb.append(" where calTable.FRealEndDate >= payHr.FEFFDT and ").append(beginDateField).append(" <= payHr.FLEFFDT ");
        sb.append(" and (calTable.FHrOrgUnitID=payHr.FHrOrgUnitID or payHr.FHrOrgUnitID is null) and fix.fid=payHr.fsourceid ");
        sb.append(" and ").append(beginDateField).append("<=fix.FEffectDay  and calTable.FRealEndDate>=fix.FEffectDay ");
        sb.append(" and fix.FEffectDay <=").append(calSchemeEndDate);
        sb.append(" and fix.FLEFFECTDAY >=").append(calSchemeBeginDate);
        sb.append(" and calTable.FHrOrgUnitID='").append(hrOrgId).append("' and item.fname_" + l + "='").append(itemName).append("'");
        sb.append(" and calTable.FcalTime=").append(calTime).append(" and calTable.FperiodYear=");
        sb.append(periodYear).append(" and calTable.FperiodMonth=").append(periodMonth);
        if (!StringUtils.isEmpty((String)replace)) {
            sb.append(" and ").append(replace);
        } else {
            sb.append(" and calTable.fpersonid in(").append(personSql).append(")");
        }
        sb.append(" union ");
        sb.append(" SELECT  b.money,a.EffectDay,a.FPersonId,b.itemName, b.FCurrencyID from ");
        sb.append(" ( ");
        sb.append(" SELECT max(fix.FEffectDay) as EffectDay, calTable.fpersonId ");
        sb.append("   FROM t_hr_scmpcaltable calTable ");
        sb.append("   left join T_HR_SFixAdjustSalary fix on calTable.fpersonid=fix.fpersonid  ");
        sb.append("   left join T_HR_SFixAdjustPayHrRecord payHr on fix.fpersonid=payHr.fpersonid and fix.FCmpItemID=payHr.FCmpItemID ");
        sb.append("   left join T_HR_SCmpItem item on item.fid=fix.FCmpItemID ");
        sb.append("  where ").append(beginDateField).append(" >= payHr.FEFFDT   ");
        sb.append(" and (calTable.FHrOrgUnitID=payHr.FHrOrgUnitID or payHr.FHrOrgUnitID is null) and ").append(beginDateField).append(">=fix.FEffectDay  ");
        sb.append(" and fix.FEffectDay <=").append(calSchemeEndDate);
        sb.append(" and fix.FLEFFECTDAY >=").append(calSchemeBeginDate);
        sb.append(" and calTable.FHrOrgUnitID='").append(hrOrgId).append("' and item.fname_" + l + "='").append(itemName).append("' ");
        sb.append(" and calTable.FcalTime=").append(calTime).append(" and calTable.FperiodYear=");
        sb.append(periodYear).append(" and calTable.FperiodMonth=").append(periodMonth);
        if (!StringUtils.isEmpty((String)replace)) {
            sb.append(" and ").append(replace);
        } else {
            sb.append(" and calTable.fpersonid in(").append(personSql).append(")");
        }
        sb.append(" group by calTable.fpersonid ");
        sb.append(" ) a, ");
        sb.append("(select distinct fix.FMoney AS money,fix.FEffectDay AS effectday,fix.FPersonId  AS personid,item.FName_" + l + "  AS itemName, fix.FCurrencyID ");
        sb.append("   FROM t_hr_scmpcaltable calTable ");
        sb.append("   left join T_HR_SFixAdjustSalary fix on calTable.fpersonid=fix.fpersonid  ");
        sb.append("   left join T_HR_SFixAdjustPayHrRecord payHr on fix.fpersonid=payHr.fpersonid and fix.FCmpItemID=payHr.FCmpItemID ");
        sb.append("   left join T_HR_SCmpItem item on item.fid=fix.FCmpItemID ");
        sb.append("  where ").append(beginDateField).append(" >= payHr.FEFFDT and fix.fid=payHr.fsourceid  ");
        sb.append("    and (calTable.FHrOrgUnitID=payHr.FHrOrgUnitID or payHr.FHrOrgUnitID is null) and ").append(beginDateField).append(">=fix.FEffectDay  ");
        sb.append("    and fix.FEffectDay <=").append(calSchemeEndDate);
        sb.append("    and fix.FLEFFECTDAY >=").append(calSchemeBeginDate);
        sb.append("    and calTable.FHrOrgUnitID='").append(hrOrgId).append("' and item.fname_" + l + "='").append(itemName).append("' ");
        if (!StringUtils.isEmpty((String)replace)) {
            sb.append(" and ").append(replace);
        } else {
            sb.append(" and calTable.fpersonid in(").append(personSql).append(")");
        }
        sb.append(" ) b  ");
        sb.append(" WHERE a.fpersonid = b.personid AND a.effectday = b.effectday  AND b.itemName='").append(itemName).append("' ");
        sb.append("  ");
        String salarySQL = sb.toString();
        return salarySQL;
    }

    @Deprecated
    public String getSegmentedSalarySQLbak(String sql, String itemName, java.util.Date beginDate, java.util.Date endDate, String hrOrgId, CalSchemeInfo calScheme) {
        StringBuilder querySql = new StringBuilder();
        Context ctx = com.kingdee.shr.compensation.app.formula.data.Tools.getInstance().getCtx();
        String l = calScheme.getLanType().getValue();
        querySql.append(" SELECT fix.FMoney as money,fix.FEffectDay AS effectDay,fix.FPersonId AS personId,item.FName_" + l + " AS itemName FROM T_HR_SFixAdjustSalary fix ");
        querySql.append(" INNER JOIN T_HR_SCmpItem item ");
        querySql.append(" ON fix.FCmpitemId = item.FId ");
        querySql.append(" AND item.FName_" + l + " = '").append(itemName).append("'");
        querySql.append(" WHERE fix.FPersonId IN ");
        querySql.append(" (");
        querySql.append(sql);
        querySql.append(" )");
        querySql.append(" AND fix.FEffectDay >= ").append("{ts '").append(beginDate).append("'}");
        querySql.append(" AND fix.FEffectDay <= ").append("{ts '").append(endDate).append("'}");
        querySql.append(" AND fix.FPayHrOrgUnitID = '").append(hrOrgId).append("'");
        querySql.append(" UNION ");
        querySql.append(" SELECT  b.money,a.EffectDay,a.FPersonId,b.itemName  FROM (");
        querySql.append(" SELECT MAX(FEffectDay) as EffectDay, FPersonId FROM T_HR_SFixAdjustSalary s INNER JOIN T_HR_SCmpItem i ON s.fcmpitemid = i.fid ").append("WHERE FEffectDay <= ").append("{ts '").append(beginDate).append("'}").append(" AND i.FName_" + l + " = '").append(itemName).append("'").append(" AND s.FPayHrOrgUnitID='").append(hrOrgId).append("' ").append("  group by FPersonId) a ,").append(" (SELECT fix2.FMoney AS money,fix2.FEffectDay AS effectday,fix2.FPersonId  AS personid,item2.FName_" + l + "  AS itemName FROM T_HR_SFixAdjustSalary fix2");
        querySql.append("  INNER JOIN T_HR_SCmpItem item2  ON fix2.FCmpitemId = item2.fid ");
        querySql.append(" WHERE fix2.FPersonId IN ");
        querySql.append("(");
        querySql.append(sql);
        querySql.append(")");
        querySql.append(" AND fix2.FPayHrOrgUnitID='").append(hrOrgId).append("'");
        querySql.append(" AND fix2.FEffectDay <= ").append("{ts '").append(beginDate).append("'} ) b ");
        querySql.append("  WHERE a.fpersonid = b.personid AND a.effectday = b.effectday  AND b.itemName = '").append(itemName).append("'");
        querySql.append(" ORDER BY effectDay ASC ");
        String salarySQL = querySql.toString();
        return salarySQL;
    }

    public void processData(String personId, String tempBegin, String tempEnd, String name, Double money, String currencyId, Map<String, List<Map<String, Object>>> allMap) {
        Context ctx = com.kingdee.shr.compensation.app.formula.data.Tools.getInstance().getCtx();
        HashMap<String, String> pam = new HashMap<String, String>();
        HashMap<String, Object> workMap = new HashMap<String, Object>();
        pam.put("beginDate", tempBegin);
        pam.put("endDate", tempEnd);
        pam.put("currDateStr", tempEnd);
        pam.put("name", name);
        pam.put("personId", personId);
        Object result = com.kingdee.eas.rpts.ctrlreport.osf.OSFExecutor.executeOSF((Context)ctx, pam, (String)"getWorkCalendarWorkDays");
        pam.clear();
        workMap.put("money", money);
        workMap.put("currencyId", currencyId);
        workMap.put("workDays", new BigDecimal(result.toString()).doubleValue());
        if (allMap.containsKey(personId)) {
            allMap.get(personId).add(workMap);
        } else {
            ArrayList<HashMap<String, Object>> workList = new ArrayList<HashMap<String, Object>>();
            workList.add(workMap);
            allMap.put(personId, workList);
        }
    }

    public Map<String, Object> getPersonSegmentedSalaryInfo(CalSchemeInfo calScheme, Map<String, List<Map<String, Object>>> map, Map<String, BigDecimal> currencyMap, Double standardWorkdays) {
        HashMap<String, Object> salaryMap = new HashMap<String, Object>();
        BigDecimal standardWorkdaysBig = new BigDecimal(standardWorkdays);
        String personId = null;
        if (null != calScheme.getCurrency()) {
            for (Map.Entry<String, List<Map<String, Object>>> entry : map.entrySet()) {
                BigDecimal sum = new BigDecimal(0);
                for (int i = 0; i < entry.getValue().size(); ++i) {
                    personId = entry.getKey();
                    Map<String, Object> moneyMap = entry.getValue().get(i);
                    BigDecimal money = new BigDecimal(moneyMap.get("money").toString());
                    BigDecimal workDays = new BigDecimal(moneyMap.get("workDays").toString());
                    BigDecimal rate = null != moneyMap.get("currendyId") ? (null == currencyMap.get(moneyMap.get("currendyId")) ? new BigDecimal(1) : currencyMap.get(moneyMap.get("currendyId"))) : new BigDecimal(1);
                    sum = sum.add(money.multiply(rate).multiply(workDays));
                }
                if (standardWorkdays != 0.0) {
                    salaryMap.put(personId, sum.divide(standardWorkdaysBig, 10, 4).doubleValue());
                    continue;
                }
                salaryMap.put(personId, 0.0);
            }
        } else {
            for (Map.Entry<String, List<Map<String, Object>>> entry : map.entrySet()) {
                BigDecimal sum = new BigDecimal(0);
                for (int i = 0; i < entry.getValue().size(); ++i) {
                    personId = entry.getKey();
                    Map<String, Object> moneyMap = entry.getValue().get(i);
                    BigDecimal rate = null != moneyMap.get("currendyId") ? (null == currencyMap.get(moneyMap.get("currendyId")) ? new BigDecimal(1) : currencyMap.get(moneyMap.get("currendyId"))) : new BigDecimal(1);
                    BigDecimal money = new BigDecimal(moneyMap.get("money").toString());
                    BigDecimal workDays = new BigDecimal(moneyMap.get("workDays").toString());
                    sum = sum.add(money.multiply(rate).multiply(workDays));
                }
                if (standardWorkdays != 0.0) {
                    salaryMap.put(personId, sum.divide(standardWorkdaysBig, 10, 4).doubleValue());
                    continue;
                }
                salaryMap.put(personId, 0.0);
            }
        }
        return salaryMap;
    }

    public Map<String, String> getCnSn(CalSchemeInfo calSchemeInfo) throws SQLException {
        Context ctx = com.kingdee.shr.compensation.app.formula.data.Tools.getInstance().getCtx();
        String l = calSchemeInfo.getLanType().getValue();
        String sql = "select FIELDSN,FNAME_" + l + " from T_HR_SCmpItem order by FIELDSN";
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (executeQuery.next()) {
                String resultKey = executeQuery.getString("FNAME_" + l + "");
                String resultValue = executeQuery.getString("FIELDSN");
                resultMap.put(resultKey, resultValue);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return resultMap;
    }

    public String getSecFixAdjustSalaryDate(Map<String, Object> paramMap, HashMap<String, Object> tempMap, CalSchemeInfo calScheme, String mainTableRowFilter, String cmpItem) {
        String key;
        Map SecFixAdjustSalaryDateMap;
        if (StringUtils.isEmpty((String)cmpItem) || paramMap.get("T_HR_SCMPCALTABLE_FPERSONID") == null) {
            return "";
        }
        String adjustSalaryDateKey = "getSecFixAdjustSalaryDateKey_" + cmpItem;
        if (tempMap.get(adjustSalaryDateKey) == null) {
            tempMap.put(adjustSalaryDateKey, this.initPersonSecFixAdjustSalaryDateInfo(calScheme, mainTableRowFilter, cmpItem));
        }
        if ((SecFixAdjustSalaryDateMap = (Map)tempMap.get(adjustSalaryDateKey)).containsKey(key = paramMap.get("T_HR_SCMPCALTABLE_FPERSONID").toString())) {
            String effectDay = SecFixAdjustSalaryDateMap.get(key).toString();
            return effectDay;
        }
        return "";
    }

    private Map<String, String> initPersonSecFixAdjustSalaryDateInfo(CalSchemeInfo calScheme, String mainTableRowFilter, String cmpItem) {
        HashMap<String, String> secFixAdjustSalaryDateMap = new HashMap<String, String>();
        try {
            String calSchemeId = calScheme.getId().toString();
            int calTime = calScheme.getCalTime();
            int periodYear = calScheme.getPeriodYear();
            int periodMonth = calScheme.getPeriodMonth();
            String hrOrgId = this.getHrOrgUnitId(calScheme);
            String personSql = "select FPersonID from T_HR_SCmpCalTable where FcalSchemeID = '" + calSchemeId + "' and FcalTime = " + calTime + " and FperiodYear = " + periodYear + " and FperiodMonth = " + periodMonth;
            String querySql = this.getSecFixAdjustSalarySQL(personSql, calScheme, cmpItem, periodYear, periodMonth, calTime, hrOrgId, mainTableRowFilter);
            Context ctx = com.kingdee.shr.compensation.app.formula.data.Tools.getInstance().getCtx();
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)querySql);
            List<Map<String, Object>> dataList = this.getDataFromExecuteQuery(executeQuery, "4");
            Map<String, Object> map = null;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Iterator<Map<String, Object>> it = dataList.iterator();
            java.util.Date effectDay = null;
            String effectDayStr = "";
            java.util.Date beginDate = calScheme.getBeginDate();
            while (it.hasNext()) {
                map = it.next();
                String key = (String)map.get("personId");
                effectDay = (java.util.Date)map.get("effectDay");
                if (null == effectDay || beginDate.after(effectDay)) continue;
                effectDayStr = dateFormat.format(effectDay);
                secFixAdjustSalaryDateMap.put(key, effectDayStr);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return secFixAdjustSalaryDateMap;
    }

    private String getSecFixAdjustSalarySQL(String sql, CalSchemeInfo calScheme, String itemName, int periodYear, int periodMonth, int calTime, String hrOrgId, String mainTableRowFilter) {
        StringBuilder sb = new StringBuilder();
        CmpPeriodTypeEnum periodType = calScheme.getCmpPeriodType();
        int month = -1;
        if (CmpPeriodTypeEnum.yeay.equals((Object)periodType)) {
            month = -12;
        } else if (CmpPeriodTypeEnum.half.equals((Object)periodType)) {
            month = -6;
        } else if (CmpPeriodTypeEnum.quarter.equals((Object)periodType)) {
            month = -3;
        }
        Context ctx = com.kingdee.shr.compensation.app.formula.data.Tools.getInstance().getCtx();
        String l = calScheme.getLanType().getValue();
        String beginDateField = "dateAdd(month, " + month + ", calTable.FRealEndDate)";
        String calSchemeId = calScheme.getId().toString();
        sb.append(" SELECT fix.FMoney as money,fix.FEffectDay AS effectDay,fix.FPersonId AS personId,item.FName_" + l + " AS itemName, ");
        sb.append(" %d \"type\" ");
        sb.append(" FROM t_hr_scmpcaltable calTable ");
        sb.append(" left join T_HR_SFixAdjustSalary fix on calTable.fpersonid=fix.fpersonid ");
        sb.append(" left join T_HR_SFixAdjustPayHrRecord payHr on fix.fpersonid=payHr.fpersonid and fix.FCmpItemID=payHr.FCmpItemID  ");
        sb.append(" left join T_HR_SCmpItem item on item.fid=fix.FCmpItemID ");
        sb.append(" where fix.FEffectDay>=").append(beginDateField).append("  and fix.FEffectDay <= calTable.FRealEndDate ");
        sb.append(" and %s ");
        sb.append(" and fix.fid=payHr.fsourceid ");
        sb.append(" and calTable.FHrOrgUnitID='").append(hrOrgId).append("'");
        if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
            String replace = mainTableRowFilter.replace("t_hr_scmpcaltable.fid", "calTable.fid").replace("t_hr_scmpcaltable.FCalState", "calTable.fcalState");
            sb.append(" and ").append(replace);
        } else {
            sb.append(" and calTable.fpersonid in(").append(sql).append(")");
        }
        sb.append(" and calTable.fcalschemeid='").append(calSchemeId).append("' and item.fname_" + l + "='");
        sb.append(itemName).append("'");
        sb.append(" and calTable.FperiodYear=").append(periodYear);
        sb.append(" and calTable.FperiodMonth=").append(periodMonth);
        sb.append(" and calTable.FcalTime=").append(calTime);
        String unitSql = sb.toString();
        String salarySQL = "select distinct money,effectDay,personId,itemName,\"type\" from (" + String.format(unitSql, 0, "payHr.FHrOrgUnitID is null") + " union " + String.format(unitSql, 1, "calTable.FHrOrgUnitID= payHr.FHrOrgUnitID") + " union " + String.format(unitSql, 0, "payHr.FHrOrgUnitID in ('')") + " union " + String.format(unitSql, 2, "calTable.FHrOrgUnitID <> payHr.FHrOrgUnitID and payHr.FHrOrgUnitID is not null and payHr.FHrOrgUnitID <> '' ") + ") temp order  by personId,effectDay";
        return salarySQL;
    }

    public double getAtsDatawithOrg(Map<String, Object> paramMap, HashMap<String, Object> tempMap, CalSchemeInfo calScheme, String mainTableRowFilter, String project, double isVac, String company, double needSubOrg) {
        Context ctx = com.kingdee.shr.compensation.app.formula.data.Tools.getInstance().getCtx();
        String calschemeid = calScheme.getId().toString();
        int calTime = calScheme.getCalTime();
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        boolean haveSubOrg = 1.0 == needSubOrg;
        boolean vacProject = 1.0 == isVac;
        boolean lockAts = calScheme.isIsAts();
        boolean lockVac = calScheme.isIsVac();
        if (!vacProject ? !lockAts : !lockVac) {
            return 0.0;
        }
        String key = "AtsResult:" + calScheme.getNumber() + "-" + periodYear + "-" + periodMonth + "-" + calTime + "-" + project + "-" + company + "-" + haveSubOrg + "-" + isVac;
        if (tempMap.get(key) == null) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("year", periodYear);
            param.put("month", periodMonth);
            param.put("times", calTime);
            String l = ctx.getLocale().getLanguage();
            String l1 = calScheme.getLanType().getValue();
            String companyLongNumber = " select fLongNumber from T_ORG_ADMIN where fid in   (select FADMINORGID  from T_ORG_ADMINORGtreehis where fDisplayName_" + l + " = '" + company + "' or  fDisplayName_" + l1 + " = '" + company + "' ) ";
            param.put("companyLongNumber", Base64Utils.encodeWithSalt(companyLongNumber));
            String personSql = "select FPersonID from T_HR_SCmpCalTable where FcalSchemeID = '" + calschemeid + "' and FcalTime = " + calTime + " and FperiodYear = " + periodYear + " and FperiodMonth = " + periodMonth;
            if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
                personSql = personSql + " and " + mainTableRowFilter;
            }
            param.put("personIds", Base64Utils.encodeWithSalt(personSql));
            param.put("haveSubOrg", haveSubOrg);
            param.put("attendProject", project);
            List listData = null;
            listData = !vacProject ? (List)OSFExecutor.executeOSF((Context)ctx, param, (String)"getAttendSumByHrOrg") : (List)OSFExecutor.executeOSF((Context)ctx, param, (String)"getHolidayProjectSummary");
            tempMap.put(key, listData);
        }
        String personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        List atsResultData = (List)tempMap.get(key);
        String evalPersonId = "";
        HashMap atsResultMap = null;
        if (null != atsResultData) {
            for (HashMap map : atsResultData) {
                evalPersonId = map.containsKey("personId") ? map.get("personId").toString() : "";
                if (!evalPersonId.equals(personId)) continue;
                atsResultMap = map;
                break;
            }
        }
        if (null != atsResultMap) {
            double res = 0.0;
            if (null != atsResultMap.get(project) && !"".equals(atsResultMap.get(project))) {
                res = Double.parseDouble(atsResultMap.get(project).toString());
            }
            return res;
        }
        return 0.0;
    }

    public double getAtsDatawithOrg_Date(Map<String, Object> paramMap, HashMap<String, Object> tempMap, CalSchemeInfo calScheme, String mainTableRowFilter, String project, double isVac, String company, double needSubOrg, String beginDate, String endDate) {
        Context ctx = com.kingdee.shr.compensation.app.formula.data.Tools.getInstance().getCtx();
        String calschemeid = calScheme.getId().toString();
        int calTime = calScheme.getCalTime();
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        boolean haveSubOrg = 1.0 == needSubOrg;
        boolean vacProject = 1.0 == isVac;
        boolean lockAts = calScheme.isIsAts();
        boolean lockVac = calScheme.isIsVac();
        if (!vacProject ? !lockAts : !lockVac) {
            return 0.0;
        }
        String key = "AtsResult:" + calScheme.getNumber() + "-" + periodYear + "-" + periodMonth + "-" + calTime + "-" + project + "-" + company + "-" + haveSubOrg + "-" + beginDate + "-" + endDate + "-" + isVac;
        if (tempMap.get(key) == null) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            String l = calScheme.getLanType().getValue();
            String l1 = ctx.getLocale().getLanguage();
            String companyLongNumber = "select fLongNumber from T_ORG_ADMIN where fid in  ( select FADMINORGID from T_ORG_ADMINORGtreehis where fDisplayName_" + l + " = '" + company + "' or fDisplayName_" + l1 + " = '" + company + "' ) ";
            param.put("companyLongNumber", Base64Utils.encodeWithSalt(companyLongNumber));
            String personSql = "select FPersonID from T_HR_SCmpCalTable where FcalSchemeID = '" + calschemeid + "' and FcalTime = " + calTime + " and FperiodYear = " + periodYear + " and FperiodMonth = " + periodMonth;
            if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
                personSql = personSql + " and " + mainTableRowFilter;
            }
            param.put("personIds", Base64Utils.encodeWithSalt(personSql.toString()));
            param.put("haveSubOrg", haveSubOrg);
            param.put("beginDate", beginDate);
            param.put("endDate", endDate);
            param.put("attendProject", project);
            List listData = null;
            listData = !vacProject ? (List)OSFExecutor.executeOSF((Context)ctx, param, (String)"getSpecialedPeriodAtsSum") : (List)OSFExecutor.executeOSF((Context)ctx, param, (String)"getLeaveDetailSummary");
            tempMap.put(key, listData);
        }
        String personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        List atsResultData = (List)tempMap.get(key);
        String evalPersonId = "";
        HashMap atsResultMap = null;
        if (null != atsResultData) {
            for (HashMap map : atsResultData) {
                evalPersonId = map.containsKey("personId") ? map.get("personId").toString() : "";
                if (!evalPersonId.equals(personId)) continue;
                atsResultMap = map;
                break;
            }
        }
        if (null != atsResultMap) {
            double res = 0.0;
            if (null != atsResultMap.get(project) && !"".equals(atsResultMap.get(project))) {
                res = Double.parseDouble(atsResultMap.get(project).toString());
            }
            return res;
        }
        return 0.0;
    }

    public double getEvaluResultScoreWithPeriod(Map<String, Object> paramMap, Map<String, Object> tempMap, CalSchemeInfo calSchemeInfo, String mainTableRowFilter, String perfModel, double needEmpPosOrg, double deviationPeriod, double calTime) {
        String mainkey = "EvaluResult";
        boolean isSysRate = false;
        boolean lockPerf = calSchemeInfo.isIsPerf();
        if (!lockPerf) {
            return 0.0;
        }
        HashMap<String, Object> evalResultMap = this.getEvaluResultWithPeriod(paramMap, tempMap, calSchemeInfo, mainTableRowFilter, perfModel, needEmpPosOrg, deviationPeriod, calTime, mainkey, isSysRate);
        if (null != evalResultMap) {
            double score = 0.0;
            if (null != evalResultMap.get("score") && !"".equals(evalResultMap.get("score"))) {
                score = Double.parseDouble(evalResultMap.get("score").toString());
            }
            return score;
        }
        return 0.0;
    }

    public String getEvaluSysDataResultRankWithPeriod(Map<String, Object> paramMap, Map<String, Object> tempMap, CalSchemeInfo calSchemeInfo, String mainTableRowFilter, String perfModel, double needEmpPosOrg, double deviationPeriod, double calTime) {
        String mainkey = "sysRateEvaluResult";
        boolean isSysRate = true;
        boolean lockPerf = calSchemeInfo.isIsPerf();
        if (!lockPerf) {
            return "";
        }
        HashMap<String, Object> evalResultMap = this.getEvaluResultWithPeriod(paramMap, tempMap, calSchemeInfo, mainTableRowFilter, perfModel, needEmpPosOrg, deviationPeriod, calTime, mainkey, isSysRate);
        if (null != evalResultMap) {
            String rank = "";
            if (null != evalResultMap.get("rank") && !"".equals(evalResultMap.get("rank"))) {
                rank = evalResultMap.get("rank").toString();
            }
            return rank;
        }
        return "";
    }

    public String getEvaluResultRankWithPeriod(Map<String, Object> paramMap, Map<String, Object> tempMap, CalSchemeInfo calSchemeInfo, String mainTableRowFilter, String perfModel, double needEmpPosOrg, double deviationPeriod, double calTime) {
        String mainkey = "EvaluResult";
        boolean isSysRate = false;
        boolean lockPerf = calSchemeInfo.isIsPerf();
        if (!lockPerf) {
            return "";
        }
        HashMap<String, Object> evalResultMap = this.getEvaluResultWithPeriod(paramMap, tempMap, calSchemeInfo, mainTableRowFilter, perfModel, needEmpPosOrg, deviationPeriod, calTime, mainkey, isSysRate);
        if (null != evalResultMap) {
            String rank = "";
            if (null != evalResultMap.get("rank") && !"".equals(evalResultMap.get("rank"))) {
                rank = evalResultMap.get("rank").toString();
            }
            return rank;
        }
        return "";
    }

    public HashMap<String, Object> getEvaluResultWithPeriod(Map<String, Object> paramMap, Map<String, Object> tempMap, CalSchemeInfo calSchemeInfo, String mainTableRowFilter, String perfModel, double needEmpPosOrg, double deviationPeriod, double calTime, String mainkey, boolean isSysRate) {
        Context ctx = com.kingdee.shr.compensation.app.formula.data.Tools.getInstance().getCtx();
        StringBuffer keyBuff = new StringBuffer(mainkey);
        keyBuff.append("-").append(calSchemeInfo.getNumber());
        HashMap<String, Integer> calculatePeriod = this.getCalculatePeriod(calSchemeInfo, deviationPeriod);
        keyBuff.append("-").append(calculatePeriod.get("year"));
        keyBuff.append("-").append(calculatePeriod.get("month"));
        keyBuff.append("-").append(calTime);
        keyBuff.append("-").append(perfModel);
        if (perfModel != null && perfModel != "") {
            keyBuff.append("-").append(perfModel);
        }
        keyBuff.append("-").append(needEmpPosOrg);
        keyBuff.append("-").append(deviationPeriod);
        String key = keyBuff.toString();
        if (tempMap.get(key) == null) {
            String calSchemeId = calSchemeInfo.getId().toString();
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("year", String.valueOf(calculatePeriod.get("year")));
            param.put("month", String.valueOf(calculatePeriod.get("month")));
            param.put("times", String.valueOf((int)calTime));
            if (perfModel != null && perfModel != "") {
                param.put("perfModel", perfModel);
            }
            if (needEmpPosOrg == 1.0) {
                StringBuffer empPosOrgSql = new StringBuffer("select FEmpPosOrgRelationID from T_HR_SCmpCalTable where t_hr_scmpcaltable.FcalSchemeID = '").append(calSchemeId).append("'");
                if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
                    empPosOrgSql.append(" and ").append(mainTableRowFilter);
                }
                param.put("empPosOrgId", Base64Utils.encodeWithSalt(empPosOrgSql.toString()));
            } else {
                StringBuffer personSql = new StringBuffer("select FPersonId from T_HR_SCmpCalTable where t_hr_scmpcaltable.FcalSchemeID = '").append(calSchemeId).append("'");
                if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
                    personSql.append(" and ").append(mainTableRowFilter);
                }
                param.put("personId", Base64Utils.encodeWithSalt(personSql.toString()));
            }
            if (isSysRate) {
                param.put("isSysRate", "1");
            }
            List listData = null;
            listData = (List)OSFExecutor.executeOSF((Context)ctx, param, (String)"getPerfEvaluResult");
            tempMap.put(key, listData);
        }
        String personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        List evaluResultData = (List)tempMap.get(key);
        String evalPersonId = "";
        HashMap evalResultMap = null;
        if (null != evaluResultData) {
            for (HashMap map : evaluResultData) {
                evalPersonId = map.containsKey("personId") ? map.get("personId").toString() : "";
                if (!evalPersonId.equals(personId)) continue;
                evalResultMap = map;
                break;
            }
        }
        return evalResultMap;
    }

    private HashMap<String, Integer> getCalculatePeriod(CalSchemeInfo calSchemeInfo, double deviationPeriod) {
        int periodYear = calSchemeInfo.getPeriodYear();
        int periodMonth = calSchemeInfo.getPeriodMonth();
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, periodYear);
        calendar.set(2, periodMonth - 1);
        calendar.set(5, 1);
        calendar.add(2, (int)deviationPeriod);
        HashMap<String, Integer> calculatePeriod = new HashMap<String, Integer>();
        calculatePeriod.put("year", calendar.get(1));
        calculatePeriod.put("month", calendar.get(2) + 1);
        return calculatePeriod;
    }

    public String getOrgEvaluResultRank(Map<String, Object> paramMap, Map<String, Object> tempMap, CalSchemeInfo calSchemeInfo, String mainTableRowFilter, String perfModel, String orgNumber, double deviationPeriod, double calTime, double returnType) {
        Map<String, Map<String, String>> orgEvaluResult = this.getOrgEvaluResult(tempMap, calSchemeInfo, perfModel, deviationPeriod, calTime);
        String rank = "";
        if (orgEvaluResult != null && orgEvaluResult.containsKey(orgNumber)) {
            Map<String, String> map = orgEvaluResult.get(orgNumber);
            if (returnType == 0.0) {
                rank = map.get("lastRank");
            } else if (returnType == 1.0) {
                rank = map.get("sysRank");
            }
        }
        return rank;
    }

    public double getOrgEvaluResultScore(Map<String, Object> paramMap, Map<String, Object> tempMap, CalSchemeInfo calSchemeInfo, String mainTableRowFilter, String perfModel, String orgNumber, double deviationPeriod, double calTime) {
        Map<String, Map<String, String>> orgEvaluResult = this.getOrgEvaluResult(tempMap, calSchemeInfo, perfModel, deviationPeriod, calTime);
        if (orgEvaluResult != null && orgEvaluResult.containsKey(orgNumber)) {
            Map<String, String> map = orgEvaluResult.get(orgNumber);
            return new BigDecimal(map.get("score")).doubleValue();
        }
        return 0.0;
    }

    public Map<String, Map<String, String>> getOrgEvaluResult(Map<String, Object> tempMap, CalSchemeInfo calSchemeInfo, String perfModel, double deviationPeriod, double calTime) {
        HashMap<String, Integer> calculatePeriod = this.getCalculatePeriod(calSchemeInfo, deviationPeriod);
        StringBuffer tempKey = new StringBuffer("OrgEvaluResult");
        tempKey.append("_").append(calSchemeInfo.getId());
        tempKey.append("_").append(calculatePeriod.get("year"));
        tempKey.append("_").append(calculatePeriod.get("month"));
        tempKey.append("_").append(calTime);
        tempKey.append("_").append(perfModel);
        String key = tempKey.toString();
        if (tempMap.containsKey(key)) {
            return (Map)tempMap.get(key);
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("perfModel", perfModel);
        param.put("periodYear", calculatePeriod.get("year"));
        param.put("periodMonth", calculatePeriod.get("month"));
        param.put("time", calTime);
        Context ctx = com.kingdee.shr.compensation.app.formula.data.Tools.getInstance().getCtx();
        Map result = (Map)OSFExecutor.executeOSF((Context)ctx, param, (String)"getOrgEvaluResult");
        tempMap.put(key, result);
        return result;
    }

    public double getCalendarTypeDays(String name, String beginDate, String endDate, String dayType, Map<String, Object> paramMap, Map<String, Object> tempMap) {
        Object result;
        String calendarLegalHolidaysKey = name + "_" + beginDate + "_" + endDate;
        if ("2".equals(dayType) && null != (result = tempMap.get(calendarLegalHolidaysKey))) {
            return (Double)result;
        }
        Context ctx = null;
        if (Tools.getInstance().getCtx() == null) {
            ctx = com.kingdee.shr.compensation.app.formula.data.Tools.getInstance().getCtx();
            Tools.getInstance().setCtx(ctx);
        } else {
            ctx = Tools.getInstance().getCtx();
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("name", name);
        param.put("beginDate", beginDate);
        param.put("endDate", endDate);
        param.put("dayType", dayType);
        String personId = (String)paramMap.get("T_HR_ATS_ATTENDANCERESULT_FPROPOSERID");
        if (org.apache.commons.lang.StringUtils.isEmpty((String)personId)) {
            personId = (String)paramMap.get("T_HR_ATS_ATTENDANCERESULTSUM_FPROPOSERID");
        }
        if (org.apache.commons.lang.StringUtils.isEmpty((String)personId)) {
            personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        }
        param.put("personId", personId);
        String currDateStr = (String)paramMap.get("T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE");
        if (org.apache.commons.lang.StringUtils.isEmpty((String)currDateStr)) {
            currDateStr = endDate;
        }
        param.put("currDateStr", currDateStr);
        result = com.kingdee.eas.rpts.ctrlreport.osf.OSFExecutor.executeOSF((Context)ctx, param, (String)"getWorkCalendarWorkDays");
        if ("2".equals(dayType)) {
            tempMap.put(calendarLegalHolidaysKey, result);
        }
        return (Double)result;
    }

    @Deprecated
    public double getSegmentedItemSalarybak(Map paramMap, HashMap tempMap, Map<String, BigDecimal> currencyMap, CalSchemeInfo calScheme, String cmpItem, double standardWorkdays, String name, String mainTableRowFilter) {
        try {
            if (StringUtils.isEmpty((String)cmpItem) || paramMap.get("T_HR_SCMPCALTABLE_FPERSONID") == null) {
                return 0.0;
            }
            long l = System.currentTimeMillis();
            System.out.println("==\u6267\u884c\u5f00\u59cb\u65f6\u95f4==\uff1a" + l);
            String segmentedItemSalaryKey = "getsegmentedItemSalary_" + cmpItem;
            if (tempMap.get(segmentedItemSalaryKey) == null) {
                tempMap.put(segmentedItemSalaryKey, this.innitPersonSegmentedSalaryInfo(currencyMap, calScheme, cmpItem, name, standardWorkdays, mainTableRowFilter));
            }
            Map segmentedItemSalaryMap = new HashMap();
            segmentedItemSalaryMap = (Map)tempMap.get(segmentedItemSalaryKey);
            String key = paramMap.get("T_HR_SCMPCALTABLE_FPERSONID").toString();
            System.out.println("==\u6267\u884c\u7ed3\u675f\u65f6\u95f4===\uff1a" + System.currentTimeMillis() + "===" + (System.currentTimeMillis() - l));
            if (segmentedItemSalaryMap.containsKey(key)) {
                double salary = new BigDecimal(segmentedItemSalaryMap.get(key).toString()).doubleValue();
                return salary;
            }
            return 0.0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public double getSegmentedItemSalary(Map paramMap, HashMap tempMap, Map<String, BigDecimal> currencyMap, CalSchemeInfo calScheme, String cmpItem, double standardWorkdays, String name, String mainTableRowFilter) {
        try {
            String key;
            Object personWork;
            if (StringUtils.isEmpty((String)cmpItem) || paramMap.get("T_HR_SCMPCALTABLE_FPERSONID") == null) {
                return 0.0;
            }
            Map<Object, Object> segmentedItemSalaryMap = new HashMap();
            String fpersonId = paramMap.get("T_HR_SCMPCALTABLE_FPERSONID").toString();
            if (!tempMap.containsKey("getWorkCalendarWorkDaysBatch_" + name)) {
                this.getAllPersonSegmentedSalaryInfo(calScheme, cmpItem, name, tempMap, mainTableRowFilter);
            }
            List salaryList = null;
            Map<String, Object> workMap = null;
            Object personSalary = tempMap.get(fpersonId + "_" + cmpItem);
            if (personSalary != null) {
                salaryList = (List)personSalary;
            }
            if ((personWork = tempMap.get("getWorkCalendarWorkDaysBatch_" + name)) != null) {
                workMap = this.getPersonWorkMap(fpersonId, personWork);
            }
            if (salaryList != null && salaryList.size() > 0 && workMap != null) {
                segmentedItemSalaryMap = this.calculateSegmentedSalaryInfo(currencyMap, calScheme, salaryList, workMap, standardWorkdays);
            }
            if (segmentedItemSalaryMap.containsKey(key = paramMap.get("T_HR_SCMPCALTABLE_FPERSONID").toString())) {
                double salary = new BigDecimal(segmentedItemSalaryMap.get(key).toString()).doubleValue();
                return salary;
            }
            return 0.0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public Map<String, Object> getPersonWorkMap(String fpersonId, Object object) {
        List salaryList = (List)object;
        Map result = null;
        if (salaryList != null && salaryList.size() > 0) {
            Object work = ((Map)salaryList.get(0)).get("workCalendar") == null ? ((Map)salaryList.get(0)).get(fpersonId) : ((Map)salaryList.get(0)).get("workCalendar");
            result = work == null ? null : (Map)work;
        }
        return result;
    }

    public Map<String, List<Map<String, Object>>> getAllPersonSegmentedSalaryInfo(CalSchemeInfo calScheme, String cmpItem, String name, Map<String, List<Map<String, Object>>> tempMap, String mainTableRowFilter) throws Exception {
        java.util.Date beginDate = calScheme.getBeginDate();
        java.util.Date endDate = calScheme.getEndDate();
        SimpleDateFormat smdf = new SimpleDateFormat("yyyy-MM-dd");
        String fpersonIdList = this.getCalSchemeFpersonIDSQL(calScheme, mainTableRowFilter);
        tempMap.put("getWorkCalendarWorkDaysBatch_" + name, this.getWorkCalendarWorkDaysBatch(fpersonIdList, smdf.format(beginDate), smdf.format(endDate), name));
        String getAllPersonSegmentedSalaryInfoKey = "getAllPersonSegmentedSalaryInfoKey";
        if (tempMap.containsKey(getAllPersonSegmentedSalaryInfoKey)) {
            return tempMap;
        }
        tempMap.put(getAllPersonSegmentedSalaryInfoKey, new ArrayList());
        String querySql = this.getSegmentedSalarySQL(calScheme, mainTableRowFilter);
        Context ctx = com.kingdee.shr.compensation.app.formula.data.Tools.getInstance().getCtx();
        try {
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)querySql);
            List<Map<String, Object>> dataList = this.getDataFromExecuteQuery(executeQuery, "2");
            Iterator<Map<String, Object>> it = dataList.iterator();
            Map<Object, Object> dataListMap = new HashMap();
            while (it.hasNext()) {
                dataListMap = it.next();
                HashMap<String, Object> fixMap = new HashMap<String, Object>();
                ArrayList<HashMap<String, Object>> fixList = new ArrayList<HashMap<String, Object>>();
                String key = (String)dataListMap.get("personId") + "_" + (String)dataListMap.get("itemName");
                fixMap.put("personId", (String)dataListMap.get("personId"));
                fixMap.put("money", ((BigDecimal)dataListMap.get("money")).toString());
                fixMap.put("effectDay", (java.util.Date)dataListMap.get("effectDay"));
                fixMap.put("itemName", (String)dataListMap.get("itemName"));
                fixMap.put("leffectDay", (java.util.Date)dataListMap.get("LEFFECTDAY"));
                fixMap.put("currencyId", (String)dataListMap.get("FCURRENCYID"));
                fixMap.put("FRealEndDate", (java.util.Date)dataListMap.get("FRealEndDate"));
                if (tempMap.containsKey(key)) {
                    tempMap.get(key).add(fixMap);
                    continue;
                }
                fixList.add(fixMap);
                tempMap.put(key, fixList);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return tempMap;
    }

    public String getCalSchemeFpersonIDSQL(CalSchemeInfo calScheme, String mainTableRowFilter) {
        String calschemeid = calScheme.getId().toString();
        int calTime = calScheme.getCalTime();
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        String personSql = "select FPersonID from T_HR_SCmpCalTable t where t.FcalSchemeID = '" + calschemeid + "' and t.FcalTime = " + calTime + " and t.FperiodYear = " + periodYear + " and t.FperiodMonth = " + periodMonth + "";
        if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
            String replace = mainTableRowFilter.replace("t_hr_scmpcaltable.fid", "t.fid").replace("t_hr_scmpcaltable.FCalState", "t.fcalState");
            personSql = personSql + " and " + replace;
        }
        return Base64Utils.encodeWithSalt(personSql);
    }

    public String getSegmentedSalarySQL(CalSchemeInfo calScheme, String mainTableRowFilter) {
        String calschemeid = calScheme.getId().toString();
        int calTime = calScheme.getCalTime();
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        String calSchemeEndDate = CmpDateUtil.toKSqlDate(calScheme.getEndDate());
        String calSchemeBeginDate = CmpDateUtil.toKSqlDate(calScheme.getBeginDate());
        String personSql = "select FPersonID from T_HR_SCmpCalTable t where t.FcalSchemeID = '" + calschemeid + "' and t.FcalTime = " + calTime + " and t.FperiodYear = " + periodYear + " and t.FperiodMonth = " + periodMonth + " and calTable.fpersonid = t.FPERSONID ";
        if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
            String replace = mainTableRowFilter.replace("t_hr_scmpcaltable.fid", "t.fid").replace("t_hr_scmpcaltable.FCalState", "t.fcalState");
            personSql = personSql + " and " + replace;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT distinct fix.FMoney as money,FIX.FCURRENCYID ,fix.FEffectDay effectDay,fix.fleffectday LEFFECTDAY,fix.FPersonId personId,calTable.FRealEndDate FRealEndDate,item.FName_" + calScheme.getLanType().getValue() + " itemName, ").append("\r\n");
        sb.append(" ( case when (fix.fpayhrorgunitid is null or fix.fpayhrorgunitid in ('')) then 0  when ( calTable.FHrOrgUnitID= fix.fpayhrorgunitid) then 1 else 2 end ) type").append("\r\n");
        sb.append(" FROM t_hr_scmpcaltable calTable ").append("\r\n");
        sb.append(" left join T_HR_SFixAdjustSalary fix on calTable.fpersonid=fix.fpersonid  ").append("\r\n");
        sb.append(" left join T_HR_SFixAdjustPayHrRecord payHr on fix.fid=payHr.FSOURCEID  ").append("\r\n");
        sb.append(" left join T_HR_SCmpItem item on item.fid=fix.FCmpItemID  ").append("\r\n");
        sb.append(" where (calTable.FHrOrgUnitID= fix.fpayhrorgunitid or fix.fpayhrorgunitid is null)");
        sb.append(" and fix.FEffectDay <= calTable.FRealEndDate ").append("\r\n");
        sb.append(" and fix.FEffectDay <=").append(calSchemeEndDate).append("\r\n");
        sb.append(" and fix.FLEFFECTDAY >=").append(calSchemeBeginDate).append("\r\n");
        sb.append(" and payHr.fleffdt >=").append(calSchemeBeginDate).append("\r\n");
        sb.append(" and calTable.FcalTime=").append(calTime).append(" and calTable.FperiodYear=");
        sb.append(periodYear).append(" and calTable.FperiodMonth=").append(periodMonth);
        sb.append(" and calTable.FcalSchemeID='").append(calschemeid).append("'\r\n");
        sb.append(" and exists (").append(personSql).append(")").append("\r\n");
        sb.append(" order by fix.FPersonId ,item.FName_" + calScheme.getLanType().getValue() + ",fix.FEffectDay ").append("\r\n");
        String salarySQL = sb.toString();
        return salarySQL;
    }

    public List<Map<String, Object>> getWorkCalendarWorkDaysBatch(String fpersonIdList, String beginDate, String endDate, String name) {
        Context ctx = com.kingdee.shr.compensation.app.formula.data.Tools.getInstance().getCtx();
        HashMap<String, String> pam = new HashMap<String, String>();
        HashMap workMap = new HashMap();
        pam.put("beginDate", beginDate);
        pam.put("endDate", endDate);
        pam.put("name", name);
        pam.put("fpersonIdList", fpersonIdList);
        ArrayList<Map<String, Object>> fixList = new ArrayList<Map<String, Object>>();
        Object result = com.kingdee.eas.rpts.ctrlreport.osf.OSFExecutor.executeOSF((Context)ctx, pam, (String)"getWorkCalendarWorkDaysBatch");
        if (result != null) {
            fixList.add((Map)result);
        }
        return fixList;
    }

    public List<Map<String, Object>> getWorkCalendarWorkDaysPolicy(String fpersonIdList, String beginDate, String endDate) {
        Context ctx = com.kingdee.shr.compensation.app.formula.data.Tools.getInstance().getCtx();
        HashMap<String, String> pam = new HashMap<String, String>();
        HashMap workMap = new HashMap();
        pam.put("beginDate", beginDate);
        pam.put("endDate", endDate);
        pam.put("fpersonIdList", fpersonIdList);
        ArrayList<Map<String, Object>> fixList = new ArrayList<Map<String, Object>>();
        Object result = com.kingdee.eas.rpts.ctrlreport.osf.OSFExecutor.executeOSF((Context)ctx, pam, (String)"getWorkCalendarWorkDaysPolicy");
        if (result != null) {
            fixList.add((Map)result);
        }
        return fixList;
    }

    public Map<String, Object> calculateSegmentedSalaryInfo(Map<String, BigDecimal> currencyMap, CalSchemeInfo calScheme, List<Map<String, Object>> list, Map<String, Object> workMap, Double standardWorkdays) throws Exception {
        HashMap<String, Object> salaryMap = new HashMap();
        java.util.Date beginDate = calScheme.getBeginDate();
        java.util.Date endDate = calScheme.getEndDate();
        HashMap<String, List<Map<String, Object>>> allMap = new HashMap<String, List<Map<String, Object>>>();
        HashMap pam = new HashMap();
        SimpleDateFormat smdf = new SimpleDateFormat("yyyy-MM-dd");
        String tempEnd = null;
        Double money = 0.0;
        String tempBegin = beginDate.toString();
        String personId = list.get(0).get("personId").toString();
        if (smdf.parse(list.get(0).get("effectDay").toString()).getTime() - beginDate.getTime() < 0L) {
            for (int i = 0; i < list.size(); ++i) {
                String currendyId;
                money = new BigDecimal(list.get(i).get("money").toString()).doubleValue();
                String string = currendyId = list.get(i).get("currendyId") == null ? null : list.get(i).get("currendyId").toString();
                if (i + 1 < list.size()) {
                    tempEnd = smdf.format(smdf.parse(list.get(i + 1).get("effectDay").toString()).getTime() - 86400000L);
                } else {
                    java.util.Date leffectDay;
                    Object obj = list.get(i).get("leffectDay");
                    Object objReal = list.get(i).get("FRealEndDate");
                    java.util.Date date = leffectDay = obj == null ? endDate : smdf.parse(obj.toString());
                    if (objReal != null) {
                        java.util.Date realEndDate = smdf.parse(objReal.toString());
                        leffectDay = leffectDay.before(realEndDate) ? leffectDay : realEndDate;
                    }
                    tempEnd = leffectDay.before(endDate) ? smdf.format(leffectDay) : endDate.toString();
                }
                this.calculateData(personId, smdf.parse(tempBegin), smdf.parse(tempEnd), workMap, money, allMap, currendyId);
                if (!tempEnd.equals(endDate.toString())) {
                    tempEnd = smdf.format(smdf.parse(tempEnd).getTime() + 86400000L);
                }
                tempBegin = tempEnd;
            }
        } else {
            for (int i = 0; i < list.size(); ++i) {
                if (i == 0) {
                    tempBegin = smdf.format(smdf.parse(list.get(i).get("effectDay").toString()).getTime());
                }
                money = new BigDecimal(list.get(i).get("money").toString()).doubleValue();
                if (i + 1 < list.size()) {
                    tempEnd = smdf.format(smdf.parse(list.get(i + 1).get("effectDay").toString()).getTime() - 86400000L);
                } else {
                    java.util.Date leffectDay;
                    Object obj = list.get(i).get("leffectDay");
                    Object objReal = list.get(i).get("FRealEndDate");
                    java.util.Date date = leffectDay = obj == null ? endDate : smdf.parse(obj.toString());
                    if (objReal != null) {
                        java.util.Date realEndDate = smdf.parse(objReal.toString());
                        leffectDay = leffectDay.before(realEndDate) ? leffectDay : realEndDate;
                    }
                    tempEnd = leffectDay.before(endDate) ? smdf.format(leffectDay) : endDate.toString();
                }
                String currendyId = list.get(i).get("currendyId") == null ? null : list.get(i).get("currendyId").toString();
                this.calculateData(personId, smdf.parse(tempBegin), smdf.parse(tempEnd), workMap, money, allMap, currendyId);
                if (!tempEnd.equals(endDate.toString())) {
                    tempEnd = smdf.format(smdf.parse(tempEnd).getTime() + 86400000L);
                }
                tempBegin = tempEnd;
            }
        }
        salaryMap = this.getPersonSegmentedSalaryInfo(calScheme, allMap, currencyMap, standardWorkdays);
        return salaryMap;
    }

    public void calculateData(String personId, java.util.Date tempBegin, java.util.Date tempEnd, Map<String, Object> workDateMap, Double money, Map<String, List<Map<String, Object>>> allMap, String currendyId) throws ParseException {
        Context ctx = com.kingdee.shr.compensation.app.formula.data.Tools.getInstance().getCtx();
        HashMap<String, Object> workMap = new HashMap<String, Object>();
        int result = 0;
        SimpleDateFormat smdf = new SimpleDateFormat("yyyy-MM-dd");
        for (Map.Entry<String, Object> entry : workDateMap.entrySet()) {
            java.util.Date workDate = smdf.parse(entry.getKey());
            if (!CmpDateUtil.isEffectiveDate(workDate, tempBegin, tempEnd) || entry.getValue() == null || !"0".equals(entry.getValue().toString())) continue;
            ++result;
        }
        workMap.put("money", money);
        workMap.put("currendyId", currendyId);
        workMap.put("workDays", new BigDecimal(result));
        if (allMap.containsKey(personId)) {
            allMap.get(personId).add(workMap);
        } else {
            ArrayList<HashMap<String, Object>> workList = new ArrayList<HashMap<String, Object>>();
            workList.add(workMap);
            allMap.put(personId, workList);
        }
    }

    public String getItemSalaryCurrency(Map<String, Object> paramMap, HashMap<String, Object> tempMap, CalSchemeInfo calScheme, String cmpItem, double isFixed, String mainTableRowFilter) {
        try {
            String key;
            Map fixCurrencyMap = new HashMap();
            String fixCurrencyMapKey = "getItemSalaryCurrency_CurrencyMap_" + isFixed;
            if (StringUtils.isEmpty((String)cmpItem) || paramMap.get("T_HR_SCMPCALTABLE_FPERSONID") == null) {
                return "";
            }
            if (tempMap.get(fixCurrencyMapKey) == null) {
                tempMap.put(fixCurrencyMapKey, this.initFixCurrencyMap(calScheme, isFixed, mainTableRowFilter));
            }
            if ((fixCurrencyMap = (Map)tempMap.get(fixCurrencyMapKey)).containsKey(key = paramMap.get("T_HR_SCMPCALTABLE_FPERSONID") + "_" + cmpItem)) {
                String currency = fixCurrencyMap.containsKey(key) ? (String)fixCurrencyMap.get(key) : "";
                return currency == null ? "" : currency;
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public Map<String, String> initFixCurrencyMap(CalSchemeInfo calScheme, double isFixed, String mainTableRowFilter) throws Exception {
        Context ctx = com.kingdee.shr.compensation.app.formula.data.Tools.getInstance().getCtx();
        String l = calScheme.getLanType().getValue();
        StringBuilder sb = new StringBuilder();
        String effectDayField = "";
        String key = null;
        String personId = "";
        String cmpItem = "";
        String calCurrency = "";
        HashMap<String, String> fixPayMap = new HashMap<String, String>();
        HashSet<String> set = new HashSet<String>();
        effectDayField = isFixed == 0.0 ? "calTable.FBeginDate" : "calTable.FRealEndDate";
        String calschemeid = calScheme.getId().toString();
        int calTime = calScheme.getCalTime();
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        String hrOrgId = calScheme.getHrOrgUnit().getId().toString();
        String personSql = "select FPersonID from T_HR_SCmpCalTable where FcalSchemeID = '" + calschemeid + "' and FcalTime = " + calTime + " and FperiodYear = " + periodYear + " and FperiodMonth = " + periodMonth;
        sb.append(" SELECT DISTINCT CALTABLE.FPersonId personId, FIX.FMONEY money, FIX.FCURRENCYID, ");
        sb.append(" CMPITEM.FNAME_" + l + " itemName, calCurrency.FNAME_" + l + " calCurrency,FIX.FEFFECTDAY effectDay, ");
        sb.append(" ( case when (PAYHR.FHRORGUNITID is null or PAYHR.FHRORGUNITID in ('')) then 0  when ( PAYHR.FHRORGUNITID ='" + hrOrgId + "') then 1 else 2 end ) type").append("\r\n");
        sb.append(" FROM T_HR_SCMPCALTABLE CALTABLE ");
        sb.append(" INNER JOIN T_HR_SFIXADJUSTSALARY FIX ON CALTABLE.FPERSONID=FIX.FPERSONID ");
        sb.append(" INNER JOIN T_HR_SFIXADJUSTPAYHRRECORD PAYHR ON FIX.FID = PAYHR.FSOURCEID AND (PAYHR.FHRORGUNITID = '" + hrOrgId + "' OR  (PAYHR.FHRORGUNITID IS NULL or PAYHR.FHRORGUNITID in ('')))");
        sb.append(" LEFT JOIN T_HR_SCMPITEM CMPITEM ON CMPITEM.FID=FIX.FCMPITEMID ");
        sb.append(" left join T_BD_Currency calCurrency on calCurrency.FID =  FIX.fcurrencyID");
        sb.append(" WHERE PAYHR.FEFFDT <= ").append(effectDayField).append(" AND PAYHR.FLEFFDT >= ").append(effectDayField);
        sb.append(" AND CALTABLE.FHRORGUNITID='").append(hrOrgId).append("'");
        sb.append(" AND CALTABLE.FCALSCHEMEID = '").append(calschemeid).append("' ");
        sb.append(" AND CALTABLE.FPERIODYEAR=");
        sb.append(periodYear).append(" AND CALTABLE.FPERIODMONTH=").append(periodMonth);
        sb.append(" AND CALTABLE.FCALTIME=").append(calTime);
        if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
            String replace = mainTableRowFilter.replace("t_hr_scmpcaltable.fid", "CALTABLE.fid").replace("t_hr_scmpcaltable.FCalState", "CALTABLE.fcalState");
            sb.append(" and ").append(replace);
        } else {
            sb.append(" AND CALTABLE.FPERSONID IN(").append(personSql).append(")");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        List<Map<String, Object>> dataList = this.getDataFromExecuteQuery(rs, "3");
        Map<String, Object> map2 = null;
        for (Map<String, Object> map2 : dataList) {
            personId = (String)map2.get("personId");
            cmpItem = (String)map2.get("itemName");
            calCurrency = (String)map2.get("calCurrency");
            key = personId + "_" + cmpItem;
            if (set.contains(key)) continue;
            set.add(key);
            fixPayMap.put(key, calCurrency);
        }
        return fixPayMap;
    }

    public static String getMonthDay(String date1, String date2) {
        Context ctx = com.kingdee.shr.compensation.app.formula.data.Tools.getInstance().getCtx();
        int rsl = (int)FunctionTools.getDiffMonsNoDate((String)date1, (String)date2);
        int year = rsl / 12;
        int month = rsl % 12;
        if (year > 0 && month > 0) {
            return year + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalLockResource", (String)"label11", (Locale)ctx.getLocale()) + month + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalLockResource", (String)"label26", (Locale)ctx.getLocale());
        }
        if (year > 0 && month <= 0) {
            return year + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalLockResource", (String)"label11", (Locale)ctx.getLocale());
        }
        if (year <= 0 && month > 0) {
            return month + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalLockResource", (String)"label26", (Locale)ctx.getLocale());
        }
        return "";
    }

    public double getCalendarWorkDays(Map paramMap, HashMap tempMap, CalSchemeInfo calScheme, String name, String beginDate, String endDate, String mainTableRowFilter) {
        Object personWork;
        double result = -1.0;
        SimpleDateFormat smdf = new SimpleDateFormat("yyyy-MM-dd");
        String fpersonIdList = this.getCalSchemeFpersonIDSQL(calScheme, mainTableRowFilter);
        Map<String, Object> workMap = null;
        String fpersonId = paramMap.get("T_HR_SCMPCALTABLE_FPERSONID").toString();
        String keyName = "getCalendarWorkDaysBatch_" + name + "_" + beginDate + "_" + endDate;
        if (!tempMap.containsKey(keyName)) {
            tempMap.put(keyName, this.getWorkCalendarWorkDaysBatch(fpersonIdList, beginDate, endDate, name));
        }
        if ((personWork = tempMap.get(keyName)) != null) {
            workMap = this.getPersonWorkMap(fpersonId, personWork);
        }
        String policyKeyName = "getWorkCalendarWorkDaysPolicy_" + name + "_" + beginDate + "_" + endDate;
        if (!(workMap != null && workMap.size() >= 1 || tempMap.containsKey(policyKeyName))) {
            tempMap.put("getWorkCalendarWorkDaysPolicy", this.getWorkCalendarWorkDaysPolicy(fpersonIdList, beginDate, endDate));
        }
        if (workMap == null || workMap.size() < 1) {
            Object personPolicyWork;
            Object v0 = personPolicyWork = tempMap.get(policyKeyName) != null ? tempMap.get(policyKeyName) : null;
            if (personPolicyWork != null) {
                workMap = this.getPersonWorkMap(fpersonId, personWork);
            }
        }
        try {
            result = this.calculatePersonWorkDate(workMap, fpersonId, smdf.parse(beginDate), smdf.parse(endDate), smdf);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return result;
    }

    public double calculatePersonWorkDate(Map<String, Object> workDateMap, String personId, java.util.Date tempBegin, java.util.Date tempEnd, DateFormat smdf) throws ParseException {
        int result = 0;
        if (workDateMap == null) {
            return -1.0;
        }
        for (Map.Entry<String, Object> entry : workDateMap.entrySet()) {
            java.util.Date workDate = smdf.parse(entry.getKey());
            if (!CmpDateUtil.isEffectiveDate(workDate, tempBegin, tempEnd) || entry.getValue() == null || !"0".equals(entry.getValue().toString())) continue;
            ++result;
        }
        return result;
    }

    public double getStopCalSalary(Map<String, Object> paramMap, HashMap<String, Object> tempMap, CalSchemeInfo calScheme, String mainTableRowFilter, String schemeName, String cmpItemsName) throws SQLException, BOSException {
        if (StringUtils.isEmpty((String)cmpItemsName)) {
            return 0.0;
        }
        String key = "PeriodItem_" + schemeName + "_" + cmpItemsName;
        String personIdkey = key + "_idSet";
        Map<String, Double> resultMap = new HashMap();
        Map personIdMap = new HashMap();
        Map<Object, Object> currencyMap = new HashMap();
        BigDecimal rate = new BigDecimal(1);
        if (tempMap.get(key) == null) {
            Map itemMap;
            String itemKey = "CalItem_getCmpStopCalName";
            if (tempMap.get(itemKey) == null) {
                tempMap.put(itemKey, this.getCmpCalTableName(calScheme));
            }
            if ((itemMap = (Map)tempMap.get(itemKey)).get(cmpItemsName) == null) {
                return 0.0;
            }
            String fieldSn = "S" + (String)itemMap.get(cmpItemsName);
            if (null != calScheme.getCurrency()) {
                java.util.Date effdt = calScheme.getExchangeRule().equals((Object)CmpExchangeRuleEnum.PERIOD_BEGIN) ? calScheme.getBeginDate() : calScheme.getEndDate();
                currencyMap = CurrencyUtil.getTargetExchangeRateMap(com.kingdee.shr.compensation.app.formula.data.Tools.getInstance().getCtx(), calScheme.getExchangeTable().getId().toString(), calScheme.getCurrency().getId().toString(), effdt);
            }
            StringBuilder str = new StringBuilder();
            str.append(" select A.fpersonId, A." + fieldSn + " as item, A.FCurrencyID currencyId, A.FID from T_HR_SCMPSTOPCAL A ");
            str.append(" where ( (A.fgrantSchemeid is null and A.fgrantState = 0 and ((A.fperiodYear < " + calScheme.getPeriodYear() + ") or (A.fperiodYear = " + calScheme.getPeriodYear() + " and A.fperiodMonth < " + calScheme.getPeriodMonth() + ") or (A.fperiodYear = " + calScheme.getPeriodYear() + " and A.fperiodMonth = " + calScheme.getPeriodMonth() + " and A.fcalTime < " + calScheme.getCalTime() + ")))");
            str.append("  or (A.fgrantSchemeid = '" + calScheme.getId().toString() + "' and A.fgrantPeriodYear = " + calScheme.getPeriodYear() + " and A.fgrantPeriodMonth = " + calScheme.getPeriodMonth() + " and A.fgrantCalTime = " + calScheme.getCalTime() + " and A.fgrantState = 1)");
            str.append(")");
            str.append(" and A.FhrOrgUnitId = '" + calScheme.getHrOrgUnit().getId() + "' ");
            String language = com.kingdee.shr.compensation.app.formula.data.Tools.getInstance().getCtx().getLocale().getLanguage();
            Object[] param = null;
            if (!StringUtils.isEmpty((String)schemeName)) {
                param = new Object[]{schemeName};
                str.append(" and A.fcalschemeid in ( ");
                str.append(" select b.fid from t_hr_scalscheme b ");
                str.append(" where b.fname_" + language + " = ? ");
                str.append(" ) ");
            }
            String personSql = "select FPersonID from T_HR_SCmpCalTable where FcalSchemeID = '" + calScheme.getId().toString() + "' ";
            if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
                str.append(" and A.fpersonId in (").append(personSql).append(" and ").append(mainTableRowFilter).append(")");
            }
            Set<String> idSet = null;
            Context ctx = com.kingdee.shr.compensation.app.formula.data.Tools.getInstance().getCtx();
            try {
                IRowSet rowSet = null;
                rowSet = param == null ? DbUtil.executeQuery((Context)ctx, (String)str.toString()) : DbUtil.executeQuery((Context)ctx, (String)str.toString(), (Object[])param);
                while (rowSet.next()) {
                    rate = null == currencyMap.get(rowSet.getString("currencyId")) ? new BigDecimal(1) : (BigDecimal)currencyMap.get(rowSet.getString("currencyId"));
                    String person = rowSet.getString("fpersonId");
                    BigDecimal fieldValue = new BigDecimal(rowSet.getDouble("item")).multiply(rate);
                    if (resultMap.containsKey(person)) {
                        BigDecimal lastValue = new BigDecimal((Double)resultMap.get(person));
                        resultMap.put(person, fieldValue.add(lastValue).doubleValue());
                        idSet = (Set)personIdMap.get(person);
                        idSet.add(rowSet.getString("FID"));
                        personIdMap.put(person, idSet);
                        continue;
                    }
                    resultMap.put(person, fieldValue.doubleValue());
                    idSet = new HashSet<String>();
                    idSet.add(rowSet.getString("FID"));
                    personIdMap.put(person, idSet);
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            tempMap.put(key, resultMap);
            tempMap.put(personIdkey, personIdMap);
        } else {
            resultMap = (Map)tempMap.get(key);
            personIdMap = (Map)tempMap.get(personIdkey);
        }
        double resultValue = 0.0;
        String personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        if (resultMap.get(personId) != null) {
            resultValue = (Double)resultMap.get(personId);
            paramMap.put("stopCalPersonId", personIdMap.get(personId));
        }
        return resultValue;
    }

    private Map<String, String> getCmpCalTableName(CalSchemeInfo calScheme) throws SQLException {
        Context ctx = com.kingdee.shr.compensation.app.formula.data.Tools.getInstance().getCtx();
        String l = calScheme.getLanType().getValue();
        String sql = "select FIELDSN, FNAME_" + l + " from T_HR_SCmpItem order by FIELDSN";
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (executeQuery.next()) {
                String resultKey = executeQuery.getString("FNAME_" + l + "");
                String resultValue = executeQuery.getString("FIELDSN");
                resultMap.put(resultKey, resultValue);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return resultMap;
    }

    public List<Map<String, Object>> getDataFromExecuteQuery(IRowSet executeQuery, String queryType) throws SQLException {
        Map<String, Object> map = null;
        ArrayList<Map<String, Object>> dataList = null;
        HashMap mapList = null;
        HashMap mapListOne = null;
        HashMap mapListZero = null;
        List<Map<String, Object>> list = null;
        List<Map<String, Object>> oneList = null;
        List<Map<String, Object>> zeroList = null;
        if (null != executeQuery) {
            String personId = null;
            dataList = new ArrayList<Map<String, Object>>();
            mapList = new HashMap();
            mapListOne = new HashMap();
            mapListZero = new HashMap();
            while (executeQuery.next()) {
                map = this.executeQueryToMap(executeQuery, queryType);
                personId = executeQuery.getString("personId");
                int type = executeQuery.getInt("type");
                if (mapList.containsKey(personId)) {
                    list = (List)mapList.get(personId);
                    list.add(map);
                } else {
                    list = new ArrayList();
                    list.add(map);
                    mapList.put(personId, list);
                }
                if (type == 1) {
                    if (mapListOne.containsKey(personId)) {
                        oneList = (List)mapListOne.get(personId);
                        oneList.add(map);
                        continue;
                    }
                    oneList = new ArrayList();
                    oneList.add(map);
                    mapListOne.put(personId, oneList);
                    continue;
                }
                if (type != 0) continue;
                if (mapListZero.containsKey(personId)) {
                    zeroList = (List)mapListZero.get(personId);
                    zeroList.add(map);
                    continue;
                }
                zeroList = new ArrayList();
                zeroList.add(map);
                mapListZero.put(personId, zeroList);
            }
            list = null;
            for (String str : mapList.keySet()) {
                list = (ArrayList)mapList.get(str);
                if (mapListOne.containsKey(str)) {
                    dataList.addAll((Collection)mapListOne.get(str));
                }
                if (!mapListZero.containsKey(str)) continue;
                dataList.addAll((Collection)mapListZero.get(str));
            }
        }
        if (null != dataList && !dataList.isEmpty()) {
            return dataList;
        }
        return new ArrayList<Map<String, Object>>(0);
    }

    public Map<String, Object> executeQueryToMap(IRowSet executeQuery, String queryType) throws SQLException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if ("1".equals(queryType)) {
            map.put("personId", executeQuery.getString("personId"));
            map.put("money", executeQuery.getBigDecimal("money") == null ? new BigDecimal(0) : executeQuery.getBigDecimal("money"));
            map.put("stdPoint", executeQuery.getString("stdPoint"));
            map.put("floatRate", executeQuery.getString("floatRate"));
            map.put("stdLevel", executeQuery.getString("stdLevel"));
            map.put("stdScope", executeQuery.getString("stdScope"));
            map.put("standard", executeQuery.getString("standard"));
            map.put("cmpItem", executeQuery.getString("cmpItem"));
            map.put("standard", executeQuery.getString("standard"));
            map.put("FEffectDay", executeQuery.getDate("FEffectDay"));
            map.put("FLEFFDT", executeQuery.getDate("FLEFFDT"));
            map.put("FBeginDate", executeQuery.getDate("FBeginDate"));
            map.put("FRealEndDate", executeQuery.getDate("FRealEndDate"));
        } else if ("5".equals(queryType)) {
            map.put("personId", executeQuery.getString("personId"));
            map.put("MONEY", executeQuery.getBigDecimal("MONEY") == null ? new BigDecimal(0) : executeQuery.getBigDecimal("MONEY"));
            map.put("FCURRENCYID", executeQuery.getString("FCURRENCYID"));
            map.put("CMPITEM", executeQuery.getString("CMPITEM"));
            map.put("FEFFECTDAY", executeQuery.getDate("FEFFECTDAY"));
        } else {
            map.put("personId", executeQuery.getString("personId"));
            map.put("money", executeQuery.getBigDecimal("money") == null ? new BigDecimal(0) : executeQuery.getBigDecimal("money"));
            map.put("itemName", executeQuery.getString("itemName"));
            map.put("effectDay", executeQuery.getDate("effectDay"));
            map.put("type", executeQuery.getInt("type"));
            if ("2".equals(queryType)) {
                map.put("LEFFECTDAY", executeQuery.getDate("LEFFECTDAY"));
                map.put("FCURRENCYID", executeQuery.getString("FCURRENCYID"));
                map.put("FRealEndDate", executeQuery.getDate("FRealEndDate"));
            }
            if ("3".equals(queryType)) {
                map.put("calCurrency", executeQuery.getString("calCurrency"));
                map.put("FCURRENCYID", executeQuery.getString("FCURRENCYID"));
            }
        }
        return map;
    }

    public List<Map<String, Object>> getDataFromExecuteQuery(IRowSet executeQuery, java.util.Date beginDate, java.util.Date endDate) throws SQLException {
        Map<String, java.util.Date> map = null;
        ArrayList<Map<String, Object>> dataList = null;
        HashMap mapSet = null;
        HashMap mapSetOne = null;
        HashMap mapSetZero = null;
        List<Map<String, java.util.Date>> list = null;
        List<Map<String, java.util.Date>> oneList = null;
        List<Map<String, java.util.Date>> zeroList = null;
        Calendar c = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (null != executeQuery) {
            String personId = null;
            dataList = new ArrayList<Map<String, Object>>();
            mapSet = new HashMap();
            mapSetOne = new HashMap();
            mapSetZero = new HashMap();
            while (executeQuery.next()) {
                map = new HashMap<String, Object>();
                personId = executeQuery.getString("personId");
                map.put("personId", (java.util.Date)((Object)executeQuery.getString("personId")));
                map.put("money", (java.util.Date)((Object)(executeQuery.getBigDecimal("money") == null ? new BigDecimal(0) : executeQuery.getBigDecimal("money"))));
                map.put("FCURRENCYID", (java.util.Date)((Object)executeQuery.getString("FCURRENCYID")));
                map.put("itemName", (java.util.Date)((Object)executeQuery.getString("itemName")));
                map.put("effectDay", executeQuery.getDate("effectDay"));
                map.put("LEFFECTDAY", executeQuery.getDate("LEFFECTDAY"));
                int type = executeQuery.getInt("type");
                if (mapSet.containsKey(personId)) {
                    list = (List)mapSet.get(personId);
                    list.add(map);
                } else {
                    list = new ArrayList();
                    list.add(map);
                    mapSet.put(personId, list);
                }
                if (type == 1) {
                    if (mapSetOne.containsKey(personId)) {
                        oneList = (List)mapSetOne.get(personId);
                        oneList.add(map);
                        continue;
                    }
                    oneList = new ArrayList();
                    oneList.add(map);
                    mapSetOne.put(personId, oneList);
                    continue;
                }
                if (type != 0) continue;
                if (mapSetZero.containsKey(personId)) {
                    zeroList = (List)mapSetZero.get(personId);
                    zeroList.add(map);
                    continue;
                }
                zeroList = new ArrayList();
                zeroList.add(map);
                mapSetZero.put(personId, zeroList);
            }
            list = null;
            java.util.Date effectDayMin = null;
            java.util.Date effectDay = null;
            java.util.Date leffectdayMax = null;
            java.util.Date leffectday = null;
            int dayTotal = this.getDays(beginDate, endDate);
            int daySum = 0;
            java.util.Date firstEffectDay = null;
            java.util.Date lastLeffectday = null;
            ArrayList<String> sectionList = new ArrayList<String>();
            String section = null;
            for (String str : mapSet.keySet()) {
                if (mapSetOne.containsKey(str)) {
                    oneList = (ArrayList)mapSetOne.get(str);
                    for (int i = 0; i < oneList.size(); ++i) {
                        map = (Map)oneList.get(i);
                        effectDay = (java.util.Date)map.get("effectDay");
                        leffectday = (java.util.Date)map.get("LEFFECTDAY");
                        if (effectDay.before(beginDate)) {
                            map.put("effectDay", beginDate);
                            effectDay = beginDate;
                        }
                        if (leffectday.after(endDate)) {
                            leffectday = endDate;
                        }
                        if (i == 0) {
                            firstEffectDay = effectDay;
                        }
                        if (lastLeffectday == null) {
                            if (null != firstEffectDay && firstEffectDay.after(beginDate)) {
                                section = sdf.format(beginDate) + "|" + sdf.format(effectDay);
                                sectionList.add(section);
                                firstEffectDay = null;
                            } else {
                                lastLeffectday = leffectday;
                            }
                        } else {
                            int one = (int)(effectDay.getTime() - lastLeffectday.getTime()) / 86400000;
                            if (1 == one) {
                                lastLeffectday = leffectday;
                            } else {
                                section = sdf.format(lastLeffectday) + "|" + sdf.format(effectDay);
                                sectionList.add(section);
                                lastLeffectday = leffectday;
                            }
                        }
                        daySum += this.getDays(effectDay, leffectday);
                        if (null == effectDayMin || effectDayMin.after(effectDay)) {
                            effectDayMin = effectDay;
                        }
                        if (null != leffectdayMax && !leffectdayMax.before(leffectday)) continue;
                        leffectdayMax = leffectday;
                    }
                    if (null != effectDayMin && !effectDayMin.after(beginDate) && null != leffectdayMax && !leffectdayMax.before(endDate) && daySum == dayTotal) {
                        dataList.addAll((Collection<Map<String, Object>>)oneList);
                    } else {
                        zeroList = (ArrayList)mapSetZero.get(str);
                        Date realEffectDay = null;
                        Date realLeffectday = null;
                        if (null != sectionList && !sectionList.isEmpty() && null != zeroList && !zeroList.isEmpty()) {
                            ArrayList<Map> zeroNewList = new ArrayList<Map>();
                            block5: for (String sectionStr : sectionList) {
                                String effectDayStr = sectionStr.split("\\|")[0];
                                String leffectdayStr = sectionStr.split("\\|")[1];
                                try {
                                    realEffectDay = !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)effectDayStr) ? new Date(sdf.parse(effectDayStr).getTime()) : null;
                                    Date date = realLeffectday = !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)leffectdayStr) ? new Date(sdf.parse(leffectdayStr).getTime()) : null;
                                    if (null == realEffectDay || null == realLeffectday) {
                                        break;
                                    }
                                }
                                catch (ParseException e) {
                                    e.printStackTrace();
                                }
                                if (null != realEffectDay && realEffectDay.after(beginDate)) {
                                    c.setTime(realEffectDay);
                                    c.add(5, 1);
                                    realEffectDay = new Date(c.getTime().getTime());
                                }
                                for (Map map2 : zeroList) {
                                    effectDay = (java.util.Date)map2.get("effectDay");
                                    leffectday = (java.util.Date)map2.get("LEFFECTDAY");
                                    if (!effectDay.before(realEffectDay) || !leffectday.after(realLeffectday)) continue;
                                    map2.put("effectDay", realEffectDay);
                                    zeroNewList.add(map2);
                                    continue block5;
                                }
                            }
                            oneList.addAll(zeroNewList);
                        }
                        Collections.sort(oneList, new Comparator<Map<String, Object>>(){

                            @Override
                            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                                java.util.Date date1 = null;
                                java.util.Date date2 = null;
                                date1 = (java.util.Date)o1.get("effectDay");
                                date2 = (java.util.Date)o2.get("effectDay");
                                return date1.compareTo(date2);
                            }
                        });
                        dataList.addAll((Collection<Map<String, Object>>)oneList);
                    }
                    daySum = 0;
                    continue;
                }
                dataList.addAll((Collection)mapSetZero.get(str));
            }
        }
        if (null != dataList && !dataList.isEmpty()) {
            return dataList;
        }
        return new ArrayList<Map<String, Object>>(0);
    }

    public int getDays(java.util.Date beginDate, java.util.Date endDate) {
        int day = (int)((endDate.getTime() - beginDate.getTime()) / 86400000L) + 1;
        return day;
    }

    public String getHisAdjSalaryRecordForCmp(Map paramMap, HashMap tempMap, CalSchemeInfo calScheme, String cmpItemName, String hrOrgUnitName, String valueType, double lastTimes) {
        String personid;
        HashMap result;
        if (lastTimes >= 1.0) {
            return "";
        }
        int lastTimesInt = (int)Math.abs(lastTimes);
        String tempMapKey = "CalFunctionService_getHisAdjSalaryRecordForCmp_" + cmpItemName + "_" + hrOrgUnitName + "_" + lastTimesInt;
        if (tempMap.get(tempMapKey) == null) {
            try {
                tempMap.put(tempMapKey, this.initHisAdjSalaryRecord(calScheme, cmpItemName, hrOrgUnitName, lastTimesInt));
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                tempMap.put(tempMapKey, new HashMap());
            }
        }
        if ((result = (HashMap)tempMap.get(tempMapKey)).containsKey(personid = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID"))) {
            Map perPersonMap = (Map)result.get(personid);
            String value = (String)perPersonMap.get(valueType);
            if (value == null) {
                return "";
            }
            return value;
        }
        return "";
    }

    public double getCmpStandardValueForCmp(HashMap tempMap, String cmpStdName, String cmpItemName, String cmpStdLevelName, String cmpStdPointName) {
        Map result;
        String tempMapKey = "CalFunctionService_getCmpStandardValueForCmp_" + cmpStdName;
        if (tempMap.get(tempMapKey) == null) {
            try {
                tempMap.put(tempMapKey, this.initCmpStdValues(cmpStdName));
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                tempMap.put(tempMapKey, new HashMap());
            }
        }
        if ((result = (Map)tempMap.get(tempMapKey)).containsKey(cmpItemName)) {
            Map itemMap = (Map)result.get(cmpItemName);
            if (null != itemMap && itemMap.containsKey(cmpStdLevelName)) {
                Map poScMap = (Map)itemMap.get(cmpStdLevelName);
                if (null != poScMap && poScMap.containsKey(cmpStdPointName)) {
                    return (Double)poScMap.get(cmpStdPointName);
                }
                return 0.0;
            }
            return 0.0;
        }
        return 0.0;
    }

    public String getCmpStdCurrencyForCmp(HashMap tempMap, String cmpStdName) {
        Map currencyMap;
        String tempMapKey = "CalFunctionService_getCmpStdCurrencyForCmp_ALL";
        if (tempMap.get(tempMapKey) == null) {
            try {
                tempMap.put(tempMapKey, this.initCmpStdCurrencyValues(cmpStdName));
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                tempMap.put(tempMapKey, new HashMap());
            }
        }
        if ((currencyMap = (Map)tempMap.get(tempMapKey)).containsKey(cmpStdName)) {
            return (String)currencyMap.get(cmpStdName);
        }
        return "";
    }

    private Map<String, String> initCmpStdCurrencyValues(String cmpStdName) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        StringBuffer sqlBuffer = new StringBuffer();
        Context ctx = com.kingdee.shr.compensation.app.formula.data.Tools.getInstance().getCtx();
        String language = ctx.getLocale().getLanguage();
        sqlBuffer.append(" SELECT STD.FNAME_").append(language).append(" STDNAME, ");
        sqlBuffer.append(" CUR.FNAME_").append(language).append(" CURNAME");
        sqlBuffer.append("  FROM T_HR_SCMPSTANDARD STD ");
        sqlBuffer.append("  INNER JOIN T_BD_CURRENCY CUR ON STD.FCURRENCYID = CUR.FID  ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
        if (rowSet == null || rowSet.size() < 1) {
            return result;
        }
        while (rowSet.next()) {
            result.put(rowSet.getString("STDNAME"), rowSet.getString("CURNAME"));
        }
        return result;
    }

    private Map<String, Map<String, String>> initHisAdjSalaryRecord(CalSchemeInfo calScheme, String cmpItemName, String hrOrgUnitName, int lastTimes) throws Exception {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        StringBuffer sqlBuffer = new StringBuffer();
        Context ctx = com.kingdee.shr.compensation.app.formula.data.Tools.getInstance().getCtx();
        String language = ctx.getLocale().getLanguage();
        sqlBuffer.append(" /*dialect*/ SELECT t1.* FROM ( ");
        sqlBuffer.append(" SELECT t.*, row_number() over(partition by t.personid order by t.effectDay desc) rn FROM  ");
        sqlBuffer.append(" ( ");
        sqlBuffer.append(" select adj.fpersonid personID,adj.fmoney money,le.floatRate floatRate,adj.feffectday effectDay, adj.FLeffectDay leffectDay ,");
        sqlBuffer.append(" std.fname_").append(language).append(" stdName,le.fname_").append(language).append(" levelName,po.fname_").append(language).append(" pointName,sc.fname_").append(language).append(" scopeName ");
        sqlBuffer.append(" ,cu.fname_").append(language).append(" currencyName ");
        sqlBuffer.append(" ,adj.FRemark_").append(language).append(" remark ,salarycause.fname_").append(language).append(" cause ");
        sqlBuffer.append(" from T_HR_SfixAdjustSalary adj ");
        sqlBuffer.append(" left join T_HR_SAdjustSalaryCause salarycause on salarycause.Fid = adj.FAdjustSalaryCauseID ");
        sqlBuffer.append(" inner join T_HR_Sfixadjustpayhrrecord rec on adj.fid = rec.fsourceid ");
        sqlBuffer.append(" left join T_HR_SCmpStandard std on adj.fstandardid = std.fid ");
        sqlBuffer.append(" left join T_HR_SCmpStdLevel le on adj.fstdLevelId = le.fid ");
        sqlBuffer.append(" left join T_HR_SCmpStdPoint po on adj.fstdpointid = po.fid ");
        sqlBuffer.append(" left join T_HR_SCMPSTDSCOPE sc on adj.fstdscopeid = sc.fid ");
        sqlBuffer.append(" left join T_ORG_HRO hr on hr.FID = adj.FPAYHRORGUNITID ");
        sqlBuffer.append(" inner join  T_HR_SCmpItem item on adj.FCMPITEMID = item.FID  ");
        sqlBuffer.append(" inner join T_BD_currency cu on adj.fcurrencyid =cu.fid ");
        sqlBuffer.append(" where item.fname_").append(language).append(" = '").append(cmpItemName).append("' ");
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)hrOrgUnitName)) {
            sqlBuffer.append(" and (hr.fname_").append(language).append(" = '").append(hrOrgUnitName).append("' ");
            sqlBuffer.append(" or adj.FPAYHRORGUNITID").append(" is null )");
        }
        sqlBuffer.append(" and adj.fpersonid in ( ").append(this.getPersonSql(calScheme)).append(")");
        sqlBuffer.append(" )t)t1 ");
        sqlBuffer.append(" where t1.rn = ").append(Math.abs(lastTimes) + 1);
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
        if (executeQuery == null || executeQuery.size() < 1) {
            return result;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        while (executeQuery.next()) {
            HashMap<String, String> perPersonMap = new HashMap<String, String>();
            perPersonMap.put(ADJ_MONEY_STR, executeQuery.getString("money"));
            perPersonMap.put(ADJ_STD_STR, executeQuery.getString("stdName"));
            perPersonMap.put(ADJ_STD_LEVEL_STR, executeQuery.getString("levelName"));
            perPersonMap.put(ADJ_STD_POINT_STR, executeQuery.getString("pointName"));
            perPersonMap.put(ADJ_STD_SCOPE_STR, executeQuery.getString("scopeName"));
            perPersonMap.put(ADJ_STD_FLOAT_STR, executeQuery.getString("floatRate"));
            perPersonMap.put(ADJ_CURRENCY_STR, executeQuery.getString("currencyName"));
            perPersonMap.put(ADJ_EFFECTDAY_STR, dateFormat.format(executeQuery.getDate("effectDay")));
            perPersonMap.put(ADJ_LEFFECTDAY_STR, dateFormat.format(executeQuery.getDate("leffectDay")));
            perPersonMap.put(ADJ_CAUSE_STR, executeQuery.getString("cause"));
            perPersonMap.put(ADJ_REMARK_STR, executeQuery.getString("remark"));
            result.put(executeQuery.getString("personID"), perPersonMap);
        }
        return result;
    }

    private Map<String, Map<String, Map<String, Double>>> initCmpStdValues(String cmpStdName) throws Exception {
        HashMap<String, Map<String, Map<String, Double>>> result = new HashMap<String, Map<String, Map<String, Double>>>();
        StringBuffer sqlBuffer = new StringBuffer();
        Context ctx = com.kingdee.shr.compensation.app.formula.data.Tools.getInstance().getCtx();
        String language = ctx.getLocale().getLanguage();
        sqlBuffer.append(" select FLevelType from T_HR_SCmpStandard where fname_").append(language).append(" = '").append(cmpStdName).append("' ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
        if (rowSet == null || rowSet.size() < 1) {
            return result;
        }
        boolean isCmpPoint = false;
        while (rowSet.next()) {
            isCmpPoint = 0 == rowSet.getInt("FLevelType");
        }
        sqlBuffer = new StringBuffer();
        sqlBuffer.append(" select ");
        sqlBuffer.append(" item.fname_").append(language).append(" itemName, ");
        sqlBuffer.append(" lev.fname_").append(language).append(" levelName, ");
        if (isCmpPoint) {
            sqlBuffer.append(" po.fname_").append(language).append(" poScName, ");
        } else {
            sqlBuffer.append(" sc.fname_").append(language).append(" poScName, ");
        }
        sqlBuffer.append(" va.Fvalue value ");
        sqlBuffer.append(" from T_HR_SCmpStandard std ");
        sqlBuffer.append(" inner join  T_HR_SCmpStdLevel lev on std.fid = lev.fcmpstandardid ");
        if (isCmpPoint) {
            sqlBuffer.append(" inner join  T_HR_SCmpStdPoint po on std.fid = po.fcmpstandardid ");
        } else {
            sqlBuffer.append(" inner join  T_HR_ScmpStdScope sc on std.fid = sc.fcmpstandardid ");
        }
        sqlBuffer.append(" inner join  T_HR_SCmpStdValue va on lev.fid = va.fcmpstdlevelid ");
        if (isCmpPoint) {
            sqlBuffer.append(" and va.fcmpstdpointid = po.fid ");
        } else {
            sqlBuffer.append(" and va.fcmpstdscopeid = sc.fid ");
        }
        sqlBuffer.append(" inner join  T_HR_SCmpStdItem stditem on std.fid = stditem.fcmpstandardid and stditem.fid = va.fcmpstditemid ");
        sqlBuffer.append(" inner join  T_HR_SCmpItem item on stditem.fcmpitemid = item.fid ");
        sqlBuffer.append(" where ");
        sqlBuffer.append(" std.fname_").append(language).append(" = '").append(cmpStdName).append("' ");
        sqlBuffer.append(" order by item.Findex, lev.FSortSn ");
        if (isCmpPoint) {
            sqlBuffer.append(" ,po.FSortSn ");
        } else {
            sqlBuffer.append(" ,sc.FSortSn ");
        }
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
        if (rowSet == null || rowSet.size() < 1) {
            return result;
        }
        String itemName = "";
        String levelName = "";
        String poScName = "";
        double value = 0.0;
        while (rowSet.next()) {
            itemName = rowSet.getString("itemName");
            levelName = rowSet.getString("levelName");
            Map levelMap = result.containsKey(itemName) ? (Map)result.get(itemName) : new HashMap();
            poScName = rowSet.getString("poScName");
            Map valueMap = levelMap.containsKey(levelName) ? (Map)levelMap.get(levelName) : new HashMap();
            value = rowSet.getDouble("value");
            valueMap.put(poScName, value);
            levelMap.put(levelName, valueMap);
            result.put(itemName, levelMap);
        }
        return result;
    }

    private String getPersonSql(CalSchemeInfo calScheme) {
        String calschemeid = calScheme.getId().toString();
        int calTime = calScheme.getCalTime();
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        String hrOrgId = calScheme.getHrOrgUnit().getId().toString();
        String personSql = "select FPersonID from T_HR_SCmpCalTable where FcalSchemeID = '" + calschemeid + "' and FcalTime = " + calTime + " and FperiodYear = " + periodYear + " and FperiodMonth = " + periodMonth;
        return personSql;
    }
}

