/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.service.timepiece;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.app.tax.YesOrNoEnum;
import com.kingdee.shr.compensation.service.timepiece.CacheExtData;
import com.kingdee.shr.compensation.service.timepiece.DataCell;
import com.kingdee.shr.compensation.service.timepiece.DataRow;
import com.kingdee.shr.validaterule.formula.SalaryCalFunction2;
import com.kingdee.shr.validaterule.util.DateUtil;
import com.kingdee.shr.validaterule.util.EntityUtil;
import com.kingdee.util.enums.Enum;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import shaded.com.google.common.collect.Lists;

public class CalFunGetExternalDataService
extends SalaryCalFunction2 {
    private static Logger logger = Logger.getLogger(CalFunGetExternalDataService.class);

    public String getExternalData(Context ctx, String schemeId, String mainTableName, Map<String, Object> paramMap, HashMap<String, Object> tempMap, String configNumber, String fieldName, double valueType) {
        CacheExtData cacheExtData;
        Date effectDate = (Date)paramMap.get(mainTableName.toUpperCase(Locale.ENGLISH) + "_CMP_SMT002_FEFFECTDATE");
        String effectDateStr = DateUtil.getDateStr((Date)effectDate);
        String tempMapKey = "CalFunGetExternalDataService_ExternalData_" + configNumber + "_" + effectDateStr;
        if (!tempMap.containsKey(tempMapKey)) {
            cacheExtData = this.initExtData(ctx, schemeId, mainTableName, configNumber, effectDate);
            tempMap.put(tempMapKey, cacheExtData);
            logger.info((Object)("com.kingdee.shr.compensation.service.timepiece.CalFunGetExternalDataService: " + cacheExtData));
        } else {
            cacheExtData = (CacheExtData)tempMap.get(tempMapKey);
        }
        return this.getExtDataValue(paramMap, cacheExtData, fieldName, valueType);
    }

    protected String getExtDataValue(Map<String, Object> paramMap, CacheExtData cacheExtData, String fieldName, double valueType) {
        Map<String, String> nameDBMapper = cacheExtData.getNameDBMapper();
        if (!nameDBMapper.containsKey(fieldName)) {
            return null;
        }
        List<DataRow> dataRows = cacheExtData.getDataRows();
        Map<String, String> filedMapper = cacheExtData.getFiledMapper();
        ArrayList matchDatas = Lists.newArrayList();
        dataRows.forEach(dataRow -> {
            boolean isMatch = this.isDataMatch(paramMap, (DataRow)dataRow, filedMapper);
            if (isMatch) {
                matchDatas.add(dataRow);
            }
        });
        if (matchDatas.isEmpty()) {
            return null;
        }
        String dbName = nameDBMapper.get(fieldName);
        if (dbName.contains("~")) {
            String[] split = dbName.split("~");
            dbName = split[1] + "." + split[2];
        }
        if (0.0 == valueType) {
            Object re = BigDecimal.ZERO;
            for (DataRow matchData : matchDatas) {
                Object value = this.getCellValue(cacheExtData, matchData.getCell(dbName));
                if (null == value) continue;
                re = ((BigDecimal)re).add(new BigDecimal(value.toString()));
            }
            return ((BigDecimal)re).toPlainString();
        }
        if (1.0 == valueType) {
            for (DataRow matchData : matchDatas) {
                Object value = this.getCellValue(cacheExtData, matchData.getCell(dbName));
                if (null == value) continue;
                return value.toString();
            }
            return null;
        }
        if (2.0 == valueType) {
            HashSet valueSet = Sets.newHashSet();
            for (DataRow matchData : matchDatas) {
                Object value = this.getCellValue(cacheExtData, matchData.getCell(dbName));
                if (null == value) continue;
                valueSet.add(value.toString());
            }
            return ((Object)valueSet).toString().replace("[", "").replace("]", "");
        }
        return null;
    }

    protected Object getCellValue(CacheExtData cacheExtData, DataCell cell) {
        Object value = cell.getValue();
        if (null == value) {
            return null;
        }
        String dbName = cell.getDbName();
        Map<String, String> enumFields = cacheExtData.getEnumFields();
        if (enumFields.containsKey(dbName)) {
            String enumSource = enumFields.get(dbName);
            Enum enumValue = (Enum)MetaDataUtil.findEnumByValue((String)enumSource, (Object)value);
            return null == enumValue ? null : enumValue.getAlias();
        }
        List<String> booleanFields = cacheExtData.getBooleanFields();
        if (booleanFields.contains(dbName)) {
            return Boolean.valueOf(value.toString()) != false ? YesOrNoEnum.YES.getAlias() : YesOrNoEnum.NO.getAlias();
        }
        return value;
    }

    protected boolean isDataMatch(Map<String, Object> paramMap, DataRow dataRow, Map<String, String> filedMapper) {
        boolean isMatch = true;
        Set<Map.Entry<String, String>> entries = filedMapper.entrySet();
        Iterator<Map.Entry<String, String>> iterator = entries.iterator();
        while (iterator.hasNext() && isMatch) {
            Map.Entry<String, String> mapper = iterator.next();
            String extFiled = mapper.getKey();
            String paraField = mapper.getValue();
            DataCell cell = dataRow.getCell(extFiled);
            Object value = cell.getValue();
            Object o = paramMap.get(paraField);
            if (null == value && null == o) continue;
            if (o == null || value == null) {
                isMatch = false;
                break;
            }
            if (o instanceof BigDecimal) {
                try {
                    BigDecimal oDecimal = new BigDecimal(value.toString());
                    isMatch = ((BigDecimal)o).compareTo(oDecimal) == 0;
                }
                catch (Exception e) {
                    isMatch = false;
                }
                continue;
            }
            if (o instanceof Timestamp) {
                isMatch = DateUtil.getDateStr((Date)((Timestamp)o)).equals(value);
                continue;
            }
            isMatch = value.toString().equals(o);
        }
        return isMatch;
    }

    protected CacheExtData initExtData(Context ctx, String schemeId, String mainTableName, String configNumber, Date effectDate) {
        CacheExtData cacheExtData = new CacheExtData();
        String configId = "";
        String configTable = "";
        try {
            String querySql = "select fid,findex from T_HR_SExtDataConfig where fnumber = ?";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])new Object[]{configNumber});
            int index = 0;
            while (rowSet.next()) {
                configId = rowSet.getString("fid");
                index = rowSet.getInt("findex");
            }
            if (index > 0) {
                configTable = "CT_Com_CmpDyCreate" + String.format("%04d", index);
            }
        }
        catch (BOSException | SQLException e) {
            logger.error((Object)"query TimepieceScheme Matching dimensions failed  ", e);
        }
        if (StringUtils.isEmpty((CharSequence)configId) || StringUtils.isEmpty((CharSequence)configTable)) {
            return cacheExtData;
        }
        String localeString = LocaleUtils.getShortCode((Context)ctx).toUpperCase(Locale.ENGLISH);
        StringBuilder querySql = new StringBuilder();
        querySql.append(" select ");
        querySql.append(" e.FSIMPLENAME,E.FQUERYFIELDID,E.FDBNAME,E.FISITEM,H.FCLIENTNUMBER ,G.FNUMBER ,H.FENTITYNAME, ");
        querySql.append(" g.FDataType,g.FEnumSource,j.FIELDSN ,d.configtype   ");
        querySql.append(" from T_HR_SCalSubmitScheme a ");
        querySql.append(" inner join T_HR_STimePieceScheme b on a.FID = b.FSubmitSchemeID ");
        querySql.append(" inner join T_HR_SchemeOutDataConfig c on b.fid = c.FtimepieceSchemeid ");
        querySql.append(" inner join ");
        querySql.append(" (select fid ,fschemeOutDataConfigid,fdimensionid as FexternalDataConfigEntryId,1 as configType from T_HR_SchemeODConfigDimension ");
        querySql.append(" union select  fid ,fschemeOutDataConfigid,FexternalDataConfigEntryId,2  as configType from T_HR_SchemeOutDataConfigEntry) ");
        querySql.append(" d on c.fid = d.fschemeOutDataConfigid ");
        querySql.append(" inner join T_HR_SExtDataConfigEntry e on d.FexternalDataConfigEntryId = e.fid ");
        querySql.append(" left join T_HR_QueryConfigField f on e.FQUERYFIELDID = f.fid ");
        querySql.append(" left join T_HR_StructureConfigColumns g on f.FFactFieldID = g.fid ");
        querySql.append(" left join T_HR_StructureConfig h on g.FSTRUCTURECONFIGID  = h.FID ");
        querySql.append(" left join T_HR_SCalSubmitItem j on j.FID = e.FQUERYFIELDID ");
        querySql.append(" where a.fid = ? ");
        querySql.append(" and e.fbillid = ? ");
        querySql.append(" order by e.findex ");
        String configTabelAlias = "AAAA";
        StringBuilder queryDataSql = new StringBuilder("select ");
        queryDataSql.append(configTabelAlias).append(".FID");
        ArrayList queryFieldList = Lists.newArrayList();
        HashMap queryTable = Maps.newHashMap();
        try {
            String mainTableNameUpper = mainTableName.toUpperCase(Locale.ENGLISH);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])new Object[]{schemeId, configId});
            while (rowSet.next()) {
                boolean isItem = rowSet.getBoolean("FISITEM");
                String simpleName = rowSet.getString("FSIMPLENAME");
                String clientNumber = rowSet.getString("FCLIENTNUMBER");
                String extDbName = "";
                String paramName = "";
                String extDbRelaName = "";
                int configType = rowSet.getInt("configType");
                if (isItem || StringUtils.isEmpty((CharSequence)clientNumber)) {
                    int submitItemSn = rowSet.getInt("FIELDSN");
                    paramName = mainTableNameUpper + "_S" + submitItemSn;
                    extDbRelaName = extDbName = rowSet.getString("FDBNAME");
                } else {
                    String fieldName = rowSet.getString("FNUMBER");
                    extDbName = rowSet.getString("FDBNAME");
                    String entityName = rowSet.getString("FENTITYNAME");
                    String entityTableName = EntityUtil.getEntityTableName((Context)ctx, (String)entityName);
                    PropertyInfo propertyInfo = EntityUtil.getPropertyInfo((Context)ctx, (String)entityName, (String)fieldName);
                    ColumnInfo mappingField = propertyInfo.getMappingField();
                    String tempDb = mappingField.getName();
                    boolean multilingual = mappingField.isMultilingual();
                    if (multilingual) {
                        tempDb = tempDb + "_" + localeString;
                    }
                    paramName = (entityTableName + "_" + clientNumber + "_FID").toUpperCase(Locale.ENGLISH);
                    extDbRelaName = entityTableName + "~" + clientNumber + "~" + tempDb + "~" + extDbName;
                    String queryTableName = entityTableName + "~" + clientNumber + "~" + extDbName;
                    String queryTableField = tempDb;
                    List queryTableFields = null;
                    queryTableFields = queryTable.containsKey(queryTableName) ? (List)queryTable.get(queryTableName) : Lists.newArrayList();
                    queryTableFields.add(queryTableField);
                    queryTable.put(queryTableName, queryTableFields);
                    String enumSource = rowSet.getString("FEnumSource");
                    if (!StringUtils.isEmpty((CharSequence)enumSource)) {
                        cacheExtData.addEnumField(clientNumber + "." + tempDb, enumSource);
                    }
                    String dataType = rowSet.getString("FDataType");
                    if (!StringUtils.isEmpty((CharSequence)enumSource) && "Boolean".equals(dataType)) {
                        cacheExtData.addBooleanField(clientNumber + "." + tempDb);
                    }
                }
                if (!queryFieldList.contains(extDbName)) {
                    queryFieldList.add(extDbName);
                }
                cacheExtData.addNameDBMapper(simpleName, extDbRelaName);
                if (configType != 1) continue;
                cacheExtData.addFieldMapper(extDbName, paramName);
            }
        }
        catch (BOSException | SQLException e) {
            logger.error((Object)"query TimepieceScheme Matching dimensions failed  ", e);
        }
        queryFieldList.forEach(field -> queryDataSql.append(",").append(configTabelAlias).append(".").append((String)field).append(" as \"").append(configTabelAlias).append(".").append((String)field).append("\""));
        StringBuilder queryFieldsBuilder = new StringBuilder();
        StringBuilder queryFromBuilder = new StringBuilder();
        queryTable.forEach((tableName, tableFields) -> {
            String[] split = tableName.split("~");
            String table = split[0];
            String tableAlias = split[1];
            String configField = split[2];
            tableFields.forEach(field -> {
                queryFieldsBuilder.append(",").append(tableAlias).append(".").append((String)field);
                queryFieldsBuilder.append(" as ").append("\"").append(tableAlias).append(".").append((String)field).append("\"");
            });
            queryFromBuilder.append(" left join ").append(table).append(" ").append(tableAlias);
            queryFromBuilder.append(" on ").append(configTabelAlias).append(".").append(configField).append(" = ").append(tableAlias).append(".fid ");
        });
        queryDataSql.append((CharSequence)queryFieldsBuilder);
        queryDataSql.append(" from ").append(configTable).append(" ").append(configTabelAlias);
        queryDataSql.append((CharSequence)queryFromBuilder);
        queryDataSql.append(" where ");
        queryDataSql.append(configTabelAlias).append(".CFEFFECTDATE = ").append(DateUtil.toKSqlDate((Date)effectDate));
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)queryDataSql.toString());
            while (rowSet.next()) {
                DataRow dataRow = new DataRow();
                queryFieldList.forEach(field -> {
                    try {
                        Object value = rowSet.getObject(configTabelAlias + "." + field);
                        dataRow.addCell(new DataCell((String)field, value));
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                });
                queryTable.forEach((tableName, tableFields) -> {
                    String[] split = tableName.split("~");
                    String tableAlias = split[1];
                    tableFields.forEach(field -> {
                        try {
                            String tempField = tableAlias + "." + field;
                            Object value = rowSet.getObject(tempField);
                            dataRow.addCell(new DataCell(tempField, value));
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                    });
                });
                cacheExtData.addDataRow(dataRow);
            }
        }
        catch (BOSException | SQLException e) {
            logger.error((Object)"query TimepieceScheme Matching dimensions failed  ", e);
        }
        return cacheExtData;
    }
}

