/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.settlement;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CalState;
import com.kingdee.shr.compensation.CmpCalTableCollection;
import com.kingdee.shr.compensation.CmpCalTableFactory;
import com.kingdee.shr.compensation.CmpCalTableInfo;
import com.kingdee.shr.compensation.app.separateSettlement.CmpStopCalCollection;
import com.kingdee.shr.compensation.app.separateSettlement.CmpStopCalFactory;
import com.kingdee.shr.compensation.app.separateSettlement.CmpStopCalInfo;
import com.kingdee.shr.compensation.app.separateSettlement.DataCal;
import com.kingdee.shr.compensation.app.separateSettlement.DataSource;
import com.kingdee.shr.compensation.app.separateSettlement.GrantState;
import com.kingdee.shr.compensation.util.CmpItemUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;

public class CmpStopCalIssueManager {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.settlement.CmpStopCalIssueManager");
    private static final CmpItemUtil itemUtil = new CmpItemUtil();
    private static Map<String, String> calTableIds = new HashMap<String, String>();

    public void transferItemColumn(Context ctx, List<String> tableList) {
        block2: {
            try {
                itemUtil.selectItemColumns(ctx, tableList);
            }
            catch (EASBizException e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void transferCal2IssueData(Context ctx, Map paramMap) {
        block2: {
            List tableList = (List)paramMap.get("tableList");
            try {
                itemUtil.dealWithItemColumns(ctx, tableList);
            }
            catch (EASBizException e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.transferBaseAndItemData(ctx, paramMap);
    }

    public void restoreIssueData(Context ctx, Map paramMap) {
        this.restoreBaseFieldsData(ctx, paramMap);
        this.restoreItemFieldsData(ctx, paramMap);
    }

    public void transferBaseAndItemData(Context ctx, Map paramMap) {
        this.transferBaseFieldsData(ctx, paramMap);
        this.transferItemFieldsData(ctx, paramMap);
    }

    public void restoreBaseFieldsData(Context ctx, Map paramMap) {
        block5: {
            try {
                String selectedIds = (String)paramMap.get("selectedData");
                CmpStopCalCollection cmpStopCalCollection = new CmpStopCalCollection();
                cmpStopCalCollection = CmpStopCalFactory.getLocalInstance((Context)ctx).getCmpStopCalCollection("where id in (" + selectedIds + ")");
                CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
                for (int i = 0; i < cmpStopCalCollection.size(); ++i) {
                    CmpCalTableInfo cmpCalTableInfo = new CmpCalTableInfo();
                    CmpStopCalInfo cmpStopCalInfo = cmpStopCalCollection.get(i);
                    BeanUtils.copyProperties((Object)cmpStopCalInfo, (Object)cmpCalTableInfo);
                    cmpCalTableInfo.setId(BOSUuid.create((String)"269E3024"));
                    calTableIds.put(cmpStopCalInfo.getCalTable().getId().toString(), cmpCalTableInfo.getId().toString());
                    coreBaseCollection.add((CoreBaseInfo)cmpCalTableInfo);
                }
                CmpCalTableFactory.getLocalInstance(ctx).saveBatchData(coreBaseCollection);
            }
            catch (BOSException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (EASBizException e) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void restoreItemFieldsData(Context ctx, Map paramMap) {
        block6: {
            try {
                List tableList = (List)paramMap.get("tableList");
                String tableName = (String)tableList.get(0);
                String tableNameRep = (String)tableList.get(1);
                String type = (String)paramMap.get("type");
                String whereField = (String)paramMap.get("whereField");
                List<String> itemList = itemUtil.getItemColumns(ctx, tableName);
                String buildSql = itemUtil.buildSqlByType(ctx, tableName, itemList, type);
                String selectedIds = (String)paramMap.get("selectedData");
                StringBuffer str = new StringBuffer();
                str.append("select * from " + tableNameRep + " where fid in (" + selectedIds + ")");
                IRowSet rs = CmpSQLUtil.executeQuery(ctx, str.toString());
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
                int size = itemList.size();
                while (rs.next()) {
                    Object[] object = new Object[size + 1];
                    for (int i = 0; i < size; ++i) {
                        object[i] = rs.getObject(itemList.get(i));
                    }
                    object[size] = calTableIds.get(rs.getString("fCalTableId"));
                    paramsList.add(object);
                }
                buildSql = buildSql + " where " + whereField + " = ?";
                CmpSQLUtil.executeBatch(ctx, buildSql, paramsList);
            }
            catch (BOSException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (SQLException e) {
                if (!logger.isDebugEnabled()) break block6;
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void transferBaseFieldsData(Context ctx, Map paramMap) {
        block5: {
            try {
                String selectedIds = (String)paramMap.get("selectedData");
                CmpCalTableCollection cmpCalTableCollection = new CmpCalTableCollection();
                cmpCalTableCollection = CmpCalTableFactory.getLocalInstance(ctx).getCmpCalTableCollection("where id in (" + selectedIds + ")");
                CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
                for (int i = 0; i < cmpCalTableCollection.size(); ++i) {
                    CmpStopCalInfo cmpStopCalInfo = new CmpStopCalInfo();
                    CmpCalTableInfo cmpCalTableInfo = cmpCalTableCollection.get(i);
                    BeanUtils.copyProperties((Object)cmpCalTableInfo, (Object)cmpStopCalInfo);
                    cmpStopCalInfo.setCalTable(cmpCalTableInfo);
                    cmpStopCalInfo.setId(BOSUuid.create((String)"3E411BA6"));
                    cmpStopCalInfo.setGrantState(GrantState.PreGrant);
                    cmpStopCalInfo.setDataSource(DataSource.Wizard);
                    coreBaseCollection.add((CoreBaseInfo)cmpStopCalInfo);
                }
                CmpStopCalFactory.getLocalInstance((Context)ctx).saveBatchData(coreBaseCollection);
            }
            catch (BOSException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (EASBizException e) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void transferItemFieldsData(Context ctx, Map paramMap) {
        block6: {
            try {
                List tableList = (List)paramMap.get("tableList");
                String tableName = (String)tableList.get(0);
                String tableNameRep = (String)tableList.get(1);
                String type = (String)paramMap.get("type");
                String whereField = (String)paramMap.get("whereField");
                List<String> itemList = itemUtil.getItemColumns(ctx, tableName);
                String buildSql = itemUtil.buildSqlByType(ctx, tableName, itemList, type);
                String selectedIds = (String)paramMap.get("selectedData");
                StringBuffer str = new StringBuffer();
                str.append("select * from " + tableNameRep + " where fid in (" + selectedIds + ")");
                IRowSet rs = CmpSQLUtil.executeQuery(ctx, str.toString());
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
                int size = itemList.size();
                while (rs.next()) {
                    Object[] object = new Object[size + 1];
                    for (int i = 0; i < size; ++i) {
                        object[i] = rs.getObject(itemList.get(i));
                    }
                    object[size] = rs.getString("fid");
                    paramsList.add(object);
                }
                buildSql = buildSql + " where " + whereField + " = ?";
                CmpSQLUtil.executeBatch(ctx, buildSql, paramsList);
            }
            catch (BOSException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (SQLException e) {
                if (!logger.isDebugEnabled()) break block6;
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public Map<String, String> restoreCalDataToIssue(Context ctx, String filter) throws BOSException, EASBizException {
        Map<String, String> idMapping = this.transferBaseFieldsData(ctx, filter);
        this.transferItemFromCal2Issue(ctx, idMapping);
        return idMapping;
    }

    public void transferItemFromCal2Issue(Context ctx, Map<String, String> idMapping) throws BOSException {
        List<String> itemList = itemUtil.getItemColumns(ctx, "T_HR_SCmpCalTable");
        if (itemList.size() < 1) {
            return;
        }
        String sql = this.buildUpdataSql("T_HR_SCmpCalTable", "T_HR_SCMPSTOPCAL", itemList);
        this.executeTransfer(ctx, sql, idMapping, true);
    }

    public Map<String, String> restoreIssueDataWithMapping(Context ctx, String filter) throws EASBizException, BOSException {
        ArrayList<String> tableList = new ArrayList<String>();
        tableList.add("t_hr_scmpstopCal");
        tableList.add("t_hr_scmpcaltable");
        String tableName = (String)tableList.get(0);
        boolean itemColumn = itemUtil.verifyItemColumn(ctx, tableName);
        if (!itemColumn) {
            itemUtil.dealWithItemColumns(ctx, tableList);
        }
        Map<String, String> idMapping = this.restoreBaseFieldsData(ctx, filter);
        this.restoreItemFromIssue2Cal(ctx, idMapping);
        return idMapping;
    }

    public void restoreCalItemDataDirectly(Context ctx, Map<String, String> idMapping) throws BOSException {
        List<String> itemList = itemUtil.getItemColumns(ctx, "T_HR_SCmpCalTable");
        if (itemList.size() < 1 || idMapping == null || idMapping.size() == 0) {
            return;
        }
        String sql = this.buildUpdataSql("T_HR_SCmpCalTable", "T_HR_SCMPSTOPCAL", itemList);
        ArrayList<Object[]> listParams = new ArrayList<Object[]>();
        ArrayList<Object[]> deleteListParams = new ArrayList<Object[]>();
        for (Map.Entry<String, String> entry : idMapping.entrySet()) {
            Object[] param = new Object[]{entry.getValue(), entry.getKey()};
            listParams.add(param);
            Object[] deleteParam = new Object[]{entry.getValue()};
            deleteListParams.add(deleteParam);
        }
        CmpSQLUtil.executeBatch(ctx, sql, listParams);
        CmpSQLUtil.executeBatch(ctx, "delete from t_hr_scmpcaltable where fid = ?", deleteListParams);
    }

    public void restoreItemFromIssue2Cal(Context ctx, Map<String, String> idMapping) throws BOSException {
        List<String> itemList = itemUtil.getItemColumns(ctx, "T_HR_SCmpCalTable");
        if (itemList.size() < 1) {
            return;
        }
        String sql = this.buildUpdataSql("T_HR_SCMPSTOPCAL", "T_HR_SCmpCalTable", itemList);
        this.executeTransfer(ctx, sql, idMapping, false);
    }

    public void executeTransfer(Context ctx, String sql, Map<String, String> idMapping, boolean reverse) throws BOSException {
        ArrayList<Object[]> listParams = new ArrayList<Object[]>();
        for (Map.Entry<String, String> entry : idMapping.entrySet()) {
            Object[] param = new Object[2];
            if (reverse) {
                param[0] = entry.getValue();
                param[1] = entry.getKey();
            } else {
                param[0] = entry.getKey();
                param[1] = entry.getValue();
            }
            listParams.add(param);
        }
        CmpSQLUtil.executeBatch(ctx, sql, listParams);
    }

    public String buildUpdataSql(String sourceTable, String targetTable, List<String> itemList) {
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(targetTable).append(" as ttable ");
        sql.append(" set (");
        StringBuffer itemRange = new StringBuffer();
        for (String s : itemList) {
            itemRange.append(s).append(",");
        }
        itemRange.deleteCharAt(itemRange.length() - 1);
        sql.append(itemRange).append(") = (select ");
        sql.append(itemRange).append(" from ");
        sql.append(sourceTable).append(" as stable where stable.fid = ?)");
        sql.append(" where ttable.fid = ?");
        return sql.toString();
    }

    public Map<String, String> transferBaseFieldsData(Context ctx, String filter) throws EASBizException, BOSException {
        HashMap<String, String> idMapping = new HashMap<String, String>();
        CmpCalTableCollection cmpCalTableCollection = new CmpCalTableCollection();
        cmpCalTableCollection = CmpCalTableFactory.getLocalInstance(ctx).getCmpCalTableCollection("where id in (" + filter + ")");
        CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
        for (int i = 0; i < cmpCalTableCollection.size(); ++i) {
            CmpStopCalInfo cmpStopCalInfo = new CmpStopCalInfo();
            CmpCalTableInfo cmpCalTableInfo = cmpCalTableCollection.get(i);
            BeanUtils.copyProperties((Object)cmpCalTableInfo, (Object)cmpStopCalInfo);
            cmpStopCalInfo.setId(BOSUuid.create((String)"3E411BA6"));
            cmpStopCalInfo.setCalTable(cmpCalTableInfo);
            cmpStopCalInfo.setGrantState(GrantState.PreGrant);
            cmpStopCalInfo.setDataSource(DataSource.Wizard);
            cmpStopCalInfo.setIsDataCal(DataCal.DataNotCal);
            cmpStopCalInfo.setDescription(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpStopCalResource", (String)"label90", (Locale)ctx.getLocale()));
            idMapping.put(cmpStopCalInfo.getId().toString(), cmpCalTableInfo.getId().toString());
            coreBaseCollection.add((CoreBaseInfo)cmpStopCalInfo);
        }
        CmpStopCalFactory.getLocalInstance((Context)ctx).saveBatchData(coreBaseCollection);
        return idMapping;
    }

    public Map<String, String> restoreBaseFieldsData(Context ctx, String filter) throws BOSException, EASBizException {
        HashMap<String, String> idMapping = new HashMap<String, String>();
        CmpStopCalCollection cmpStopCalCollection = new CmpStopCalCollection();
        cmpStopCalCollection = CmpStopCalFactory.getLocalInstance((Context)ctx).getCmpStopCalCollection("where id in (" + filter + ")");
        CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
        for (int i = 0; i < cmpStopCalCollection.size(); ++i) {
            CmpCalTableInfo cmpCalTableInfo = new CmpCalTableInfo();
            CmpStopCalInfo cmpStopCalInfo = cmpStopCalCollection.get(i);
            BeanUtils.copyProperties((Object)cmpStopCalInfo, (Object)cmpCalTableInfo);
            cmpCalTableInfo.setId(cmpStopCalInfo.getCalTable() != null ? cmpStopCalInfo.getCalTable().getId() : BOSUuid.create((String)"269E3024"));
            cmpCalTableInfo.setCalState(CalState.NOCAL);
            idMapping.put(cmpStopCalInfo.getId().toString(), cmpCalTableInfo.getId().toString());
            coreBaseCollection.add((CoreBaseInfo)cmpCalTableInfo);
        }
        CmpCalTableFactory.getLocalInstance(ctx).saveBatchData(coreBaseCollection);
        return idMapping;
    }

    public void updataStopCalState(Context ctx, Set<String> successRecord) throws BOSException {
        String sql = "update t_hr_scmpstopCal set FIsDataCal = 1 where fid = ?";
        ArrayList<Object[]> listParams = new ArrayList<Object[]>();
        for (String s : successRecord) {
            Object[] param = new Object[]{s};
            listParams.add(param);
        }
        CmpSQLUtil.executeBatch(ctx, sql, listParams);
    }

    public void cleanTempCalData(Context ctx, Collection<String> values) throws BOSException {
        ArrayList<Object[]> deleteListParams = new ArrayList<Object[]>();
        for (String s : values) {
            Object[] deleteParam = new Object[]{s};
            deleteListParams.add(deleteParam);
        }
        CmpSQLUtil.executeBatch(ctx, "delete from t_hr_scmpcaltable where fid = ?", deleteListParams);
    }

    public String addCmpCalTableRecord(Context ctx, CalSchemeInfo calSchemeInfo, CmpStopCalInfo calInfo) throws BOSException, EASBizException, ParseException {
        CmpStopCalInfo cmpStopCalInfo = CmpStopCalFactory.getLocalInstance((Context)ctx).getCmpStopCalInfo(" where id in ('" + calInfo.getId().toString() + "') ");
        CmpCalTableInfo cmpCalTableInfo = new CmpCalTableInfo();
        BeanUtils.copyProperties((Object)cmpStopCalInfo, (Object)cmpCalTableInfo);
        BOSUuid calTableUuid = BOSUuid.create((String)"269E3024");
        cmpCalTableInfo.setId(calTableUuid);
        cmpCalTableInfo.setBeginDate(calSchemeInfo.getBeginDate());
        cmpCalTableInfo.setEndDate(calSchemeInfo.getEndDate());
        if (cmpCalTableInfo.getTaxUnit() == null) {
            cmpCalTableInfo.setTaxUnit(calSchemeInfo.getTaxUnit());
        }
        cmpCalTableInfo.setCalState(CalState.HASCAL);
        cmpCalTableInfo.setCalScheme(calSchemeInfo);
        cmpCalTableInfo.setPeriodYear(calSchemeInfo.getPeriodYear());
        cmpCalTableInfo.setPeriodMonth(calSchemeInfo.getPeriodMonth());
        cmpCalTableInfo.setCalTime(calSchemeInfo.getCalTime());
        cmpCalTableInfo.setCurrency(calSchemeInfo.getCurrency());
        cmpCalTableInfo.setExchangeTable(calSchemeInfo.getExchangeTable());
        cmpCalTableInfo.setExchangeRule(calSchemeInfo.getExchangeRule());
        cmpCalTableInfo.setCmpPeriodType(calSchemeInfo.getCmpPeriodType());
        cmpCalTableInfo.setIsNotNeedCal(false);
        cmpCalTableInfo.setDescription(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpStopCalResource", (String)"label31", (Locale)ctx.getLocale()));
        CmpCalTableFactory.getLocalInstance(ctx).save((CoreBaseInfo)cmpCalTableInfo);
        return calTableUuid.toString();
    }

    public void updateCmpStopCalStatus(Context ctx, CalSchemeInfo calSchemeInfo, CmpStopCalInfo calInfo, boolean exists) throws BOSException {
        StringBuilder stopCalSql = new StringBuilder();
        stopCalSql.append(" update T_HR_SCmpStopCal set ");
        if (exists) {
            stopCalSql.append(" FGrantSchemeID = null, ");
            stopCalSql.append(" FGrantPeriodYear = null, ");
            stopCalSql.append(" FGrantPeriodMonth = null, ");
            stopCalSql.append(" FGrantCalTime = null, ");
            stopCalSql.append(" FGrantState = 0, ");
        } else {
            stopCalSql.append(" FGrantSchemeID = '" + calSchemeInfo.getId().toString() + "', ");
            stopCalSql.append(" FGrantPeriodYear =" + calSchemeInfo.getPeriodYear() + ", ");
            stopCalSql.append(" FGrantPeriodMonth = " + calSchemeInfo.getPeriodMonth() + ", ");
            stopCalSql.append(" FGrantCalTime = " + calSchemeInfo.getCalTime() + ", ");
            stopCalSql.append(" FGrantState = 1, ");
        }
        stopCalSql.append(" FIsRefer = 1 ");
        stopCalSql.append("where fid = '" + calInfo.getId().toString() + "' ");
        CmpSQLUtil.execute(ctx, stopCalSql.toString());
    }

    public void updateCaltableItemValue(Context ctx, String calschemeId, String caltableId, String stopcalId) throws BOSException, SQLException {
        StringBuilder select = new StringBuilder();
        select.append(" select b.fid, b.fieldSn ");
        select.append(" from T_HR_SCalSchemeItem a ");
        select.append(" inner join T_HR_SCmpItem b on a.fcmpitemid = b.fid ");
        select.append(" where a.fcalschemeid = '" + calschemeId + "' ");
        select.append(" order by a.fsortsn ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)select.toString());
        StringBuilder itemColumn = new StringBuilder();
        ArrayList<String> itemList = new ArrayList<String>();
        StringBuilder caltableUpdate = new StringBuilder();
        caltableUpdate.append(" update T_HR_SCmpCalTable set FisNotNeedCal = 1, ");
        caltableUpdate.append(" FValidateState = 60, ");
        while (rs.next()) {
            String fieldSn = " S" + rs.getString("fieldSn");
            itemList.add(fieldSn);
            if (!rs.isLast()) {
                itemColumn.append(fieldSn + ",");
                caltableUpdate.append(fieldSn + " = ?,");
                continue;
            }
            itemColumn.append(fieldSn);
            caltableUpdate.append(fieldSn + " = ? ");
        }
        caltableUpdate.append(" where fid = '" + caltableId + "'");
        String stopcalSelect = " select " + itemColumn.toString() + " from T_HR_SCmpStopCal where fid = '" + stopcalId + "'";
        IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)stopcalSelect);
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        while (rs2.next()) {
            Object[] object = new Object[itemList.size()];
            for (int i = 0; i < itemList.size(); ++i) {
                object[i] = rs2.getObject(((String)itemList.get(i)).trim());
            }
            paramsList.add(object);
        }
        CmpSQLUtil.executeBatch(ctx, caltableUpdate.toString(), paramsList);
        StringBuilder stopCalUpdate = new StringBuilder();
        stopCalUpdate.append(" update T_HR_SCmpStopCal set FcalTableId = '" + caltableId + "' where fid = '" + stopcalId + "' ");
        CmpSQLUtil.execute(ctx, stopCalUpdate.toString());
    }
}

