/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.tax.service;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.TaxExceptionEnum;
import com.kingdee.shr.compensation.app.tax.HousingFactory;
import com.kingdee.shr.compensation.app.tax.HousingInfo;
import com.kingdee.shr.compensation.app.tax.LoanTypeEnum;
import com.kingdee.shr.compensation.app.tax.TaxBaseFactory;
import com.kingdee.shr.compensation.app.tax.TaxBaseInfo;
import com.kingdee.shr.compensation.app.tax.TaxStateEnum;
import com.kingdee.shr.compensation.app.tax.TaxTypeEnum;
import com.kingdee.shr.compensation.tax.TaxBizException;
import com.kingdee.shr.compensation.tax.TaxUtil;
import com.kingdee.shr.compensation.tax.service.TeneAndHousingService;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public class HousingService
extends TeneAndHousingService {
    @Override
    protected TaxTypeEnum getTaxTypeEnum() {
        return TaxTypeEnum.HOUSING;
    }

    public TaxBizException beforeSaveHousingInfo(HousingInfo info) {
        double money = info.getMoney();
        if (money != 1000.0) {
            return new TaxBizException(TaxExceptionEnum.HOUSING_MONTY.getValue(), TaxExceptionEnum.HOUSING_MONTY.getName());
        }
        return null;
    }

    @Override
    public String saveInfo(Context ctx, String jsonParam) throws Exception {
        List attList;
        int i;
        ArrayList<HousingInfo> housingList = new ArrayList<HousingInfo>();
        Map map = (Map)JSON.parseObject((String)jsonParam, Map.class);
        TaxBaseInfo bill = null;
        if (null == map.get("state")) {
            return TaxUtil.error(ctx, TaxExceptionEnum.STATE_NOT_NULL.getValue(), TaxExceptionEnum.STATE_NOT_NULL.getName());
        }
        Map objMap = (Map)map.get("housing");
        TaxStateEnum state = TaxStateEnum.getEnum((int)TaxUtil.getMapInt(map, "state"));
        String billIds = this.getTaxBaseInfoByState(ctx, 10, state.getValue());
        if (null != billIds) {
            DbUtil.execute((Context)ctx, (String)("delete from T_HR_SHousing where FBillId in (" + billIds + ")"));
            DbUtil.execute((Context)ctx, (String)("delete from T_HR_STenement where FBillId in (" + billIds + ")"));
            DbUtil.execute((Context)ctx, (String)("delete from T_HR_STaxBase where fid in (" + billIds + ")"));
        }
        if (state.equals((Object)TaxStateEnum.SUBMIT)) {
            String personId = TaxUtil.getPersonId(ctx);
            StringBuilder str = new StringBuilder();
            str.append(" select fid, FEffdtYear effdtYear, FEffdtMonth effdtMonth ");
            str.append(" from T_HR_STaxBase where FPersonId = '").append(personId).append("' ");
            str.append(" and FType = 20 and FleffdtYear >= 2199 and FState = 30 ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            if (rowSet.size() > 0) {
                String billId = null;
                int effdtYear = 0;
                int effdtMonth = 0;
                if (rowSet.next()) {
                    billId = rowSet.getString(1);
                    effdtYear = rowSet.getInt("effdtYear");
                    effdtMonth = rowSet.getInt("effdtMonth");
                }
                int month = TaxUtil.getEffdtMonth(ctx);
                Calendar calendar = Calendar.getInstance();
                calendar.add(2, month);
                int leffdtYear = calendar.get(1);
                int leffdtMonth = calendar.get(2) + 1;
                if (leffdtYear < effdtYear || leffdtYear == effdtYear && leffdtMonth < effdtMonth) {
                    leffdtYear = effdtYear;
                    leffdtMonth = effdtMonth;
                }
                String sql = "update T_HR_STaxBase set FLeffdtYear = " + leffdtYear + ", FLeffdtMonth = " + leffdtMonth + ", FState = 40 where fid = '" + billId + "'";
                DbUtil.execute((Context)ctx, (String)sql);
            }
        }
        HousingInfo housInfo = (HousingInfo)TaxUtil.convertMapToInfo(ctx, objMap, "com.kingdee.shr.compensation.app.tax.Housing", HousingInfo.class);
        housInfo.setId(null);
        bill = this.setTaxBaseInfoForSave(ctx, state, housInfo.getMoney());
        IObjectPK pk = TaxBaseFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)bill);
        bill.setId(BOSUuid.read((String)pk.toString()));
        List loanList = (List)objMap.get("loan");
        for (i = 0; i < loanList.size(); ++i) {
            HousingInfo copyInfo = (HousingInfo)housInfo.clone();
            Map loanMap = (Map)loanList.get(i);
            copyInfo.setLoanType(LoanTypeEnum.getEnum((int)TaxUtil.getMapInt(loanMap, "loanType")));
            copyInfo.setBank(TaxUtil.getMapString(loanMap, "bank"));
            copyInfo.setLoanNumber(TaxUtil.getMapString(loanMap, "loanNumber"));
            copyInfo.setFirstDate(CmpDateUtil.parseDate(TaxUtil.getMapString(loanMap, "firstDate")));
            copyInfo.setTerm(TaxUtil.getMapInt(loanMap, "term"));
            copyInfo.setBill(bill);
            housingList.add(copyInfo);
        }
        for (i = 0; i < housingList.size(); ++i) {
            HousingFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)housingList.get(i));
        }
        if (objMap.containsKey("attachment") && null != (attList = (List)objMap.get("attachment")) && attList.size() > 0) {
            this.saveAttactment(attList, pk.toString());
        }
        return TaxUtil.success(ctx, pk.toString());
    }
}

