/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.tax.task.impl;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.compensation.app.tax.IncomeTaxIssueCollection;
import com.kingdee.shr.compensation.app.tax.IncomeTaxIssueFactory;
import com.kingdee.shr.compensation.app.tax.IncomeTaxIssueInfo;
import com.kingdee.shr.compensation.app.tax.IncomeTaxIssueInviteEnum;
import com.kingdee.shr.compensation.app.tax.TaskIncomeTaxRelationCollection;
import com.kingdee.shr.compensation.app.tax.TaskIncomeTaxRelationFactory;
import com.kingdee.shr.compensation.app.taxCal.ITaxCalTask;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskStateEnum;
import com.kingdee.shr.compensation.app.taxCal.vo.IncomeTaxIssueInviteResponse;
import com.kingdee.shr.compensation.app.taxCal.vo.IncomeTaxIssueInviteResponseVO;
import com.kingdee.shr.compensation.tax.task.ITaxTaskService;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.message.MessageUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ConfirmedIncomeIssueInviteService
implements ITaxTaskService {
    private static Logger logger = Logger.getLogger(ConfirmedIncomeIssueInviteService.class);

    @Override
    public void onSuccess(Context ctx, TaxCalTaskInfo taskInfo, String response) throws BOSException {
        IncomeTaxIssueInviteResponseVO responseVO = (IncomeTaxIssueInviteResponseVO)JSON.parseObject((String)response, IncomeTaxIssueInviteResponseVO.class);
        List persons = responseVO.getData().getRylb();
        String taskId = taskInfo.getId().toString();
        if (null == persons || persons.isEmpty()) {
            logger.error((Object)("_afterInviteConfirmedPerson: person list is empty, taskId = " + taskId));
            return;
        }
        String relationOql = "select bizId where taskId = '" + taskId + "'";
        TaskIncomeTaxRelationCollection collection = TaskIncomeTaxRelationFactory.getLocalInstance((Context)ctx).getTaskIncomeTaxRelationCollection(relationOql);
        StringBuilder issueIds = new StringBuilder();
        for (int i = 0; i < collection.size(); ++i) {
            if (issueIds.length() > 0) {
                issueIds.append(",");
            }
            issueIds.append(collection.get(i).getBizId());
        }
        Map<String, String> map = this.batchUpdateInviteStatus(ctx, taskInfo.getAccept_id(), persons, issueIds);
        if (null != map && !map.isEmpty()) {
            TaxCalTaskFactory.getLocalInstance((Context)ctx).updateStateMsgById(taskId, TaxCalTaskStateEnum.FINISHED, responseVO.getMsg());
            this.sendMessage(ctx, taskInfo.getAccept_id(), map);
        }
    }

    private void sendMessage(Context ctx, String acceptId, Map<String, String> map) {
        String title = "\u7533\u8bc9\u5c5e\u5b9e\u4eba\u5458\u9080\u8bf7\u7684\u4efb\u52a1\u7f16\u7801[%s]\u9080\u8bf7\u5b8c\u6210\uff0c\u8be6\u60c5\u67e5\u770b\u7533\u8bc9\u5c5e\u5b9e\u4eba\u5458\u5217\u8868\u6216\u4efb\u52a1\u6267\u884c\u76d1\u63a7\u5217\u8868";
        String content = "\u7eb3\u7a0e\u5355\u4f4d[%s][%s]\u9080\u8bf7\u5b8c\u6210\uff0c%s\u3002";
        String yearMonth = CmpDateUtil.getDateStr(CmpDateUtil.getLastMonthEndDate(), "yyyyMM");
        title = String.format(title, acceptId);
        content = String.format(content, map.get("taxUnitName"), yearMonth, map.get("details"));
        MessageUtil.setNeedSending(ctx);
        MessageUtil.sendMessage(ctx, map.get("userId"), title, content, "\u85aa\u916c\u4e2a\u7a0e");
    }

    private Map<String, String> batchUpdateInviteStatus(Context ctx, String acceptId, List<IncomeTaxIssueInviteResponse> persons, StringBuilder issueIds) throws BOSException {
        String issueOql = "select id, taxUnit.name, person.cardType, person.cardNumber, lastUpdateUser.person.id where id in " + CmpStrUtil.buildInSql(issueIds.toString());
        IncomeTaxIssueCollection issueCollection = IncomeTaxIssueFactory.getLocalInstance((Context)ctx).getIncomeTaxIssueCollection(issueOql);
        if (null == issueCollection || issueCollection.isEmpty()) {
            logger.error((Object)("cannot find income tax issues by acceptId: " + acceptId));
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuilder details = new StringBuilder();
        String batchSQL = "update t_hr_sIncomeTaxIssue set fInviteStatus = ?, fInviteErrInfo = ? where fid = ?";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        boolean isTaskComplete = true;
        for (int i = 0; i < issueCollection.size(); ++i) {
            IncomeTaxIssueInfo issue = issueCollection.get(i);
            String cardTypeName = issue.getPerson().getCardType().getAlias();
            String cardNumber = issue.getPerson().getCardNumber();
            int inviteStatus = 1;
            for (IncomeTaxIssueInviteResponse person : persons) {
                if (!person.getZzhm().equals(cardNumber) || !cardTypeName.equals(person.getZzlx())) continue;
                if (details.length() > 0) {
                    details.append(",");
                }
                Object[] param = new Object[3];
                inviteStatus = this.getIncomeTaxIssueInviteEnumByName(person.getZt());
                param[0] = inviteStatus;
                param[1] = person.getErrinfo();
                param[2] = issue.getId().toString();
                paramList.add(param);
                details.append("[").append(person.getXm()).append("]").append("\u9080\u8bf7\u72b6\u6001\u4e3a[").append(person.getZt()).append("]");
                map.put("taxUnitName", issue.getTaxUnit().getName());
                map.put("userId", issue.getLastUpdateUser().getPerson().getId().toString());
                break;
            }
            if (inviteStatus != true) continue;
            isTaskComplete = false;
        }
        if (details.length() > 0) {
            map.put("details", details.toString());
        }
        if (!paramList.isEmpty()) {
            DbUtil.executeBatch((Context)ctx, (String)batchSQL, paramList);
        }
        if (!isTaskComplete) {
            TaxCalTaskFactory.getLocalInstance((Context)ctx).updateStateMsgByAcceptID(acceptId, TaxCalTaskStateEnum.RUNNING, "");
        }
        return map;
    }

    private Integer getIncomeTaxIssueInviteEnumByName(String name) {
        for (Object item : IncomeTaxIssueInviteEnum.getEnumList()) {
            IncomeTaxIssueInviteEnum typeEnum = (IncomeTaxIssueInviteEnum)item;
            if (!typeEnum.getAlias().equals(name)) continue;
            return typeEnum.getValue();
        }
        return 1;
    }

    @Override
    public void onFailure(Context ctx, TaxCalTaskInfo taskInfo, String errMsg) throws BOSException {
        String taskId = taskInfo.getId().toString();
        String updateSql = "update T_HR_STaxCalTask Set fSTATE = ? , fMsg = ? where fid = ?";
        String updateIssueSql = "update T_HR_SIncomeTaxIssue set FInviteStatus = ? , FInviteErrInfo = ? where fid in (select r.fBizId from T_HR_STaskIncomeTaxRelation r left join T_HR_STaxCalTask t on r.fTaskId = t.fid where t.fid = ? and t.fCatalog = 170)";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] param = new Object[]{30, StringUtils.isEmpty((CharSequence)errMsg) ? "\u4eba\u5458\u9080\u8bf7\u5931\u8d25" : errMsg, taskId};
        paramList.add(param);
        DbUtil.executeBatch((Context)ctx, (String)updateSql, paramList);
        paramList.clear();
        param[0] = -1;
        param[1] = StringUtils.isEmpty((CharSequence)errMsg) ? "\u4eba\u5458\u9080\u8bf7\u5931\u8d25" : errMsg;
        param[2] = taskId;
        paramList.add(param);
        DbUtil.executeBatch((Context)ctx, (String)updateIssueSql, paramList);
        this.sendMsg2Commander(ctx, taskId);
    }

    public void sendMsg2Commander(Context ctx, String taskId) {
        try {
            ITaxCalTask taxCalTask = TaxCalTaskFactory.getLocalInstance((Context)ctx);
            TaxCalTaskInfo taxCalTaskInfo = taxCalTask.getTaxCalTaskInfo("select id,state,number,taxUnit.id,taxUnit.name,period,creator where id ='" + taskId + "'");
            String number = taxCalTaskInfo.getNumber();
            String taxUnitName = taxCalTaskInfo.getTaxUnit().getName();
            String sendUserID = taxCalTaskInfo.getCreator().getId().toString();
            String title = "\u4eba\u5458\u9080\u8bf7\u7684\u4efb\u52a1\u7f16\u7801[{0}]\u9080\u8bf7\u5931\u8d25\uff0c\u8be6\u60c5\u67e5\u770b\u4e2a\u7a0e\u7533\u62a5\u5217\u8868\u6216\u4efb\u52a1\u6267\u884c\u76d1\u63a7\u5217\u8868";
            String msgTemplate = "\u7eb3\u7a0e\u5355\u4f4d[{0}]\u4efb\u52a1\u7f16\u7801[{1}]\u9080\u8bf7\u5931\u8d25";
            String category = "\u85aa\u916c\u4e2a\u7a0e";
            String titleStr = MessageFormat.format(title, number);
            String msg = MessageFormat.format(msgTemplate, taxUnitName, number);
            MessageUtil.setNeedSending(ctx);
            MessageUtil.sendMessage(ctx, sendUserID, titleStr, msg, category);
        }
        catch (Exception e) {
            logger.error((Object)"FailureHandler130 error: ", (Throwable)e);
        }
    }
}

