/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.tax.task.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.compensation.app.tax.TaxUnitInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskStateEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxDirectDeductionCollection;
import com.kingdee.shr.compensation.app.taxCal.TaxDirectDeductionFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxDirectDeductionInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxUnitDeductionFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxUnitDeductionInfo;
import com.kingdee.shr.compensation.tax.task.ITaxTaskService;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.message.MessageUtil;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PersonCollectConfirmService
implements ITaxTaskService {
    private static Logger logger = Logger.getLogger(PersonCollectConfirmService.class);
    private String names;

    @Override
    public void onSuccess(Context ctx, TaxCalTaskInfo taskInfo, String response) throws BOSException {
        TaxUnitDeductionInfo taxUnitDeductionInfo;
        TaxCalTaskInfo taxCalTaskInfo;
        Map bodyMap = (Map)JSONUtils.convertJsonToObject((Context)ctx, (String)response, Map.class);
        Map dataMap = (Map)bodyMap.get("data");
        List dataList = dataMap.containsKey("qrgjrylb") ? (List)dataMap.get("qrgjrylb") : null;
        String taskId = taskInfo.getId().toString();
        String msg = (String)bodyMap.get("msg");
        TaxCalTaskFactory.getLocalInstance((Context)ctx).updateStateMsgById(taskId, TaxCalTaskStateEnum.FINISHED, StringUtils.isEmpty((String)msg) ? "6\u4e07\u76f4\u63a5\u6263\u9664\u4eba\u5458\u786e\u8ba4\u5b8c\u6210" : msg);
        if (null == dataList || dataList.isEmpty()) {
            return;
        }
        try {
            taxCalTaskInfo = TaxCalTaskFactory.getLocalInstance((Context)ctx).getTaxCalTaskInfo("select id,state,number,taxUnit.id,taxUnit.name,period,creator,msg where id ='" + taskId + "'");
        }
        catch (EASBizException e) {
            logger.error((Object)"_saveConfirm error: ", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
        TaxUnitInfo taxUnit = taxCalTaskInfo.getTaxUnit();
        String taxUnitId = taxUnit.getId().toString();
        String period = taxCalTaskInfo.getPeriod();
        int year = Integer.parseInt(period.substring(0, 4)) - 1;
        try {
            taxUnitDeductionInfo = TaxUnitDeductionFactory.getLocalInstance((Context)ctx).getTaxUnitDeductionInfo(" where taxUnit.id = '" + taxUnitId + "' and year = " + year);
        }
        catch (EASBizException e1) {
            logger.error((Object)"_saveConfirm error: ", (Throwable)e1);
            throw new BOSException(e1.getMessage());
        }
        String taxUnitDeductionId = taxUnitDeductionInfo.getId().toString();
        HashSet<String> successSet = new HashSet<String>();
        HashMap<String, String> errorMap = new HashMap<String, String>();
        HashSet<String> detailSet = new HashSet<String>();
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        Timestamp createTime = new Timestamp(System.currentTimeMillis());
        for (Map stringObjectMap : dataList) {
            String cardNumber = stringObjectMap.get("zzhm").toString();
            int status = (int)Double.parseDouble(stringObjectMap.get("status").toString());
            if (0 == status) {
                successSet.add(cardNumber);
            } else {
                errorMap.put(cardNumber, null == stringObjectMap.get("errInfo") ? "" : stringObjectMap.get("errInfo").toString());
            }
            detailSet.add(cardNumber);
        }
        String cardNumbers = CmpStrUtil.convertSetToSqlString(detailSet);
        String oql = "select id, isDecdut, taxPersonRecordEntry.id, taxPersonRecordEntry.bill.cardNumber, taxPersonRecordEntry.person.name where taxUnitDeduction.id = '" + taxUnitDeductionId + "' and taxPersonRecordEntry.bill.cardNumber in (" + cardNumbers + ")";
        TaxDirectDeductionCollection collection = TaxDirectDeductionFactory.getLocalInstance((Context)ctx).getTaxDirectDeductionCollection(oql);
        try {
            ArrayList<Object[]> directParamList = new ArrayList<Object[]>();
            ArrayList<Object[]> entryParamList = new ArrayList<Object[]>();
            StringBuilder names = new StringBuilder();
            int count = 0;
            for (int i = 0; i < collection.size(); ++i) {
                TaxDirectDeductionInfo info = collection.get(i);
                String cardNumber = info.getTaxPersonRecordEntry().getBill().getCardNumber();
                int status = successSet.contains(cardNumber) ? 20 : (errorMap.containsKey(cardNumber) ? 30 : 10);
                String errorInfo = errorMap.getOrDefault(cardNumber, "");
                Object[] directParam = new Object[]{status, errorInfo, userId, createTime, info.getId().toString()};
                directParamList.add(directParam);
                Object[] entryParam = new Object[]{info.isIsDecdut(), info.getTaxPersonRecordEntry().getId().toString()};
                entryParamList.add(entryParam);
                if (count < 5 && status == 20) {
                    if (names.length() > 0) {
                        names.append("\u3001");
                    }
                    names.append(info.getTaxPersonRecordEntry().getPerson().getName());
                    ++count;
                    continue;
                }
                if (count != 5) continue;
                names.append("...");
            }
            String updateSql = "UPDATE T_HR_STaxDirectDeduction SET FSate = ?, FErrorMsg_L2 = ?, FLASTUPDATEUSERID = ?, FLASTUPDATETIME = ?  WHERE FID = ? ";
            DbUtil.executeBatch((Context)ctx, (String)updateSql, directParamList);
            updateSql = "update t_hr_sTaxPersonRecordEntry SET FIsDirect = ? WHERE FId = ? ";
            DbUtil.executeBatch((Context)ctx, (String)updateSql, entryParamList);
            this.setNames(names.toString());
            this.sendMsg2Commander(ctx, taxCalTaskInfo);
        }
        catch (Exception e) {
            logger.error((Object)"_saveConfirm error: ", (Throwable)e);
        }
    }

    @Override
    public void onFailure(Context ctx, TaxCalTaskInfo taskInfo, String errMsg) throws BOSException {
        String updateSql = "update T_HR_STaxCalTask Set fSTATE = ? , fMsg = ? where fid = ?";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] param = new Object[]{30, org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)errMsg) ? "6\u4e07\u76f4\u63a5\u6263\u9664\u4eba\u5458\u786e\u8ba4\u5931\u8d25" : errMsg, taskInfo.getId().toString()};
        paramList.add(param);
        DbUtil.executeBatch((Context)ctx, (String)updateSql, paramList);
        String requestContent = taskInfo.getRequestParam().getParamContent();
        JSONObject map = JSON.parseObject((String)requestContent);
        String ids = (String)map.get("ids");
        if (ids.length() > 0) {
            String sql = "update T_HR_STaxDirectDeduction set FSate = 30 where fid in " + CmpStrUtil.buildInSql(ids);
            DbUtil.execute((Context)ctx, (String)sql);
        }
        this.sendMsg2Commander(ctx, taskInfo);
    }

    protected void sendMsg2Commander(Context ctx, TaxCalTaskInfo taxCalTaskInfo) {
        try {
            String number = taxCalTaskInfo.getNumber();
            TaxCalTaskStateEnum state = taxCalTaskInfo.getState();
            String taxUnitName = taxCalTaskInfo.getTaxUnit().getName();
            String period = taxCalTaskInfo.getPeriod();
            String sendUserID = taxCalTaskInfo.getCreator().getId().toString();
            String title = "\u4eba\u5458\u786e\u8ba4\u7684\u4efb\u52a1\u7f16\u7801[{0}]\u5df2\u5b8c\u6210\uff0c\u8be6\u60c5\u67e5\u770b\u4eba\u5458\u786e\u8ba4\u540d\u5355\u5217\u8868\u6216\u4efb\u52a1\u6267\u884c\u76d1\u63a7\u5217\u8868";
            String msg = "\u7eb3\u7a0e\u5355\u4f4d[{0}][{1}]\u4e0d\u6ee16\u4e07\u4eba\u5458\u540d\u5355\u786e\u8ba4\u5b8c\u6210\uff0c\u5458\u5de5[{2}]-[{3}]\u3002";
            msg = state == TaxCalTaskStateEnum.FINISHED ? MessageFormat.format(msg, taxUnitName, period.split("-")[0], this.names, "\u786e\u8ba4\u6210\u529f") : taxCalTaskInfo.getMsg();
            String category = "\u85aa\u916c\u4e2a\u7a0e";
            String titleStr = MessageFormat.format(title, number);
            MessageUtil.setNeedSending(ctx);
            MessageUtil.sendMessage(ctx, sendUserID, titleStr, msg, category);
        }
        catch (Exception e) {
            logger.error((Object)"FailureHandler100 error: ", (Throwable)e);
        }
    }

    public void setNames(String names) {
        this.names = names;
    }
}

