/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.taxCal.analysis;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.CardTypeEnum;
import com.kingdee.shr.compensation.CmpSchemePersonHasFacadeFactory;
import com.kingdee.shr.compensation.app.incomeTax.ReductionSummaryFacadeFactory;
import com.kingdee.shr.compensation.app.taxCal.DeclareTypeEnum;
import com.kingdee.shr.compensation.app.taxCal.ITaxCalInitFacade;
import com.kingdee.shr.compensation.app.taxCal.TaxCalDelRecordCollection;
import com.kingdee.shr.compensation.app.taxCal.TaxCalDelRecordFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalDelRecordInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalDelTypeEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxCalFieldConfigCollection;
import com.kingdee.shr.compensation.app.taxCal.TaxCalFieldConfigFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalFieldConfigInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalForJSFacadeFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalInitFacadeFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskCatalogEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskInfo;
import com.kingdee.shr.compensation.taxCal.HandleFailure4TaxCal;
import com.kingdee.shr.compensation.taxCal.VO.TaxCalInfoNoTaxItem;
import com.kingdee.shr.compensation.taxCal.util.TaxConstant;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CombineDataForResult {
    private static final Logger logger = Logger.getLogger(CombineDataForResult.class);
    private List<String> itemColumnList;
    private Set<String> strItemColumnList;
    private Set<String> itemSumSet;
    private List<String> taxItemIdList;
    private Map<String, TaxCalFieldConfigCollection> apiFieldMap = new HashMap<String, TaxCalFieldConfigCollection>();
    private List<TaxCalInfoNoTaxItem> taxCalInfoNoTaxItem;
    private TaxCalTaskInfo taskInfo;
    private boolean isFbSubmit = false;

    public void execute(Context ctx, String taskId, String jsonData) throws BOSException {
        this.taskInfo = TaxCalTaskFactory.getLocalInstance((Context)ctx).getTaskById(taskId);
        boolean bl = this.isFbSubmit = this.taskInfo.getCatalog() == TaxCalTaskCatalogEnum.FbUpload;
        if (this.isFbSubmit) {
            Map bodyMap = (Map)JSON.parseObject((String)jsonData, Map.class);
            String code = (String)bodyMap.get("code");
            int status = 2;
            if (!"0000".equals(code) && !"0251".equals(code)) {
                status = -1;
            }
            this.updateSummaryStatus(ctx, taskId, status);
        }
        if (this.taskInfo.getCatalog() == TaxCalTaskCatalogEnum.TaxCal || this.isFbSubmit) {
            this.calPerson(ctx, taskId, jsonData);
        } else {
            this.delPerson(ctx, taskId);
        }
    }

    private void updateSummaryStatus(Context ctx, String taskId, int status) throws BOSException {
        String sql = "update T_HR_SReductionSummary set fStatus =" + status + " where fid in (select fBizId from T_HR_STaskIncomeTaxRelation where fTaskId = '" + taskId + "')";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void delPerson(Context ctx, String taskId) throws BOSException {
        String oql = "where taskId = '" + taskId + "'";
        TaxCalDelRecordCollection delRecordCollection = TaxCalDelRecordFactory.getLocalInstance((Context)ctx).getTaxCalDelRecordCollection(oql);
        if (delRecordCollection.isEmpty()) {
            return;
        }
        TaxCalDelRecordInfo recordInfo = delRecordCollection.get(0);
        TaxCalDelTypeEnum oprType = recordInfo.getOprType();
        ITaxCalInitFacade iTaxCalInitFacade = TaxCalInitFacadeFactory.getLocalInstance((Context)ctx);
        if (TaxCalDelTypeEnum.DEL_PERSON == oprType) {
            String lastUpdateUserId = recordInfo.getCreator().getId().toString();
            ArrayList<String> calTableIdList = new ArrayList<String>();
            String sql = "select fCmpCalTableID from T_HR_STaxCalTaskDetail where fCalTaskId = '" + taskId + "'";
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                while (rs.next()) {
                    calTableIdList.add(rs.getString("fCmpCalTableID"));
                }
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)("SELECT fCalSchemeId FROM T_HR_SCMPCalTable WHERE FID = '" + (String)calTableIdList.get(0) + "'"));
                while (rowSet.next()) {
                    String calSchemeId = rowSet.getString("fCalSchemeId");
                    CmpSchemePersonHasFacadeFactory.getLocalInstance(ctx).delete("", CmpStrUtil.convertListToString(calTableIdList), calSchemeId, true, lastUpdateUserId);
                    HandleFailure4TaxCal handle = new HandleFailure4TaxCal();
                    handle.sendMsg2TaskCreator(ctx, taskId);
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        } else if (TaxCalDelTypeEnum.DEL_LWBC == oprType) {
            iTaxCalInitFacade.afterRecalcDelete(taskId);
            TaxCalForJSFacadeFactory.getLocalInstance((Context)ctx).executeNextTask(taskId);
        } else {
            iTaxCalInitFacade.afterTaxCalDelete(taskId, oprType);
        }
        iTaxCalInitFacade.updateInitAndDeleteConfig(taskId);
    }

    private void calPerson(Context ctx, String taskId, String jsonData) throws BOSException {
        Map bodyMap = (Map)JSON.parseObject((String)jsonData, Map.class);
        this.initPerson2TaxCalInfo(ctx, taskId);
        this.initTaxItem(ctx);
        this.deleteSumAndDetail(ctx, taskId);
        this.updateJsonDataToSum(ctx, taskId, bodyMap);
        this.updateDetailByRelay(ctx, taskId);
        this.submitInitData(ctx, taskId);
        Map dataMap = (Map)bodyMap.get("data");
        this.updateReductionInfo(ctx, taskId, dataMap);
    }

    private void updateJmsx(Context ctx, String taskId, Map<String, Object> dataMap) throws BOSException {
        java.util.Date periodDate;
        TaxCalTaskInfo task = TaxCalTaskFactory.getLocalInstance((Context)ctx).getTaskById(taskId);
        String period = task.getPeriod();
        String taxUnitId = task.getTaxUnit().getId().toString();
        try {
            periodDate = CmpDateUtil.parseDate(period + "-01");
        }
        catch (ParseException e) {
            throw new BOSException("cannot parse date: " + period + "-01");
        }
        for (Object obj : DeclareTypeEnum.getEnumList()) {
            List syjkbxList;
            DeclareTypeEnum declareTypeEnum = (DeclareTypeEnum)obj;
            Map map = (Map)dataMap.get(declareTypeEnum.getValue());
            if (null == map) continue;
            List jmsxList = (List)map.get("jmsxfblb");
            if (null != jmsxList && !jmsxList.isEmpty()) {
                this.updateJmsxStatus(ctx, periodDate, jmsxList, taxUnitId);
            }
            if (null != (syjkbxList = (List)map.get("syjkbxlb")) && !syjkbxList.isEmpty()) {
                this.updateSyjkbxStatus(ctx, periodDate, syjkbxList, taxUnitId);
            }
            List syylbxList = (List)map.get("syylbxlb");
            if (null == syjkbxList || syjkbxList.isEmpty()) continue;
            this.updateSyylbxStatus(ctx, periodDate, syylbxList, taxUnitId);
        }
    }

    private void updateSyylbxStatus(Context ctx, java.util.Date periodDate, List<Map<String, Object>> syylbxList, String taxUnitId) throws BOSException {
        String sql = "update t_hr_sTaxDelayInsuranceItem set FStatus = ?, FErrMsg = ? where FCardType = ? and FCardNumber = ? and FAccountNo = ? and FCheckCode = ? and FPeriodDate = ? and fTaxUnitId = ? and fAmount > 0";
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (Map<String, Object> jmsx : syylbxList) {
            Object[] param = new Object[]{this.convertStatus(jmsx.get("status")), jmsx.get("errorinfo"), jmsx.get("zzlx"), jmsx.get("zzhm"), jmsx.get("syylzhbh"), jmsx.get("bsjym"), CmpDateUtil.toSqlDate(periodDate), taxUnitId};
            params.add(param);
        }
        DbUtil.executeBatch((Context)ctx, (String)sql, params);
    }

    private void updateSyjkbxStatus(Context ctx, java.util.Date periodDate, List<Map<String, Object>> syjkbxList, String taxUnitId) throws BOSException {
        String sql = "update T_HR_SCommInsuranceItem set FStatus = ?, FErrMsg = ? where FCardType = ? and FCardNumber = ? and FTaxPriorityCode = ? and FPeriodDate = ? and fTaxUnitId = ? and fAmount > 0";
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (Map<String, Object> jmsx : syjkbxList) {
            Object[] param = new Object[]{this.convertStatus(jmsx.get("status")), jmsx.get("errorinfo"), jmsx.get("zzlx"), jmsx.get("zzhm"), jmsx.get("sysbm"), CmpDateUtil.toSqlDate(periodDate), taxUnitId};
            params.add(param);
        }
        DbUtil.executeBatch((Context)ctx, (String)sql, params);
    }

    private void updateJmsxStatus(Context ctx, java.util.Date periodDate, List<Map<String, Object>> jmsxList, String taxUnitId) throws BOSException {
        String sql = "update t_hr_sReductionItem set FStatus = ?, FErrMsg = ? where FCardType = ? and FCardNumber = ? and FPeriodDate = ? and FCatalog = ? and FIncomeItemCode = ? and FTaxUnitId = ? and fAmount > 0";
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (Map<String, Object> jmsx : jmsxList) {
            Object[] param = new Object[]{this.convertStatus(jmsx.get("status")), jmsx.get("errorinfo"), jmsx.get("zzlx"), jmsx.get("zzhm"), CmpDateUtil.toSqlDate(periodDate), jmsx.get("jmfs"), jmsx.get("sdxm"), taxUnitId};
            params.add(param);
        }
        DbUtil.executeBatch((Context)ctx, (String)sql, params);
    }

    private Object convertStatus(Object val) {
        if (null == val) {
            return 2;
        }
        String str = String.valueOf(val);
        int status = Integer.parseInt(str);
        if (status == -9 || status == -8 || status == -1) {
            return -1;
        }
        return 2;
    }

    private void submitInitData(Context ctx, String taskId) throws BOSException {
        StringBuilder str = new StringBuilder();
        str.append(" SELECT A01.FID ");
        str.append(" FROM T_HR_STAXCALINITDETAIL A01 ");
        str.append(" WHERE EXISTS(SELECT 1 FROM T_HR_STAXCALTASKDETAIL A02");
        str.append(" WHERE FCALTASKID = '").append(taskId).append("' ");
        str.append(" AND A01.FPERSONID = A02.FPERSONID AND A01.FINCOMEITEMID = A02.FINCOMEITEMID ");
        str.append(" AND A01.FPERIODBEGIN = A02.FPERIODBEGIN) ");
        str.append(" AND A01.FTAXUNITID = '").append(this.taskInfo.getTaxUnit().getId().toString()).append("' ");
        str.append(" AND FSTATE = ").append(30);
        str.append(" AND NOT EXISTS(SELECT 1 FROM T_HR_STAXCALTASKDETAIL A03 ");
        str.append(" WHERE A01.FCMPCALTABLEID = A03.FCMPCALTABLEID AND A01.fIncomeItemId = A03.fIncomeItemId AND A03.FDATASTATE = 10)");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        if (rowSet.size() < 1) {
            return;
        }
        str = new StringBuilder();
        try {
            while (rowSet.next()) {
                str.append("'").append(rowSet.getString(1)).append("',");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error((Object)e);
        }
        String sqlIds = str.substring(0, str.length() - 1);
        TaxCalForJSFacadeFactory.getLocalInstance((Context)ctx).submitInitData(sqlIds, taskId, TaxCalTaskCatalogEnum.TaxCal);
    }

    private void deleteSumAndDetail(Context ctx, String taskId) throws BOSException {
        StringBuilder str = new StringBuilder();
        str.append(" delete from T_HR_STaxCalConfigSum A01 where exists(");
        str.append(" select 1 from T_HR_STaxCalTaskDetail A02 ");
        str.append(" where FCalTaskID = '").append(taskId).append("' and A01.FCmpCalTableID = A02.FCmpCalTableID and A01.fIncomeItemId = A02.fIncomeItemId)");
        DbUtil.execute((Context)ctx, (String)str.toString());
        str = new StringBuilder();
        str.append(" delete from T_HR_STaxCalConfigDetail A01 where exists(");
        str.append(" select 1 from T_HR_STaxCalTaskDetail A02 ");
        str.append(" where FCalTaskID = '").append(taskId).append("' and A01.FCmpCalTableID = A02.FCmpCalTableID and A01.fIncomeItemId = A02.fIncomeItemId)");
        DbUtil.execute((Context)ctx, (String)str.toString());
    }

    private void updateJsonDataToSum(Context ctx, String taskId, Map<String, Object> bodyMap) throws BOSException {
        StringBuilder sumSQL = new StringBuilder();
        int fieldCount = this.getInsertDetailDataSql("T_HR_STaxCalConfigSum", sumSQL);
        StringBuilder configSQL = new StringBuilder();
        this.getInsertDetailDataSql("T_HR_STaxCalConfigDetail", configSQL);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        ArrayList<Object[]> initParams = new ArrayList<Object[]>();
        Map dataMap = (Map)bodyMap.get("data");
        List declareTypeEnumList = DeclareTypeEnum.getEnumList();
        for (DeclareTypeEnum declareTypeEnum : declareTypeEnumList) {
            String declareType = declareTypeEnum.getValue();
            Map declareData = (Map)dataMap.get(declareType);
            if (null == declareData || declareData.isEmpty()) continue;
            for (Map.Entry entry : declareData.entrySet()) {
                String apiObj = (String)entry.getKey();
                Object value = entry.getValue();
                if (!(value instanceof List)) continue;
                List rowList = (List)value;
                this.addParamToList(ctx, rowList, declareType, apiObj, paramList, initParams, fieldCount);
            }
        }
        if (!paramList.isEmpty()) {
            DbUtil.executeBatch((Context)ctx, (String)sumSQL.toString(), paramList);
            DbUtil.executeBatch((Context)ctx, (String)configSQL.toString(), paramList);
        }
        if (!initParams.isEmpty()) {
            String initSQL = "update t_hr_sTaxCalInitDetail set FState = ?, FErrorInfo =? where FCmpCalTableID = ? and FIncomeItemId =?";
            DbUtil.executeBatch((Context)ctx, (String)initSQL, initParams);
        }
        this.updateBatchNo(ctx, taskId);
    }

    private void updateReductionInfo(Context ctx, String taskId, Map<String, Object> dataMap) {
        try {
            this.updateJmsx(ctx, taskId, dataMap);
            ReductionSummaryFacadeFactory.getLocalInstance((Context)ctx).updateStatusByTaskId(taskId);
        }
        catch (Exception e) {
            logger.error((Object)"->\u66f4\u65b0\u51cf\u514d\u4e8b\u9879\u72b6\u6001\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    private boolean isFailed(int status) {
        return 0 != status && 1 != status;
    }

    private void updateBatchNo(Context ctx, String taskId) {
        try {
            String declareSQL = "select fBatchNo, fTbType from t_hr_sIncomeTaxDeclar d, t_hr_sTaxCalTask t where d.fTaxUnitId = t.fTaxUnitId and d.fYearMonth = t.fPeriod and t.fid = '" + taskId + "'";
            IRowSet declareRs = DbUtil.executeQuery((Context)ctx, (String)declareSQL);
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            while (declareRs.next()) {
                String batchNo = declareRs.getString("fBatchNo");
                String tbType = declareRs.getString("fTbType");
                String payerType = "0";
                if ("3".equals(tbType)) {
                    payerType = "1";
                }
                Object[] param = new Object[]{batchNo, payerType, taskId};
                params.add(param);
            }
            if (!params.isEmpty()) {
                String batchNoSQL = "update t_hr_sTaxCalConfigDetail set fBatchNo = ? where fid in (select config.fid from t_hr_sTaxCalConfigDetail config, t_hr_sTaxCalTaskDetail task, t_hr_sTaxPersonRecordEntry person where config.fCmpCalTableId = task.fCmpCalTableId and config.fIncomeItemId = task.fIncomeItemId and task.fPersonId = person.fPersonId and task.fTaxUnitId = person.fTaxUnitId and person.fPayerType = ? and task.fCalTaskId = ?)";
                DbUtil.executeBatch((Context)ctx, (String)batchNoSQL, params);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"updateBatchNo error: ", (Throwable)e);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private int getInsertDetailDataSql(String tableName, StringBuilder sql) {
        ArrayList fixFields = Lists.newArrayList((Object[])new String[]{"FCALSCHEMEID", "FCMPCALTABLEID", "FRELAYID", "FPERSONID", "FTAXUNITID", "FPERIODBEGIN", "FPERIODEND", "FINCOMEITEMID", "FCREATORID", "FCREATETIME", "FLASTUPDATEUSERID", "FLASTUPDATETIME"});
        String bosId = "F020ABDD";
        if (tableName.equalsIgnoreCase("T_HR_STAXCALCONFIGDETAIL")) {
            bosId = "CF8A697F";
        }
        sql.append("INSERT INTO ").append(tableName).append("(Fid, ");
        for (String fixField : fixFields) {
            sql.append(fixField).append(",");
        }
        for (int i = 0; i < this.itemColumnList.size(); ++i) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append(this.itemColumnList.get(i));
        }
        sql.append(" ) values(newBosId('").append(bosId).append("'), ");
        int fieldCount = fixFields.size() + this.itemColumnList.size();
        for (int i = 0; i < fieldCount; ++i) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append("?");
        }
        sql.append(")");
        return fieldCount;
    }

    private TaxCalFieldConfigCollection getTaxCalFields(Context ctx, String declareType, String apiObj, String incomeItemCode) throws BOSException {
        TaxCalFieldConfigCollection fields;
        String key = declareType + "_" + apiObj;
        if (!StringUtils.isEmpty((String)incomeItemCode)) {
            key = key + "_" + incomeItemCode;
        }
        if ((fields = this.apiFieldMap.get(key)) != null) {
            return fields;
        }
        String oql = "select declareType, taxItem.id, taxItem.fieldSn, bizField, apiField, apiObj, incomeItemCode where declareType = '" + declareType + "' and apiObj = '" + apiObj + "' and isResult = 1";
        if (!StringUtils.isEmpty((String)incomeItemCode) && !TaxConstant.FB.contains(apiObj)) {
            oql = oql + " and incomeItemCode = '" + incomeItemCode + "'";
        }
        if (null == (fields = TaxCalFieldConfigFactory.getLocalInstance((Context)ctx).getTaxCalFieldConfigCollection(oql)) || fields.isEmpty()) {
            String errMsg = "Lacking api field configuration for declareType [" + declareType + "], apiObj [" + apiObj + "], incomeItemCode [" + incomeItemCode + "]";
            logger.error((Object)errMsg);
            throw new BOSException(errMsg);
        }
        this.apiFieldMap.put(key, fields);
        return fields;
    }

    private void addParamToList(Context ctx, List<Map<String, Object>> list, String declareType, String apiObj, List<Object[]> paramsList, List<Object[]> initParams, int fieldCount) throws BOSException {
        if (list.isEmpty()) {
            return;
        }
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        Date createTime = new Date(System.currentTimeMillis());
        for (Map<String, Object> dataMap : list) {
            String zzhm;
            String incomeCode = (String)dataMap.get("sdxm");
            TaxCalFieldConfigCollection fields = this.getTaxCalFields(ctx, declareType, apiObj, incomeCode);
            String zzlx = (String)dataMap.get("zzlx");
            TaxCalInfoNoTaxItem basicInfo = this.filterByPersonAndIncomeCode(zzlx, zzhm = (String)dataMap.get("zzhm"), incomeCode = fields.get(0).getIncomeItemCode());
            if (null == basicInfo) continue;
            Object[] initParam = new Object[]{40, dataMap.get("errorinfo"), basicInfo.getCmpCalTableId(), basicInfo.getIncomeItemId()};
            initParams.add(initParam);
            int status = Integer.parseInt(String.valueOf(dataMap.get("status")));
            boolean isFailed = this.isFailed(status);
            if (isFailed) {
                initParam[0] = 50;
                continue;
            }
            Object[] param = new Object[fieldCount];
            param[0] = basicInfo.getCalSchemeId();
            param[1] = basicInfo.getCmpCalTableId();
            param[2] = basicInfo.getRelayId();
            param[3] = basicInfo.getPersonId();
            param[4] = basicInfo.getTaxUnitId();
            param[5] = basicInfo.getPeriodBegin();
            param[6] = basicInfo.getPeriodEnd();
            param[7] = basicInfo.getIncomeItemId();
            param[8] = userId;
            param[9] = createTime;
            param[10] = userId;
            param[11] = createTime;
            for (int k = 0; k < this.taxItemIdList.size(); ++k) {
                String taxItemId = this.taxItemIdList.get(k);
                TaxCalFieldConfigInfo field = this.filterByTaxItem(fields, taxItemId);
                Object value = null;
                if (null != field) {
                    value = dataMap.get(field.getApiField());
                }
                param[12 + k] = value;
            }
            paramsList.add(param);
        }
    }

    private TaxCalInfoNoTaxItem filterByPersonAndIncomeCode(String zzlx, String zzhm, String incomeCode) {
        for (TaxCalInfoNoTaxItem item : this.taxCalInfoNoTaxItem) {
            if (!zzlx.equals(item.getCardType()) || !zzhm.equals(item.getCardNo()) || !incomeCode.equals(item.getIncomeCode())) continue;
            return item;
        }
        return null;
    }

    private TaxCalFieldConfigInfo filterByTaxItem(TaxCalFieldConfigCollection fields, String taxItemId) {
        for (int i = 0; i < fields.size(); ++i) {
            TaxCalFieldConfigInfo field = fields.get(i);
            if (null == field.getTaxItem() || null == field.getTaxItem().getId() || !taxItemId.equals(field.getTaxItem().getId().toString())) continue;
            return field;
        }
        return null;
    }

    private void updateDetailByRelay(Context ctx, String taskId) throws BOSException {
        String item;
        StringBuilder str = new StringBuilder();
        for (String column : this.itemColumnList) {
            str.append("CONFIG.").append(column).append(",").append("RELAY.").append(column).append(" AS ").append("\"RELAY").append(column).append("\",");
        }
        String items = str.substring(0, str.length() - 1);
        str = new StringBuilder();
        str.append(" SELECT distinct CONFIG.FCMPCALTABLEID, CONFIG.FRELAYID, INCOMEITEM.FTAXCALMETHOD,TASK.fIncomeItemId,CONFIG.FErrorInfo,CONFIG.FStatus,").append(items);
        str.append(" FROM T_HR_STAXCALCONFIGSUM CONFIG ");
        str.append(" LEFT JOIN T_HR_STAXCALCONFIGSUM RELAY ON CONFIG.FRELAYID = RELAY.FCMPCALTABLEID  and CONFIG.fIncomeItemId = RELAY.fIncomeItemId ");
        str.append(" INNER JOIN T_HR_STAXCALTASKDETAIL TASK on CONFIG.FCMPCALTABLEID = TASK.FCMPCALTABLEID and CONFIG.fIncomeItemId = TASK.fIncomeItemId ");
        str.append(" INNER JOIN T_HR_STAXINCOMEITEM INCOMEITEM ON TASK.FINCOMEITEMID = INCOMEITEM.FID  ");
        str.append(" WHERE TASK.FCALTASKID = '").append(taskId).append("'");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        ArrayList<Object[]> relyParamsList = new ArrayList<Object[]>();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        HashMap<String, Integer> itemIndexMap = new HashMap<String, Integer>();
        for (int i = 0; i < this.itemColumnList.size(); ++i) {
            item = this.itemColumnList.get(i);
            if ("T20".equalsIgnoreCase(item)) {
                itemIndexMap.put("T1", i);
                continue;
            }
            if ("T22".equalsIgnoreCase(item)) {
                itemIndexMap.put("T2", i);
                continue;
            }
            if (!"T38".equalsIgnoreCase(item)) continue;
            itemIndexMap.put("T37", i);
        }
        try {
            while (rowSet.next()) {
                HashMap<String, BigDecimal> fixItemMap = new HashMap<String, BigDecimal>();
                Object[] param = new Object[this.itemColumnList.size() + 4];
                int taxCalMethod = rowSet.getInt("FTAXCALMETHOD");
                for (int i = 0; i < this.itemColumnList.size(); ++i) {
                    item = this.itemColumnList.get(i);
                    if (this.strItemColumnList.contains(item)) {
                        param[i] = rowSet.getString(item);
                        continue;
                    }
                    BigDecimal sum = this.isBigDecimalEmpty(rowSet.getBigDecimal(item)) ? BigDecimal.ZERO : rowSet.getBigDecimal(item);
                    BigDecimal sub = this.isBigDecimalEmpty(rowSet.getBigDecimal("RELAY" + item)) ? BigDecimal.ZERO : rowSet.getBigDecimal("RELAY" + item);
                    BigDecimal result = 20 == taxCalMethod || !this.itemSumSet.contains(item) ? sum : sum.subtract(sub);
                    if ("T37".equalsIgnoreCase(item)) {
                        fixItemMap.put(item, sum.subtract(sub));
                    }
                    if (10 == taxCalMethod && "T1".equalsIgnoreCase(item)) {
                        fixItemMap.put(item, sum.add(null == rowSet.getBigDecimal("T19") ? BigDecimal.ZERO : rowSet.getBigDecimal("T19")));
                    }
                    if (10 == taxCalMethod && "T2".equalsIgnoreCase(item)) {
                        fixItemMap.put(item, sum.add(null == rowSet.getBigDecimal("T21") ? BigDecimal.ZERO : rowSet.getBigDecimal("T21")));
                    }
                    param[i] = result;
                }
                for (Map.Entry entry : itemIndexMap.entrySet()) {
                    if (!fixItemMap.containsKey(entry.getKey())) continue;
                    param[((Integer)entry.getValue()).intValue()] = fixItemMap.get(entry.getKey());
                }
                param[this.itemColumnList.size()] = 10;
                param[this.itemColumnList.size() + 1] = 1;
                param[this.itemColumnList.size() + 2] = rowSet.getString("FCMPCALTABLEID");
                param[this.itemColumnList.size() + 3] = rowSet.getString("fIncomeItemId");
                paramsList.add(param);
                if (StringUtils.isEmpty((String)rowSet.getString("FRELAYID"))) continue;
                param = new Object[]{rowSet.getString("FRELAYID"), rowSet.getString("fIncomeItemId")};
                relyParamsList.add(param);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error((Object)e);
        }
        str = new StringBuilder();
        str.append(" UPDATE T_HR_STAXCALCONFIGDETAIL SET ");
        for (String column : this.itemColumnList) {
            str.append(",").append(column).append(" = ?");
        }
        str.append(",FState = ?, FIsLast = ?");
        str.append(" WHERE FCMPCALTABLEID = ? and fIncomeItemId = ? ");
        DbUtil.executeBatch((Context)ctx, (String)str.toString().replaceFirst(",", ""), paramsList);
        if (!relyParamsList.isEmpty()) {
            String sql = "update T_HR_STAXCALCONFIGDETAIL set FIsLast = 0 where FCMPCALTABLEID = ?  and fIncomeItemId = ?";
            DbUtil.executeBatch((Context)ctx, (String)sql, relyParamsList);
        }
    }

    private boolean isBigDecimalEmpty(Object obj) {
        if (null == obj) {
            return true;
        }
        if (!(obj instanceof BigDecimal)) {
            return true;
        }
        BigDecimal bigObj = (BigDecimal)obj;
        return bigObj.equals(BigDecimal.ZERO);
    }

    private void initPerson2TaxCalInfo(Context ctx, String taskId) throws BOSException {
        this.taxCalInfoNoTaxItem = new ArrayList<TaxCalInfoNoTaxItem>();
        String str = " SELECT FCALSCHEMEID, INIT.FCMPCALTABLEID, FRELAYID, INIT.FPERSONID, pre.fPayerType, RECORD.FCARDTYPE ZZLX, RECORD.FCARDNUMBER ZZHM,  INIT.FTAXUNITID, INIT.FPERIODBEGIN, INIT.FPERIODEND, INIT.fIncomeItemId, item.fIncomeCode  FROM T_HR_STAXCALINITDETAIL INIT  INNER JOIN T_HR_STAXCALTASKDETAIL TASK ON INIT.FCMPCALTABLEID = TASK.FCMPCALTABLEID and INIT.fIncomeItemId = TASK.fIncomeItemId INNER JOIN T_HR_STAXPERSONRECORD record ON TASK.FPERSONID = record.FPERSONID INNER JOIN T_HR_STaxPersonRecordEntry pre ON INIT.fPersonId = pre.fPersonId and INIT.fTaxUnitId = pre.fTaxUnitId  INNER JOIN T_HR_STaxIncomeItem item ON init.fIncomeItemId = item.fid  WHERE TASK.FCALTASKID = '" + taskId + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str);
        try {
            while (rowSet.next()) {
                TaxCalInfoNoTaxItem info = new TaxCalInfoNoTaxItem();
                String cardType = CardTypeEnum.getEnum(rowSet.getString("ZZLX")).getAlias();
                info.setCardType(cardType);
                info.setCardNo(rowSet.getString("ZZHM"));
                info.setCalSchemeId(rowSet.getString("FCALSCHEMEID"));
                info.setCmpCalTableId(rowSet.getString("FCMPCALTABLEID"));
                info.setIncomeCode(rowSet.getString("fIncomeCode"));
                info.setIncomeItemId(rowSet.getString("fIncomeItemId"));
                info.setPayerType(rowSet.getString("fPayerType"));
                info.setPeriodBegin(rowSet.getDate("FPERIODBEGIN"));
                info.setPeriodEnd(rowSet.getDate("FPERIODEND"));
                info.setPersonId(rowSet.getString("FPERSONID"));
                info.setRelayId(rowSet.getString("FRELAYID"));
                info.setTaxUnitId(rowSet.getString("FTAXUNITID"));
                this.taxCalInfoNoTaxItem.add(info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"initPersonInfo error: ", (Throwable)e);
        }
    }

    protected void initTaxItem(Context ctx) throws BOSException {
        this.itemColumnList = new ArrayList<String>();
        this.strItemColumnList = new HashSet<String>();
        this.taxItemIdList = new ArrayList<String>();
        this.itemSumSet = new HashSet<String>();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)"SELECT FIELDSN, FNUMBER, FISSUM, FDATATYPE, fid  FROM T_HR_STAXITEM");
        try {
            while (rowSet.next()) {
                String item = "T" + rowSet.getInt(1);
                this.itemColumnList.add(item);
                if (1 == rowSet.getInt("FDATATYPE")) {
                    this.strItemColumnList.add(item);
                }
                this.taxItemIdList.add(rowSet.getString("fid"));
                if (1 != rowSet.getInt(3)) continue;
                this.itemSumSet.add(item);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error((Object)e);
        }
    }
}

