/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.taxCal.util;

import com.kingdee.bos.BOSException;
import com.kingdee.shr.compensation.util.Base64Utils;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

public class TaxCalcFileUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.taxCal.util.TaxCalcFileUtils");

    public static String getUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] file2ByteArray(File file) {
        byte[] buffer = null;
        FileInputStream fis = null;
        ByteArrayOutputStream bos = null;
        try {
            int n;
            fis = new FileInputStream(file);
            bos = new ByteArrayOutputStream(1024);
            byte[] b = new byte[1024];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            buffer = bos.toByteArray();
        }
        catch (IOException e) {
            logger.error((Object)"getBytes error; ", (Throwable)e);
        }
        finally {
            if (null != bos) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    bos = null;
                }
            }
            if (null != fis) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    fis = null;
                }
            }
        }
        return buffer;
    }

    public static byte[] zipFiles2ByteArray(List<File> srcFiles) throws BOSException {
        ByteArrayOutputStream os = null;
        ZipOutputStream zos = null;
        FileInputStream in = null;
        try {
            os = new ByteArrayOutputStream();
            zos = new ZipOutputStream((OutputStream)os);
            zos.setEncoding("GBK");
            for (File srcFile : srcFiles) {
                int len;
                byte[] buf = new byte[1024];
                zos.putNextEntry(new ZipEntry(srcFile.getName()));
                in = new FileInputStream(srcFile);
                while ((len = in.read(buf)) != -1) {
                    zos.write(buf, 0, len);
                }
                zos.closeEntry();
                in.close();
            }
            Object object = os.toByteArray();
            return object;
        }
        catch (Exception e) {
            throw new BOSException("compress files error: " + e.getMessage());
        }
        finally {
            if (null != zos) {
                try {
                    zos.close();
                }
                catch (IOException e) {
                    zos = null;
                }
            }
            if (null != os) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    os = null;
                }
            }
            TaxCalcFileUtils.safeClose(in);
        }
    }

    public static void zipDir2ByteArray(List<File> srcDir, File outDir, boolean KeepDirStructure) throws BOSException {
        long start = System.currentTimeMillis();
        FileOutputStream out = null;
        ZipOutputStream zos = null;
        try {
            out = new FileOutputStream(outDir);
            zos = new ZipOutputStream((OutputStream)out);
            zos.setEncoding("GBK");
            TaxCalcFileUtils.compress(srcDir, zos, KeepDirStructure);
            long end = System.currentTimeMillis();
            logger.info((Object)("zipDir2ByteArray time cost: " + (end - start) + " ms"));
        }
        catch (Exception e) {
            logger.error((Object)"zipDir2ByteArray error: ", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
        finally {
            if (null != zos) {
                try {
                    zos.close();
                }
                catch (IOException e) {
                    zos = null;
                }
            }
            if (null != out) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    out = null;
                }
            }
        }
    }

    private static void compress(File sourceFile, ZipOutputStream zos, String name, boolean KeepDirStructure) throws Exception {
        block11: {
            block10: {
                byte[] buf = new byte[1024];
                if (!sourceFile.isFile()) break block10;
                FileInputStream in = null;
                try {
                    int len;
                    zos.putNextEntry(new ZipEntry(name));
                    in = new FileInputStream(sourceFile);
                    while ((len = in.read(buf)) != -1) {
                        zos.write(buf, 0, len);
                    }
                    zos.closeEntry();
                }
                catch (Exception e) {
                    try {
                        throw e;
                    }
                    catch (Throwable throwable) {
                        TaxCalcFileUtils.safeClose(in);
                        throw throwable;
                    }
                }
                TaxCalcFileUtils.safeClose(in);
                break block11;
            }
            File[] listFiles = sourceFile.listFiles();
            if (listFiles == null || listFiles.length == 0) {
                if (KeepDirStructure) {
                    zos.putNextEntry(new ZipEntry(name + "/"));
                    zos.closeEntry();
                }
            } else {
                for (File file : listFiles) {
                    if (KeepDirStructure) {
                        TaxCalcFileUtils.compress(file, zos, name + "/" + file.getName(), KeepDirStructure);
                        continue;
                    }
                    TaxCalcFileUtils.compress(file, zos, file.getName(), KeepDirStructure);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compress(List<File> sourceFileList, ZipOutputStream zos, boolean KeepDirStructure) throws Exception {
        byte[] buf = new byte[1024];
        for (File sourceFile : sourceFileList) {
            String name = sourceFile.getName();
            if (sourceFile.isFile()) {
                FileInputStream in = null;
                try {
                    int len;
                    zos.putNextEntry(new ZipEntry(name));
                    in = new FileInputStream(sourceFile);
                    while ((len = in.read(buf)) != -1) {
                        zos.write(buf, 0, len);
                    }
                    zos.closeEntry();
                    TaxCalcFileUtils.safeClose(in);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                finally {
                    TaxCalcFileUtils.safeClose(in);
                    continue;
                }
            }
            File[] listFiles = sourceFile.listFiles();
            if (listFiles == null || listFiles.length == 0) {
                if (!KeepDirStructure) continue;
                zos.putNextEntry(new ZipEntry(name + "/"));
                zos.closeEntry();
                continue;
            }
            for (File file : listFiles) {
                if (KeepDirStructure) {
                    TaxCalcFileUtils.compress(file, zos, name + "/" + file.getName(), KeepDirStructure);
                    continue;
                }
                TaxCalcFileUtils.compress(file, zos, file.getName(), KeepDirStructure);
            }
        }
    }

    public static void base64ToFile(String base64, File file) throws BOSException {
        byte[] byteBase64;
        try {
            byteBase64 = Base64Utils.decode(base64, "GBK");
        }
        catch (Exception e) {
            throw new BOSException("\u5904\u7406\u538b\u7f29\u6587\u4ef6\u51fa\u9519\uff1a" + e.getMessage());
        }
        if (null == byteBase64) {
            return;
        }
        FilterOutputStream bos = null;
        FileOutputStream outputStream = null;
        File tmp = new File(TaxCalcFileUtils.getUUID() + ".zip");
        try {
            outputStream = new FileOutputStream(tmp);
            bos = new BufferedOutputStream(outputStream);
            bos.write(byteBase64);
            ((BufferedOutputStream)bos).flush();
            TaxCalcFileUtils.unZip(tmp.getPath(), file, "GBK");
        }
        catch (Exception e) {
            throw new BOSException("\u751f\u6210\u538b\u7f29\u6587\u4ef6\u51fa\u9519\uff1a" + e.getMessage());
        }
        finally {
            if (null != bos) {
                try {
                    bos.close();
                }
                catch (IOException ex) {
                    bos = null;
                }
            }
            if (null != outputStream) {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (IOException ex) {
                    outputStream = null;
                }
            }
            FileUtils.deleteQuietly((File)tmp);
        }
    }

    public static void unZip(String unZipPath, File file, String encoding) throws BOSException {
        ZipFile zipFile = null;
        FileOutputStream outStream = null;
        InputStream inputStream = null;
        ZipEntry zipEntry = null;
        try {
            zipFile = new ZipFile(unZipPath, encoding);
            Enumeration entities = zipFile.getEntries();
            while (entities.hasMoreElements()) {
                zipEntry = (ZipEntry)entities.nextElement();
                inputStream = zipFile.getInputStream(zipEntry);
                if (zipEntry.isDirectory()) continue;
                outStream = new FileOutputStream(file);
                TaxCalcFileUtils.write2Disk(outStream, inputStream);
            }
            zipFile.close();
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void write2Disk(FileOutputStream outStream, InputStream inputStream) throws Exception {
        try {
            int length = 0;
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) > 0) {
                outStream.write(buffer, 0, length);
            }
            outStream.flush();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            TaxCalcFileUtils.safeClose(outStream);
            TaxCalcFileUtils.safeClose(inputStream);
        }
    }

    public static String getTimestamp(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        return dateFormat.format(date);
    }

    public static String getCnPeriod(String period) {
        SimpleDateFormat dateFormat1 = new SimpleDateFormat("yyyy\u5e74MM\u6708");
        SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return dateFormat1.format(dateFormat2.parse(period));
        }
        catch (ParseException e) {
            return period;
        }
    }

    public static String getCnPeriod1(Date period) {
        SimpleDateFormat dateFormat1 = new SimpleDateFormat("yyyy\u5e74MM\u6708");
        return dateFormat1.format(period);
    }

    public static String getCnPeriod2(Date period) {
        SimpleDateFormat dateFormat1 = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        String start = dateFormat1.format(period);
        Date endDate = CmpDateUtil.getEndOfMonth(period);
        String end = dateFormat1.format(endDate);
        return start + "\u5230" + end;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bytes2File(byte[] file, String path) {
        File target = new File(path);
        FileOutputStream os = null;
        FilterOutputStream bos = null;
        try {
            os = new FileOutputStream(target);
            bos = new BufferedOutputStream(os);
            bos.write(file);
        }
        catch (Exception e) {
            logger.error((Object)"bytes2File error: ", (Throwable)e);
        }
        finally {
            if (null != bos) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    bos = null;
                }
            }
            if (null != os) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException e) {
                    os = null;
                }
            }
        }
    }

    public static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

