/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;

public class CmpFileOperateUtils {
    public static void compress(Map<String, String> fileNameMapper, File sourceFile, ZipOutputStream zos, String name, boolean KeepDirStructure, boolean keepRoot) throws Exception {
        block12: {
            block11: {
                byte[] buf = new byte[10240];
                if (!sourceFile.isFile()) break block11;
                zos.putNextEntry(new ZipEntry(name));
                FileInputStream in = null;
                try {
                    int len;
                    in = new FileInputStream(sourceFile);
                    while ((len = in.read(buf)) != -1) {
                        zos.write(buf, 0, len);
                    }
                    zos.closeEntry();
                }
                catch (Exception e) {
                    try {
                        throw new RuntimeException("zip error from ZipUtils", e);
                    }
                    catch (Throwable throwable) {
                        CmpFileOperateUtils.closeResource(in);
                        throw throwable;
                    }
                }
                CmpFileOperateUtils.closeResource(in);
                break block12;
            }
            File[] listFiles = sourceFile.listFiles();
            if (listFiles == null || listFiles.length == 0) {
                if (KeepDirStructure) {
                    zos.putNextEntry(new ZipEntry(name + "/"));
                    zos.closeEntry();
                }
            } else {
                for (File file : listFiles) {
                    if (KeepDirStructure && keepRoot) {
                        String parentPath = fileNameMapper.getOrDefault(name, name);
                        String fileName = fileNameMapper.containsKey(file.getName()) ? fileNameMapper.get(file.getName()) : file.getName();
                        CmpFileOperateUtils.compress(fileNameMapper, file, zos, parentPath + "/" + fileName, KeepDirStructure, true);
                        continue;
                    }
                    if (fileNameMapper.containsKey(file.getName())) {
                        CmpFileOperateUtils.compress(fileNameMapper, file, zos, fileNameMapper.get(file.getName()), KeepDirStructure, true);
                        continue;
                    }
                    CmpFileOperateUtils.compress(fileNameMapper, file, zos, file.getName(), KeepDirStructure, true);
                }
            }
        }
    }

    public static void compress(Map<String, String> fileNameMapper, String sourceDir, String targetDir, String name, boolean KeepDirStructure) throws Exception {
        String fileName = name;
        if (!fileName.contains(".zip")) {
            fileName = fileName + ".zip";
        }
        File sourceFile = new File(sourceDir);
        try (FileOutputStream out = new FileOutputStream(new File(targetDir + File.separatorChar + fileName));
             ZipOutputStream zos = new ZipOutputStream(out);){
            CmpFileOperateUtils.compress(fileNameMapper, sourceFile, zos, sourceFile.getName(), KeepDirStructure, false);
        }
        catch (Exception e) {
            throw new RuntimeException("zip error from ZipUtils", e);
        }
        finally {
            FileUtils.deleteDirectory((File)sourceFile);
        }
    }

    public static void copyTheOnlyFileToDownload(String sourceDir, String targetDir, String fileName) throws Exception {
        File sourceFile = new File(sourceDir);
        File[] listFiles = sourceFile.listFiles();
        File file = listFiles[0];
        try (FileOutputStream out = new FileOutputStream(new File(targetDir + File.separatorChar + fileName));
             FileInputStream in = new FileInputStream(file);){
            int len;
            byte[] buf = new byte[10240];
            while ((len = in.read(buf)) != -1) {
                out.write(buf, 0, len);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("zip error from ZipUtils", e);
        }
        finally {
            FileUtils.deleteDirectory((File)sourceFile);
        }
    }

    public static void closeResource(Closeable ... closeables) {
        for (Closeable closeable : closeables) {
            if (null == closeable) continue;
            try {
                closeable.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

