/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.complexquery.QueryFieldInfo;
import com.kingdee.shr.compensation.CmpItemCollection;
import com.kingdee.shr.compensation.CmpItemDataType;
import com.kingdee.shr.compensation.CmpItemFactory;
import com.kingdee.shr.compensation.CmpItemInfo;
import com.kingdee.shr.compensation.exception.CmpItemException;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CmpItemUtil {
    private static final int totalLength = 20;
    private static final int numberPoint = 10;
    private static final String itemRegex = "^(S|s)\\d+$";

    public static void addItemColumns(Context ctx, Object item, List<String> tableList) throws EASBizException {
        ArrayList<String> sqlList = new ArrayList<String>();
        CmpItemCollection cmpItemCollection = (CmpItemCollection)((Object)item);
        CmpItemInfo cmpItemInfo = null;
        if (item == null || cmpItemCollection.size() <= 0) {
            return;
        }
        for (int i = 0; i < cmpItemCollection.size(); ++i) {
            cmpItemInfo = cmpItemCollection.get(i);
            CmpItemUtil.getAddItemColumnSql(cmpItemInfo, tableList, sqlList);
        }
        CmpSQLUtil.executeBatchSql(ctx, sqlList.toArray());
    }

    public static void getAddItemColumnSql(CmpItemInfo cmpItemInfo, List<String> tableList, List<String> sqlList) throws EASBizException {
        int fieldsn = cmpItemInfo.getFieldSn();
        int dataLength = cmpItemInfo.getDataLength();
        CmpItemDataType dataType = cmpItemInfo.getDataType();
        StringBuilder sql = new StringBuilder();
        for (String s : tableList) {
            sql.setLength(0);
            sql.append("alter table ").append(s);
            sql.append(" add S").append(fieldsn);
            if (dataType == CmpItemDataType.NUMBER) {
                sql.append(" numeric(20,10)");
            } else {
                if (dataLength > 1000) {
                    throw new CmpItemException(CmpItemException.TOOLONG);
                }
                sql.append(" nvarchar(").append(dataLength).append(")");
            }
            sqlList.add(sql.toString());
        }
    }

    public static void deleteItemColumns(Context ctx, List<String> columnList, List<String> tableList) {
        StringBuilder sql = new StringBuilder();
        ArrayList<String> sqlList = new ArrayList<String>();
        if (tableList.size() > 0 && columnList.size() > 0) {
            for (String value : tableList) {
                for (String s : columnList) {
                    sql.setLength(0);
                    sql.append("if exists (select KSQL_COL_NAME col from KSQL_USERCOLUMNS where KSQL_COL_TABNAME = '");
                    sql.append(value).append("' and KSQL_COL_NAME = '").append(s).append("')");
                    sql.append("alter table ").append(value).append(" drop column ").append(s);
                    sqlList.add(sql.toString());
                }
            }
            CmpSQLUtil.executeBatchSql(ctx, sqlList.toArray());
        }
    }

    public void selectItemColumns(Context ctx, List<String> tableList) throws EASBizException {
        Map passiveMap = this.getFields(ctx, tableList.get(0));
        Map initMap = this.getFields(ctx, tableList.get(1));
        Map itemMap = this.getItems(ctx);
        CmpItemCollection cmpItemCollection = new CmpItemCollection();
        CmpItemInfo cmpItemInfo = null;
        CmpItemDataType dataType = null;
        for (String column : initMap.keySet()) {
            if (passiveMap.containsKey(column)) continue;
            Map map = itemMap.containsKey(column) ? (Map)itemMap.get(column) : (Map)initMap.get(column);
            cmpItemInfo = new CmpItemInfo();
            int fieldsn = Integer.parseInt(column.substring(1));
            dataType = (CmpItemDataType)((Object)map.get("dataType"));
            int dataLength = Integer.parseInt(map.get("dataLength").toString());
            if (dataLength > 1000) {
                dataLength = 1000;
            }
            cmpItemInfo.setFieldSn(fieldsn);
            cmpItemInfo.setDataType(dataType);
            cmpItemInfo.setDataLength(dataLength);
            cmpItemCollection.add(cmpItemInfo);
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(tableList.get(0));
        if (cmpItemCollection.size() > 0) {
            CmpItemUtil.addItemColumns(ctx, (Object)cmpItemCollection, list);
        }
    }

    public Map getFields(Context ctx, String tableName) {
        LinkedHashMap filedsMap = new LinkedHashMap();
        HashMap<String, Object> map = null;
        CmpItemDataType dataType = null;
        String ksql = "SELECT KSQL_COL_NAME as columnName,KSQL_COL_TYPE as dataType,KSQL_COL_LENGTH as dataLength FROM KSQL_USERCOLUMNS WHERE (KSQL_COL_NAME like 'S%' or  KSQL_COL_NAME like 's%') and KSQL_COL_TABNAME = '" + tableName + "'";
        try {
            IRowSet rs = CmpSQLUtil.executeQuery(ctx, ksql);
            while (rs.next()) {
                String column = rs.getString("columnName");
                if (!column.matches(itemRegex)) continue;
                map = new HashMap<String, Object>();
                String snType = rs.getString("dataType");
                if ("character varying".equalsIgnoreCase(snType) || "varchar".equalsIgnoreCase(snType) || "nvarchar".equalsIgnoreCase(snType) || "NVARCHAR2".equalsIgnoreCase(snType) || "sysname".equalsIgnoreCase(snType) || "ntext".equalsIgnoreCase(snType) || "NCLOB".equalsIgnoreCase(snType) || "VARCHAR2".equalsIgnoreCase(snType)) {
                    dataType = CmpItemDataType.STRING;
                } else if ("decimal".equalsIgnoreCase(snType) || "NUMBER".equalsIgnoreCase(snType) || "numeric".equalsIgnoreCase(snType)) {
                    dataType = CmpItemDataType.NUMBER;
                }
                map.put("dataType", (Object)dataType);
                map.put("dataLength", rs.getString("dataLength"));
                filedsMap.put(column.toLowerCase(Locale.ENGLISH), map);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return filedsMap;
    }

    public Map getItems(Context ctx) {
        HashMap itemsMap = new HashMap();
        HashMap<String, Object> map = null;
        CmpItemDataType dataType = null;
        try {
            CmpItemCollection cmpItemCollection = CmpItemFactory.getLocalInstance(ctx).getCmpItemCollection();
            for (int i = 0; i < cmpItemCollection.size(); ++i) {
                CmpItemInfo cmpItemInfo = cmpItemCollection.get(i);
                dataType = cmpItemInfo.getDataType();
                map = new HashMap<String, Object>();
                map.put("dataType", (Object)dataType);
                map.put("dataLength", cmpItemInfo.getDataLength());
                itemsMap.put("s" + cmpItemInfo.getFieldSn(), map);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return itemsMap;
    }

    public static void replaceItemColumns(QueryFieldInfo fields) {
        if (fields.getChildren() != null) {
            for (int i = 0; i < fields.getChildren().size(); ++i) {
                CmpItemUtil.replaceItemColumns((QueryFieldInfo)fields.getChildren().get(i));
            }
        } else {
            String field = fields.getField();
            if (!StringUtils.isEmpty((String)field) && field.contains("cmp_CTB")) {
                field = field.replace("cmp_CTB", "cmp_CTR");
                fields.setField(field);
            }
        }
    }

    public boolean verifyItemColumn(Context ctx, String tableName) {
        String ksql = "SELECT KSQL_COL_NAME as columnName FROM KSQL_USERCOLUMNS WHERE (KSQL_COL_NAME like 'S%' or  KSQL_COL_NAME like 's%') and KSQL_COL_TABNAME = '" + tableName + "'";
        try {
            IRowSet rs = CmpSQLUtil.executeQuery(ctx, ksql);
            while (rs.next()) {
                String columnName = rs.getString("columnName");
                if (!columnName.matches(itemRegex)) continue;
                return true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public List<String> getItemColumns(Context ctx, String tableName) {
        HashSet<String> itemSet = new HashSet<String>();
        String ksql = "SELECT KSQL_COL_NAME as columnName FROM KSQL_USERCOLUMNS WHERE (KSQL_COL_NAME like 'S%' or  KSQL_COL_NAME like 's%') and KSQL_COL_TABNAME = '" + tableName + "'";
        try {
            IRowSet rs = CmpSQLUtil.executeQuery(ctx, ksql);
            while (rs.next()) {
                String columnName = rs.getString("columnName");
                if (!columnName.matches(itemRegex)) continue;
                itemSet.add(columnName);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return new ArrayList<String>(itemSet);
    }

    public String buildSqlByType(Context ctx, String tableName, List<String> itemList, String type) {
        StringBuffer buildSql = new StringBuffer();
        if ("update".equals(type)) {
            buildSql.append("update " + tableName + " set ");
            for (int i = 0; i < itemList.size(); ++i) {
                buildSql.append(itemList.get(i) + " = ?,");
            }
            buildSql = buildSql.deleteCharAt(buildSql.length() - 1);
        } else {
            buildSql.append("insert into " + tableName);
            StringBuffer itemSql = new StringBuffer();
            StringBuffer valuesSql = new StringBuffer();
            for (int i = 0; i < itemList.size(); ++i) {
                itemSql.append(itemList.get(i) + ", ");
                valuesSql.append("?, ");
            }
            itemSql = itemSql.deleteCharAt(buildSql.length() - 1);
            valuesSql = valuesSql.deleteCharAt(buildSql.length() - 1);
            buildSql = buildSql.append("(" + itemSql + ") ").append(" values(" + valuesSql + ")");
        }
        return buildSql.toString();
    }

    public void dealWithItemColumns(Context ctx, List<String> tableList) throws EASBizException {
        Map passiveMap = this.getFields(ctx, tableList.get(0));
        Map initMap = this.getFields(ctx, tableList.get(1));
        Map itemMap = this.getItems(ctx);
        CmpItemCollection addItemCollection = new CmpItemCollection();
        ArrayList<String> columnList = new ArrayList<String>();
        CmpItemInfo cmpItemInfo = null;
        CmpItemDataType dataType = null;
        for (String column : initMap.keySet()) {
            int dataLength;
            if (passiveMap.containsKey(column)) continue;
            Map map = itemMap.containsKey(column) ? (Map)itemMap.get(column) : (Map)initMap.get(column);
            cmpItemInfo = new CmpItemInfo();
            int fieldsn = Integer.parseInt(column.substring(1));
            dataType = (CmpItemDataType)((Object)map.get("dataType"));
            int n = dataLength = CmpStrUtil.isNullOrEmpty(map.get("dataLength")) ? 20 : Integer.parseInt(map.get("dataLength").toString());
            if (dataLength > 1000) {
                dataLength = 1000;
            }
            cmpItemInfo.setFieldSn(fieldsn);
            cmpItemInfo.setDataType(dataType);
            cmpItemInfo.setDataLength(dataLength);
            addItemCollection.add(cmpItemInfo);
        }
        for (String column : passiveMap.keySet()) {
            if (initMap.containsKey(column)) continue;
            columnList.add("S" + Integer.parseInt(column.substring(1)));
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(tableList.get(0));
        if (addItemCollection.size() > 0) {
            CmpItemUtil.addItemColumns(ctx, (Object)addItemCollection, list);
        }
        if (columnList.size() > 0) {
            CmpItemUtil.deleteItemColumns(ctx, columnList, list);
        }
    }

    public void initCmpItemColumn(Context ctx, String RepTableName, String tableName) {
        try {
            ArrayList<String> tableList = new ArrayList<String>();
            tableList.add(RepTableName);
            tableList.add(tableName);
            this.dealWithItemColumns(ctx, tableList);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }
}

