/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.syssetting.app.osf.OSFAppUtil;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class HRCmpReportUtil {
    public static final DateFormat dateFmt_yyyyMM = new SimpleDateFormat("yyyyMM");
    public static final DateFormat dateFmt_yyyy_MM = new SimpleDateFormat("yyyy-MM");
    public static final DateFormat dateFmt_yyyy_M = new SimpleDateFormat("yyyy-M");
    public static final DateFormat dateFmt_yyyy_MM_dd = new SimpleDateFormat("yyyy-MM-dd");
    public static final String isNotStartSHR = "\uff08uninitialized\uff09";
    public static final String CMP_BRIEF_PERMID = "fffffff0-ffff-efff-f2bd-0000002990a0PERMITEM";

    public static String getTempTableName(Context ctx) throws Exception {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String tempTableName = pool.createTempTableName();
        return tempTableName;
    }

    public static void relaseTempTable(Context ctx, String tempTableName) throws BOSException {
        if (!StringUtils.isEmpty((String)tempTableName)) {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            pool.releaseTable(tempTableName);
        }
    }

    public static String getCmpItemsInvolvedLaborCost(Context ctx, String classify) {
        StringBuffer cmpItemBuffer = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        sql.append("select cmpItem.Fid fid from T_HR_SCmpItem cmpItem inner join T_HR_SLaborCostType laborCostType on cmpItem.FLaborCostTypeID = laborCostType.fid ").append("where laborCostType.fstate = 1 and cmpItem.fstate = 1 and cmpItem.FDataType = 0 ").append("and exists(select 1 from T_HR_SCostBear costBear where cmpItem.FID = costBear.FCmpItemID) ");
        if (!StringUtil.isEmpty((String)classify)) {
            sql.append(" and laborCostType.fid = '" + classify + "' ");
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                String cmpItemId = rowSet.getString("fid");
                cmpItemBuffer.append("'" + cmpItemId + "', ");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return cmpItemBuffer.toString().length() > 0 ? cmpItemBuffer.toString().substring(0, cmpItemBuffer.toString().length() - 2) : "";
    }

    public static String getRootAdminId() {
        return "00000000-0000-0000-0000-000000000000CCE7AED4";
    }

    public static HashSet<String> getDefaultId() {
        HashSet<String> defualtBillId = new HashSet<String>();
        defualtBillId.add("8r0AAAAKnsDk802D");
        return defualtBillId;
    }

    public static String getSumLaborByPeriodYearAndMonth(Context ctx, String cmpItems, String orgId, int year, int month) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String userId = HRCmpReportUtil.getUserId(ctx);
        String datePoint = HRCmpReportUtil.getDatePoint(year, month);
        if (StringUtils.isEmpty((String)cmpItems)) {
            cmpItems = "''";
        }
        String includeSubSql = null;
        includeSubSql = HRCmpReportUtil.isUserOrgIncludeSub(ctx, userId, orgId, CMP_BRIEF_PERMID) ? " where adcount.fhistoryrelateid = '" + orgId + "'" : " where adminOrgHis.fhistoryrelateid = '" + orgId + "' and adcount.fhistoryrelateid = '" + orgId + "'";
        sql.append("select costBear.FPeriodYear periodYear, costBear.FPeriodMonth periodMonth, sum(case when costBear.FBearMoney is null then 0 else costBear.FBearMoney end) total ").append("from T_ORG_Admin adminOrg ").append("inner join T_ORG_AdminHIS adcount on adminOrg.fid = adcount.fhistoryrelateid ").append("left join T_ORG_AdminHIS adminOrgHis on (charindex(concat(adcount.FLongNumber,'!'),adminOrgHis.FLongNumber) = 1 or adcount.FLongNumber = adminOrgHis.FLongNumber) ").append("inner join ( ").append(HRCmpReportUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(HRCmpReportUtil.getMobileAdminRangeSql(ctx, userId, CMP_BRIEF_PERMID) + " ").append(") orgRange on adcount.fhistoryrelateid = orgRange.forgid ").append("inner join T_HR_SCostBear costBear on adminOrgHis.fhistoryrelateid = costBear.FCostBearOrgUnitID ").append(includeSubSql + " ").append("and costBear.FCmpItemId in (" + cmpItems + " ) ").append("and adcount.feffdt <=" + datePoint + " and adcount.fleffdt >=" + datePoint + " ").append("and adminOrgHis.feffdt <=" + datePoint + " and adminOrgHis.fleffdt >=" + datePoint + " ").append("group by costBear.FPeriodYear, costBear.FPeriodMonth ").append("order by costBear.FPeriodYear, costBear.FPeriodMonth ");
        return sql.toString();
    }

    public static String getManageOrgIdsSql(Context ctx, String orgId, int year, int month) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String userId = HRCmpReportUtil.getUserId(ctx);
        String datePoint = HRCmpReportUtil.getDatePoint(year, month);
        String includeSubSql = null;
        includeSubSql = HRCmpReportUtil.isUserOrgIncludeSub(ctx, userId, orgId, CMP_BRIEF_PERMID) ? " where adcount.fhistoryrelateid = '" + orgId + "'" : " where adminOrgHis.fhistoryrelateid = '" + orgId + "' and adcount.fhistoryrelateid = '" + orgId + "'";
        sql.append("select adminOrgHis.fhistoryrelateid  adminOrgId ").append("from T_ORG_Admin adminOrg ").append("inner join T_ORG_AdminHIS adcount on adminOrg.fid = adcount.fhistoryrelateid ").append("left join T_ORG_AdminHIS adminOrgHis on (charindex(concat(adcount.FLongNumber,'!'),adminOrgHis.FLongNumber) = 1 or adcount.FLongNumber = adminOrgHis.FLongNumber) ").append("inner join ( ").append(HRCmpReportUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(HRCmpReportUtil.getMobileAdminRangeSql(ctx, userId, CMP_BRIEF_PERMID) + " ").append(") orgRange on adcount.fhistoryrelateid = orgRange.forgid ").append(includeSubSql + " ").append("and adcount.feffdt <=" + datePoint + " and adcount.fleffdt >=" + datePoint + " ").append("and adminOrgHis.feffdt <=" + datePoint + " and adminOrgHis.fleffdt >=" + datePoint + " ");
        return sql.toString();
    }

    public static String getCostBearSumDataSql(Context ctx, String cmpItems, String orgId) {
        StringBuffer sql = new StringBuffer();
        if (StringUtils.isEmpty((String)cmpItems)) {
            cmpItems = "''";
        }
        if (StringUtils.isEmpty((String)orgId)) {
            orgId = "''";
        }
        sql.append("select costBear.FPeriodYear periodYear, costBear.FPeriodMonth periodMonth, sum(case when costBear.FBearMoney is null then 0 else costBear.FBearMoney end) total ").append("from T_HR_SCostBear costBear where costBear.FCostBearOrgUnitID in (" + orgId + ")").append("and costBear.FCmpItemId in (" + cmpItems + " ) ").append("group by costBear.FPeriodYear, costBear.FPeriodMonth ").append("order by costBear.FPeriodYear, costBear.FPeriodMonth ");
        return sql.toString();
    }

    public static String sendMsgLaborInfoSql(Context ctx, String cmpItems, String uId, int year, int month) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String datePoint = HRCmpReportUtil.getDatePoint(year, month);
        String orgId = HRCmpReportUtil.getResponseAdminOrg(ctx, uId);
        if (StringUtils.isEmpty((String)cmpItems)) {
            cmpItems = "''";
        }
        String userId = HRCmpReportUtil.getUserId(ctx);
        String includeSubSql = null;
        includeSubSql = HRCmpReportUtil.isUserOrgIncludeSub(ctx, userId, orgId, CMP_BRIEF_PERMID) ? " where adcount.fhistoryrelateid = '" + orgId + "'" : " where adminOrgHis.fhistoryrelateid = '" + orgId + "' and adcount.fhistoryrelateid = '" + orgId + "'";
        sql.append("select costBear.FPeriodYear periodYear, costBear.FPeriodMonth periodMonth, sum(case when costBear.FBearMoney is null then 0 else costBear.FBearMoney end) total ").append("from T_ORG_Admin adminOrg ").append("inner join T_ORG_AdminHIS adcount on adminOrg.fid = adcount.fhistoryrelateid ").append("left join T_ORG_AdminHIS adminOrgHis on (charindex(concat(adcount.FLongNumber,'!'),adminOrgHis.FLongNumber) = 1 or adcount.FLongNumber = adminOrgHis.FLongNumber) ").append("inner join ( ").append(HRCmpReportUtil.getPersonPositionResponseAdminSql(uId)).append(" union ").append(HRCmpReportUtil.getAdminRangeSql(ctx, uId) + " ").append(") orgRange on adcount.fhistoryrelateid = orgRange.forgid ").append("inner join T_HR_SCostBear costBear on adminOrgHis.fhistoryrelateid = costBear.FCostBearOrgUnitID ").append(includeSubSql + " ").append("and costBear.FCmpItemId in (" + cmpItems + " ) ").append("and adcount.feffdt <=" + datePoint + " and adcount.fleffdt >=" + datePoint + " ").append("and adminOrgHis.feffdt <=" + datePoint + " and adminOrgHis.fleffdt >=" + datePoint + " ").append("group by costBear.FPeriodYear, costBear.FPeriodMonth ").append("order by costBear.FPeriodYear, costBear.FPeriodMonth desc ");
        return sql.toString();
    }

    public static String sendMsgPersonInfoSql(Context ctx, String cmpItems, String uId, int year, int month) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String datePoint = HRCmpReportUtil.getDatePoint(year, month);
        String orgId = HRCmpReportUtil.getResponseAdminOrg(ctx, uId);
        if (StringUtils.isEmpty((String)cmpItems)) {
            cmpItems = "''";
        }
        String userId = HRCmpReportUtil.getUserId(ctx);
        String includeSubSql = null;
        includeSubSql = HRCmpReportUtil.isUserOrgIncludeSub(ctx, userId, orgId, CMP_BRIEF_PERMID) ? " where adcount.fhistoryrelateid = '" + orgId + "'" : " where adminOrgHis.fhistoryrelateid = '" + orgId + "' and adcount.fhistoryrelateid = '" + orgId + "'";
        sql.append("select count(distinct costBear.FPersonId) personCount, costBear.FPeriodYear periodYear, costBear.FPeriodMonth periodMonth ").append("from T_ORG_Admin adminOrg ").append("inner join T_ORG_AdminHIS adcount on adminOrg.fid = adcount.fhistoryrelateid ").append("left join T_ORG_AdminHIS adminOrgHis on (charindex(concat(adcount.FLongNumber,'!'),adminOrgHis.FLongNumber) = 1 or adcount.FLongNumber = adminOrgHis.FLongNumber) ").append("inner join ( ").append(HRCmpReportUtil.getPersonPositionResponseAdminSql(uId)).append(" union ").append(HRCmpReportUtil.getAdminRangeSql(ctx, uId) + " ").append(") orgRange on adcount.fhistoryrelateid = orgRange.forgid ").append("inner join T_HR_SCostBear costBear on adminOrgHis.fhistoryrelateid = costBear.FCostBearOrgUnitID ").append(includeSubSql + " ").append("where costBear.FCmpItemId in (" + cmpItems + " ) ").append("and adcount.feffdt <=" + datePoint + " and adcount.fleffdt >=" + datePoint + " ").append("and adminOrgHis.feffdt <=" + datePoint + " and adminOrgHis.fleffdt >=" + datePoint + " ").append("group by costBear.FPeriodYear, costBear.FPeriodMonth ").append("order by costBear.FPeriodYear, costBear.FPeriodMonth desc ");
        return sql.toString();
    }

    public static String getSumIndexByPeriodYearAndMonth(Context ctx, String orgId, int year, int month) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String userId = HRCmpReportUtil.getUserId(ctx);
        String datePoint = HRCmpReportUtil.getDatePoint(year, month);
        String includeSubSql = null;
        includeSubSql = HRCmpReportUtil.isUserOrgIncludeSub(ctx, userId, orgId, CMP_BRIEF_PERMID) ? " where adcount.fhistoryrelateid = '" + orgId + "'" : " where adminOrgHis.fhistoryrelateid = '" + orgId + "' and adcount.fhistoryrelateid = '" + orgId + "'";
        sql.append("select cmpIndex.FYear periodYear, cmpIndex.FPeriod periodMonth, sum(case when cmpIndex.FAmount is null then 0 else cmpIndex.FAmount end) total ").append("from T_ORG_Admin adminOrg ").append("inner join T_ORG_AdminHIS adcount on adminOrg.fid = adcount.fhistoryrelateid ").append("left join T_ORG_AdminHIS adminOrgHis on (charindex(concat(adcount.FLongNumber,'!'),adminOrgHis.FLongNumber) = 1 or adcount.FLongNumber = adminOrgHis.FLongNumber) ").append("inner join ( ").append(HRCmpReportUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(HRCmpReportUtil.getMobileAdminRangeSql(ctx, userId, CMP_BRIEF_PERMID) + " ").append(") orgRange on adcount.fhistoryrelateid = orgRange.forgid ").append("inner join T_HR_SCmpIndexAnalysisData cmpIndex on adminOrgHis.fhistoryrelateid = cmpIndex.FAdminOrgID ").append(includeSubSql + " ").append("and cmpIndex.FPeriodType = 3 ").append("and adcount.feffdt <=" + datePoint + " and adcount.fleffdt >=" + datePoint + " ").append("and adminOrgHis.feffdt <=" + datePoint + " and adminOrgHis.fleffdt >=" + datePoint + " ").append("group by cmpIndex.FYear, cmpIndex.FPeriod ").append("order by cmpIndex.FYear, cmpIndex.FPeriod ");
        return sql.toString();
    }

    public static String getDetailPersonByPeriodYearAndMonth(Context ctx, String cmpItems, String orgId, int year, int month) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String userId = HRCmpReportUtil.getUserId(ctx);
        String datePoint = HRCmpReportUtil.getDatePoint(year, month);
        if (StringUtils.isEmpty((String)cmpItems)) {
            cmpItems = "''";
        }
        String includeSubSql = null;
        includeSubSql = HRCmpReportUtil.isUserOrgIncludeSub(ctx, userId, orgId, CMP_BRIEF_PERMID) ? " where adcount.fhistoryrelateid = '" + orgId + "'" : " where adminOrgHis.fhistoryrelateid = '" + orgId + "' and adcount.fhistoryrelateid = '" + orgId + "'";
        sql.append("select distinct costBear.FPersonId personId, costBear.FPeriodYear periodYear, costBear.FPeriodMonth periodMonth, sum(case when costBear.FBearMoney is null then 0 else costBear.FBearMoney end) total ").append("from T_ORG_Admin adminOrg ").append("inner join T_ORG_AdminHIS adcount on adminOrg.fid = adcount.fhistoryrelateid ").append("left join T_ORG_AdminHIS adminOrgHis on (charindex(concat(adcount.FLongNumber,'!'),adminOrgHis.FLongNumber) = 1 or adcount.FLongNumber = adminOrgHis.FLongNumber) ").append("inner join ( ").append(HRCmpReportUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(HRCmpReportUtil.getMobileAdminRangeSql(ctx, userId, CMP_BRIEF_PERMID) + " ").append(") orgRange on adcount.fhistoryrelateid = orgRange.forgid ").append("inner join T_HR_SCostBear costBear on adminOrgHis.fhistoryrelateid = costBear.FCostBearOrgUnitID ").append(includeSubSql + " ").append("and costBear.FCmpItemId in (" + cmpItems + " ) ").append("and adcount.feffdt <=" + datePoint + " and adcount.fleffdt >=" + datePoint + " ").append("and adminOrgHis.feffdt <=" + datePoint + " and adminOrgHis.fleffdt >=" + datePoint + " ").append("group by costBear.FPersonId, costBear.FPeriodYear, costBear.FPeriodMonth ").append("order by costBear.FPeriodYear, costBear.FPeriodMonth ");
        return sql.toString();
    }

    public static String getSumLaborItemsByPeriodYearAndMonth(Context ctx, String cmpItems, String orgId, int year, int month) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String userId = HRCmpReportUtil.getUserId(ctx);
        String datePoint = HRCmpReportUtil.getDatePoint(year, month);
        if (StringUtils.isEmpty((String)cmpItems)) {
            cmpItems = "''";
        }
        String includeSubSql = null;
        includeSubSql = HRCmpReportUtil.isUserOrgIncludeSub(ctx, userId, orgId, CMP_BRIEF_PERMID) ? " where adcount.fhistoryrelateid = '" + orgId + "'" : " where adminOrgHis.fhistoryrelateid = '" + orgId + "' and adcount.fhistoryrelateid = '" + orgId + "'";
        sql.append("select costBear.FCmpitemId cmpItemId, sum(case when costBear.FBearMoney is null then 0 else costBear.FBearMoney end) total ").append("from T_ORG_Admin adminOrg ").append("inner join T_ORG_AdminHIS adcount on adminOrg.fid = adcount.fhistoryrelateid ").append("left join T_ORG_AdminHIS adminOrgHis on (charindex(concat(adcount.FLongNumber,'!'),adminOrgHis.FLongNumber) = 1 or adcount.FLongNumber = adminOrgHis.FLongNumber) ").append("inner join ( ").append(HRCmpReportUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(HRCmpReportUtil.getMobileAdminRangeSql(ctx, userId, CMP_BRIEF_PERMID) + " ").append(") orgRange on adcount.fhistoryrelateid = orgRange.forgid ").append("inner join T_HR_SCostBear costBear on adminOrgHis.fhistoryrelateid = costBear.FCostBearOrgUnitID ").append(includeSubSql + " ").append("and costBear.FCmpItemId in (" + cmpItems + " ) ").append("and adcount.feffdt <=" + datePoint + " and adcount.fleffdt >=" + datePoint + " ").append("and adminOrgHis.feffdt <=" + datePoint + " and adminOrgHis.fleffdt >=" + datePoint + " ").append("and costBear.FPeriodYear =" + year + " and costBear.FPeriodMonth =" + month + " ").append("group by costBear.FCmpitemId ");
        return sql.toString();
    }

    public static String getSumCurrOrgDataByPeriodYearAndMonth(Context ctx, String cmpItems, String orgId, int year, int month) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String userId = HRCmpReportUtil.getUserId(ctx);
        String datePoint = HRCmpReportUtil.getDatePoint(year, month);
        if (StringUtils.isEmpty((String)cmpItems)) {
            cmpItems = "''";
        }
        String l = LocaleUtils.getShortCode((Context)ctx);
        String includeSubSql = null;
        includeSubSql = HRCmpReportUtil.isUserOrgIncludeSub(ctx, userId, orgId, CMP_BRIEF_PERMID) ? " where adcount.fhistoryrelateid = '" + orgId + "'" : " where adminOrgHis.fhistoryrelateid = '" + orgId + "' and adcount.fhistoryrelateid = '" + orgId + "'";
        sql.append("select adcount.fname_" + l + " name, adcount.fhistoryrelateid id, adcount.fisleaf isleaf, sum(case when costBear.FBearMoney is null then 0 else costBear.FBearMoney end) total ").append("from T_ORG_Admin adminOrg ").append("inner join T_ORG_AdminHIS adcount on adminOrg.fid = adcount.fhistoryrelateid ").append("inner join ( ").append(HRCmpReportUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(HRCmpReportUtil.getMobileAdminRangeSql(ctx, userId, CMP_BRIEF_PERMID) + " ").append(") orgRange on adcount.fhistoryrelateid = orgRange.forgid ").append("inner join T_HR_SCostBear costBear on adcount.fhistoryrelateid = costBear.FCostBearOrgUnitID ").append(includeSubSql + " ").append("and costBear.FCmpItemId in (" + cmpItems + " ) ").append("and adcount.feffdt <=" + datePoint + " and adcount.fleffdt >=" + datePoint + " ").append("and costBear.FPeriodYear =" + year + " and costBear.FPeriodMonth =" + month + " ").append("group by adcount.fname_" + l + " , adcount.fhistoryrelateid, adcount.fisleaf ");
        return sql.toString();
    }

    public static String getSumSubOrgDataByPeriodYearAndMonth(Context ctx, String orgId, String cmpItems, int year, int month) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String userId = HRCmpReportUtil.getUserId(ctx);
        String datePoint = HRCmpReportUtil.getDatePoint(year, month);
        if (StringUtils.isEmpty((String)cmpItems)) {
            cmpItems = "''";
        }
        String l = LocaleUtils.getShortCode((Context)ctx);
        String includeSubSql = null;
        includeSubSql = HRCmpReportUtil.isUserOrgIncludeSub(ctx, userId, orgId, CMP_BRIEF_PERMID) ? " where adcount.fhistoryrelateid = '" + orgId + "'" : " where adminOrgHis.fhistoryrelateid = '" + orgId + "' and adcount.fhistoryrelateid = '" + orgId + "'";
        sql.append("select adcount.fname_" + l + " name, adcount.fhistoryrelateid id, adcount.fisleaf isleaf, sum(case when costBear.FBearMoney is null then 0 else costBear.FBearMoney end) total ").append("from T_ORG_Admin adminOrg ").append("inner join T_ORG_AdminHIS adcount on adminOrg.fid = adcount.fhistoryrelateid ").append("left join T_ORG_AdminHIS adminOrgHis on (charindex(concat(adcount.FLongNumber,'!'),adminOrgHis.FLongNumber) = 1 or adcount.FLongNumber = adminOrgHis.FLongNumber) ").append("inner join ( ").append(HRCmpReportUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(HRCmpReportUtil.getMobileAdminRangeSql(ctx, userId, CMP_BRIEF_PERMID) + " ").append(") orgRange on adcount.fhistoryrelateid = orgRange.forgid ").append("inner join T_HR_SCostBear costBear on adminOrgHis.fhistoryrelateid = costBear.FCostBearOrgUnitID ").append(includeSubSql + " ").append("and costBear.FCmpItemId in (" + cmpItems + " ) ").append("and adcount.feffdt <=" + datePoint + " and adcount.fleffdt >=" + datePoint + " ").append("and adminOrgHis.feffdt <=" + datePoint + " and adminOrgHis.fleffdt >=" + datePoint + " ").append("and costBear.FPeriodYear =" + year + " and costBear.FPeriodMonth =" + month + " ").append("group by adcount.fname_" + l + " , adcount.fhistoryrelateid, adcount.fisleaf ");
        return sql.toString();
    }

    public static String getYearSalaryTrend(Context ctx, String cmpItems, String orgId, int year, int month, boolean isCurrYear) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String userId = HRCmpReportUtil.getUserId(ctx);
        String datePoint = HRCmpReportUtil.getDatePoint(year, month);
        if (StringUtils.isEmpty((String)cmpItems)) {
            cmpItems = "''";
        }
        String includeSubSql = null;
        includeSubSql = HRCmpReportUtil.isUserOrgIncludeSub(ctx, userId, orgId, CMP_BRIEF_PERMID) ? " where adcount.fhistoryrelateid = '" + orgId + "'" : " where adminOrgHis.fhistoryrelateid = '" + orgId + "' and adcount.fhistoryrelateid = '" + orgId + "'";
        sql.append("select costBear.FPeriodYear periodYear, costBear.FPeriodMonth periodMonth, sum(case when costBear.FBearMoney is null then 0 else costBear.FBearMoney end) total ").append("from T_ORG_Admin adminOrg ").append("inner join T_ORG_AdminHIS adcount on adminOrg.fid = adcount.fhistoryrelateid ").append("left join T_ORG_AdminHIS adminOrgHis on (charindex(concat(adcount.FLongNumber,'!'),adminOrgHis.FLongNumber) = 1 or adcount.FLongNumber = adminOrgHis.FLongNumber) ").append("inner join ( ").append(HRCmpReportUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(HRCmpReportUtil.getAdminRangeSql(ctx, userId) + " ").append(") orgRange on adcount.fhistoryrelateid = orgRange.forgid ").append("inner join T_HR_SCostBear costBear on adminOrgHis.fhistoryrelateid = costBear.FCostBearOrgUnitID ").append(includeSubSql + " ").append("and costBear.FCmpItemId in (" + cmpItems + " ) ");
        if (isCurrYear) {
            sql.append("and costBear.FPeriodYear = " + year + " and  costBear.FPeriodMonth <= " + month + " ");
        } else {
            sql.append("and costBear.FPeriodYear = " + year + " and  costBear.FPeriodMonth >= " + month + " ");
        }
        sql.append("and adcount.feffdt <=" + datePoint + " and adcount.fleffdt >=" + datePoint + " ").append("and adminOrgHis.feffdt <=" + datePoint + " and adminOrgHis.fleffdt >=" + datePoint + " ").append("group by costBear.FPeriodYear, costBear.FPeriodMonth ").append("order by costBear.FPeriodYear, costBear.FPeriodMonth ");
        return sql.toString();
    }

    public static String getBudgetTrend(Context ctx, String orgId, int year) {
        StringBuffer sql = new StringBuffer();
        sql.append("select FStdValue total, entry.FYear year, entry.FMonth month ").append("from T_HR_SCmpBudgetStd budgetStd ").append("inner join T_HR_SCmpBudgetStdEntry entry on budgetStd.fid = entry.fparentId ").append("where budgetStd.FAdminOrgId = '" + orgId + "' ").append("and budgetStd.FState = 1 ").append("and entry.FYear in ( " + (year - 1) + ", " + year + ") ");
        return sql.toString();
    }

    public static String getSumLaborTotalBySingleMonth(Context ctx, String cmpItems, String orgId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String userId = HRCmpReportUtil.getUserId(ctx);
        int year = HRCmpReportUtil.getCurrYear();
        int month = HRCmpReportUtil.getCurrMonth();
        String datePoint = HRCmpReportUtil.getDatePoint(year, month);
        if (StringUtils.isEmpty((String)cmpItems)) {
            cmpItems = "''";
        }
        String includeSubSql = null;
        includeSubSql = HRCmpReportUtil.isUserOrgIncludeSub(ctx, userId, orgId, CMP_BRIEF_PERMID) ? " where adcount.fhistoryrelateid = '" + orgId + "'" : " where adminOrgHis.fhistoryrelateid = '" + orgId + "' and adcount.fhistoryrelateid = '" + orgId + "'";
        sql.append("select costBear.FPeriodYear periodYear, costBear.FPeriodMonth periodMonth, sum(case when costBear.FBearMoney is null then 0 else costBear.FBearMoney end) total ").append("from T_ORG_Admin adminOrg ").append("inner join T_ORG_AdminHIS adcount on adminOrg.fid = adcount.fhistoryrelateid ").append("left join T_ORG_AdminHIS adminOrgHis on (charindex(concat(adcount.FLongNumber,'!'),adminOrgHis.FLongNumber) = 1 or adcount.FLongNumber = adminOrgHis.FLongNumber) ").append("inner join ( ").append(HRCmpReportUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(HRCmpReportUtil.getAdminRangeSql(ctx, userId) + " ").append(") orgRange on adcount.fhistoryrelateid = orgRange.forgid ").append("inner join T_HR_SCostBear costBear on adminOrgHis.fhistoryrelateid = costBear.FCostBearOrgUnitID ").append(includeSubSql + " ").append("and costBear.FCmpItemId in (" + cmpItems + " ) ").append("and adcount.feffdt <=" + datePoint + " and adcount.fleffdt >=" + datePoint + " ").append("and adminOrgHis.feffdt <=" + datePoint + " and adminOrgHis.fleffdt >=" + datePoint + " ").append("group by costBear.FPeriodYear, costBear.FPeriodMonth ").append("order by costBear.FPeriodYear, costBear.FPeriodMonth ");
        return sql.toString();
    }

    public static String getCompSalaryTrend(Context ctx, String cmpItems, String orgId, int year, int month) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String userId = HRCmpReportUtil.getUserId(ctx);
        String datePoint = HRCmpReportUtil.getDatePoint(year, month);
        if (StringUtils.isEmpty((String)cmpItems)) {
            cmpItems = "''";
        }
        String includeSubSql = null;
        includeSubSql = HRCmpReportUtil.isUserOrgIncludeSub(ctx, userId, orgId, CMP_BRIEF_PERMID) ? " where adcount.fhistoryrelateid = '" + orgId + "'" : " where adminOrgHis.fhistoryrelateid = '" + orgId + "' and adcount.fhistoryrelateid = '" + orgId + "'";
        sql.append("select costBear.FPeriodYear periodYear, costBear.FPeriodMonth periodMonth, sum(case when costBear.FBearMoney is null then 0 else costBear.FBearMoney end) total ").append("from T_ORG_Admin adminOrg ").append("inner join T_ORG_AdminHIS adcount on adminOrg.fid = adcount.fhistoryrelateid ").append("left join T_ORG_AdminHIS adminOrgHis on (charindex(concat(adcount.FLongNumber,'!'),adminOrgHis.FLongNumber) = 1 or adcount.FLongNumber = adminOrgHis.FLongNumber) ").append("inner join ( ").append(HRCmpReportUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(HRCmpReportUtil.getAdminRangeSql(ctx, userId) + " ").append(") orgRange on adcount.fhistoryrelateid = orgRange.forgid ").append("inner join T_HR_SCostBear costBear on adminOrgHis.fhistoryrelateid = costBear.FCostBearOrgUnitID ").append(includeSubSql + " ").append("and costBear.FCmpItemId in (" + cmpItems + " ) ").append("and costBear.FPeriodYear in (" + (year - 2) + ", " + (year - 1) + ", " + year + " ) ").append("and adcount.feffdt <=" + datePoint + " and adcount.fleffdt >=" + datePoint + " ").append("and adminOrgHis.feffdt <=" + datePoint + " and adminOrgHis.fleffdt >=" + datePoint + " ").append("group by costBear.FPeriodYear, costBear.FPeriodMonth ").append("order by costBear.FPeriodYear, costBear.FPeriodMonth ");
        return sql.toString();
    }

    public static String getCurrMonthBudget(String orgId, int year, int month) {
        StringBuffer sql = new StringBuffer();
        sql.append("select FStdValue total ").append("from T_HR_SCmpBudgetStd budgetStd ").append("inner join T_HR_SCmpBudgetStdEntry entry on budgetStd.fid = entry.fparentId ").append("where budgetStd.FAdminOrgId = '" + orgId + "' ").append("and budgetStd.FState = 1 ").append("and entry.FYear = " + year + " ").append("and entry.FMonth = " + month + " ");
        return sql.toString();
    }

    public static String getCmpResignSum(Context ctx, String cmpItems, String tempTable) {
        StringBuffer sql = new StringBuffer();
        if (StringUtils.isEmpty((String)cmpItems)) {
            cmpItems = "''";
        }
        String l = LocaleUtils.getShortCode((Context)ctx);
        sql.append("select reason.fid reasonid, reason.fname_" + l + " reasonname, reason.fnumber reasonnumber, temp.personid personid, totaltbl.total total ").append("from " + tempTable + " temp ").append("inner join t_hr_bddimissionreason reason on reason.fid = temp.reasonid ").append("left join( ").append("select costbear.fpersonid personid, sum(case when costbear.fcostmoney is null then 0 else costbear.fbearmoney end) total ").append("from t_hr_scostbear costbear inner join ( ").append("select distinct fpersonid, fperiodyear, max(fperiodmonth) fperiodmonth from ( ").append("select distinct cost.fpersonid, cost.fperiodmonth, cost.fperiodyear from t_hr_scostbear cost inner join (SELECT fpersonid, max(fperiodYear) FPERIODYEAR  FROM t_hr_scostbear group by fpersonid) maxtbl on maxtbl.FPERIODYEAR = cost.fperiodYear and maxtbl.fpersonid = cost.fpersonid ").append(") maxyeartbl group by fpersonid, fperiodyear) latesttbl ").append("on latesttbl.fpersonid = costbear.fpersonid and latesttbl.fperiodyear = costbear.fperiodyear and latesttbl.fperiodmonth = costbear.fperiodmonth ").append("where costBear.FCmpItemId in (" + cmpItems + " ) ").append("group by costbear.fpersonid) totaltbl ").append("on temp.personid = totaltbl.personid ").append("and reason.fstate = 1 ").append("order by reason.fnumber ");
        return sql.toString();
    }

    public static String getCmpSection(String orgId, String len) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT salConfig.flabel_" + len + ", salConfig.fminValue, salConfig.fmaxValue ").append("from T_HR_SCmpSectionConfig secConfig ").append("left join T_HR_SCmpSalaryConfigField salConfig on secConfig.fid = salConfig.fparentid ").append("where secConfig.fstate = 1 and secConfig.fadminorgid = '" + orgId + "' order by salConfig.FMinValue ");
        return sql.toString();
    }

    public static String getSalaryTrendGroupByYear(Context ctx, String cmpItems, String orgId, int year) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String userId = HRCmpReportUtil.getUserId(ctx);
        String datePoint = HRCmpReportUtil.getDatePoint(year, 12);
        if (StringUtils.isEmpty((String)cmpItems)) {
            cmpItems = "''";
        }
        String includeSubSql = null;
        includeSubSql = HRCmpReportUtil.isUserOrgIncludeSub(ctx, userId, orgId, CMP_BRIEF_PERMID) ? " where adcount.fhistoryrelateid = '" + orgId + "'" : " where adminOrgHis.fhistoryrelateid = '" + orgId + "' and adcount.fhistoryrelateid = '" + orgId + "'";
        sql.append("select costBear.FPeriodYear periodYear, costBear.FPeriodMonth periodMonth, sum(case when costBear.FBearMoney is null then 0 else costBear.FBearMoney end) total ").append("from T_ORG_Admin adminOrg ").append("inner join T_ORG_AdminHIS adcount on adminOrg.fid = adcount.fhistoryrelateid ").append("left join T_ORG_AdminHIS adminOrgHis on (charindex(concat(adcount.FLongNumber,'!'),adminOrgHis.FLongNumber) = 1 or adcount.FLongNumber = adminOrgHis.FLongNumber) ").append("inner join T_Org_LayerType layType on adcount.flayerTypeID = layType.FID ").append("inner join ( ").append(HRCmpReportUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(HRCmpReportUtil.getAdminRangeSql(ctx, userId) + " ").append(") orgRange on adminOrgHis.fhistoryrelateid = orgRange.forgid ").append("inner join T_HR_SCostBear costBear on adminOrgHis.fhistoryrelateid = costBear.FCostBearOrgUnitID ").append(includeSubSql + " ").append("and costBear.FCmpItemId in (" + cmpItems + " ) ").append("and costBear.FPeriodYear in (" + (year - 2) + ", " + (year - 1) + ", " + year + " ) ").append("and adcount.feffdt <=" + datePoint + " and adcount.fleffdt >=" + datePoint + " ").append("and adminOrgHis.feffdt <=" + datePoint + " and adminOrgHis.fleffdt >=" + datePoint + " ").append("and layType.FAdminAffiliationType in ('US3TP3eJJgbgU0A+qMDqhoRbQ4A=', 'US3TP3eIJgbgU0A+qMDqhoRbQ4A=')").append("group by costBear.FPeriodYear, costBear.FPeriodMonth ").append("order by costBear.FPeriodYear, costBear.FPeriodMonth ");
        return sql.toString();
    }

    public static String getPersonCountGroupByYear(Context ctx, String cmpItems, String orgId, int year) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String userId = HRCmpReportUtil.getUserId(ctx);
        String datePoint = HRCmpReportUtil.getDatePoint(year, 12);
        if (StringUtils.isEmpty((String)cmpItems)) {
            cmpItems = "''";
        }
        String includeSubSql = null;
        includeSubSql = HRCmpReportUtil.isUserOrgIncludeSub(ctx, userId, orgId, CMP_BRIEF_PERMID) ? " where adcount.fhistoryrelateid = '" + orgId + "'" : " where adminOrgHis.fhistoryrelateid = '" + orgId + "' and adcount.fhistoryrelateid = '" + orgId + "'";
        sql.append("select costBear.FPeriodYear periodYear, count(distinct costBear.FPersonId) count ").append("from T_ORG_Admin adminOrg ").append("inner join T_ORG_AdminHIS adcount on adminOrg.fid = adcount.fhistoryrelateid ").append("left join T_ORG_AdminHIS adminOrgHis on (charindex(concat(adcount.FLongNumber,'!'),adminOrgHis.FLongNumber) = 1 or adcount.FLongNumber = adminOrgHis.FLongNumber) ").append("inner join T_Org_LayerType layType on adcount.flayerTypeID = layType.FID ").append("inner join ( ").append(HRCmpReportUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(HRCmpReportUtil.getAdminRangeSql(ctx, userId) + " ").append(") orgRange on adcount.fhistoryrelateid = orgRange.forgid ").append("inner join T_HR_SCostBear costBear on adminOrgHis.fhistoryrelateid = costBear.FCostBearOrgUnitID ").append(includeSubSql + " ").append("and costBear.FCmpItemId in (" + cmpItems + " ) ").append("and costBear.FPeriodYear in (" + (year - 2) + ", " + (year - 1) + ", " + year + " ) ").append("and adcount.feffdt <=" + datePoint + " and adcount.fleffdt >=" + datePoint + " ").append("and adminOrgHis.feffdt <=" + datePoint + " and adminOrgHis.fleffdt >=" + datePoint + " ").append("and layType.FAdminAffiliationType in ('US3TP3eJJgbgU0A+qMDqhoRbQ4A=', 'US3TP3eIJgbgU0A+qMDqhoRbQ4A=') ").append("group by costBear.FPeriodYear ").append("order by costBear.FPeriodYear ");
        return sql.toString();
    }

    public static String getSalaryStdTrendGroupByYear(Context ctx, String dimension, String number, int year) {
        StringBuffer sql = new StringBuffer();
        String joinTableSql = "";
        int dim = Integer.parseInt(dimension);
        switch (dim) {
            case 1: {
                joinTableSql = "from T_MGR_CmpCityStandardData cmpData inner join T_HR_City relation on cmpData.FCityID = relation.Fid ";
                break;
            }
            case 2: {
                joinTableSql = "from T_MGR_CmpIndustryStandardData cmpData inner join T_HR_Industry relation on cmpData.FIndustryID = relation.Fid ";
                break;
            }
            case 3: {
                joinTableSql = "from T_MGR_CmpEnterpriseStdData cmpData inner join T_HR_EnterpriseNature relation on cmpData.FEnterpriseNatureID = relation.Fid ";
                break;
            }
        }
        sql.append("select cmpData.FYear periodYear, cmpData.FValue total ").append(joinTableSql).append("where relation.fnumber = '" + number + "' ").append("and cmpData.FYear in (" + (year - 2) + ", " + (year - 1) + ", " + year + ") ").append("order by cmpData.FYear ");
        return sql.toString();
    }

    public static String getSalarySubOrgGroupByYear(Context ctx, String cmpItems, String orgId, int year) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String userId = HRCmpReportUtil.getUserId(ctx);
        String datePoint = HRCmpReportUtil.getDatePoint(year, 12);
        if (StringUtils.isEmpty((String)cmpItems)) {
            cmpItems = "''";
        }
        String l = LocaleUtils.getShortCode((Context)ctx);
        String includeSubSql = null;
        includeSubSql = HRCmpReportUtil.isUserOrgIncludeSub(ctx, userId, orgId, CMP_BRIEF_PERMID) ? " where adcount.fhistoryrelateid = '" + orgId + "'" : " where adminOrgHis.fhistoryrelateid = '" + orgId + "' and adcount.fhistoryrelateid = '" + orgId + "'";
        sql.append("select costBear.FPeriodYear periodYear, costBear.FPeriodMonth periodMonth, adminOrg.fid orgId, adminOrg.fname_" + l + " orgName, sum(case when costBear.FBearMoney is null then 0 else costBear.FBearMoney end) total ").append("from T_ORG_Admin adminOrg ").append("inner join T_ORG_AdminHIS adcount on adminOrg.fid = adcount.fhistoryrelateid ").append("left join T_ORG_AdminHIS adminOrgHis on (charindex(concat(adcount.FLongNumber,'!'), adminOrgHis.FLongNumber) = 1 or adcount.FLongNumber = adminOrgHis.FLongNumber) ").append("inner join T_Org_LayerType layType on adcount.flayerTypeID = layType.FID ").append("inner join ( ").append(HRCmpReportUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(HRCmpReportUtil.getAdminRangeSql(ctx, userId) + " ").append(") orgRange on adcount.fhistoryrelateid = orgRange.forgid ").append("left join T_HR_SCostBear costBear on adminOrgHis.fhistoryrelateid = costBear.FCostBearOrgUnitID ").append(includeSubSql + " ").append("and costBear.FCmpItemId in (" + cmpItems + " ) ").append("and costBear.FPeriodYear in (" + (year - 1) + ", " + year + " ) ").append("and adcount.fparentid = '" + orgId + "' ").append("and adcount.feffdt <=" + datePoint + " and adcount.fleffdt >=" + datePoint + " ").append("and adminOrgHis.feffdt <=" + datePoint + " and adminOrgHis.fleffdt >=" + datePoint + " ").append("and layType.FAdminAffiliationType in ('US3TP3eJJgbgU0A+qMDqhoRbQ4A=', 'US3TP3eIJgbgU0A+qMDqhoRbQ4A=') ").append("group by costBear.FPeriodYear, costBear.FPeriodMonth, adminOrg.fid, adminOrg.fname_" + l + " ").append("order by costBear.FPeriodYear, costBear.FPeriodMonth ");
        return sql.toString();
    }

    public static String getPersonCountSubOrgGroupGroupByYear(Context ctx, String cmpItems, String orgId, int year) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String userId = HRCmpReportUtil.getUserId(ctx);
        String datePoint = HRCmpReportUtil.getDatePoint(year, 12);
        if (StringUtils.isEmpty((String)cmpItems)) {
            cmpItems = "''";
        }
        String includeSubSql = null;
        includeSubSql = HRCmpReportUtil.isUserOrgIncludeSub(ctx, userId, orgId, CMP_BRIEF_PERMID) ? " where adcount.fhistoryrelateid = '" + orgId + "'" : " where adminOrgHis.fhistoryrelateid = '" + orgId + "' and adcount.fhistoryrelateid = '" + orgId + "'";
        String l = LocaleUtils.getShortCode((Context)ctx);
        sql.append("select costBear.FPeriodYear periodYear, adminOrg.fid orgId, count(distinct costBear.FPersonId) count ").append("from T_ORG_Admin adminOrg ").append("inner join T_ORG_AdminHIS adcount on adminOrg.fid = adcount.fhistoryrelateid ").append("left join T_ORG_AdminHIS adminOrgHis on (charindex(concat(adcount.FLongNumber,'!'), adminOrgHis.FLongNumber) = 1 or adcount.FLongNumber = adminOrgHis.FLongNumber) ").append("inner join T_Org_LayerType layType on adcount.flayerTypeID = layType.FID ").append("inner join ( ").append(HRCmpReportUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(HRCmpReportUtil.getAdminRangeSql(ctx, userId) + " ").append(") orgRange on adcount.fhistoryrelateid = orgRange.forgid ").append("left join T_HR_SCostBear costBear on adminOrgHis.fhistoryrelateid = costBear.FCostBearOrgUnitID ").append(includeSubSql + " ").append("and costBear.FCmpItemId in (" + cmpItems + " ) ").append("and costBear.FPeriodYear in (" + (year - 1) + ", " + year + " ) ").append("and adcount.fparentid = '" + orgId + "' ").append("and adcount.feffdt <=" + datePoint + " and adcount.fleffdt >=" + datePoint + " ").append("and adminOrgHis.feffdt <=" + datePoint + " and adminOrgHis.fleffdt >=" + datePoint + " ").append("and layType.FAdminAffiliationType in ('US3TP3eJJgbgU0A+qMDqhoRbQ4A=', 'US3TP3eIJgbgU0A+qMDqhoRbQ4A=') ").append("group by costBear.FPeriodYear, costBear.FPeriodMonth, adminOrg.fid, adminOrg.fname_" + l + " ").append("order by costBear.FPeriodYear, costBear.FPeriodMonth ");
        return sql.toString();
    }

    public static String getAverageSalaryByOrgId(Context ctx, String orgId, String cmpItems, int year) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String userId = HRCmpReportUtil.getUserId(ctx);
        String datePoint = HRCmpReportUtil.getDatePoint(year, 12);
        if (StringUtils.isEmpty((String)cmpItems)) {
            cmpItems = "''";
        }
        String includeSubSql = null;
        includeSubSql = HRCmpReportUtil.isUserOrgIncludeSub(ctx, userId, orgId, CMP_BRIEF_PERMID) ? " where adcount.fhistoryrelateid = '" + orgId + "'" : " where adminOrgHis.fhistoryrelateid = '" + orgId + "' and adcount.fhistoryrelateid = '" + orgId + "'";
        sql.append("select costBear.FPeriodYear periodYear, costBear.FPeriodMonth periodMonth, sum(case when costBear.FBearMoney is null then 0 else costBear.FBearMoney end) total ").append("from T_ORG_Admin adminOrg ").append("inner join T_ORG_AdminHIS adcount on adminOrg.fid = adcount.fhistoryrelateid ").append("left join T_ORG_AdminHIS adminOrgHis on (charindex(concat(adcount.FLongNumber,'!'),adminOrgHis.FLongNumber) = 1 or adcount.FLongNumber = adminOrgHis.FLongNumber) ").append("inner join T_Org_LayerType layType on adcount.flayerTypeID = layType.FID ").append("inner join ( ").append(HRCmpReportUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(HRCmpReportUtil.getAdminRangeSql(ctx, userId) + " ").append(") orgRange on adcount.fhistoryrelateid = orgRange.forgid ").append("inner join T_HR_SCostBear costBear on adminOrgHis.fhistoryrelateid = costBear.FCostBearOrgUnitID ").append(includeSubSql + " ").append("and costBear.FCmpItemId in (" + cmpItems + " ) ").append("and costBear.FPeriodYear in (" + year + " ) ").append("and adcount.feffdt <=" + datePoint + " and adcount.fleffdt >=" + datePoint + " ").append("and adminOrgHis.feffdt <=" + datePoint + " and adminOrgHis.fleffdt >=" + datePoint + " ").append("and layType.FAdminAffiliationType in ('US3TP3eJJgbgU0A+qMDqhoRbQ4A=', 'US3TP3eIJgbgU0A+qMDqhoRbQ4A=') ").append("group by costBear.FPeriodYear, costBear.FPeriodMonth ").append("order by costBear.FPeriodYear, costBear.FPeriodMonth ");
        return sql.toString();
    }

    public static String getAveragePersonCountOrgId(Context ctx, String cmpItems, String orgId, int year) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String userId = HRCmpReportUtil.getUserId(ctx);
        String datePoint = HRCmpReportUtil.getDatePoint(year, 12);
        if (StringUtils.isEmpty((String)cmpItems)) {
            cmpItems = "''";
        }
        String includeSubSql = null;
        includeSubSql = HRCmpReportUtil.isUserOrgIncludeSub(ctx, userId, orgId, CMP_BRIEF_PERMID) ? " where adcount.fhistoryrelateid = '" + orgId + "'" : " where adminOrgHis.fhistoryrelateid = '" + orgId + "' and adcount.fhistoryrelateid = '" + orgId + "'";
        sql.append("select costBear.FPeriodYear periodYear, count(distinct costBear.FPersonId) count ").append("from T_ORG_Admin adminOrg ").append("inner join T_ORG_AdminHIS adcount on adminOrg.fid = adcount.fhistoryrelateid ").append("left join T_ORG_AdminHIS adminOrgHis on (charindex(concat(adcount.FLongNumber,'!'),adminOrgHis.FLongNumber) = 1 or adcount.FLongNumber = adminOrgHis.FLongNumber) ").append("inner join T_Org_LayerType layType on adcount.flayerTypeID = layType.FID ").append("inner join ( ").append(HRCmpReportUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(HRCmpReportUtil.getAdminRangeSql(ctx, userId) + " ").append(") orgRange on adcount.fhistoryrelateid = orgRange.forgid ").append("inner join T_HR_SCostBear costBear on adminOrgHis.fhistoryrelateid = costBear.FCostBearOrgUnitID ").append(includeSubSql + " ").append("and costBear.FCmpItemId in (" + cmpItems + " ) ").append("and costBear.FPeriodYear in (" + year + " ) ").append("and adcount.feffdt <=" + datePoint + " and adcount.fleffdt >=" + datePoint + " ").append("and adminOrgHis.feffdt <=" + datePoint + " and adminOrgHis.fleffdt >=" + datePoint + " ").append("and layType.FAdminAffiliationType in ('US3TP3eJJgbgU0A+qMDqhoRbQ4A=', 'US3TP3eIJgbgU0A+qMDqhoRbQ4A=') ").append("group by costBear.FPeriodYear ").append("order by costBear.FPeriodYear ");
        return sql.toString();
    }

    public static String getCityAverageSalary(String orgId) {
        StringBuffer sql = new StringBuffer();
        sql.append("select sum(cmpData.FValue) total ").append("from T_ORG_Admin adminOrg ").append("inner join T_Org_LayerType layType on adminOrg.flayerTypeID = layType.FID ").append("inner join T_HR_SHRAdminOrgUnitExtend pro on adminOrg.fid = pro.FAdminOrgUnitID ").append("inner join T_MGR_CmpCityStandardData cmpData on cmpData.FCityID = pro.FCityID ").append("where cmpData.FYear = (select max(FYear) from T_MGR_CmpCityStandardData) and adminOrg.Fid = '" + orgId + "' ").append("and layType.FAdminAffiliationType in ('US3TP3eJJgbgU0A+qMDqhoRbQ4A=', 'US3TP3eIJgbgU0A+qMDqhoRbQ4A=')");
        return sql.toString();
    }

    public static String getIndustryAverageSalary(String orgId) {
        StringBuffer sql = new StringBuffer();
        sql.append("select sum(cmpData.FValue) total ").append("from T_ORG_Admin adminOrg ").append("inner join T_Org_LayerType layType on adminOrg.flayerTypeID = layType.FID ").append("inner join T_HR_SHRAdminOrgUnitExtend pro on adminOrg.fid = pro.FAdminOrgUnitID ").append("inner join T_MGR_CmpIndustryStandardData cmpData on cmpData.FIndustryID =  pro.FHRIndustryID ").append("where cmpData.FYear = (select max(FYear) from T_MGR_CmpIndustryStandardData) and adminOrg.Fid = '" + orgId + "' ").append("and layType.FAdminAffiliationType in ('US3TP3eJJgbgU0A+qMDqhoRbQ4A=', 'US3TP3eIJgbgU0A+qMDqhoRbQ4A=')");
        return sql.toString();
    }

    public static String getEnterpriseNatureAverageSalary(String orgId) {
        StringBuffer sql = new StringBuffer();
        sql.append("select sum(cmpData.FValue) total ").append("from T_ORG_Admin adminOrg ").append("inner join T_Org_LayerType layType on adminOrg.flayerTypeID = layType.FID ").append("inner join T_HR_SHRAdminOrgUnitExtend pro on adminOrg.fid = pro.FAdminOrgUnitID ").append("inner join T_MGR_CmpEnterpriseStdData cmpData on cmpData.FEnterpriseNatureID = pro.FEnterpriseNatureID ").append("where cmpData.FYear = (select max(FYear) from T_MGR_CmpEnterpriseStdData) and adminOrg.Fid = '" + orgId + "' ").append("and layType.FAdminAffiliationType in ('US3TP3eJJgbgU0A+qMDqhoRbQ4A=', 'US3TP3eIJgbgU0A+qMDqhoRbQ4A=')");
        return sql.toString();
    }

    public static Map<String, Object> getCmpLaborItems(Context ctx) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        StringBuffer sql = new StringBuffer();
        String l = LocaleUtils.getShortCode((Context)ctx);
        sql.append("select cmpItem.fid cmpItemId, laborCostType.fname_" + l + " name, laborCostType.fid id from T_HR_SCmpItem cmpItem inner join T_HR_SLaborCostType laborCostType on cmpItem.FLaborCostTypeID = laborCostType.fid ").append("where laborCostType.fstate = 1 and cmpItem.fstate = 1 and cmpItem.FDataType = 0 ").append("and exists(select 1 from T_HR_SCostBear costBear where cmpItem.FID = costBear.FCmpItemID) ");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                HashMap<String, String> mapItem = new HashMap<String, String>();
                String name = rowSet.getString("name");
                String id = rowSet.getString("id");
                String cmpItemId = rowSet.getString("cmpItemId");
                mapItem.put("name", name);
                mapItem.put("id", id);
                map.put(cmpItemId, mapItem);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return map;
    }

    public static String getPersonPositionResponseAdminSql(String userId) {
        StringBuffer sql = new StringBuffer("select adminOrg.fid as forgId").append(" from T_HR_EmpOrgRelation emprelation").append(" inner join T_PM_User pmuser on pmuser.fpersonid = emprelation.fpersonid").append(" inner join T_ORG_Position position on position.fid= emprelation.fpositionid").append(" inner join T_ORG_Admin adcount on position.fadminorgunitid = adcount.fid").append(" left join T_ORG_Admin adminOrg on (charindex(concat(adcount.flongnumber,'!'),adminOrg.flongnumber) = 1 or adcount.flongnumber = adminOrg.flongnumber)").append(" where pmuser.fid = '").append(userId).append("'").append(" and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and position.fisrespposition = 1").append(" and adminOrg.fissealup = 0").append(" and adminOrg.fisstartshr = 1");
        return sql.toString();
    }

    public static String getAdminRangeSql(Context ctx, String userId) {
        StringBuffer sql = new StringBuffer("select adminOrg.fid as forgId").append(" from t_org_admin adminOrg").append(" where fid in (").append(SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)"fffffff0-ffff-efff-f2bd-0000000f4a22PERMITEM") + ")").append(" and fid in (").append(SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)"fffffff0-ffff-efff-f2bd-0000000f4a24PERMITEM") + ")").append(" and fid in (").append(SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)"fffffff0-ffff-efff-f2bd-0000000f4a26PERMITEM") + ")").append(" and fid in (").append(SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)"fffffff0-ffff-efff-f2bd-0000000f4a28PERMITEM") + ")");
        return sql.toString();
    }

    public static String getMobileAdminRangeSql(Context ctx, String userId, String permItemId) {
        StringBuffer sql = new StringBuffer();
        boolean isLeader = HRCmpReportUtil.getUserIsLeader(ctx, userId);
        if (isLeader) {
            String adminOrgRangeSql = SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)permItemId);
            sql.append("select adminRange.FAdminOrgID as forgId from (");
            sql.append(adminOrgRangeSql);
            sql.append(") adminRange");
        } else {
            sql.append("select null as forgId");
        }
        return sql.toString();
    }

    public static boolean getUserIsLeader(Context ctx, String userId) {
        boolean isLeader = false;
        String leaderSql = "select * from t_hr_personpositionextend where fpersonid in (select fpersonid from t_pm_user where fid ='" + userId + "') and fisleader=1";
        try {
            IRowSet isLeaderRowSet = DbUtil.executeQuery((Context)ctx, (String)leaderSql);
            isLeader = isLeaderRowSet.size() > 0;
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return isLeader;
    }

    public static String getCmpSalaryMaxPeriodYear(Context ctx) {
        String userId = HRCmpReportUtil.getUserId(ctx);
        StringBuffer sql = new StringBuffer("select max(FPeriodYear) periodYear ").append(" from T_HR_SCmpCalTable cmp").append(" inner join T_BD_Person person on person.Fid = cmp.FPersonid ").append(" inner join T_PM_User usr on usr.FPersonid = person.Fid ").append(" where usr.Fid = '" + userId + "' ").append(" and cmp.FCalstate >= 12 ");
        return sql.toString();
    }

    public static String getCmpSalaryMaxPeriodMonthByPeriodYear(Context ctx, int periodYear) {
        String userId = HRCmpReportUtil.getUserId(ctx);
        StringBuffer sql = new StringBuffer("select max(FPeriodMonth) periodMonth ").append(" from T_HR_SCmpCalTable cmp").append(" inner join T_BD_Person person on person.Fid = cmp.FPersonid ").append(" inner join T_PM_User usr on usr.FPersonid = person.Fid ").append(" where usr.Fid = '" + userId + "' ").append(" and cmp.FPeriodYear = " + periodYear + " ").append(" and cmp.FCalstate >= 12 ");
        return sql.toString();
    }

    public static String getCmpItemDataByPeriodYear(Context ctx, int periodYear, Map<String, Object> cmpItemMap, List<String> fieldSnLabels) {
        String userId = HRCmpReportUtil.getUserId(ctx);
        StringBuffer sql = new StringBuffer("select ");
        for (Map.Entry<String, Object> entry : cmpItemMap.entrySet()) {
            String fieldSn = entry.getKey();
            fieldSnLabels.add(fieldSn);
            sql.append("sum(case when " + fieldSn + " is null then 0 else " + fieldSn + " end) " + fieldSn + ", ");
        }
        sql.append(" FPeriodYear periodYear, FPeriodMonth periodMonth ").append(" from T_HR_SCmpCalTable cmpCalTable ").append(" inner join T_BD_Person person on person.Fid = cmpCalTable.FPersonid ").append(" inner join T_PM_User usr on usr.FPersonid = person.Fid ").append(" where usr.Fid = '" + userId + "' ").append(" and FPeriodYear in (" + periodYear + ", " + (periodYear - 1) + ") ").append(" and cmpCalTable.FCalstate in (12, 20) ").append(" group by FPeriodYear, FPeriodMonth  ");
        return sql.toString();
    }

    public static String getCmpItemWitchDataTypeIsNumber(Context ctx, int periodYear, int periodMonth) {
        String userId = HRCmpReportUtil.getUserId(ctx);
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuffer sql = new StringBuffer("select cmpItem.FieldSn fieldSn, cmpItem.FName_" + l + " name ").append(" from T_HR_SCmpCalTable cmpCalTable ").append(" inner join T_BD_Person person on person.Fid = cmpCalTable.FPersonid ").append(" inner join T_PM_User usr on usr.FPersonid = person.Fid ").append(" inner join T_HR_SCalScheme calScheme on  cmpCalTable.FCalSchemeId  = calScheme.fid ").append(" inner join T_HR_SCalSchemeItem calSchemeItem on calScheme.Fid = calSchemeItem.FCalSchemeID ").append(" inner join T_HR_SCmpItem cmpItem on cmpItem.Fid = calSchemeItem.FCmpItemID ").append(" where usr.Fid = '" + userId + "' ").append(" and cmpItem.FDataType = 0 ").append(" and cmpItem.FState = 1 ").append(" and cmpCalTable.FPeriodYear = " + periodYear + " and cmpCalTable.FPeriodMonth = " + periodMonth + " ").append(" and calSchemeItem.FIsPayTotal = 1 ").append(" and cmpCalTable.FCalState in (12, 20) ");
        return sql.toString();
    }

    public static String queryTokenSQL() {
        return "select FAccessToken token from T_CDS_CloudServiceConfig";
    }

    private static String getDatePoint(int year, int month) {
        String datePoint = "{ ts '" + dateFmt_yyyy_MM_dd.format(new Date()) + "'}";
        Calendar cal = Calendar.getInstance();
        String dateStr = year + "-" + month + "-01";
        try {
            cal.setTime(dateFmt_yyyy_MM_dd.parse(dateStr));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        cal.roll(5, -1);
        datePoint = "{ ts '" + dateFmt_yyyy_MM_dd.format(cal.getTime()) + "'}";
        return datePoint;
    }

    public static int getYearViaPeriod(String period) {
        int year = 1900;
        if (StringUtils.isEmpty((String)period)) {
            Date now = new Date();
            year = Integer.parseInt(dateFmt_yyyyMM.format(now).substring(0, 4));
        } else {
            year = Integer.parseInt(period.substring(0, 4));
        }
        return year;
    }

    public static int getMonthViaPeriod(String period) {
        int month = 1;
        if (StringUtils.isEmpty((String)period)) {
            Date now = new Date();
            month = Integer.parseInt(dateFmt_yyyyMM.format(now).substring(4, 6));
        } else {
            month = Integer.parseInt(period.substring(4, 6));
        }
        return month;
    }

    public static String rate(double d1, double d2) {
        if (d2 != 0.0) {
            BigDecimal b1 = new BigDecimal(d1);
            BigDecimal b2 = new BigDecimal(d2);
            double result = b1.divide(b2, 4, 4).doubleValue();
            return HRCmpReportUtil.round(HRCmpReportUtil.mul(result, 100.0), 2) + "%";
        }
        return "0%";
    }

    public static void getPercent(List<Map<String, Object>> list, double sumTotal) {
        double wholePercent = 100.0;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Map<String, Object> map = list.get(i);
            if (i == size - 1) {
                map.put("percent", HRCmpReportUtil.formatDouble(wholePercent) + "%");
                continue;
            }
            double total = (Double)map.get("total");
            String percent = HRCmpReportUtil.rate(total, sumTotal);
            wholePercent -= Double.valueOf(percent.substring(0, percent.length() - 1)).doubleValue();
            map.put("percent", percent);
        }
    }

    public static double mul(double d1, double d2) {
        BigDecimal b1 = new BigDecimal(d1);
        BigDecimal b2 = new BigDecimal(d2);
        return b1.multiply(b2).doubleValue();
    }

    public static double round(double d, int len) {
        if (len != 0) {
            BigDecimal b1 = new BigDecimal(d);
            BigDecimal b2 = new BigDecimal(1);
            return b1.divide(b2, len, 4).doubleValue();
        }
        return 0.0;
    }

    public static String getUserId(Context ctx) {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userId = userInfo != null ? userInfo.getId().toString() : (String)ctx.get((Object)"userID");
        return userId;
    }

    public static int getCurrYear() {
        int year = 1900;
        Calendar cal = Calendar.getInstance();
        year = cal.get(1);
        return year;
    }

    public static int getCurrMonth() {
        int month = 1;
        Calendar cal = Calendar.getInstance();
        month = cal.get(2) + 1;
        return month;
    }

    public static List<String> getDefPeriodLabel(int year, int month, int n) {
        ArrayList<String> labelList = new ArrayList<String>();
        Calendar cal = Calendar.getInstance();
        try {
            Date date = dateFmt_yyyy_M.parse(year + "-" + month);
            cal.setTime(date);
            cal.add(2, -n);
            for (int i = 0; i < 6; ++i) {
                cal.add(2, 1);
                String label = dateFmt_yyyy_M.format(cal.getTime());
                labelList.add(label);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return labelList;
    }

    public static Double calPercent(Double val1, Double val2) {
        double percent = 0.0;
        if (val2 != 0.0) {
            percent = Math.round((val1 - val2) / val2 * 100.0);
        }
        return percent;
    }

    public static double formatDouble(double value) {
        DecimalFormat df = new DecimalFormat("#.##");
        return Double.valueOf(df.format(value));
    }

    public static void handleTrendList(int year, int month, List<String> labelList, List<Double> dataList, Map<String, Object> data) {
        List<String> defPeriodLabelList = HRCmpReportUtil.getDefPeriodLabel(year, month, 6);
        for (int i = 0; i < defPeriodLabelList.size(); ++i) {
            String label = defPeriodLabelList.get(i);
            labelList.add(label);
            if (data.containsKey(label)) {
                dataList.add(Double.valueOf(data.get(label).toString()));
                continue;
            }
            dataList.add(0.0);
        }
    }

    public static void handleTrendListOnlyYear(int year, List<String> labelList, List<Double> dataList, Map<String, Object> data) {
        ArrayList<String> defPeriodLabelList = new ArrayList<String>();
        defPeriodLabelList.add(year - 2 + "");
        defPeriodLabelList.add(year - 1 + "");
        defPeriodLabelList.add(year + "");
        for (int i = 0; i < defPeriodLabelList.size(); ++i) {
            String label = (String)defPeriodLabelList.get(i);
            labelList.add(label);
            if (data.containsKey(label)) {
                dataList.add(Double.valueOf(data.get(label).toString()));
                continue;
            }
            dataList.add(0.0);
        }
    }

    public static String getRegisterInfo(Context ctx) throws EASBizException, BOSException {
        HashMap param = new HashMap();
        Map result = (Map)OSFAppUtil.callService((Context)ctx, (String)"getSHRCloudAccessTokenService", param);
        String token = "";
        if (result != null) {
            token = (String)result.get("accessToken");
        }
        return token;
    }

    public static boolean isEnterprise(Context ctx, String orgId) throws BOSException {
        boolean result = false;
        String sql = "select adminOrg.fid from T_ORG_Admin adminOrg inner join T_Org_LayerType layType on adminOrg.flayerTypeID = layType.FID where layType.FAdminAffiliationType in ('US3TP3eJJgbgU0A+qMDqhoRbQ4A=', 'US3TP3eIJgbgU0A+qMDqhoRbQ4A=') and adminOrg.fid = '" + orgId + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rowSet.next()) {
                result = true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getNatureInfo(Context ctx, String orgId) throws BOSException {
        StringBuffer queryBuf = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        sql.append("select pro.FCityID cityId, pro.FHRIndustryID industryId, pro.FEnterpriseNatureID enterpriseNatureId").append(" from T_ORG_Admin adminOrg").append(" inner join T_Org_LayerType layType on adminOrg.flayerTypeID = layType.FID").append(" inner join T_HR_SHRAdminOrgUnitExtend pro on adminOrg.fid = pro.FAdminOrgUnitID").append(" where adminOrg.Fid = '" + orgId + "'").append(" and layType.FAdminAffiliationType in ('US3TP3eJJgbgU0A+qMDqhoRbQ4A=', 'US3TP3eIJgbgU0A+qMDqhoRbQ4A=')");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            String cityId = "";
            String industryId = "";
            String enterpriseNatureId = "";
            if (rowSet.next()) {
                cityId = rowSet.getString("cityId");
                industryId = rowSet.getString("industryId");
                enterpriseNatureId = rowSet.getString("enterpriseNatureId");
            }
            queryBuf.append("cityId=" + cityId + "&industryId=" + industryId + "&enterpriseNatureId=" + enterpriseNatureId);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return queryBuf.toString();
    }

    public static String getResponseAdminOrg(Context ctx, String userId) throws BOSException {
        String fid = "";
        StringBuffer sql = new StringBuffer("select adminOrg.fid").append(" from T_HR_EmpOrgRelation emprelation").append(" inner join T_PM_User pmuser on pmuser.fpersonid = emprelation.fpersonid").append(" inner join T_ORG_Position position on position.fid = emprelation.fpositionid").append(" inner join T_ORG_Admin adminOrg on position.fadminorgunitid = adminOrg.fid").append(" where pmuser.fid = '").append(userId).append("'").append(" and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and position.fisrespposition=1").append(" order by adminOrg.flongnumber asc");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rowSet.next()) {
                fid = rowSet.getString("fid");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return fid;
    }

    public static boolean isUserOrgIncludeSub(Context ctx, String userId, String orgId, String permItemId) throws BOSException {
        String tempSql;
        IRowSet tempRowSet;
        List<String> permIdList = HRCmpReportUtil.getMangaerPermList(ctx, userId);
        StringBuffer responseSql = new StringBuffer("select adminOrg.fid as forgId").append(" from T_HR_EmpOrgRelation emprelation").append(" inner join T_PM_User pmuser on pmuser.fpersonid = emprelation.fpersonid").append(" inner join T_ORG_Position position on position.fid= emprelation.fpositionid").append(" inner join T_ORG_Admin adcount on position.fadminorgunitid = adcount.fid").append(" left join T_ORG_Admin adminOrg on (charindex(concat(adcount.flongnumber,'!'),adminOrg.flongnumber) = 1 or adcount.flongnumber = adminOrg.flongnumber)").append(" where pmuser.fid = '").append(userId).append("'").append(" and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and emprelation.FIsLatestInAday = 1").append(" and position.fisrespposition = 1").append(" and adminOrg.fissealup = 0").append(" and adminOrg.fisstartshr = 1").append(" and adminOrg.fid = '").append(orgId).append("'");
        IRowSet responseAdmin = DbUtil.executeQuery((Context)ctx, (String)responseSql.toString());
        if (responseAdmin.size() > 0) {
            return true;
        }
        StringBuffer hrAdminNotIncludeSubSql = new StringBuffer();
        hrAdminNotIncludeSubSql.append(" select adminOrg.fid as forgId FROM T_HR_SHRUserAdminOrgPerm adminorgperm ");
        hrAdminNotIncludeSubSql.append(" inner join T_ORG_Admin adminOrg on adminorgperm.fadminorgid = adminOrg.fid ");
        hrAdminNotIncludeSubSql.append(" inner join T_PM_User as pmuser on pmuser.fid = adminorgperm.fuserid ");
        hrAdminNotIncludeSubSql.append(" inner join T_HR_PersonPositionExtend as pp on pp.fpersonid = pmuser.fpersonid ");
        hrAdminNotIncludeSubSql.append(" where adminorgperm.fuserid = '").append(userId).append("'");
        hrAdminNotIncludeSubSql.append(" and pp.fisleader = 1 and adminOrg.fissealup = 0  and adminOrg.fisstartshr = 1 ");
        hrAdminNotIncludeSubSql.append(" and adminorgperm.fpermitemid in ").append(HRUtilExtend.getStrFromList(permIdList)).append("  and adminorgperm.FIsIncludeSubOrg = 0 ");
        hrAdminNotIncludeSubSql.append(" union ");
        hrAdminNotIncludeSubSql.append(" SELECT adminorgperm.FAdminOrgID as forgId FROM T_HR_SHRRoleAdminOrgPerm adminorgperm ");
        hrAdminNotIncludeSubSql.append(" inner join T_ORG_Admin adminOrg on adminorgperm.fadminorgid = adminOrg.fid ");
        hrAdminNotIncludeSubSql.append(" inner join T_PM_RolePerm role on role.FROLEID = adminorgperm.FRoleID ");
        hrAdminNotIncludeSubSql.append(" inner join T_PM_User as pmuser on pmuser.fid = adminorgperm.fuserid ");
        hrAdminNotIncludeSubSql.append(" inner join T_HR_PersonPositionExtend as pp on pp.fpersonid = pmuser.fpersonid ");
        hrAdminNotIncludeSubSql.append(" where adminorgperm.FUserId = '").append(userId).append("'");
        hrAdminNotIncludeSubSql.append(" and pp.fisleader = 1 and adminOrg.fissealup = 0  and adminOrg.fisstartshr = 1 ");
        hrAdminNotIncludeSubSql.append(" and role.fpermitemid in ").append(HRUtilExtend.getStrFromList(permIdList)).append("  and adminorgperm.FIsIncludeSubOrg = 0 and adminorgperm.FIsForbidden = 0 ");
        hrAdminNotIncludeSubSql.append(" and exists(SELECT 1 FROM T_PM_UserRoleOrg t1 where t1.FROLEID = adminorgperm.FRoleID and t1.FUserId = '").append(userId).append("') ");
        StringBuffer easAdminNotIncludeSubSql = new StringBuffer().append(" select adminOrg.fid as forgId").append(" from T_PM_OrgRangeIncludeSubOrg orgRange").append(" inner join T_ORG_Admin adminOrg on orgRange.forgid = adminOrg.fid").append(" inner join T_PM_User as pmuser on pmuser.fid = orgRange.fuserid").append(" inner join T_HR_PersonPositionExtend as pp on pp.fpersonid = pmuser.fpersonid").append(" where orgRange.fuserid = '").append(userId).append("' and orgRange.ftype = 20").append(" and pp.fisleader = 1").append(" and adminOrg.fissealup = 0").append(" and adminOrg.fisstartshr = 1").append(" and orgRange.FIsIncludeSubOrg = 0");
        if (permIdList.size() == 0 ? (tempRowSet = DbUtil.executeQuery((Context)ctx, (String)(tempSql = "select * from t_org_admin where ( fid in (" + easAdminNotIncludeSubSql + ")) and fid ='" + orgId + "'"))).size() > 0 : permIdList.size() == 1 && (tempRowSet = DbUtil.executeQuery((Context)ctx, (String)(tempSql = "select * from t_org_admin where ( fid in (" + hrAdminNotIncludeSubSql + ")) and fid ='" + orgId + "'"))).size() > 0) {
            return false;
        }
        tempSql = HRCmpReportUtil.getAdminRangeSql(ctx, userId, permItemId) + " and fid = '" + orgId + "'";
        tempRowSet = DbUtil.executeQuery((Context)ctx, (String)tempSql);
        return tempRowSet.size() > 0;
    }

    public static List<String> getMangaerPermList(Context ctx, String userId) {
        ArrayList<String> resultList = new ArrayList<String>();
        ArrayList<String> permIdsList = new ArrayList<String>();
        permIdsList.add(CMP_BRIEF_PERMID);
        String permItemIds = HRUtilExtend.getStrFromList(permIdsList);
        StringBuilder sqlStr = new StringBuilder();
        sqlStr.append(" SELECT FPERMITEMID FROM T_HR_SHRUSERADMINORGPERM WHERE FUSERID = '").append(userId).append("' ");
        sqlStr.append(" AND FPERMITEMID IN ").append(permItemIds);
        sqlStr.append(" GROUP BY FPERMITEMID ");
        sqlStr.append(" UNION ");
        sqlStr.append(" SELECT ROLE.FPERMITEMID ");
        sqlStr.append(" FROM T_HR_SHRROLEADMINORGPERM ADMINORGPERM ");
        sqlStr.append(" INNER JOIN T_PM_ROLEPERM ROLE ON ROLE.FROLEID = ADMINORGPERM.FROLEID ");
        sqlStr.append(" WHERE ADMINORGPERM.FUSERID = '").append(userId).append("' ");
        sqlStr.append(" AND ROLE.FPERMITEMID IN ").append(permItemIds);
        sqlStr.append(" AND EXISTS(SELECT 1 FROM T_PM_USERROLEORG T1 WHERE T1.FROLEID = ADMINORGPERM.FROLEID AND T1.FUSERID = '" + userId + "') ");
        sqlStr.append(" GROUP BY ROLE.FPERMITEMID ");
        try {
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStr.toString());
            while (iRowSet.next()) {
                resultList.add(iRowSet.getString("fpermitemid"));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return resultList;
    }

    public static String getAdminRangeSql(Context ctx, String userId, String permItemId) {
        StringBuffer sql = new StringBuffer("select adminOrg.fid as forgId").append(" from t_org_admin adminOrg").append(" where fid in (").append(SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)permItemId) + ")");
        return sql.toString();
    }

    public static String getCmpItemsInvolvedLaborCost(Context ctx, String classify, Boolean isAnalysisApp) {
        StringBuffer cmpItemBuffer = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        sql.append("select cmpItem.Fid fid from T_HR_SCmpItem cmpItem inner join T_HR_SLaborCostType laborCostType on cmpItem.FLaborCostTypeID = laborCostType.fid ").append("where laborCostType.fstate = 1 and cmpItem.fstate = 1 and cmpItem.FDataType = 0 ").append("and exists(select 1 from T_HR_SCostBear costBear where cmpItem.FID = costBear.FCmpItemID) ");
        if (!StringUtil.isEmpty((String)classify)) {
            sql.append(" and laborCostType.fid = '" + classify + "' ");
        }
        if (isAnalysisApp.booleanValue()) {
            sql.append(" and cmpItem.FIsAnalysisApp = 1");
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                String cmpItemId = rowSet.getString("fid");
                cmpItemBuffer.append("'" + cmpItemId + "', ");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return cmpItemBuffer.toString().length() > 0 ? cmpItemBuffer.toString().substring(0, cmpItemBuffer.toString().length() - 2) : "";
    }
}

