/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util.filter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.FilterUtil;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.CmpPermCollection;
import com.kingdee.shr.compensation.CmpPermFactory;
import com.kingdee.shr.compensation.CmpPermInfo;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.filter.CmpSchemeFilter;
import com.kingdee.util.StringUtils;
import java.util.HashMap;

public abstract class CmpPermFilter {
    public static String getPermSQL(Context ctx, String scheme, String permItemId, boolean historyMode) {
        StringBuilder sb = new StringBuilder();
        FilterInfo filterInfo = CmpPermFilter.getPermFilter(ctx, scheme, permItemId);
        if (CmpStrUtil.isEmpty(filterInfo.toString())) {
            return sb.toString();
        }
        SqlParam sqlParam = new SqlParam();
        HashMap<String, String> selectMapping = new HashMap<String, String>();
        if ("002".equals(scheme)) {
            selectMapping.put("cmp_person.id", "person.id");
        } else if ("006".equals(scheme)) {
            selectMapping.put("person.id", "person.id");
        } else if ("008".equals(scheme)) {
            selectMapping.put("person.id", "person.id");
        } else {
            selectMapping.put("person.id", "person.id");
        }
        sqlParam.setSelectMapping(selectMapping);
        sqlParam.setFilterInfo(filterInfo);
        sqlParam.setScheme(scheme);
        sqlParam.setNewSearch(true);
        sqlParam.setHistoryMode(historyMode);
        try {
            sb.append("select * from(");
            String sql = FilterUtil.getSql((Context)ctx, (SqlParam)sqlParam);
            sb.append(sql);
            sb.append(") personTemp");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static String getPermSQLByHRO(Context ctx, String scheme, String hrOrgId, String otherFilter, boolean historyMode) {
        StringBuilder sb = new StringBuilder();
        FilterInfo filterInfo = CmpPermFilter.getPermFilterByHRO(ctx, scheme, hrOrgId, historyMode);
        if (CmpStrUtil.isEmpty(filterInfo.toString())) {
            return sb.toString();
        }
        SqlParam sqlParam = new SqlParam();
        HashMap<String, String> selectMapping = new HashMap<String, String>();
        String hrOrgField = "cal_hrOrgUnit.id";
        if ("002".equals(scheme)) {
            selectMapping.put("cmp_person.id", "person.id");
            hrOrgField = "cal_hrOrgUnit.id";
        } else if ("006".equals(scheme)) {
            selectMapping.put("person.id", "person.id");
            hrOrgField = "cmpHROrgUnit.id";
        } else if ("008".equals(scheme)) {
            selectMapping.put("person.id", "person.id");
        } else {
            selectMapping.put("person.id", "person.id");
            hrOrgField = "soc_hrOrg.id";
        }
        try {
            filterInfo.mergeFilter(new FilterInfo(hrOrgField + " = '" + hrOrgId + "'"), "AND");
            if (!CmpStrUtil.isEmpty(otherFilter)) {
                FilterInfo otherFilterInfo = new FilterInfo(otherFilter);
                filterInfo.mergeFilter(otherFilterInfo, "AND");
            }
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        catch (ParserException e1) {
            e1.printStackTrace();
        }
        sqlParam.setSelectMapping(selectMapping);
        sqlParam.setFilterInfo(filterInfo);
        sqlParam.setScheme(scheme);
        sqlParam.setNewSearch(true);
        sqlParam.setHistoryMode(historyMode);
        try {
            sb.append("select * from(");
            String sql = FilterUtil.getSql((Context)ctx, (SqlParam)sqlParam);
            sb.append(sql);
            sb.append(") personTemp");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static String getPersonTaxPRangeSql(Context ctx, String permItemId) {
        StringBuilder sb = new StringBuilder();
        String scheme = "006";
        String hrOrgField = "cmpHROrgUnit.id";
        HashMap<String, String> selectMapping = new HashMap<String, String>();
        selectMapping.put("person.id", "personId");
        FilterInfo filterInfo = CmpPermFilter.getPermFilter(ctx, scheme, permItemId);
        String hrRange = CmpSchemeFilter.getHrOrgUnitRangeSQL(ctx, permItemId);
        String adminRange = CmpSchemeFilter.getStraightAdminOrgUnitRangeSql(ctx, permItemId);
        if (CmpStrUtil.isEmpty(filterInfo.toString())) {
            String filterStr = hrOrgField + " in (" + hrRange + ")";
            try {
                filterInfo = new FilterInfo(filterStr);
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
        }
        try {
            FilterInfo adminFilter = new FilterInfo("adminOrgUnit.id in (" + adminRange + ")");
            FilterInfo useDefault = new FilterInfo("cmpEmpORelation.useDefault = 0 ");
            adminFilter.mergeFilter(useDefault, "or");
            filterInfo.mergeFilter(adminFilter, "and");
        }
        catch (ParserException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        SqlParam sqlParam = new SqlParam();
        sqlParam.setSelectMapping(selectMapping);
        sqlParam.setFilterInfo(filterInfo);
        sqlParam.setScheme(scheme);
        sqlParam.setNewSearch(true);
        sqlParam.setHistoryMode(true);
        sqlParam.setNeedDistinct(false);
        try {
            String sql = FilterUtil.getSql((Context)ctx, (SqlParam)sqlParam);
            sb.append(sql);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static String getPermForImportSQL(Context ctx, String scheme, String permItemId, boolean historyMode) {
        StringBuilder sb = new StringBuilder();
        String hrOrgField = "cal_hrOrgUnit.id";
        HashMap<String, String> selectMapping = new HashMap<String, String>();
        if ("002".equals(scheme)) {
            selectMapping.put("cmp_person.id", "personId");
            selectMapping.put("cal_hrOrgUnit.id", "hrOrgId");
        } else if ("006".equals(scheme)) {
            selectMapping.put("person.id", "personId");
            selectMapping.put("cmpHROrgUnit.id", "hrOrgId");
            hrOrgField = "cmpHROrgUnit.id";
        } else if ("008".equals(scheme)) {
            selectMapping.put("person.id", "personId");
            selectMapping.put("soc_hrOrg.id", "hrOrgId");
            hrOrgField = "soc_hrOrg.id";
        } else {
            selectMapping.put("person.id", "person.id");
        }
        FilterInfo filterInfo = CmpPermFilter.getPermFilter(ctx, scheme, permItemId);
        String hrRange = CmpSchemeFilter.getHrOrgUnitRangeSQL(ctx, permItemId);
        if (CmpStrUtil.isEmpty(filterInfo.toString())) {
            String filterStr = hrOrgField + " in (" + hrRange + ")";
            try {
                filterInfo = new FilterInfo(filterStr);
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
        }
        SqlParam sqlParam = new SqlParam();
        sqlParam.setSelectMapping(selectMapping);
        sqlParam.setFilterInfo(filterInfo);
        sqlParam.setScheme(scheme);
        sqlParam.setNewSearch(true);
        sqlParam.setHistoryMode(historyMode);
        try {
            sb.append("select * from(");
            String sql = FilterUtil.getSql((Context)ctx, (SqlParam)sqlParam);
            sb.append(sql);
            sb.append(") personTemp");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static FilterInfo getPermFilterByHRO(Context ctx, String scheme, String hrOrgId, boolean historyMode) {
        FilterInfo filterInfo = new FilterInfo();
        scheme = StringUtils.isEmpty((String)scheme) ? "006" : scheme;
        String personid = HRFilterUtils.getCurrentPersonId((Context)ctx);
        if (CmpStrUtil.isEmpty(personid)) {
            return filterInfo;
        }
        String oql = "select hrOrgUnit.id,filter where person.id = '" + personid + "' and scheme='" + scheme + "' and  hrOrgUnit.id = '" + hrOrgId + "'";
        try {
            CmpPermCollection cmpPermCollection;
            boolean exist = CmpPermFactory.getLocalInstance(ctx).exists(oql);
            if (exist && (cmpPermCollection = CmpPermFactory.getLocalInstance(ctx).getCmpPermCollection(oql)) != null && cmpPermCollection.size() > 0) {
                CmpPermInfo cmpPermInfo = null;
                cmpPermInfo = cmpPermCollection.get(0);
                String filterStr = cmpPermInfo.getFilter();
                if (CmpStrUtil.isEmpty(filterStr)) {
                    return filterInfo;
                }
                filterInfo = new FilterInfo(filterStr);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filterInfo;
    }

    public static FilterInfo getPermFilter(Context ctx, String scheme, String permItemId) {
        FilterInfo filter = new FilterInfo();
        scheme = StringUtils.isEmpty((String)scheme) ? "006" : scheme;
        String personid = HRFilterUtils.getCurrentPersonId((Context)ctx);
        if (CmpStrUtil.isEmpty(personid)) {
            return filter;
        }
        String hrRange = CmpSchemeFilter.getHrOrgUnitRangeSQL(ctx, permItemId);
        String oql = "select hrOrgUnit.id,filter where person.id = '" + personid + "' and scheme='" + scheme + "' and hrOrgUnit.id in (" + hrRange + ")";
        CmpPermCollection cmpPermCollection = null;
        try {
            cmpPermCollection = CmpPermFactory.getLocalInstance(ctx).getCmpPermCollection(oql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (cmpPermCollection != null && cmpPermCollection.size() > 0) {
            StringBuilder hrOrgSB = new StringBuilder();
            String hrOrgField = "cal_hrOrgUnit.id";
            if ("002".equals(scheme)) {
                hrOrgField = "cal_hrOrgUnit.id";
            } else if ("006".equals(scheme)) {
                hrOrgField = "cmpHROrgUnit.id";
            } else if ("008".equals(scheme)) {
                hrOrgField = "soc_hrOrg.id";
            }
            int size = cmpPermCollection.size();
            for (int i = 0; i < size; ++i) {
                CmpPermInfo cmpPermInfo = cmpPermCollection.get(i);
                String filterStr = cmpPermInfo.getFilter();
                if (CmpStrUtil.isEmpty(filterStr)) continue;
                String hrOrgId = cmpPermInfo.getHrOrgUnit().getId().toString();
                try {
                    filterStr = filterStr + " and " + hrOrgField + "='" + hrOrgId + "'";
                    FilterInfo filterInfo = new FilterInfo(filterStr);
                    filter.mergeFilter(filterInfo, "OR");
                    hrOrgSB.append(" '").append(hrOrgId).append("', ");
                    continue;
                }
                catch (ParserException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
            if (hrOrgSB.length() > 0) {
                String hrOrgStr = hrOrgSB.substring(0, hrOrgSB.lastIndexOf(","));
                try {
                    FilterInfo otherFilter = new FilterInfo(hrOrgField + " not in (" + hrOrgStr + ")");
                    filter.mergeFilter(otherFilter, "OR");
                }
                catch (ParserException e) {
                    e.printStackTrace();
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
        }
        return filter;
    }

    public static FilterInfo getPermFilterByKey(Context ctx, String scheme, String hrOrgKey, String personKey, boolean historyMode) {
        FilterInfo filter = new FilterInfo();
        scheme = StringUtils.isEmpty((String)scheme) ? "006" : scheme;
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        if (CmpStrUtil.isEmpty(personId)) {
            return filter;
        }
        String oql = "select hrOrgUnit.id,filter where person.id = '" + personId + "' and scheme='" + scheme + "'";
        CmpPermCollection cmpPermCollection = null;
        try {
            cmpPermCollection = CmpPermFactory.getLocalInstance(ctx).getCmpPermCollection(oql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        StringBuilder hrOrgSb = new StringBuilder();
        if (cmpPermCollection != null && cmpPermCollection.size() > 0) {
            String hrOrgField = "cal_hrOrgUnit.id";
            SqlParam sqlParam = new SqlParam();
            HashMap<String, String> selectMapping = new HashMap<String, String>();
            if ("002".equals(scheme)) {
                selectMapping.put("cmp_person.id", "person.id");
            } else if ("006".equals(scheme)) {
                selectMapping.put("person.id", "person.id");
                hrOrgField = "cmpHROrgUnit.id";
            } else if ("008".equals(scheme)) {
                selectMapping.put("person.id", "person.id");
                hrOrgField = "soc_hrOrg.id";
            } else {
                selectMapping.put("person.id", "person.id");
            }
            int size = cmpPermCollection.size();
            for (int i = 0; i < size; ++i) {
                CmpPermInfo cmpPermInfo = cmpPermCollection.get(i);
                String filterStr = cmpPermInfo.getFilter();
                if (CmpStrUtil.isEmpty(filterStr)) continue;
                String hrOrgId = cmpPermInfo.getHrOrgUnit().getId().toString();
                try {
                    filterStr = filterStr + " and " + hrOrgField + "='" + hrOrgId + "'";
                    FilterInfo filterInfo = new FilterInfo(filterStr);
                    hrOrgSb.append(",'").append(hrOrgId).append("'");
                    sqlParam.setSelectMapping(selectMapping);
                    sqlParam.setFilterInfo(filterInfo);
                    sqlParam.setScheme(scheme);
                    sqlParam.setNewSearch(true);
                    sqlParam.setHistoryMode(historyMode);
                    String sql = FilterUtil.getSql((Context)ctx, (SqlParam)sqlParam);
                    String permFilter = "(" + personKey + " in (" + sql + ") and " + hrOrgKey + "='" + hrOrgId + "')";
                    filterInfo = new FilterInfo(permFilter);
                    filter.mergeFilter(filterInfo, "OR");
                    if (i != size - 1) continue;
                    String hrOrgStr = hrOrgSb.substring(1);
                    permFilter = hrOrgKey + " not in (" + hrOrgStr + ")";
                    filterInfo = new FilterInfo(permFilter);
                    filter.mergeFilter(filterInfo, "OR");
                    continue;
                }
                catch (ParserException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (BOSException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return filter;
    }

    public static String getCmpPersonPermFilter(Context ctx, String hrOrgKey, String personKey, String permItemId, boolean historyMode) {
        String scheme = "006";
        String personid = HRFilterUtils.getCurrentPersonId((Context)ctx);
        if (CmpStrUtil.isEmpty(personid)) {
            return null;
        }
        String hrOrgUnitRangeSQL = CmpSchemeFilter.getHrOrgUnitRangeSQL(ctx, permItemId);
        String oql = "select hrOrgUnit.id,filter where person.id = '" + personid + "' and scheme='" + scheme + "' and hrOrgUnit.id in (" + hrOrgUnitRangeSQL + ")";
        CmpPermCollection cmpPermCollection = null;
        try {
            cmpPermCollection = CmpPermFactory.getLocalInstance(ctx).getCmpPermCollection(oql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder hrOrgSb = new StringBuilder();
        if (cmpPermCollection != null && cmpPermCollection.size() > 0) {
            SqlParam sqlParam = new SqlParam();
            HashMap<String, String> selectMapping = new HashMap<String, String>();
            selectMapping.put("person.id", "person.id");
            sb.append("(");
            int size = cmpPermCollection.size();
            for (int i = 0; i < size; ++i) {
                CmpPermInfo cmpPermInfo = cmpPermCollection.get(i);
                String filterStr = cmpPermInfo.getFilter();
                if (CmpStrUtil.isEmpty(filterStr)) continue;
                String hrOrgId = cmpPermInfo.getHrOrgUnit().getId().toString();
                try {
                    FilterInfo filterInfo = new FilterInfo(filterStr);
                    hrOrgSb.append("'").append(hrOrgId).append("', ");
                    sqlParam.setSelectMapping(selectMapping);
                    sqlParam.setFilterInfo(filterInfo);
                    sqlParam.setScheme(scheme);
                    sqlParam.setNewSearch(true);
                    sqlParam.setHistoryMode(historyMode);
                    String sql = FilterUtil.getSql((Context)ctx, (SqlParam)sqlParam);
                    if (i != 0) {
                        sb.append(" or  ");
                    }
                    sb.append("(").append(personKey).append(" in (").append(sql).append(") and ").append(hrOrgKey).append("='").append(hrOrgId).append("')");
                    if (i != size - 1) continue;
                    String hrOrgStr = hrOrgSb.substring(0, hrOrgSb.lastIndexOf(","));
                    sb.append(" or  ");
                    sb.append(hrOrgKey + " not in (" + hrOrgStr + ")");
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (sb.length() > 0) {
            sb.append(")");
        }
        return sb.toString();
    }

    public static String getCmpPersonPermFilter(Context ctx, String mainKey, String hrOrgKey, String personKey, String permItemId, boolean historyMode) {
        String sql = null;
        String scheme = "006";
        String personid = HRFilterUtils.getCurrentPersonId((Context)ctx);
        if (CmpStrUtil.isEmpty(personid)) {
            return null;
        }
        String hrOrgUnitRangeSQL = CmpSchemeFilter.getHrOrgUnitRangeSQL(ctx, permItemId);
        String oql = "select hrOrgUnit.id,filter where person.id = '" + personid + "' and scheme='" + scheme + "' and hrOrgUnit.id in (" + hrOrgUnitRangeSQL + ")";
        CmpPermCollection cmpPermCollection = null;
        try {
            cmpPermCollection = CmpPermFactory.getLocalInstance(ctx).getCmpPermCollection(oql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder hrOrgSb = new StringBuilder();
        if (cmpPermCollection != null && cmpPermCollection.size() > 0) {
            SqlParam sqlParam = new SqlParam();
            HashMap<String, String> selectMapping = new HashMap<String, String>();
            selectMapping.put(mainKey, mainKey);
            sb.append("(");
            int size = cmpPermCollection.size();
            for (int i = 0; i < size; ++i) {
                CmpPermInfo cmpPermInfo = cmpPermCollection.get(i);
                String filterStr = cmpPermInfo.getFilter();
                if (CmpStrUtil.isEmpty(filterStr)) continue;
                String hrOrgId = cmpPermInfo.getHrOrgUnit().getId().toString();
                try {
                    FilterInfo filterInfo = new FilterInfo(filterStr);
                    hrOrgSb.append("'").append(hrOrgId).append("', ");
                    sqlParam.setSelectMapping(selectMapping);
                    sqlParam.setFilterInfo(filterInfo);
                    sqlParam.setScheme(scheme);
                    sqlParam.setNewSearch(true);
                    sqlParam.setHistoryMode(historyMode);
                    sql = FilterUtil.getSql((Context)ctx, (SqlParam)sqlParam);
                    if (i != 0) {
                        sb.append(" or  ");
                    }
                    sb.append("(").append(personKey).append(" in (").append(sql).append(") and ").append(hrOrgKey).append("='").append(hrOrgId).append("')");
                    if (i != size - 1) continue;
                    String hrOrgStr = hrOrgSb.substring(0, hrOrgSb.lastIndexOf(","));
                    sb.append(" or  ");
                    sb.append(hrOrgKey).append(" not in (").append(hrOrgStr).append(")");
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (sb.length() > 0) {
            sb.append(")");
        }
        return sb.toString();
    }

    public static FilterInfo getDynamicOrgRangeFilter(Context ctx, String scheme, String permItemId, boolean hisMode, boolean isAdminRange) {
        if (CmpStrUtil.isNullOrEmpty(scheme, permItemId)) {
            return null;
        }
        FilterInfo filterInfo = null;
        try {
            String filterSql = CmpPermFilter.getPermRangeSqlByScheme(ctx, scheme, permItemId, hisMode, isAdminRange);
            filterInfo = new FilterInfo(filterSql);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filterInfo;
    }

    private static String getPermRangeSqlByScheme(Context ctx, String scheme, String permItemId, boolean hisMode, boolean isAdminRange) {
        String useDefaultField = "";
        String adminRangeField = "";
        String hrRangeField = "";
        String dataPermField = "";
        if ("002".equals(scheme)) {
            useDefaultField = "cmp_CTB.useDefault";
            adminRangeField = "cal_adminOrg.id";
            hrRangeField = "cal_hrOrgUnit.id";
            dataPermField = "cmp_person.id";
        } else if ("006".equals(scheme)) {
            useDefaultField = "cmpEmpORelation.useDefault";
            adminRangeField = "adminOrgUnit.id";
            hrRangeField = "cmpHROrgUnit.id";
            dataPermField = "person.id";
        } else if ("008".equals(scheme)) {
            useDefaultField = "soc_record.useDefault";
            adminRangeField = "soc_adminOrg.id";
            hrRangeField = "soc_hrOrg.id";
            dataPermField = "person.id";
        }
        String adminOrgRangeSql = CmpSchemeFilter.getAdminOrgUnitRangeSQL(ctx, permItemId);
        String hrOrgRangeSql = CmpSchemeFilter.getHrOrgUnitRangeSQL(ctx, permItemId);
        String permSQL = CmpPermFilter.getPermSQL(ctx, scheme, permItemId, hisMode);
        StringBuilder filterSql = new StringBuilder();
        if (isAdminRange) {
            filterSql.append(hrRangeField).append(" in(").append(hrOrgRangeSql).append(")").append(" and ");
            filterSql.append("((").append(useDefaultField).append("=1").append(" and ").append(adminRangeField);
            filterSql.append(" in (").append(adminOrgRangeSql).append("))").append(" or (").append(useDefaultField);
            filterSql.append("=0))");
        } else {
            filterSql.append("(").append(adminRangeField).append(" in(").append(adminOrgRangeSql).append(") and ");
            filterSql.append(hrRangeField).append(" in(").append(hrOrgRangeSql).append("))");
        }
        if (!StringUtils.isEmpty((String)permSQL)) {
            filterSql.append(" and ").append(dataPermField).append(" in(").append(permSQL).append(") ");
        }
        return filterSql.toString();
    }
}

