/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util.pdf;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kingdee.bos.Context;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.shr.compensation.util.pdf.PdfPTableHelper;
import com.kingdee.shr.compensation.util.pdf.StyleExtractor;
import com.kingdee.shr.compensation.util.pdf.TagAndStyle;
import com.kingdee.shr.compensation.util.pdf.TextStyle;
import com.kingdee.util.StringUtils;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.draw.LineSeparator;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Html2PdfConverter {
    private static final Logger LOG = LoggerFactory.getLogger(Html2PdfConverter.class);
    protected Context ctx;
    public static final String paragraphReg = "<p*?([\\s\\S]*?)>([\\s\\S]*?)</p>";
    public static final String titleReg = "<h[1-6]*?([\\s\\S]*?)>([\\s\\S]*?)</h[1-6]>";
    public static final Pattern paragraphPattern = Pattern.compile("<p*?([\\s\\S]*?)>([\\s\\S]*?)</p>");
    public static final Pattern titlePattern = Pattern.compile("<h[1-6]*?([\\s\\S]*?)>([\\s\\S]*?)</h[1-6]>");
    public static final String tableReg = "<table*?([\\s\\S]*?)>([\\s\\S]*?)</table>";
    public static final Pattern tablePattern = Pattern.compile("<table*?([\\s\\S]*?)>([\\s\\S]*?)</table>");
    public static final String divReg = "<div*?([\\s\\S]*?)>([\\s\\S]*?)</div>";
    public static final Pattern divPattern = Pattern.compile("<div*?([\\s\\S]*?)>([\\s\\S]*?)</div>");
    public static final String hrReg = "<hr*?([\\s\\S]*?)/>";
    public static final Pattern hrPattern = Pattern.compile("<hr*?([\\s\\S]*?)/>");
    private static final String tagStartReg = "<[a-z]*?([\\s\\S]*?)>";
    public static final Pattern tagPattern = Pattern.compile("<[a-z]*?([\\s\\S]*?)>");
    public static final String RETURN_TAG = "<br/>";
    public static final String RETURN_TAG1 = "<br />";
    public static final String CUT_LINE = "<hr";
    public static final String SIM_SUM = "\u5b8b\u4f53";
    private Map<String, BaseFont> fontMap = new HashMap<String, BaseFont>();
    private String defaultFontFamily;
    private StyleExtractor styleExtractor;
    protected PdfWriter pdfWriter;

    private void loadPresetFont() {
        try {
            String basePath = Html2PdfConverter.getFontFilePath();
            BaseFont simSun = BaseFont.createFont((String)(basePath + "simsun.ttc,0"), (String)"Identity-H", (boolean)true);
            this.fontMap.put(SIM_SUM, simSun);
        }
        catch (IOException e) {
            LOG.error("Html2PdfConverter static code error: ", (Throwable)e);
        }
    }

    public static String getFontFilePath() {
        String basePath = SHRSyssettingUtil.getProperitesPath();
        if (!basePath.endsWith(File.separator)) {
            basePath = basePath + File.separator;
        }
        basePath = basePath + "shr" + File.separator;
        return basePath;
    }

    public Html2PdfConverter() {
        this.defaultFontFamily = SIM_SUM;
        this.styleExtractor = new StyleExtractor();
    }

    public Html2PdfConverter(Context ctx) {
        this.ctx = ctx;
        this.defaultFontFamily = SIM_SUM;
        this.styleExtractor = new StyleExtractor();
    }

    public void generatePdfFile(String htmlContent, File pdfFile, Map<String, byte[]> imageMap) {
        this.loadPresetFont();
        List<String> htmlPartitions = this.getHtmlPartitions(htmlContent);
        try (Document document = new Document();){
            if (pdfFile.createNewFile()) {
                LOG.info("create new File" + pdfFile.getName());
            }
            OutputStream os = Files.newOutputStream(pdfFile.toPath(), new OpenOption[0]);
            this.pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)os);
            document.open();
            this.beforeResolve(this.pdfWriter);
            for (String partition : htmlPartitions) {
                if (this.isTable(partition = partition.replaceAll("&nbsp;", " "))) {
                    PdfPTable table = this.createTable(partition, document);
                    document.add((Element)table);
                    continue;
                }
                if (partition.startsWith(CUT_LINE)) {
                    Paragraph newLine = new Paragraph();
                    newLine.add((Element)Chunk.NEWLINE);
                    document.add((Element)newLine);
                    LineSeparator lineSeparator = new LineSeparator();
                    lineSeparator.setLineWidth(0.5f);
                    document.add((Element)lineSeparator);
                    document.add((Element)newLine);
                    continue;
                }
                Matcher tagMatcher = tagPattern.matcher(partition);
                ArrayList<String> tagPairs = new ArrayList<String>();
                while (tagMatcher.find()) {
                    String tag = tagMatcher.group();
                    if (RETURN_TAG.equalsIgnoreCase(tag)) continue;
                    tagPairs.add(tag);
                }
                Paragraph paragraph = this.resolveAndRender(partition, tagPairs, imageMap);
                if (paragraph.getChunks().isEmpty()) continue;
                document.add((Element)paragraph);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private PdfPTable createTable(String partition, Document document) throws IOException {
        PdfPTableHelper pdfTableHelper = new PdfPTableHelper(this);
        return pdfTableHelper.createTable(partition, document);
    }

    private List<String> getHtmlPartitions(String htmlContent) {
        ArrayList partitions = Lists.newArrayList();
        boolean flag = true;
        htmlContent = this.dealWithConvertedChar(htmlContent);
        while (flag) {
            String partition;
            Matcher pMatcher;
            if (htmlContent.startsWith("<p")) {
                pMatcher = paragraphPattern.matcher(htmlContent);
                if (!pMatcher.find()) continue;
                partition = pMatcher.group(0);
                htmlContent = htmlContent.substring(partition.length());
                partitions.add(partition);
                continue;
            }
            if (this.isTable(htmlContent)) {
                Matcher tMatcher = tablePattern.matcher(htmlContent);
                if (!tMatcher.find()) continue;
                partition = tMatcher.group(0);
                htmlContent = htmlContent.substring(partition.length());
                partitions.add(partition);
                continue;
            }
            if (htmlContent.startsWith(CUT_LINE)) {
                partitions.add(CUT_LINE);
                Matcher hrMatcher = hrPattern.matcher(htmlContent);
                if (!hrMatcher.find()) continue;
                String hr = hrMatcher.group();
                htmlContent = htmlContent.replaceFirst(hr, "");
                continue;
            }
            if (htmlContent.startsWith("<div")) {
                pMatcher = divPattern.matcher(htmlContent);
                if (!pMatcher.find()) continue;
                partition = pMatcher.group(0);
                htmlContent = htmlContent.substring(partition.length());
                Matcher hrMatcher = hrPattern.matcher(partition);
                if (!hrMatcher.find()) continue;
                partitions.add(CUT_LINE);
                continue;
            }
            if (htmlContent.startsWith("<h")) {
                pMatcher = titlePattern.matcher(htmlContent);
                if (!pMatcher.find()) continue;
                partition = pMatcher.group(0);
                htmlContent = htmlContent.substring(partition.length());
                partitions.add(partition);
                continue;
            }
            flag = false;
        }
        return partitions;
    }

    protected String dealWithConvertedChar(String htmlContent) {
        htmlContent = htmlContent.replace("\n", "");
        HashMap characters = Maps.newHashMap();
        characters.put("&middot;", "\u00b7");
        characters.put("&hellip;", "\u2026");
        characters.put("&amp;", "&");
        characters.put("&mdash;", "\u2014");
        characters.put("&ldquo;", "\u201c");
        characters.put("&rdquo;", "\u201d");
        characters.put("&lsquo;", "\u2018");
        characters.put("&rsquo;", "\u2019");
        characters.put("&lt;", "<");
        characters.put("&gt;", ">");
        for (Map.Entry entry : characters.entrySet()) {
            htmlContent = htmlContent.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return htmlContent;
    }

    private boolean isTable(String content) {
        return content.startsWith("<table");
    }

    protected void beforeResolve(PdfWriter pdfWriter) {
    }

    private static boolean isPair(String left, String right) {
        if (!right.startsWith("</")) {
            return false;
        }
        if (left.startsWith("</")) {
            return false;
        }
        String tagName = left.trim().contains(" ") ? left.substring(left.indexOf("<") + 1, left.trim().indexOf(" ")) : left.substring(left.indexOf("<") + 1, left.trim().indexOf(">"));
        return left.startsWith("<" + tagName) && right.equalsIgnoreCase("</" + tagName + ">");
    }

    public Paragraph resolveAndRender(String p, List<String> tagPairs, Map<String, byte[]> imageMap) throws IOException {
        Paragraph paragraph = new Paragraph();
        Stack<TagAndStyle> stack = new Stack<TagAndStyle>();
        float lineHeight = -1.0f;
        float lineHeightPt = -1.0f;
        String textAlign = null;
        for (String currentTag : tagPairs) {
            int currentTagIndex = p.indexOf(currentTag);
            if (stack.isEmpty()) {
                String contentBefore = p.substring(0, currentTagIndex);
                TextStyle textStyle = this.styleExtractor.extractStyles(currentTag);
                if (textStyle.getTextAlign() != null) {
                    textAlign = textStyle.getTextAlign();
                }
                if (textStyle.getLineHeight() > 0.0f) {
                    lineHeight = textStyle.getLineHeight();
                }
                if (textStyle.getLineHeightPt() > 0.0f) {
                    lineHeightPt = textStyle.getLineHeightPt();
                }
                if (!Html2PdfConverter.isEmpty(contentBefore)) {
                    this.createRunAndAddStyle(paragraph, textStyle, contentBefore, imageMap);
                }
                stack.push(TagAndStyle.newTagAndStyle(currentTag, textStyle));
            } else {
                String lastTag;
                String tagContent = p.substring(0, currentTagIndex);
                TagAndStyle lastStyle = (TagAndStyle)stack.peek();
                if (!Html2PdfConverter.isEmpty(tagContent)) {
                    this.createRunAndAddStyle(paragraph, lastStyle.getTextStyle(), tagContent, imageMap);
                }
                if (Html2PdfConverter.isPair(lastTag = lastStyle.getTag(), currentTag)) {
                    stack.pop();
                } else {
                    TextStyle subStyle = this.styleExtractor.extractStyles(currentTag);
                    this.styleExtractor.mergerStyle(lastStyle.getTextStyle(), subStyle);
                    stack.push(TagAndStyle.newTagAndStyle(currentTag, subStyle));
                }
            }
            p = p.substring(p.indexOf(currentTag) + currentTag.length());
        }
        if (null != textAlign) {
            this.setParagraphAlign(paragraph, textAlign);
        }
        float fontSize = this.getMaxFontSize(paragraph);
        if (lineHeight > 0.0f) {
            paragraph.setLeading(fontSize, lineHeight);
        } else if (lineHeightPt > 0.0f) {
            paragraph.setLeading(lineHeightPt);
        }
        return paragraph;
    }

    public float getMaxFontSize(Paragraph paragraph) {
        ArrayList chunks = paragraph.getChunks();
        if (null == chunks || chunks.isEmpty()) {
            return 12.0f;
        }
        float fontSize = 0.0f;
        for (Element element : chunks) {
            if (!(element instanceof Chunk)) continue;
            Chunk chunk = (Chunk)element;
            float size = chunk.getFont().getSize();
            fontSize = Math.max(fontSize, size);
        }
        return fontSize > 0.0f ? fontSize : 12.0f;
    }

    public void setParagraphAlign(Paragraph paragraph, String textAlign) {
        if ("center".equalsIgnoreCase(textAlign)) {
            paragraph.setAlignment(1);
        } else if ("left".equalsIgnoreCase(textAlign)) {
            paragraph.setAlignment(0);
        } else if ("right".equalsIgnoreCase(textAlign)) {
            paragraph.setAlignment(2);
        } else if ("justify".equalsIgnoreCase(textAlign)) {
            paragraph.setAlignment(3);
        }
    }

    public void createRunAndAddStyle(Paragraph paragraph, TextStyle textStyle, String text, Map<String, byte[]> imageMap) throws DocumentException, IOException {
        if (!text.contains(RETURN_TAG) && !text.contains(RETURN_TAG1)) {
            this.setTextAndAddPicture(paragraph, text, textStyle, imageMap);
            return;
        }
        String[] textArr = text.contains(RETURN_TAG) ? text.split(RETURN_TAG) : text.split(RETURN_TAG1);
        for (String sub : textArr) {
            this.setTextAndAddPicture(paragraph, sub, textStyle, imageMap);
            paragraph.add((Element)Chunk.NEWLINE);
        }
    }

    private void addText2Paragraph(Paragraph paragraph, String text, TextStyle textStyle) {
        String fontFamily;
        if (Html2PdfConverter.isEmpty(text)) {
            return;
        }
        if (text.contains("##")) {
            String varRegExp = "##(.+?)##";
            Pattern fieldPattern = Pattern.compile(varRegExp);
            Matcher matcher = fieldPattern.matcher(text);
            while (matcher.find()) {
                String field = matcher.group();
                text = text.replace(field, "        ");
            }
        }
        Chunk chunk = new Chunk(text);
        if (null == textStyle) {
            paragraph.add((Element)chunk);
            return;
        }
        if (textStyle.isUnderline()) {
            float lineThickness = 0.7f;
            float lineYPosition = -1.0f;
            chunk.setUnderline(lineThickness, lineYPosition);
        }
        if (StringUtils.isEmpty((String)(fontFamily = textStyle.getFontFamily()))) {
            fontFamily = this.defaultFontFamily;
        }
        BaseFont baseFont = this.getBaseFont(fontFamily);
        Font font = new Font(baseFont);
        this.styleExtractor.setFontStyle(textStyle, font);
        chunk.setFont(font);
        if (textStyle.getTextIndent() > 0.0f) {
            paragraph.setFirstLineIndent(textStyle.getTextIndent());
        }
        if (textStyle.getR1() >= 0) {
            chunk.setBackground(new Color(textStyle.getR1(), textStyle.getG1(), textStyle.getB1()));
        } else if (!StringUtils.isEmpty((String)textStyle.getBackgroundColor())) {
            chunk.setBackground(StyleExtractor.COLOR_MAP.get(textStyle.getBackgroundColor()));
        }
        if (textStyle.isLineThrough()) {
            float lineThickness = 0.7f;
            float lineYPosition = font.getSize() / 2.0f;
            chunk.setUnderline(lineThickness, lineYPosition);
        }
        paragraph.add((Element)chunk);
    }

    public BaseFont getBaseFont(String fontFamily) {
        String fontName = this.extractFontName(fontFamily);
        BaseFont baseFont = this.fontMap.get(fontName);
        if (null == baseFont) {
            LOG.error("============\u5b57\u4f53\u7f3a\u5931\uff0c\u4f7f\u7528\u5b8b\u4f53======");
            baseFont = this.fontMap.get(SIM_SUM);
        }
        return baseFont;
    }

    protected String extractFontName(String fontFamily) {
        ArrayList<String> fontNames = new ArrayList<String>();
        fontNames.add("\u4eff\u5b8b");
        fontNames.add("\u5fae\u8f6f\u96c5\u9ed1");
        fontNames.add("\u6977\u4f53");
        fontNames.add("\u9ed1\u4f53");
        fontNames.add("\u96b6\u4e66");
        fontNames.add("Arial Black");
        fontNames.add("Arial");
        fontNames.add("Andale Mono");
        fontNames.add("Courier New");
        fontNames.add("Georigia");
        fontNames.add("Helvetica");
        fontNames.add("impact");
        fontNames.add("Sans Serif");
        fontNames.add("Terminal");
        for (String fontName : fontNames) {
            if (!fontFamily.contains(fontName)) continue;
            return fontName;
        }
        return SIM_SUM;
    }

    public void setTextAndAddPicture(Paragraph paragraph, String text, TextStyle textStyle, Map<String, byte[]> imageMap) throws DocumentException, IOException {
        if (null == imageMap || imageMap.isEmpty()) {
            this.addText2Paragraph(paragraph, text, textStyle);
            return;
        }
        TreeMap<Integer, String> imageFields = new TreeMap<Integer, String>();
        for (Map.Entry<String, byte[]> entry : imageMap.entrySet()) {
            String signatureField = entry.getKey();
            int index = text.indexOf(signatureField);
            if (index < 0) continue;
            imageFields.put(index, signatureField);
        }
        if (imageFields.isEmpty()) {
            this.addText2Paragraph(paragraph, text, textStyle);
            return;
        }
        List<String> fragments = this.subTextByImageFields(text, imageFields);
        for (String fragment : fragments) {
            if (!imageMap.containsKey(fragment)) {
                this.addText2Paragraph(paragraph, fragment, textStyle);
                continue;
            }
            byte[] image = imageMap.get(fragment);
            this.addImage2Paragraph(paragraph, image);
        }
    }

    protected List<String> subTextByImageFields(String text, Map<Integer, String> imageFields) {
        ArrayList<String> fragments = new ArrayList<String>();
        for (Map.Entry<Integer, String> entry : imageFields.entrySet()) {
            String imageField = entry.getValue();
            int picIndex = text.indexOf(imageField);
            String pictureBefore = text.substring(0, picIndex);
            if (!Html2PdfConverter.isEmpty(pictureBefore)) {
                fragments.add(pictureBefore);
            }
            fragments.add(imageField);
            text = text.substring(picIndex + imageField.length());
        }
        if (!Html2PdfConverter.isEmpty(text)) {
            fragments.add(text);
        }
        return fragments;
    }

    protected void addImage2Paragraph(Paragraph paragraph, byte[] imagePath) throws IOException {
        Image image = Image.getInstance((byte[])imagePath);
        image.setAlignment(paragraph.getAlignment());
        image.scaleToFit(50.0f, 25.0f);
        Chunk chunk = new Chunk(image, 0.0f, -5.0f);
        paragraph.add((Element)chunk);
    }

    public static boolean isEmpty(String str) {
        return null == str || str.equals("");
    }

    public void setStyleExtractor(StyleExtractor styleExtractor) {
        this.styleExtractor = styleExtractor;
    }

    public void setDefaultFontFamily(String defaultFontFamily) {
        this.defaultFontFamily = defaultFontFamily;
    }

    public Map<String, BaseFont> getFontMap() {
        return this.fontMap;
    }

    public void setFontMap(Map<String, BaseFont> fontMap) {
        this.fontMap = fontMap;
    }

    public PdfWriter getPdfWriter() {
        return this.pdfWriter;
    }

    public StyleExtractor getStyleExtractor() {
        return this.styleExtractor;
    }
}

