/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util.pdf;

import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.shr.compensation.util.pdf.BorderAttr;
import com.kingdee.shr.compensation.util.pdf.Html2PdfConverter;
import com.kingdee.shr.compensation.util.pdf.StyleExtractor;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PdfPTableHelper {
    protected Html2PdfConverter html2PdfConverter;
    public static final String tdTag = "<td*?([\\s\\S]*?)>";
    public static final String tdReg = "<td*?([\\s\\S]*?)>([\\s\\S]*?)</td>";
    public static final String thTag = "<th*?([\\s\\S]*?)>";
    public static final String thReg = "<th*?([\\s\\S]*?)>([\\s\\S]*?)</th>";
    public static final String trReg = "<tr*?([\\s\\S]*?)>([\\s\\S]*?)</tr>";
    public static final String captionReg = "<caption>([\\s\\S]*?)</caption>";
    public static final String tableTag = "<table*?([\\s\\S]*?)>";
    public static final Pattern tdRegPattern = Pattern.compile("<td*?([\\s\\S]*?)>([\\s\\S]*?)</td>");
    public static final Pattern tdTagPattern = Pattern.compile("<td*?([\\s\\S]*?)>");
    public static final Pattern thTagPattern = Pattern.compile("<th*?([\\s\\S]*?)>");
    public static final Pattern thRegPattern = Pattern.compile("<th*?([\\s\\S]*?)>([\\s\\S]*?)</th>");
    public static final Pattern trRegPattern = Pattern.compile("<tr*?([\\s\\S]*?)>([\\s\\S]*?)</tr>");
    public static final Pattern tableTagPattern = Pattern.compile("<table*?([\\s\\S]*?)>");
    private float[] cellWidthArr;
    private int[] cellWidthPxArr;
    private boolean borderWidthFlag = true;
    private int columnIndex;

    public PdfPTableHelper(Html2PdfConverter html2PdfConverter) {
        this.html2PdfConverter = html2PdfConverter;
    }

    public PdfPTable createTable(String tableHtml, Document document) throws IOException {
        List<List<String>> rowList = this.getRowsFromTable(tableHtml);
        if (tableHtml.contains("</caption>")) {
            this.addCaptionAsParagraph(tableHtml, document);
        }
        int totalColumns = this.getTotalColumns(rowList);
        PdfPTable table = new PdfPTable(totalColumns);
        Matcher tableTagMatch = tableTagPattern.matcher(tableHtml);
        BorderAttr parentBorderAttr = null;
        if (tableTagMatch.find()) {
            parentBorderAttr = this.addTableStyle(table, tableTagMatch.group(0));
        }
        this.cellWidthArr = new float[totalColumns];
        this.cellWidthPxArr = new int[totalColumns];
        for (List<String> columns : rowList) {
            int rowIndex = rowList.indexOf(columns);
            for (String column : columns) {
                String cellContent;
                int start;
                this.columnIndex = this.columnIndex == 0 ? columns.indexOf(column) : this.columnIndex;
                String tag = "";
                if (column.contains("<td")) {
                    Matcher tdTagMatcher = tdTagPattern.matcher(column);
                    if (tdTagMatcher.find()) {
                        tag = tdTagMatcher.group(0);
                    }
                    start = column.indexOf(tag) + tag.length();
                    cellContent = column.substring(start, column.indexOf("</td>"));
                } else {
                    Matcher thTagMatcher = thTagPattern.matcher(column);
                    if (thTagMatcher.find()) {
                        tag = thTagMatcher.group(0);
                    }
                    start = column.indexOf(tag) + tag.length();
                    cellContent = column.substring(start, column.indexOf("</th>"));
                }
                PdfPCell cell = this.createCellAndAddStyle(tag, parentBorderAttr, rowIndex);
                Matcher pMatcher = Html2PdfConverter.paragraphPattern.matcher(cellContent);
                boolean isParagraph = false;
                while (pMatcher.find()) {
                    isParagraph = true;
                    String paragraph = pMatcher.group(0);
                    int pIdx = paragraph.indexOf("<p");
                    paragraph = paragraph.substring(pIdx);
                    ArrayList<String> tagPairs = new ArrayList<String>();
                    Matcher innerTagMatcher = Html2PdfConverter.tagPattern.matcher(paragraph);
                    while (innerTagMatcher.find()) {
                        String contentTag = innerTagMatcher.group();
                        if ("<br/>".equalsIgnoreCase(contentTag)) continue;
                        tagPairs.add(contentTag);
                    }
                    Paragraph para = this.html2PdfConverter.resolveAndRender(paragraph, tagPairs, null);
                    cell.addElement((Element)para);
                }
                if (!isParagraph) {
                    ArrayList<String> tagPairs = new ArrayList<String>();
                    Matcher innerTagMatcher = Html2PdfConverter.tagPattern.matcher(cellContent);
                    while (innerTagMatcher.find()) {
                        String contentTag = innerTagMatcher.group();
                        if ("<br/>".equalsIgnoreCase(contentTag)) continue;
                        tagPairs.add(contentTag);
                    }
                    if (!tagPairs.isEmpty()) {
                        Paragraph para = this.html2PdfConverter.resolveAndRender(cellContent, tagPairs, null);
                        cell.addElement((Element)para);
                    } else {
                        BaseFont baseFont = this.html2PdfConverter.getBaseFont("");
                        Font font = new Font(baseFont);
                        Chunk chunk = new Chunk(cellContent);
                        chunk.setFont(font);
                        Paragraph para = new Paragraph();
                        para.add((Element)chunk);
                        cell.addElement((Element)para);
                    }
                }
                table.addCell(cell);
            }
        }
        if (this.borderWidthFlag) {
            table.setWidths(this.cellWidthArr);
        } else {
            table.setWidths(this.cellWidthPxArr);
        }
        return table;
    }

    private int getTotalColumns(List<List<String>> rowList) {
        List<String> firstRow = rowList.get(0);
        int total = firstRow.size();
        String colspanReg = "colspan=\"\\d\"";
        Pattern colspanPattern = Pattern.compile(colspanReg);
        for (String cell : firstRow) {
            Matcher matcher = colspanPattern.matcher(cell);
            if (!matcher.find()) continue;
            String colspan = matcher.group();
            int val = Integer.parseInt(colspan.split("=")[1].trim().replace("\"", ""));
            total += val - 1;
        }
        return total;
    }

    private void addCaptionAsParagraph(String tableHtml, Document document) throws IOException {
        Pattern captionPattern = Pattern.compile(captionReg);
        Matcher captionMatcher = captionPattern.matcher(tableHtml);
        if (captionMatcher.find()) {
            String caption = captionMatcher.group();
            ArrayList<String> tagPairs = new ArrayList<String>();
            Matcher innerTagMatcher = Html2PdfConverter.tagPattern.matcher(caption);
            while (innerTagMatcher.find()) {
                String contentTag = innerTagMatcher.group();
                tagPairs.add(contentTag);
            }
            Paragraph captionParagraph = this.html2PdfConverter.resolveAndRender(caption, tagPairs, null);
            captionParagraph.setAlignment(1);
            document.add((Element)captionParagraph);
        }
    }

    protected List<List<String>> getRowsFromTable(String tableHtml) {
        ArrayList<List<String>> rowList = new ArrayList<List<String>>();
        Matcher rowMatcher = trRegPattern.matcher(tableHtml);
        while (rowMatcher.find()) {
            String row = rowMatcher.group();
            int rowIndex = row.indexOf("<tr");
            Matcher columnMatcher = (row = row.substring(rowIndex)).contains("<th") ? thRegPattern.matcher(row) : tdRegPattern.matcher(row);
            ArrayList<String> columnList = new ArrayList<String>();
            while (columnMatcher.find()) {
                String cellHtml = columnMatcher.group(0);
                int tdIndex = cellHtml.contains("<td") ? cellHtml.indexOf("<td") : cellHtml.indexOf("<th");
                cellHtml = cellHtml.substring(tdIndex);
                columnList.add(cellHtml);
            }
            rowList.add(columnList);
        }
        return rowList;
    }

    protected PdfPCell createCellAndAddStyle(String tdTag, BorderAttr parentBorderAttr, int rowIndex) {
        String[] strArr;
        PdfPCell cell = new PdfPCell();
        BorderAttr childBorderAttr = null;
        if (tdTag.contains("style")) {
            Matcher styleMatch = StyleExtractor.stylePattern.matcher(tdTag);
            String styleAttr = "";
            if (styleMatch.find()) {
                styleAttr = styleMatch.group();
            }
            String[] styleArr = styleAttr.split("=");
            String styles = styleArr[1].replace("\"", "").trim();
            List styleDetails = Arrays.asList((Object[])styles.split(";"));
            for (String styleDetail : styleDetails) {
                String[] styleContents = styleDetail.split(":");
                String key = styleContents[0].trim();
                String val = styleContents[1].trim();
                if (key.equalsIgnoreCase("background")) {
                    String[] rgb = StyleExtractor.getRGBArr(val);
                    cell.setBackgroundColor(new Color(Integer.parseInt(rgb[0].trim()), Integer.parseInt(rgb[1].trim()), Integer.parseInt(rgb[2].trim())));
                    continue;
                }
                if ("width".equals(key) && rowIndex == 0) {
                    if (val.contains("%")) {
                        this.cellWidthArr[this.columnIndex] = Float.parseFloat(val.replace("%", ""));
                        continue;
                    }
                    if (!val.contains("px")) continue;
                    this.cellWidthPxArr[this.columnIndex] = Integer.parseInt(val.replace("px", ""));
                    this.borderWidthFlag = false;
                    continue;
                }
                if ("height".equals(key)) {
                    cell.setFixedHeight(Float.parseFloat(val.replace("px", "")));
                    continue;
                }
                if ("text-align".equals(key)) {
                    if ("left".equalsIgnoreCase(val)) {
                        cell.setHorizontalAlignment(0);
                        continue;
                    }
                    if ("right".equalsIgnoreCase(val)) {
                        cell.setHorizontalAlignment(2);
                        continue;
                    }
                    if ("center".equalsIgnoreCase(val)) {
                        cell.setHorizontalAlignment(1);
                        continue;
                    }
                    if (!"justify".equalsIgnoreCase(val)) continue;
                    cell.setHorizontalAlignment(3);
                    continue;
                }
                if ("vertical-align".equals(key)) {
                    if ("top".equalsIgnoreCase(val)) {
                        cell.setVerticalAlignment(4);
                        continue;
                    }
                    if ("bottom".equalsIgnoreCase(val)) {
                        cell.setVerticalAlignment(6);
                        continue;
                    }
                    if (!"middle".equalsIgnoreCase(val)) continue;
                    cell.setVerticalAlignment(5);
                    continue;
                }
                if ("border-color".equals(key)) {
                    childBorderAttr = childBorderAttr == null ? new BorderAttr() : childBorderAttr;
                    childBorderAttr.setBorderColor(val);
                    continue;
                }
                if ("border-style".equals(key)) {
                    childBorderAttr = childBorderAttr == null ? new BorderAttr() : childBorderAttr;
                    childBorderAttr.setBorderStyle(val);
                    continue;
                }
                if ("border-width".equals(key)) {
                    childBorderAttr = childBorderAttr == null ? new BorderAttr() : childBorderAttr;
                    childBorderAttr.setBorderWidth(Float.parseFloat(val.replace("px", "")));
                    continue;
                }
                if (!"border".equals(key)) continue;
                childBorderAttr = childBorderAttr == null ? new BorderAttr() : childBorderAttr;
                String[] borderAttrArr = val.split(" ");
                if (borderAttrArr.length == 3) {
                    childBorderAttr.setBorderWidth(Float.parseFloat(borderAttrArr[0].replace("px", "").replace("pt", "")));
                    childBorderAttr.setBorderStyle(borderAttrArr[0].trim());
                    childBorderAttr.setBorderColor(borderAttrArr[1].trim());
                    continue;
                }
                if (!"none".equals(val)) continue;
                childBorderAttr.setBorderStyle("none");
            }
            tdTag = tdTag.replace(styleAttr, "");
        }
        ++this.columnIndex;
        childBorderAttr = this.mergeBorderStyle(parentBorderAttr, childBorderAttr);
        this.setCellBorderStyle(childBorderAttr, cell);
        for (String str : strArr = tdTag.split(" ")) {
            int colspan;
            String[] otherAttrs = str.split("=");
            if (otherAttrs.length == 1) continue;
            String val = otherAttrs[1].replace("\"", "").replace(">", "").trim();
            if (str.contains("valign")) {
                if ("top".equalsIgnoreCase(val)) {
                    cell.setVerticalAlignment(4);
                    continue;
                }
                if ("bottom".equalsIgnoreCase(val)) {
                    cell.setVerticalAlignment(6);
                    continue;
                }
                if ("left".equalsIgnoreCase(val)) {
                    cell.setHorizontalAlignment(0);
                    continue;
                }
                if ("right".equalsIgnoreCase(val)) {
                    cell.setHorizontalAlignment(2);
                    continue;
                }
                if (!"center".equalsIgnoreCase(val)) continue;
                cell.setHorizontalAlignment(1);
                cell.setVerticalAlignment(5);
                continue;
            }
            if (str.contains("colspan")) {
                colspan = Integer.parseInt(val);
                cell.setColspan(colspan);
                if (rowIndex != 0) continue;
                for (int i = 0; i < colspan - 1; ++i) {
                    this.cellWidthArr[this.columnIndex + i] = 0.0f;
                    this.cellWidthPxArr[this.columnIndex + i] = 0;
                }
                this.columnIndex += colspan - 1;
                continue;
            }
            if (!str.contains("rowspan")) continue;
            colspan = Integer.parseInt(val);
            cell.setRowspan(colspan);
        }
        return cell;
    }

    private void setCellBorderStyle(BorderAttr borderAttr, PdfPCell cell) {
        int[] rgb;
        String borderColor;
        if (null == borderAttr) {
            return;
        }
        String lineStyle = borderAttr.getBorderStyle();
        if (null != lineStyle) {
            if ("hidden".equals(lineStyle) || "none".equals(lineStyle)) {
                cell.setBorder(0);
            } else {
                cell.setBorder(15);
            }
        }
        if (null != (borderColor = borderAttr.getBorderColor()) && (rgb = StyleExtractor.hex2RGB(borderColor)) != null) {
            cell.setBorderColor(new Color(rgb[0], rgb[1], rgb[2]));
        }
        if (borderAttr.getBorderWidth() > 0.0f) {
            cell.setBorderWidth(borderAttr.getBorderWidth());
        }
    }

    private BorderAttr mergeBorderStyle(BorderAttr parentBorderAttr, BorderAttr childBorderAttr) {
        if (null == childBorderAttr) {
            return parentBorderAttr;
        }
        if (null == parentBorderAttr) {
            return childBorderAttr;
        }
        if (null == childBorderAttr.getBorderStyle()) {
            childBorderAttr.setBorderStyle(parentBorderAttr.getBorderStyle());
        }
        if (null == childBorderAttr.getBorderColor()) {
            childBorderAttr.setBorderColor(parentBorderAttr.getBorderColor());
        }
        if (childBorderAttr.getBorderWidth() < 0.0f) {
            childBorderAttr.setBorderWidth(parentBorderAttr.getBorderWidth());
        }
        return childBorderAttr;
    }

    protected BorderAttr addTableStyle(PdfPTable table, String content) {
        String[] strArr;
        Matcher styleMatcher = StyleExtractor.stylePattern.matcher(content);
        table.setHorizontalAlignment(0);
        BorderAttr borderAttr = null;
        if (styleMatcher.find()) {
            String[] styles;
            String style = styleMatcher.group();
            String styleContent = style.split("=")[1].replaceAll("\"", "");
            for (String css : styles = styleContent.split(";")) {
                if (!css.contains(":")) continue;
                String[] entry = css.split(":");
                String key = entry[0].trim();
                String value = entry[1].trim();
                if ("width".equalsIgnoreCase(key)) {
                    if (value.contains("px")) {
                        table.setTotalWidth(Float.parseFloat(value.replace("px", "")));
                        continue;
                    }
                    if (!value.contains("%")) continue;
                    table.setWidthPercentage(Float.parseFloat(value.replace("%", "")));
                    continue;
                }
                if ("float".equalsIgnoreCase(key)) {
                    if (value.equalsIgnoreCase("left")) {
                        table.setHorizontalAlignment(0);
                        continue;
                    }
                    if (!value.equalsIgnoreCase("right")) continue;
                    table.setHorizontalAlignment(2);
                    continue;
                }
                if ("margin-left".equalsIgnoreCase(key) || "margin-right".equalsIgnoreCase(key)) {
                    if (!value.equalsIgnoreCase("auto")) continue;
                    table.setHorizontalAlignment(1);
                    continue;
                }
                if ("border-color".equalsIgnoreCase(key)) {
                    borderAttr = borderAttr == null ? new BorderAttr() : borderAttr;
                    borderAttr.setBorderColor(value);
                    continue;
                }
                if (!"border-style".equalsIgnoreCase(key)) continue;
                borderAttr = borderAttr == null ? new BorderAttr() : borderAttr;
                borderAttr.setBorderStyle(value);
            }
        }
        for (String str : strArr = content.split(" ")) {
            if (str.contains("cellspacing")) {
                String[] cellSpacingArr = str.split("=");
                String cellSpacing = cellSpacingArr[1].replace("\"", "").replace(">", "");
                table.setSpacingBefore(Float.parseFloat(cellSpacing));
                continue;
            }
            if (!str.equals("border")) continue;
            String[] borderWidthArr = str.split("=");
            String borderWidth = borderWidthArr[1].replace("\"", "").replace(">", "");
            borderAttr = borderAttr == null ? new BorderAttr() : borderAttr;
            borderAttr.setBorderWidth(Float.parseFloat(borderWidth));
        }
        return borderAttr;
    }
}

