/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util.timepiece;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.app.timepiece.externaldata.FieldType;
import com.kingdee.shr.compensation.app.timepiece.externaldata.InputType;
import com.kingdee.shr.compensation.app.timepiece.externaldata.vo.ConfigEntry;
import com.kingdee.shr.compensation.app.timepiece.externaldata.vo.ConfigInfo;
import com.kingdee.shr.validaterule.CmpItemDataType;
import com.kingdee.shr.validaterule.util.EntityUtil;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;

public class ExternalConfigUtil {
    public static String getResoureString(Context ctx, String key) {
        return EASResource.getString((String)"com.kingdee.shr.compensation.app.timepiece.externaldata.ExternalDataConfigResource", (String)key, (Locale)ctx.getLocale());
    }

    public static Map<String, ConfigInfo> initExtDataConfig(Context ctx, Set<String> configSchemes) throws BOSException, SQLException {
        return ExternalConfigUtil.initExtDataConfig(ctx, configSchemes, "FNUMBER");
    }

    private static Map<String, ConfigInfo> initExtDataConfig(Context ctx, Set<String> configSchemes, String conditionField) throws BOSException, SQLException {
        HashMap schemeMap = Maps.newHashMap();
        StringBuilder queryConfigSql = new StringBuilder();
        String initConfigSql = ExternalConfigUtil.getInitConfigSql();
        queryConfigSql.append(initConfigSql);
        queryConfigSql.append(" and  extC.").append(conditionField).append(" in (");
        boolean isFirst = false;
        for (String schemeNum : configSchemes) {
            if (isFirst) {
                queryConfigSql.append(",");
            } else {
                isFirst = true;
            }
            queryConfigSql.append("?");
        }
        queryConfigSql.append(")");
        Object[] schemeParams = configSchemes.toArray();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)queryConfigSql.toString(), (Object[])schemeParams);
        while (rowSet.next()) {
            ConfigInfo configInfo;
            String extcnumber = rowSet.getString("EXTCNUMBER");
            String extcentity = rowSet.getString("EXTCENTITY");
            String configId = rowSet.getString("configId");
            if (schemeMap.containsKey(extcnumber)) {
                configInfo = (ConfigInfo)schemeMap.get(extcnumber);
            } else {
                configInfo = new ConfigInfo();
                configInfo.setScheme(extcnumber);
                configInfo.setEntity(extcentity);
                configInfo.setConfigId(configId);
            }
            ExternalConfigUtil.assembleConfigEntry(ctx, configInfo, rowSet);
            schemeMap.put(extcnumber, configInfo);
        }
        return schemeMap;
    }

    public static ConfigInfo initExtDataConfig(Context ctx, String configId) throws BOSException, SQLException {
        Map<String, ConfigInfo> configInfoMap = ExternalConfigUtil.initExtDataConfig(ctx, Sets.newHashSet((Object[])new String[]{configId}), "FID");
        AtomicReference configInfo = new AtomicReference();
        configInfoMap.forEach((number, info) -> configInfo.set(info));
        return (ConfigInfo)configInfo.get();
    }

    private static void assembleConfigEntry(Context ctx, ConfigInfo configInfo, IRowSet rowSet) throws SQLException {
        ConfigEntry configEntry = new ConfigEntry();
        int extcefieldtype = rowSet.getInt("EXTCEFIELDTYPE");
        int extcedatatype = rowSet.getInt("EXTCEDATATYPE");
        int extcerequired = rowSet.getInt("EXTCEREQUIRED");
        boolean required = 1 == extcerequired;
        String extecdbname = rowSet.getString("EXTECDBNAME");
        String extcename = rowSet.getString("EXTCENAME");
        String sccnumber = rowSet.getString("SCCNUMBER");
        String scnumber = rowSet.getString("SCNUMBER");
        String scentity = rowSet.getString("SCENTITY");
        int inputType = rowSet.getInt("FInputType");
        int index = rowSet.getInt("findex");
        configEntry.setName(extcename);
        configEntry.setDbName(extecdbname);
        configEntry.setRequired(required);
        configEntry.setFieldType(FieldType.getEnum((int)extcefieldtype));
        configEntry.setDataType(CmpItemDataType.getEnum((int)extcedatatype));
        configEntry.setStructureNumber(scnumber);
        configEntry.setStructureEntity(scentity);
        configEntry.setStructureColumnNumber(sccnumber);
        configEntry.setInputType(InputType.getEnum((int)inputType));
        configEntry.setIndex(index);
        String enumSource = rowSet.getString("FEnumSource");
        if (!StringUtils.isEmpty((String)enumSource)) {
            configEntry.setEnum(true);
            configEntry.setEnumSource(enumSource);
        }
        if (!StringUtils.isEmpty((String)scentity) && !StringUtils.isEmpty((String)sccnumber)) {
            PropertyInfo propertyInfo = EntityUtil.getPropertyInfo((Context)ctx, (String)scentity, (String)sccnumber);
            ColumnInfo mappingField = propertyInfo.getMappingField();
            String tempDb = mappingField.getName();
            boolean multilingual = mappingField.isMultilingual();
            if (multilingual) {
                tempDb = tempDb + "_" + LocaleUtils.getShortCode((Context)ctx).toUpperCase(Locale.ENGLISH);
            }
            configEntry.setStructureColDbName(tempDb);
            String entityTableName = EntityUtil.getEntityTableName((Context)ctx, (String)scentity);
            configEntry.setStructureEntityTable(entityTableName);
        }
        configInfo.addEntry(configEntry);
    }

    private static String getInitConfigSql() {
        StringBuilder queryConfigSql = new StringBuilder();
        queryConfigSql.append(" SELECT ");
        queryConfigSql.append(" extC.FID configId,extc.fnumber EXTCNUMBER,extc.fentity EXTCENTITY,extce.FInputType, ");
        queryConfigSql.append(" extce.FieldType EXTCEFIELDTYPE,extce.FDataType EXTCEDATATYPE,extce.FRequired EXTCEREQUIRED, ");
        queryConfigSql.append(" extce.fdbName EXTECDBNAME,extce.fsimplename EXTCENAME,extCE.findex, ");
        queryConfigSql.append(" scc.FNUMBER SCCNUMBER,SCC.FDataType SCCDATATYPE,SCC.FEnumSource, ");
        queryConfigSql.append(" sc.FCLIENTNUMBER SCNUMBER,sc.FENTITYNAME SCENTITY ");
        queryConfigSql.append(" FROM T_HR_SExtDataConfig extC ");
        queryConfigSql.append(" inner join T_HR_SExtDataConfigEntry extCE on extC.fid = extCE.fbillId ");
        queryConfigSql.append(" left join T_HR_QueryConfigField QCF on extCE.FQUERYFIELDID = QCF.FID  ");
        queryConfigSql.append(" left join T_HR_StructureConfigColumns SCC on QCF.FFACTFIELDID = SCC.FID  ");
        queryConfigSql.append(" left join T_HR_StructureConfig SC on SCC.FSTRUCTURECONFIGID = SC.FID  ");
        queryConfigSql.append(" left join T_HR_SCalSubmitItem CSI on extCE.FQUERYFIELDID = CSI.FID  ");
        queryConfigSql.append(" where ");
        queryConfigSql.append(" extc.fentity is not null ");
        queryConfigSql.append(" and extc.fstate = 1 ");
        return queryConfigSql.toString();
    }
}

