/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util.timepiece;

import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.BaseItemStateEnum;
import com.kingdee.shr.compensation.app.timepiece.scheme.TimepieceSchemeCollection;
import com.kingdee.shr.compensation.app.timepiece.scheme.TimepieceSchemeFactory;
import com.kingdee.shr.compensation.app.timepiece.scheme.TimepieceSchemeInfo;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TimepieceSchemeUtils {
    private static Logger logger = Logger.getLogger(TimepieceSchemeUtils.class);

    public static String getSubmitSchemeId(Context ctx, String timepieceSchemeId) {
        String submitSchemeId = null;
        String sql = "SELECT FSubmitSchemeID  FROM T_HR_STimepieceScheme WHERE FID =  ? ";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{timepieceSchemeId});
            while (rs.next()) {
                submitSchemeId = rs.getString("FSubmitSchemeID");
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return submitSchemeId;
    }

    public static List<String> getSubmitSchemeIds(Context ctx, String adminOrgRangeSql, String hrOrgUnitRangeSQL, int schemeType) {
        ArrayList<String> ids = new ArrayList<String>();
        try {
            Set<String> hrOrgNumbers = TimepieceSchemeUtils.getHRORangeNumbers(ctx, hrOrgUnitRangeSQL);
            CmpInSql<String> inSqlObject = CmpInSqlFactory.getInstance();
            String inSql = inSqlObject.createInSqlBaseOnFNumber(ctx, hrOrgNumbers);
            String includePermSql = "select FID from T_ORG_HRO where FNUMBER in " + inSql;
            String sql = "SELECT fid  FROM T_HR_SCalSubmitScheme  WHERE FSubmitSchemeType =  " + schemeType + " and (FHrOrgUnitID in (" + hrOrgUnitRangeSQL + ") or FHrOrgUnitID in (" + includePermSql + ") and FIncludeSub = 1) and ( FAdminOrgUnitID in (" + adminOrgRangeSql + ") or FAdminOrgUnitID is null )";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                ids.add(rs.getString("fid"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return ids;
    }

    public static Set<String> getHRORangeNumbers(Context ctx, String hroRangeSql) {
        HashSet<String> result = new HashSet<String>();
        String sql = "select FLongNumber from T_ORG_hro where fid in (" + hroRangeSql + ")";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                String temp = rowSet.getString("FLongNumber");
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)temp)) continue;
                String[] number = temp.split("!");
                result.addAll(Arrays.asList(number));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return result;
    }

    public static Map<String, Object> getRequiredColumns(Context ctx, String submitSchemeIdWhereSql, boolean needEnableData) throws BOSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList colNames = new ArrayList();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)submitSchemeIdWhereSql)) {
            return map;
        }
        String language = ctx.getLocale().getLanguage();
        String sql = "Select e.FSubmitTarget , m.fieldSn,m.fdataType,m.fname_" + language + " MNAME,n.FBillEntryTableName ,n.FCalShemeTableName ,t.FIsRequired,t.fstate state from  T_HR_SCalSubmitScheme e  inner join  T_HR_SCalSubmitSchemeItem t on t.FCalSubmitSchemeID = e.fid  inner join T_HR_SCalSubmitItem m on  m.fid = t.FCalSubmitItemID  inner join T_HR_SCalShemeTableRelation n on n.FSubmitSchemeID =e.fid   where e.fid in  " + submitSchemeIdWhereSql;
        if (needEnableData) {
            sql = sql + "and t.fstate = 1 ";
        }
        sql = sql + " order by t.FSortSn asc ";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            HashSet<String> set = new HashSet<String>();
            while (rs.next()) {
                HashMap<String, String> gridIdMap = new HashMap<String, String>();
                String fieldSn = rs.getString("fieldSn");
                if (set.contains(fieldSn)) continue;
                gridIdMap.put("rename", rs.getString("MNAME"));
                gridIdMap.put("name", "CMP_SMT002.S" + fieldSn);
                gridIdMap.put("label", rs.getString("MNAME"));
                gridIdMap.put("type", "String");
                set.add(fieldSn);
                colNames.add(gridIdMap);
            }
            map.put("colNames", colNames);
        }
        catch (Exception e) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitShemeBillResource", (String)"label10", (Locale)ctx.getLocale()));
        }
        return map;
    }

    public static Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    public static String checkItemIfExistTimepieceSum(Context ctx, String itemId, String submitSchemeId) {
        StringBuilder stringBuilder;
        block9: {
            String language = ctx.getLocale().getLanguage();
            String sqlItem = "select calscheme.fname_" + language + " as name from  T_HR_SCalSubmitScheme calscheme  inner join  T_HR_STimepieceScheme scheme on calscheme.fid = scheme.FSubmitSchemeID   inner join  T_HR_SumItemConfig config on scheme.fid = config.FTimepieceScheme   inner join  T_HR_SumDimension t on config.fid = t.FSumItemConfig   where t.FDimensionID  = '" + itemId + "'  and calscheme. fid ='" + submitSchemeId + "'";
            String sqlentryItem = "select calscheme.fname_" + language + " as name from  T_HR_SCalSubmitScheme calscheme  inner join  T_HR_STimepieceScheme scheme on calscheme.fid = scheme.FSubmitSchemeID   inner join  T_HR_SumItemConfig config on scheme.fid = config.FTimepieceScheme   inner join  T_HR_SumItemConfigEntry t on config.fid = t.FSumItemConfigID   where t.FAccSubmitItemValID ='" + itemId + "' and scheme.FSubmitSchemeID='" + submitSchemeId + "' ";
            stringBuilder = new StringBuilder();
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlItem);
                int count = 0;
                while (rs.next()) {
                    if (count >= 10) {
                        stringBuilder.append(rs.getString("\u2026\u2026"));
                        break;
                    }
                    stringBuilder.append(rs.getString("name"));
                    ++count;
                }
                if (count >= 10) break block9;
                rs = DbUtil.executeQuery((Context)ctx, (String)sqlentryItem);
                while (rs.next()) {
                    if (count >= 10) {
                        stringBuilder.append(rs.getString("\u2026\u2026"));
                        break;
                    }
                    if (count == 0) {
                        stringBuilder.append(rs.getString("name"));
                    } else if (count <= 9) {
                        stringBuilder.append(",").append(rs.getString("name"));
                    }
                    ++count;
                }
            }
            catch (BOSException | SQLException e) {
                throw new RuntimeException(e);
            }
        }
        return stringBuilder.toString();
    }

    public static String checkItemIfExistOutConfigDimension(Context ctx, String itemId, String schemeId) {
        String language = ctx.getLocale().getLanguage();
        String sqlItem = "select con.fname_" + language + " name from T_HR_STimepieceScheme scheme inner join  T_HR_SchemeOutDataConfig out on scheme.fid = out.FtimepieceSchemeid  inner join T_HR_SExtDataConfig con on con.fid = out.FexternalDataConfigId  inner join  T_HR_SchemeODConfigDimension  n on out.fid = n.fschemeOutDataConfigid   inner join T_HR_SExtDataConfigEntry entry on n.fdimensionid = entry.fid where entry.FQueryFieldID  ='" + itemId + "' and  scheme.FSubmitSchemeID ='" + schemeId + "' ";
        StringBuilder stringBuilder = new StringBuilder();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlItem);
            int count = 0;
            while (rs.next()) {
                if (count >= 10) {
                    stringBuilder.append(rs.getString("\u2026\u2026"));
                    break;
                }
                if (count == 0) {
                    stringBuilder.append(rs.getString("name"));
                } else if (count <= 9) {
                    stringBuilder.append(",").append(rs.getString("name"));
                }
                ++count;
            }
        }
        catch (BOSException | SQLException e) {
            throw new RuntimeException(e);
        }
        return stringBuilder.toString();
    }

    public static void getSubmitSchemeIdsByState(Context ctx, BaseItemStateEnum stateEnum, String billId, Set<String> idSet, Set<String> existsSubmitItemIdSet) {
        String billInSql = CmpStrUtil.buildInSql(billId);
        if (existsSubmitItemIdSet == null) {
            existsSubmitItemIdSet = new HashSet<String>();
        }
        if (idSet == null) {
            idSet = new HashSet<String>();
        }
        String sql = " SELECT scheme.FID FROM T_HR_STimepieceScheme tt  inner join  T_HR_SCalSubmitScheme scheme on  scheme.Fid =tt.FSubmitSchemeID  where tt.Fid in " + billInSql + " and scheme.FState=" + stateEnum.getValue();
        if (1 == stateEnum.getValue()) {
            sql = " SELECT scheme.FID FID,subItem.FID subItemId FROM T_HR_STimepieceScheme tt  inner join T_HR_SCalSubmitScheme scheme on  scheme.Fid =tt.FSubmitSchemeID left join T_HR_SCalSubmitSchemeItem subItem on subItem.FCalSubmitSchemeID = scheme.FID where tt.Fid in " + billInSql + " and scheme.FState=" + 2;
        }
        try {
            IRowSet iRowSet = CmpSQLUtil.executeQuery(ctx, sql);
            if (iRowSet.size() == 0) {
                return;
            }
            while (iRowSet.next()) {
                String subItemId;
                String schemeId = iRowSet.getString("FID");
                if (1 == stateEnum.getValue() && !StringUtils.isEmpty((String)(subItemId = iRowSet.getString("subItemId")))) {
                    existsSubmitItemIdSet.add(schemeId);
                }
                idSet.add(schemeId);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static List getNoCalBill(Context ctx, String idfilter) {
        ArrayList<String> list = new ArrayList<String>();
        String sql = "select fbillid from T_HR_TimepieceBillEntry entry where  fentrycalstatus = '0' and  entry.fbillid in " + idfilter;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                list.add(rs.getString("fbillid"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return list;
    }

    public static Map<String, String> getBillIdMap(Context ctx, String billId) {
        HashMap<String, String> idsMap = new HashMap<String, String>();
        try {
            Object[] ids = billId.split(",");
            CmpInSql inSql = CmpInSqlFactory.getInstance();
            String idfilter = inSql.createInSql(ctx, ids, "'", "T_HR_STimepieceScheme", "fid");
            TimepieceSchemeCollection timepieceSchemeCollection = TimepieceSchemeFactory.getLocalInstance((Context)ctx).getTimepieceSchemeCollection("  where id in " + idfilter + " ");
            for (int i = 0; i < timepieceSchemeCollection.size(); ++i) {
                TimepieceSchemeInfo info = timepieceSchemeCollection.get(i);
                idsMap.put(info.getId().toString(), info.getSubmitScheme().getId().toString());
            }
        }
        catch (BOSException e) {
            throw new RuntimeException(e);
        }
        return idsMap;
    }

    public static List<String> getSubmitSchemeFormulaItem(Context ctx, String fsubmitSchemeId) {
        ArrayList<String> ids = new ArrayList<String>();
        String sql = "select FCalItem from T_HR_SBaseFormula f  inner join  T_HR_SBusinessRelationConfig  config on config.fid = f.FBusinessRelationConfigID  inner join  T_HR_SCalSubmitScheme scheme on scheme.fid = config.FBusinessId   where f.FIsCal =1 AND  scheme.fid ='" + fsubmitSchemeId + "'";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                ids.add(rs.getString("FCalItem"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return ids;
    }

    public static FilterInfo getParentHroTimepieceScheme(Context ctx, String hrOrgUnitRange) {
        FilterInfo filterInfo = new FilterInfo();
        if (StringUtils.isEmpty((String)hrOrgUnitRange)) {
            return filterInfo;
        }
        String querySql = "select flongnumber from T_ORG_HRO where fid in(" + hrOrgUnitRange + ")";
        HashSet longNumberSet = Sets.newHashSet();
        IRowSet rowSet = null;
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql);
            while (rowSet.next()) {
                String longNUMBER = rowSet.getString("FLongNUMBER");
                String[] split = longNUMBER.split("!");
                StringBuilder tempLongNumber = new StringBuilder();
                for (int i = 0; i < split.length - 1; ++i) {
                    String number = split[i];
                    if (i > 0) {
                        tempLongNumber.append("!");
                    }
                    tempLongNumber.append(number);
                    longNumberSet.add(tempLongNumber.toString());
                }
            }
        }
        catch (BOSException | SQLException e) {
            throw new RuntimeException(e);
        }
        querySql = "select fid from T_ORG_HRO where FLongNumber in ('" + org.apache.commons.lang3.StringUtils.join((Iterable)longNumberSet, (String)"','") + "')";
        HashSet idSet = Sets.newHashSet();
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql);
            while (rowSet.next()) {
                String fid = rowSet.getString("fid");
                idSet.add(fid);
            }
        }
        catch (BOSException | SQLException e) {
            throw new RuntimeException(e);
        }
        FilterInfo filter = new FilterInfo();
        String sql = "select fid from T_HR_SCalSubmitScheme where FHrOrgUnitID in (" + hrOrgUnitRange + ")union all select fid from T_HR_SCalSubmitScheme where FHrOrgUnitID in ('" + org.apache.commons.lang3.StringUtils.join((Iterable)idSet, (String)"','") + "') and fincludeSub = 1";
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
        return filter;
    }
}

