/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CmpAccountBillPersonRecordCollection;
import com.kingdee.shr.compensation.CmpAccountBillPersonRecordInfo;
import com.kingdee.shr.compensation.CmpItemAccountBillCollection;
import com.kingdee.shr.compensation.CmpItemAccountBillEntryCollection;
import com.kingdee.shr.compensation.CmpItemAccountBillEntryFactory;
import com.kingdee.shr.compensation.CmpItemAccountBillEntryInfo;
import com.kingdee.shr.compensation.CmpItemAccountBillFactory;
import com.kingdee.shr.compensation.CmpItemAccountBillInfo;
import com.kingdee.shr.compensation.CmpItemAccountBillRecordCollection;
import com.kingdee.shr.compensation.CmpItemAccountBillRecordInfo;
import com.kingdee.shr.compensation.CmpItemAccountBillRecordMlCurrencyFactory;
import com.kingdee.shr.compensation.CmpItemAccountCollection;
import com.kingdee.shr.compensation.CmpItemAccountEntryInfo;
import com.kingdee.shr.compensation.CmpItemAccountInfo;
import com.kingdee.shr.compensation.CmpItemCollection;
import com.kingdee.shr.compensation.CmpItemFactory;
import com.kingdee.shr.compensation.CmpItemInfo;
import com.kingdee.shr.compensation.CmpItemRecordInfo;
import com.kingdee.shr.compensation.CostBearBillType;
import com.kingdee.shr.compensation.CostBearCalSchemeFactory;
import com.kingdee.shr.compensation.CostBearCalSchemeInfo;
import com.kingdee.shr.compensation.CostBearCalSchemeRecordCollection;
import com.kingdee.shr.compensation.CostBearCalSchemeRecordFactory;
import com.kingdee.shr.compensation.CostBearCalSchemeRecordInfo;
import com.kingdee.shr.compensation.CostBearStateEnum;
import com.kingdee.shr.compensation.GenerVoucherStateEnum;
import com.kingdee.shr.compensation.OptionalFieldFactory;
import com.kingdee.shr.compensation.SubmitBillState;
import com.kingdee.shr.compensation.app.AbstractCostBearCalSchemeControllerBean;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CostBearCalSchemeControllerBean
extends AbstractCostBearCalSchemeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.CostBearCalSchemeControllerBean");
    protected String insertSql = "insert into T_HR_CmpItemAccountBillRecordM (FID, FCmpItemAccountBillRecordID, FCaltableItemAmount, FCommitmentItemCurrencyID, FCommitmentItemAmount, FExchangeRate, FAccountBillID)  values(newbosid('A8E53ADE'), ?, ?, ?, ?, ?, ?)";

    @Override
    protected boolean _updateCmpItemAccountBill(Context ctx, String accountBillIds) throws BOSException {
        return false;
    }

    @Override
    protected boolean _createCmpItemAccountBill(Context ctx, Map map) throws BOSException, EASBizException {
        Date businessDate = (Date)map.get("businessDate");
        Date recordDate = (Date)map.get("recordDate");
        Date matureDate = (Date)map.get("matureDate");
        CalSchemeInfo calSchemeInfo = (CalSchemeInfo)map.get("calSchemeInfo");
        CmpItemAccountCollection accountColl = (CmpItemAccountCollection)((Object)map.get("accountColl"));
        this.saveItemAccountDetails(ctx, accountColl, calSchemeInfo);
        CoreBaseCollection billColl = (CoreBaseCollection)map.get("billColl");
        CmpItemAccountBillFactory.getLocalInstance(ctx).saveBatchData(billColl);
        CoreBaseCollection costBearCalSchemeCollection = this.assembleCostBearCalScheme(ctx, calSchemeInfo, billColl, businessDate, recordDate, matureDate);
        CostBearCalSchemeFactory.getLocalInstance(ctx).saveBatchData(costBearCalSchemeCollection);
        CostBearCalSchemeRecordInfo recordInfo = this.addCostBearCalSchemeRecord(ctx, calSchemeInfo, billColl, accountColl);
        this.updateCostBealMlAccoutBill(ctx, calSchemeInfo);
        this.addCmpItemAccountBillRecordMl(ctx, calSchemeInfo, billColl);
        boolean isAllGenerated = this.isAllGenerated(ctx, calSchemeInfo);
        if (isAllGenerated) {
            recordInfo.setCostBearState(CostBearStateEnum.ALL);
        } else {
            recordInfo.setCostBearState(CostBearStateEnum.PART);
        }
        SelectorItemCollection udpSelector = new SelectorItemCollection();
        udpSelector.add("costBearState");
        CostBearCalSchemeRecordFactory.getLocalInstance(ctx).updatePartial(recordInfo, udpSelector);
        return true;
    }

    @Override
    protected boolean _deleteCmpItemAccountBill(Context ctx, Map map) throws BOSException, EASBizException {
        String billId = (String)map.get("billIds");
        String billNumber = (String)map.get("billNumbers");
        String billSchemeId = (String)map.get("billSchemeIds");
        List optionalIdList = (List)map.get("optionalIdList");
        List calSchemeInfoList = (List)map.get("calSchemeInfoList");
        String deleteCostBearRecord = "delete from T_HR_CostBearCalSchemeRecord where FCalSchemeID  in ('" + billSchemeId + "') and FCmpItemAccoutBills in ('" + billNumber + "')";
        String deleteBillEntry = "delete from T_HR_SCmpItemAccountBillentry where FCmpItemAccountBillID in ('" + billId + "')";
        String deleteBill = "delete from T_HR_SCmpItemAccountBill where fid in ('" + billId + "')";
        DbUtil.execute((Context)ctx, (String)deleteBillEntry);
        DbUtil.execute((Context)ctx, (String)deleteBill);
        DbUtil.execute((Context)ctx, (String)deleteCostBearRecord);
        this.updateCostBearReport(ctx, calSchemeInfoList);
        this.deleteCostBearCalScheme(ctx, billId);
        this.deleteCostBearMlCurrency(ctx, calSchemeInfoList, billId);
        this.updateCostBearCalSchemeRecord(ctx, calSchemeInfoList);
        this.deleteCmpItemAccountBillRecordMlCurrency(ctx, billId);
        if (optionalIdList != null && !optionalIdList.isEmpty()) {
            this.deleteOptionalField(ctx, CmpStrUtil.join(optionalIdList, "','", null));
        }
        return true;
    }

    protected List<String> getCmpItems(CmpItemAccountInfo itemAccountInfo) {
        ArrayList<String> cmpItemList = new ArrayList<String>();
        if (itemAccountInfo == null || itemAccountInfo.getEntries() == null || itemAccountInfo.getEntries().isEmpty()) {
            return cmpItemList;
        }
        for (int i = 0; i < itemAccountInfo.getEntries().size(); ++i) {
            CmpItemAccountEntryInfo entryInfo = itemAccountInfo.getEntries().get(i);
            if (entryInfo == null || entryInfo.getCmpItemRecords() == null) continue;
            for (int n = 0; n < entryInfo.getCmpItemRecords().size(); ++n) {
                CmpItemRecordInfo cmpItemRecord = entryInfo.getCmpItemRecords().get(n);
                if (cmpItemRecord.getCmpItem() == null || cmpItemRecord.getCmpItem().getId() == null) continue;
                String cmpItemId = cmpItemRecord.getCmpItem().getId().toString();
                cmpItemList.add(cmpItemId);
            }
        }
        return cmpItemList;
    }

    protected String getCostBearDataTempTab(Context ctx, String itemAccountId, String company, String cmpItemIdSql, CalSchemeInfo calSchemeInfo) throws BOSException {
        String calSchemeId = calSchemeInfo.getId() == null ? "" : calSchemeInfo.getId().toString();
        String tempTableName = null;
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        StringBuilder selectCostBearSql = new StringBuilder();
        selectCostBearSql.append("select cost.FCostBearOrgID, cost.FCostBearOrgUnitID, cost.FCalOrgUnitID, cost.FHrOrgUnitID, cost.FAdminOrgID, cost.FCalSchemeID, cost.FCmpPeriodID, cost.FCmpItemID, cost.FPersonID, cost.FBearMoney, cost.FCostMoney,");
        selectCostBearSql.append(" cost.FCalTime, cost.FPeriodYear, cost.FPeriodMonth, cost.FCreatorID, cost.FCreateTime, cost.FLastUpdateUserID, cost.FLastUpdateTime, cost.FControlUnitID, cost.FCostValue, cost.FBearValue, cost.FCostBearPerc, ");
        selectCostBearSql.append(" cost.FCmpCalTableId, cost.FAccountBillID, ");
        selectCostBearSql.append(" caltable.FCurrencyID as FCalTableItemCurrencyID, ");
        selectCostBearSql.append(" isnull(cost.FBearMoney, 0) as FCalTableItemAmount, ");
        selectCostBearSql.append(" case when cost.FCommitmentCurrencyID is null then (case when acct.FCommitmentCurrencyID is null then caltable.FCurrencyID else acct.FCommitmentCurrencyID end )  else cost.FCommitmentCurrencyID end as FCommitmentItemCurrencyID, ");
        selectCostBearSql.append(" isnull(cost.FBearMoney, 0) * (case when caltable.FCurrencyID = (case when cost.FCommitmentCurrencyID is null then (case when acct.FCommitmentCurrencyID is null then caltable.FCurrencyID else acct.FCommitmentCurrencyID end )  else cost.FCommitmentCurrencyID end) then 1 else  rate.FConvertRate end) as FCommitmentItemAmount, ");
        selectCostBearSql.append(" case when caltable.FCurrencyID = (case when cost.FCommitmentCurrencyID is null then (case when acct.FCommitmentCurrencyID is null then caltable.FCurrencyID else acct.FCommitmentCurrencyID end )  else cost.FCommitmentCurrencyID end) then 1 else  rate.FConvertRate end as FExchangeRate, ");
        selectCostBearSql.append(" unitRe.FToUnitID as FFinanceOrgUnitID, ");
        selectCostBearSql.append(" isnull(rate.fid, '') as FExchangeRateID, ");
        selectCostBearSql.append(" caltable.FPositionID as FPositionId ");
        selectCostBearSql.append(" from t_hr_scostbear cost");
        selectCostBearSql.append(" inner join T_ORG_UnitRelation unitRe on unitRe.FFromUnitID = cost.FCostBearOrgUnitID ");
        selectCostBearSql.append(" inner join T_ORG_TypeRelation typeRe on typeRe.fid = unitRe.FTYPERELATIONID  ");
        selectCostBearSql.append(" left join T_HR_SCmpCalTable caltable on cost.FCmpCalTableId = caltable.FID");
        selectCostBearSql.append(" left join T_HR_SCmpItemAccount as acct on acct.fid =  '").append(itemAccountId).append("'");
        selectCostBearSql.append(" left join T_BD_ExchangeTable ect on ect.fid =  caltable.FExchangeTableID ");
        selectCostBearSql.append(" left join T_BD_ExchangeAux aux on aux.FExchangeTableId = ect.fid and aux.FSourceCurrencyID = caltable.FCurrencyID and aux.FTargetCurrencyID = (case when cost.FCommitmentCurrencyID is null then (case when acct.FCommitmentCurrencyID is null then caltable.FCurrencyID else acct.FCommitmentCurrencyID end )  else cost.FCommitmentCurrencyID end) ");
        selectCostBearSql.append(" left join T_BD_ExchangeRate as rate on rate.FExchangeAuxID = aux.FID and rate.FAvailTime <= caltable.FRealEndDate and rate.FInvalidTime >= caltable.FRealEndDate ");
        selectCostBearSql.append("where cost.FCalSchemeID = '").append(calSchemeId).append("'");
        selectCostBearSql.append("  and cost.FperiodYear =  ").append(calSchemeInfo.getPeriodYear());
        selectCostBearSql.append("  and cost.FperiodMonth = ").append(calSchemeInfo.getPeriodMonth());
        selectCostBearSql.append("  and cost.FcalTime =  ").append(calSchemeInfo.getCalTime());
        selectCostBearSql.append("  and typeRe.FTOTYPE = 1 ");
        selectCostBearSql.append("  and typeRe.FFROMTYPE = 0 ");
        selectCostBearSql.append("  and unitRe.FToUnitID = '").append(company).append("'");
        selectCostBearSql.append(" and cost.FCmpItemID in ").append(cmpItemIdSql);
        try {
            String excuteSql = "";
            Connection conn = EJBFactory.getConnection((Context)ctx);
            DatabaseMetaData metaData = conn.getMetaData();
            if (metaData != null) {
                String dbName = metaData.getDatabaseProductName();
                int databaseMajorVersion = metaData.getDatabaseMajorVersion();
                excuteSql = dbName != null && "Oracle".equalsIgnoreCase(dbName) && databaseMajorVersion == 11 ? MessageFormat.format("select * into {0} from ( {1} ) TTT where rownum > -1 ", tempTableName, selectCostBearSql) : MessageFormat.format("select * into {0} from ( {1} ) TTT ", tempTableName, selectCostBearSql);
            } else {
                excuteSql = MessageFormat.format("select * into {0} from ( {1} ) TTT ", tempTableName, selectCostBearSql);
            }
            DbUtil.execute((Context)ctx, (String)excuteSql.toString());
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return tempTableName;
    }

    protected void saveItemAccountDetails(Context ctx, CmpItemAccountCollection accountCollection, CalSchemeInfo calSchemeInfo) throws BOSException {
        if (accountCollection == null || accountCollection.size() < 1) {
            return;
        }
        CmpInSql<String> cmpInSql = CmpInSqlFactory.getInstance();
        ArrayList<String> insertSqls = new ArrayList<String>();
        HashSet<String> tempTableNames = new HashSet<String>();
        for (int j = 0; j < accountCollection.size(); ++j) {
            CmpItemAccountInfo itemAccountInfo = accountCollection.get(j);
            if (itemAccountInfo == null || itemAccountInfo.getEntries() == null) continue;
            List<String> cmpItemList = this.getCmpItems(itemAccountInfo);
            String cmpItemIdSql = cmpInSql.createInSqlBaseOnFId(ctx, cmpItemList);
            String company = itemAccountInfo.getCompany() == null ? "" : itemAccountInfo.getCompany().getId().toString();
            String itemAccountId = itemAccountInfo.getId() == null ? "" : itemAccountInfo.getId().toString();
            String tempTableName = this.getCostBearDataTempTab(ctx, itemAccountId, company, cmpItemIdSql, calSchemeInfo);
            tempTableNames.add(tempTableName);
            StringBuilder insert = new StringBuilder();
            insert.append("insert into t_hr_costbearmlcurrency (");
            insert.append(" FID, FCostBearOrgID, FCostBearOrgUnitID, FCalOrgUnitID, FHrOrgUnitID, FAdminOrgID, FCalSchemeID, FCmpPeriodID, FCmpItemID, FPersonID, FBearMoney, FCostMoney, FCalTime, FPeriodYear, FPeriodMonth, ");
            insert.append(" FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FCostValue, FBearValue, FCostBearPerc, FCmpCalTableId, FAccountBillID, ");
            insert.append(" FCalTableItemCurrencyID, FCalTableItemAmount, FCommitmentItemCurrencyID, FCommitmentItemAmount, FExchangeRate, FFinanceOrgUnitID, FExchangeRateID, FPositionId) ");
            insert.append(" select newbosid('A0CCD0F3'),");
            insert.append(" t.FCostBearOrgID, t.FCostBearOrgUnitID, t.FCalOrgUnitID, t.FHrOrgUnitID, t.FAdminOrgID, t.FCalSchemeID,  t.FCmpPeriodID, t.FCmpItemID, t.FPersonID, sum(t.FBearMoney) as FBearMoney, ");
            insert.append(" t.FCostMoney, t.FCalTime, t.FPeriodYear, t.FPeriodMonth, t.FCreatorID, t.FCreateTime, t.FLastUpdateUserID, t.FLastUpdateTime, t.FControlUnitID, to_char(t.FCostValue) as FCostValue, to_char(t.FBearValue) as FBearValue, ");
            insert.append(" sum(t.FCostBearPerc) as FCostBearPerc, t.FCmpCalTableId, t.FAccountBillID, t.FCalTableItemCurrencyID, sum(t.FCalTableItemAmount) as FCalTableItemAmount, t.FCommitmentItemCurrencyID, ");
            insert.append(" sum(t.FCommitmentItemAmount) as FCommitmentItemAmount, t.FExchangeRate, t.FFinanceOrgUnitID, t.FExchangeRateID, t.FPositionId ");
            insert.append(" from ").append(tempTableName).append(" t ");
            insert.append(" group by t.FCalSchemeID, t.FCmpPeriodID, t.FPeriodYear, t.FPeriodMonth, t.FCalTime, t.FPersonID, t.FHrOrgUnitID,t.FCostBearOrgUnitID,");
            insert.append(" t.FCmpCalTableId, t.FAccountBillID, t.FCmpItemID, t.FCalTableItemCurrencyID, t.FCommitmentItemCurrencyID, t.FExchangeRate,");
            insert.append(" t.FFinanceOrgUnitID, t.FExchangeRateID, t.FPositionId, t.FCostBearOrgID, t.FCalOrgUnitID, t.FAdminOrgID, t.FCostMoney,");
            insert.append(" t.FCreatorID, t.FCreateTime, t.FLastUpdateUserID, t.FLastUpdateTime, t.FControlUnitID, to_char(t.FCostValue), to_char(t.FBearValue) ");
            insertSqls.add(insert.toString());
        }
        CmpSQLUtil.executeBatchSql(ctx, insertSqls.toArray());
        cmpInSql.release(ctx);
        if (!tempTableNames.isEmpty()) {
            for (String tempTableName : tempTableNames) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
            }
        }
    }

    protected CoreBaseCollection assembleCostBearCalScheme(Context ctx, CalSchemeInfo calSchemeInfo, CoreBaseCollection accountBillCollection, Date businessDate, Date recordDate, Date matureDate) throws BOSException {
        CoreBaseCollection collection = new CoreBaseCollection();
        for (int i = 0; i < accountBillCollection.size(); ++i) {
            CmpItemAccountBillInfo accountBillInfo = (CmpItemAccountBillInfo)accountBillCollection.get(i);
            CostBearCalSchemeInfo costBearCalSchemeInfo = new CostBearCalSchemeInfo();
            costBearCalSchemeInfo.setCalScheme(calSchemeInfo);
            costBearCalSchemeInfo.setPeriodYear(calSchemeInfo.getPeriodYear());
            costBearCalSchemeInfo.setPeriodMonth(calSchemeInfo.getPeriodMonth());
            costBearCalSchemeInfo.setCalTime(calSchemeInfo.getCalTime());
            costBearCalSchemeInfo.setCostBearBillType(CostBearBillType.XING_HAN);
            costBearCalSchemeInfo.setSubmitBillState(SubmitBillState.WAITING);
            costBearCalSchemeInfo.setGenerVoucherSate(GenerVoucherStateEnum.WAITING);
            costBearCalSchemeInfo.setCmpItemAccountBill(accountBillInfo);
            costBearCalSchemeInfo.setBusinessDate(businessDate);
            costBearCalSchemeInfo.setRecordDate(recordDate);
            costBearCalSchemeInfo.setMatureDate(matureDate);
            String oql = "select id, amount where cmpItemAccountBill = '" + accountBillInfo.getId().toString() + "'";
            CmpItemAccountBillEntryCollection billEntryCollection = CmpItemAccountBillEntryFactory.getLocalInstance(ctx).getCmpItemAccountBillEntryCollection(oql);
            if (billEntryCollection == null || billEntryCollection.isEmpty()) continue;
            BigDecimal caltableItemAmount = BigDecimal.ZERO;
            for (int j = 0; j < billEntryCollection.size(); ++j) {
                CmpItemAccountBillEntryInfo billEntryInfo = billEntryCollection.get(j);
                if (billEntryInfo == null) continue;
                BigDecimal amount = billEntryInfo.getAmount() == null ? BigDecimal.ZERO : billEntryInfo.getAmount();
                caltableItemAmount = caltableItemAmount.add(amount);
            }
            costBearCalSchemeInfo.setCaltableItemAmount(caltableItemAmount);
            collection.add((CoreBaseInfo)costBearCalSchemeInfo);
        }
        return collection;
    }

    protected CostBearCalSchemeRecordInfo addCostBearCalSchemeRecord(Context ctx, CalSchemeInfo calSchemeInfo, CoreBaseCollection accountBillCollection, CmpItemAccountCollection accountColl) throws BOSException, EASBizException {
        String billIds;
        StringBuffer ids = new StringBuffer();
        for (int i = 0; i < accountBillCollection.size(); ++i) {
            CmpItemAccountBillInfo accountBillInfo = (CmpItemAccountBillInfo)accountBillCollection.get(i);
            if (accountBillInfo == null) continue;
            String billNumber = accountBillInfo.getNumber();
            if (i < accountBillCollection.size() - 1) {
                ids.append(billNumber).append(",");
                continue;
            }
            ids.append(billNumber);
        }
        String oql = "select id, calScheme.id, periodYear, periodMonth, calTime, costBearState, costBearBillType, cmpItemAccoutBills  where calScheme = '" + calSchemeInfo.getId().toString() + "' and periodYear = " + calSchemeInfo.getPeriodYear() + "  and periodMonth = " + calSchemeInfo.getPeriodMonth() + "  and calTime = " + calSchemeInfo.getCalTime();
        CostBearCalSchemeRecordCollection recordCollection = CostBearCalSchemeRecordFactory.getLocalInstance(ctx).getCostBearCalSchemeRecordCollection(oql);
        CostBearCalSchemeRecordInfo recordInfo = null;
        if (recordCollection != null && !recordCollection.isEmpty()) {
            recordInfo = recordCollection.get(0);
        } else {
            recordInfo = new CostBearCalSchemeRecordInfo();
            recordInfo.setId(BOSUuid.create((String)"04806D01"));
            recordInfo.setCalScheme(calSchemeInfo);
            recordInfo.setPeriodYear(calSchemeInfo.getPeriodYear());
            recordInfo.setPeriodMonth(calSchemeInfo.getPeriodMonth());
            recordInfo.setCalTime(calSchemeInfo.getCalTime());
        }
        recordInfo.setCostBearBillType(CostBearBillType.XING_HAN);
        String string = billIds = CmpStrUtil.isEmpty(recordInfo.getCmpItemAccoutBills()) ? ids.toString() : recordInfo.getCmpItemAccoutBills() + "," + ids.toString();
        if (billIds.length() > 4000) {
            billIds = billIds.substring(0, 3999);
        }
        recordInfo.setCmpItemAccoutBills(billIds);
        CostBearCalSchemeRecordFactory.getLocalInstance(ctx).save(recordInfo);
        return recordInfo;
    }

    protected boolean isAllGenerated(Context ctx, CalSchemeInfo calSchemeInfo) throws BOSException {
        StringBuilder query1 = new StringBuilder();
        query1.append("select distinct unitRe.FToUnitID  ");
        query1.append(" from T_HR_SCostBear cost ");
        query1.append(" inner join T_ORG_UnitRelation unitRe on unitRe.FFromUnitID = cost.FCostBearOrgUnitID ");
        query1.append(" inner join T_ORG_TypeRelation typeRe on typeRe.fid = unitRe.FTYPERELATIONID ");
        query1.append(" where cost.fcalSchemeid = ? ");
        query1.append(" and cost.fperiodYear = ? ");
        query1.append(" and cost.fperiodMonth = ? ");
        query1.append(" and cost.fcalTime = ? ");
        query1.append(" and typeRe.FTOTYPE = 1 ");
        query1.append(" and typeRe.FFROMTYPE = 0 ");
        Object[] param1 = new Object[]{calSchemeInfo.getId().toString(), calSchemeInfo.getPeriodYear(), calSchemeInfo.getPeriodMonth(), calSchemeInfo.getCalTime()};
        IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)query1.toString(), (Object[])param1);
        String query2 = "select distinct FCompanyID from T_HR_SCmpItemAccountBill where FCalSchemeID = ? and fPeriodYear = ? and fPeriodMonth = ? and fCalTime = ? ";
        Object[] param2 = new Object[]{calSchemeInfo.getId().toString(), calSchemeInfo.getPeriodYear(), calSchemeInfo.getPeriodMonth(), calSchemeInfo.getCalTime()};
        IRowSet rowSet2 = DbUtil.executeQuery((Context)ctx, (String)query2, (Object[])param2);
        return rowSet1 != null && rowSet2 != null && rowSet1.size() == rowSet2.size();
    }

    protected void updateCostBealMlAccoutBill(Context ctx, CalSchemeInfo calSchemeInfo) throws BOSException, EASBizException {
        String oql = "select id, calScheme.id, company.id, periodYear, periodMonth, calTime  where calScheme = '" + calSchemeInfo.getId().toString() + "' and periodYear = " + calSchemeInfo.getPeriodYear() + "  and periodMonth = " + calSchemeInfo.getPeriodMonth() + "  and calTime = " + calSchemeInfo.getCalTime();
        CmpItemAccountBillCollection accountBillCollection = CmpItemAccountBillFactory.getLocalInstance(ctx).getCmpItemAccountBillCollection(oql);
        ArrayList<Object[]> listParam = new ArrayList<Object[]>();
        if (accountBillCollection != null && !accountBillCollection.isEmpty()) {
            for (int i = 0; i < accountBillCollection.size(); ++i) {
                CmpItemAccountBillInfo accountBillInfo = accountBillCollection.get(i);
                if (accountBillInfo == null) continue;
                String company = accountBillInfo.getCompany() == null ? "" : accountBillInfo.getCompany().getId().toString();
                Object[] param = new Object[]{accountBillInfo.getId().toString(), company, accountBillInfo.getCalScheme().getId().toString(), accountBillInfo.getPeriodYear(), accountBillInfo.getPeriodMonth(), accountBillInfo.getCalTime()};
                listParam.add(param);
            }
            String update = "update t_hr_costbearmlcurrency set FAccountBillID = ? where FFinanceOrgUnitID = ? and FCalSchemeID = ? and FPeriodYear = ? and FPeriodMonth = ? and FCalTime = ?";
            DbUtil.executeBatch((Context)ctx, (String)update, listParam);
        }
    }

    protected String createTempTableName(Context ctx, CalSchemeInfo calSchemeInfo, CmpItemAccountBillInfo accountBillInfo) throws BOSException {
        StringBuilder query = new StringBuilder();
        query.append("select * ");
        query.append("from t_hr_costbearmlcurrency ");
        query.append("where FCalSchemeID = '" + calSchemeInfo.getId().toString() + "' ");
        query.append(" and FPeriodYear = " + calSchemeInfo.getPeriodYear());
        query.append(" and FPeriodMonth = " + calSchemeInfo.getPeriodMonth());
        query.append(" and FCalTime = " + calSchemeInfo.getCalTime());
        query.append(" and FAccountBillID = '" + accountBillInfo.getId().toString() + "' ");
        try {
            String tempTableName = this.createTempTable(ctx, query.toString());
            return tempTableName;
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    protected String createTempTable(Context ctx, String sourceSql) throws Exception {
        String tplTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
        long startDate = System.currentTimeMillis();
        String excuteSql = "";
        Connection conn = EJBFactory.getConnection((Context)ctx);
        DatabaseMetaData metaData = conn.getMetaData();
        if (metaData != null) {
            String dbName = metaData.getDatabaseProductName();
            int databaseMajorVersion = metaData.getDatabaseMajorVersion();
            excuteSql = dbName != null && "Oracle".equalsIgnoreCase(dbName) && databaseMajorVersion == 11 ? MessageFormat.format("select * into {0} from ( {1} ) TTT where rownum > -1 ", tplTableName, sourceSql) : MessageFormat.format("select * into {0} from ( {1} ) TTT ", tplTableName, sourceSql);
        } else {
            excuteSql = MessageFormat.format("select * into {0} from ( {1} ) TTT ", tplTableName, sourceSql);
        }
        DbUtil.execute((Context)ctx, (String)excuteSql);
        long endDate = System.currentTimeMillis();
        logger.info((Object)(" create tempTable time : " + (endDate - startDate) / 1000L + " s"));
        return tplTableName;
    }

    protected Map<String, String> getCmpItemSnMap(Context ctx, CoreBaseCollection accountBillCollection) throws BOSException {
        HashSet<String> cmpItems = new HashSet<String>();
        for (int i = 0; i < accountBillCollection.size(); ++i) {
            CmpItemAccountBillEntryCollection billEntryCollection;
            CmpItemAccountBillInfo accountBillInfo = (CmpItemAccountBillInfo)accountBillCollection.get(i);
            if (accountBillInfo == null || (billEntryCollection = accountBillInfo.getEntries()) == null || billEntryCollection.isEmpty()) continue;
            for (int j = 0; j < billEntryCollection.size(); ++j) {
                String cmpItemId;
                CmpItemAccountBillEntryInfo billEntryInfo = billEntryCollection.get(j);
                if (billEntryInfo == null || billEntryInfo.isEmpty() || billEntryInfo.getCmpItemRecords() == null || billEntryInfo.getCmpItemRecords().isEmpty()) continue;
                CmpItemAccountBillRecordCollection cmpItemRecords = billEntryInfo.getCmpItemRecords();
                for (int k = 0; k < cmpItemRecords.size(); ++k) {
                    CmpItemAccountBillRecordInfo billRecordInfo = cmpItemRecords.get(k);
                    if (billRecordInfo == null || billRecordInfo.getCmpItem() == null || billRecordInfo.getCmpItem().getId() == null) continue;
                    cmpItems.add(billRecordInfo.getCmpItem().getId().toString());
                }
                if (billEntryInfo.getOptionalFieldOne() != null) {
                    CmpItemInfo cmpItemInfo = billEntryInfo.getOptionalFieldOne().getCmpItem();
                    String string = cmpItemInfo == null ? "" : (cmpItemId = cmpItemInfo.getId() == null ? "" : cmpItemInfo.getId().toString());
                    if (!StringUtils.isEmpty((CharSequence)cmpItemId)) {
                        cmpItems.add(cmpItemId);
                    }
                }
                if (billEntryInfo.getOptionalFieldTwo() != null) {
                    CmpItemInfo cmpItemInfo = billEntryInfo.getOptionalFieldTwo().getCmpItem();
                    String string = cmpItemInfo == null ? "" : (cmpItemId = cmpItemInfo.getId() == null ? "" : cmpItemInfo.getId().toString());
                    if (!StringUtils.isEmpty((CharSequence)cmpItemId)) {
                        cmpItems.add(cmpItemId);
                    }
                }
                if (billEntryInfo.getOptionalFieldThree() != null) {
                    CmpItemInfo cmpItemInfo = billEntryInfo.getOptionalFieldThree().getCmpItem();
                    String string = cmpItemInfo == null ? "" : (cmpItemId = cmpItemInfo.getId() == null ? "" : cmpItemInfo.getId().toString());
                    if (!StringUtils.isEmpty((CharSequence)cmpItemId)) {
                        cmpItems.add(cmpItemId);
                    }
                }
                if (billEntryInfo.getOptionalFieldFour() != null) {
                    CmpItemInfo cmpItemInfo = billEntryInfo.getOptionalFieldFour().getCmpItem();
                    String string = cmpItemInfo == null ? "" : (cmpItemId = cmpItemInfo.getId() == null ? "" : cmpItemInfo.getId().toString());
                    if (!StringUtils.isEmpty((CharSequence)cmpItemId)) {
                        cmpItems.add(cmpItemId);
                    }
                }
                if (billEntryInfo.getOptionalFieldFive() == null) continue;
                CmpItemInfo cmpItemInfo = billEntryInfo.getOptionalFieldFive().getCmpItem();
                String string = cmpItemInfo == null ? "" : (cmpItemId = cmpItemInfo.getId() == null ? "" : cmpItemInfo.getId().toString());
                if (StringUtils.isEmpty((CharSequence)cmpItemId)) continue;
                cmpItems.add(cmpItemId);
            }
        }
        HashMap<String, String> cmpItemSnMap = new HashMap<String, String>();
        if (cmpItems.size() < 1) {
            return cmpItemSnMap;
        }
        CmpInSql cmpInSql = CmpInSqlFactory.getInstance();
        String cmpItemIdSql = cmpInSql.createInSqlBaseOnFId(ctx, cmpItems);
        CmpItemCollection cmpItemColl = CmpItemFactory.getLocalInstance(ctx).getCmpItemCollection(" where id in " + cmpItemIdSql);
        if (cmpItemColl != null && cmpItemColl.size() > 0) {
            for (int m = 0; m < cmpItemColl.size(); ++m) {
                CmpItemInfo cmpItemInfo = cmpItemColl.get(m);
                if (cmpItemInfo == null || cmpItemInfo.getId() == null) continue;
                cmpItemSnMap.put(cmpItemInfo.getId().toString(), "S" + cmpItemInfo.getFieldSn());
            }
        }
        return cmpItemSnMap;
    }

    protected void addCmpItemAccountBillRecordMl(Context ctx, CalSchemeInfo calSchemeInfo, CoreBaseCollection accountBillCollection) throws BOSException {
        Map<String, String> cmpItemSnMap = this.getCmpItemSnMap(ctx, accountBillCollection);
        for (int i = 0; i < accountBillCollection.size(); ++i) {
            CmpItemAccountBillInfo accountBillInfo = (CmpItemAccountBillInfo)accountBillCollection.get(i);
            if (accountBillInfo == null) continue;
            String tempTableName = this.createTempTableName(ctx, calSchemeInfo, accountBillInfo);
            CmpItemAccountBillEntryCollection billEntryCollection = accountBillInfo.getEntries();
            if (billEntryCollection == null || billEntryCollection.isEmpty()) continue;
            HashMap<String, List<String>> personMap = new HashMap<String, List<String>>();
            for (int j = 0; j < billEntryCollection.size(); ++j) {
                CmpItemAccountBillEntryInfo billEntryInfo = billEntryCollection.get(j);
                if (billEntryInfo == null || billEntryInfo.isEmpty()) continue;
                this.buildCmpItemAccountBillRecordM(ctx, billEntryInfo, tempTableName, personMap, accountBillInfo, cmpItemSnMap);
            }
        }
    }

    protected Map<String, Object> getOptionalCmpItemInfo(CmpItemAccountBillEntryInfo billEntryInfo, Map<String, String> cmpItemSnMap) {
        String cmpItemId;
        CmpItemInfo cmpItemInfo;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String opval = "";
        LinkedList<String> optionalCmpItems = new LinkedList<String>();
        if (billEntryInfo.getOptionalFieldOne() != null) {
            opval = opval + billEntryInfo.getOptionalFieldOne().getCalValue() + "_";
            cmpItemInfo = billEntryInfo.getOptionalFieldOne().getCmpItem();
            String string = cmpItemInfo == null ? "" : (cmpItemId = cmpItemInfo.getId() == null ? "" : cmpItemInfo.getId().toString());
            if (cmpItemSnMap.containsKey(cmpItemId)) {
                optionalCmpItems.add(cmpItemSnMap.get(cmpItemId));
            }
        }
        if (billEntryInfo.getOptionalFieldTwo() != null) {
            opval = opval + billEntryInfo.getOptionalFieldTwo().getCalValue() + "_";
            cmpItemInfo = billEntryInfo.getOptionalFieldTwo().getCmpItem();
            String string = cmpItemInfo == null ? "" : (cmpItemId = cmpItemInfo.getId() == null ? "" : cmpItemInfo.getId().toString());
            if (cmpItemSnMap.containsKey(cmpItemId)) {
                optionalCmpItems.add(cmpItemSnMap.get(cmpItemId));
            }
        }
        if (billEntryInfo.getOptionalFieldThree() != null) {
            opval = opval + billEntryInfo.getOptionalFieldThree().getCalValue() + "_";
            cmpItemInfo = billEntryInfo.getOptionalFieldThree().getCmpItem();
            String string = cmpItemInfo == null ? "" : (cmpItemId = cmpItemInfo.getId() == null ? "" : cmpItemInfo.getId().toString());
            if (cmpItemSnMap.containsKey(cmpItemId)) {
                optionalCmpItems.add(cmpItemSnMap.get(cmpItemId));
            }
        }
        if (billEntryInfo.getOptionalFieldFour() != null) {
            opval = opval + billEntryInfo.getOptionalFieldFour().getCalValue() + "_";
            cmpItemInfo = billEntryInfo.getOptionalFieldFour().getCmpItem();
            String string = cmpItemInfo == null ? "" : (cmpItemId = cmpItemInfo.getId() == null ? "" : cmpItemInfo.getId().toString());
            if (cmpItemSnMap.containsKey(cmpItemId)) {
                optionalCmpItems.add(cmpItemSnMap.get(cmpItemId));
            }
        }
        if (billEntryInfo.getOptionalFieldFive() != null) {
            opval = opval + billEntryInfo.getOptionalFieldFive().getCalValue() + "_";
            cmpItemInfo = billEntryInfo.getOptionalFieldFive().getCmpItem();
            String string = cmpItemInfo == null ? "" : (cmpItemId = cmpItemInfo.getId() == null ? "" : cmpItemInfo.getId().toString());
            if (cmpItemSnMap.containsKey(cmpItemId)) {
                optionalCmpItems.add(cmpItemSnMap.get(cmpItemId));
            }
        }
        if (!StringUtils.isEmpty((CharSequence)opval)) {
            opval = opval.substring(0, opval.length() - 1);
        }
        resultMap.put("optionalVal", opval);
        resultMap.put("optionalCmpItems", optionalCmpItems);
        return resultMap;
    }

    protected void buildCmpItemAccountBillRecordM(Context ctx, CmpItemAccountBillEntryInfo billEntryInfo, String tempTableName, Map<String, List<String>> personMap, CmpItemAccountBillInfo accountBillInfo, Map<String, String> cmpItemSnMap) throws BOSException {
        CmpAccountBillPersonRecordCollection billPersonRecord = billEntryInfo.getBillPersonRecord();
        CmpItemAccountBillRecordCollection cmpItemRecords = billEntryInfo.getCmpItemRecords();
        AdminOrgUnitInfo adminOrg = billEntryInfo.getAdminOrg();
        if (cmpItemRecords == null || cmpItemRecords.isEmpty()) {
            return;
        }
        String currencyId = billEntryInfo.getCommitmentItemCurrency() == null || billEntryInfo.getCommitmentItemCurrency().getId() == null ? "" : billEntryInfo.getCommitmentItemCurrency().getId().toString();
        Map<String, Object> optionalCmpItemMap = this.getOptionalCmpItemInfo(billEntryInfo, cmpItemSnMap);
        String opval = optionalCmpItemMap.get("optionalVal").toString();
        LinkedList optionalCmpItems = (LinkedList)optionalCmpItemMap.get("optionalCmpItems");
        ArrayList<Object[]> listParam = new ArrayList<Object[]>();
        for (int k = 0; k < cmpItemRecords.size(); ++k) {
            int m;
            CmpItemAccountBillRecordInfo billRecordInfo = cmpItemRecords.get(k);
            if (billRecordInfo == null || billRecordInfo.getCmpItem() == null || billRecordInfo.getCmpItem().getId() == null) continue;
            String cmpItemId = billRecordInfo.getCmpItem().getId().toString();
            List<String> personIds = this.getPersonIds(billPersonRecord);
            StringBuilder sSql = new StringBuilder();
            sSql.append("select ");
            if (optionalCmpItems.size() > 0) {
                for (m = 0; m < optionalCmpItems.size(); ++m) {
                    sSql.append("calTable.").append((String)optionalCmpItems.get(m)).append(",");
                }
            }
            sSql.append(" a.FCmpItemID, a.FCalTableItemCurrencyID,sum(a.FCalTableItemAmount) as FCalTableItemAmount,a.FCommitmentItemCurrencyID,sum(a.FCommitmentItemAmount) as FCommitmentItemAmount,a.FExchangeRate from ");
            sSql.append(tempTableName).append(" a ");
            sSql.append(" left join T_HR_SCmpCalTable calTable on calTable.fid = a.FCmpCalTableId ");
            sSql.append(" where FCmpItemID = '").append(cmpItemId).append("' ");
            if (adminOrg != null) {
                sSql.append(" and a.FCostBearOrgUnitID = '").append(adminOrg.getId().toString()).append("'");
            }
            if (billEntryInfo.isIsResidualPerson()) {
                List<String> tempPersonIds;
                if (personMap.containsKey(cmpItemId) && !(tempPersonIds = personMap.get(cmpItemId)).isEmpty()) {
                    sSql.append(" and a.FPersonID not in ('").append(CmpStrUtil.join(tempPersonIds, "','", null)).append("')");
                }
            } else if (!personIds.isEmpty()) {
                personMap.put(cmpItemId, personIds);
                sSql.append(" and a.FPersonID in ('").append(CmpStrUtil.join(personIds, "','", null)).append("')");
            }
            sSql.append(" group by ");
            if (adminOrg != null) {
                sSql.append(" a.FCostBearOrgUnitID, ");
            }
            sSql.append(" a.FCmpItemID,");
            if (optionalCmpItems.size() > 0) {
                for (m = 0; m < optionalCmpItems.size(); ++m) {
                    sSql.append("calTable.").append((String)optionalCmpItems.get(m)).append(",");
                }
            }
            sSql.append(" FCalTableItemCurrencyID,a.FCommitmentItemCurrencyID, a.FExchangeRate");
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sSql.toString());
                while (rowSet.next()) {
                    String commitmentItemAmount;
                    String nowCmpItemId = rowSet.getString("FCmpItemID");
                    String nowcurrencyId = rowSet.getString("FCommitmentItemCurrencyID");
                    StringBuilder nowCompareStr = new StringBuilder(nowCmpItemId);
                    if (optionalCmpItems.size() > 0) {
                        for (int i = 0; i < optionalCmpItems.size(); ++i) {
                            nowCompareStr.append("_").append(rowSet.getString((String)optionalCmpItems.get(i)));
                        }
                    }
                    StringBuilder entryDataCompareStr = new StringBuilder(cmpItemId);
                    if (!StringUtils.isEmpty((CharSequence)opval)) {
                        entryDataCompareStr.append("_").append(opval);
                    }
                    if (!StringUtils.isEmpty((CharSequence)currencyId)) {
                        nowCompareStr.append("_").append(nowcurrencyId);
                        entryDataCompareStr.append("_").append(currencyId);
                    }
                    if (!nowCompareStr.toString().equals(entryDataCompareStr.toString())) continue;
                    String caltableItemAmount = rowSet.getString("FCaltableItemAmount");
                    if ("0E-10".equals(caltableItemAmount)) {
                        caltableItemAmount = "0";
                    }
                    if ("0E-10".equals(commitmentItemAmount = rowSet.getString("FCommitmentItemAmount"))) {
                        commitmentItemAmount = "0";
                    }
                    Object[] param = new Object[]{billRecordInfo.getId().toString(), caltableItemAmount, rowSet.getString("FCommitmentItemCurrencyID"), commitmentItemAmount, rowSet.getString("FExchangeRate"), accountBillInfo.getId().toString()};
                    listParam.add(param);
                }
                continue;
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (!listParam.isEmpty()) {
            DbUtil.executeBatch((Context)ctx, (String)this.insertSql, listParam);
        }
    }

    protected List<String> getPersonIds(CmpAccountBillPersonRecordCollection billPersonRecord) {
        ArrayList<String> list = new ArrayList<String>();
        if (billPersonRecord == null || billPersonRecord.isEmpty()) {
            return list;
        }
        for (int i = 0; i < billPersonRecord.size(); ++i) {
            CmpAccountBillPersonRecordInfo recordInfo = billPersonRecord.get(i);
            PersonInfo person = recordInfo.getPerson();
            if (person == null) continue;
            list.add(person.getId().toString());
        }
        return list;
    }

    protected void deleteCostBearCalScheme(Context ctx, String billIds) throws BOSException, EASBizException {
        String oql = " where cmpItemAccountBill in ('" + billIds + "')";
        CostBearCalSchemeFactory.getLocalInstance(ctx).delete(oql);
    }

    protected void deleteCostBearMlCurrency(Context ctx, List<CalSchemeInfo> calSchemeInfoList, String billIds) throws BOSException, EASBizException {
        StringBuilder delete = new StringBuilder();
        delete.append("delete from T_HR_CostBearMlCurrency ");
        delete.append(" where FCalSchemeID = ? ");
        delete.append("   and FPeriodYear = ? ");
        delete.append("   and FPeriodMonth = ? ");
        delete.append("   and FCalTime = ? ");
        delete.append("   and FAccountBillID in ( ? ) ");
        ArrayList<Object[]> listParam = new ArrayList<Object[]>();
        for (CalSchemeInfo calSchemeInfo : calSchemeInfoList) {
            if (calSchemeInfo == null) continue;
            Object[] param = new Object[]{calSchemeInfo.getId().toString(), calSchemeInfo.getPeriodYear(), calSchemeInfo.getPeriodMonth(), calSchemeInfo.getCalTime(), billIds};
            listParam.add(param);
        }
        if (!listParam.isEmpty()) {
            DbUtil.executeBatch((Context)ctx, (String)delete.toString(), listParam);
        }
    }

    protected void updateCostBearReport(Context ctx, List<CalSchemeInfo> calSchemeInfoList) throws BOSException {
        String isDistributeSql = "update T_HR_SCostBearReport set FIsDistribute=0 where FCalSchemeID=? and FPeriodYear=? and FPeriodMonth=? and FCalTime=? ";
        ArrayList<Object[]> listParam = new ArrayList<Object[]>();
        for (CalSchemeInfo calSchemeInfo : calSchemeInfoList) {
            if (calSchemeInfo == null) continue;
            Object[] param = new Object[]{calSchemeInfo.getId().toString(), calSchemeInfo.getPeriodYear(), calSchemeInfo.getPeriodMonth(), calSchemeInfo.getCalTime()};
            listParam.add(param);
        }
        if (!listParam.isEmpty()) {
            DbUtil.executeBatch((Context)ctx, (String)isDistributeSql, listParam);
        }
    }

    protected void updateCostBearCalSchemeRecord(Context ctx, List<CalSchemeInfo> calSchemeInfoList) throws BOSException, EASBizException {
        CoreBaseCollection baseCollection = new CoreBaseCollection();
        for (int i = 0; i < calSchemeInfoList.size(); ++i) {
            CalSchemeInfo calSchemeInfo = calSchemeInfoList.get(i);
            String oql = "select id, calScheme.id, periodYear, periodMonth, calTime, costBearState, costBearBillType, cmpItemAccoutBills  where calScheme = '" + calSchemeInfo.getId().toString() + "' and periodYear = " + calSchemeInfo.getPeriodYear() + "  and periodMonth = " + calSchemeInfo.getPeriodMonth() + "  and calTime = " + calSchemeInfo.getCalTime();
            CostBearCalSchemeRecordCollection recordCollection = CostBearCalSchemeRecordFactory.getLocalInstance(ctx).getCostBearCalSchemeRecordCollection(oql);
            String sql = "select FCalSchemeID, FPeriodYear, FPeriodMonth, FCalTime, FNumber from T_HR_SCmpItemAccountBill  where FCalSchemeID = ?   and FPeriodYear = ?   and FPeriodMonth = ?   and FCalTime = ? ";
            Object[] param = new Object[]{calSchemeInfo.getId().toString(), calSchemeInfo.getPeriodYear(), calSchemeInfo.getPeriodMonth(), calSchemeInfo.getCalTime()};
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
            HashMap<String, String> resultMap = new HashMap<String, String>();
            try {
                while (rowSet.next()) {
                    String calSchemeID = rowSet.getString("FCalSchemeID");
                    String periodYear = rowSet.getString("FPeriodYear");
                    String periodMonth = rowSet.getString("FPeriodMonth");
                    String calTime = rowSet.getString("FCalTime");
                    String number = rowSet.getString("FNumber");
                    String key = calSchemeID + "_" + periodYear + "_" + periodMonth + "_" + calTime;
                    if (resultMap.containsKey(key)) {
                        resultMap.put(key, (String)resultMap.get(key) + "," + number);
                        continue;
                    }
                    resultMap.put(key, number);
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            for (int j = 0; j < recordCollection.size(); ++j) {
                CostBearCalSchemeRecordInfo recordInfo = recordCollection.get(j);
                CostBearCalSchemeRecordInfo newRecordInfo = new CostBearCalSchemeRecordInfo();
                newRecordInfo.setId(recordInfo.getId());
                newRecordInfo.setCalScheme(recordInfo.getCalScheme());
                newRecordInfo.setPeriodYear(recordInfo.getPeriodYear());
                newRecordInfo.setPeriodMonth(recordInfo.getPeriodMonth());
                newRecordInfo.setCalTime(recordInfo.getCalTime());
                String key = recordInfo.getCalScheme().getId().toString() + "_" + recordInfo.getPeriodYear() + "_" + recordInfo.getPeriodMonth() + "_" + recordInfo.getCalTime();
                newRecordInfo.setCmpItemAccoutBills((String)resultMap.get(key));
                newRecordInfo.setCostBearState(newRecordInfo.getCmpItemAccoutBills() == null ? CostBearStateEnum.NONE : CostBearStateEnum.PART);
                newRecordInfo.setCostBearBillType(CmpStrUtil.isEmpty((String)resultMap.get(key)) ? null : recordInfo.getCostBearBillType());
                baseCollection.add((CoreBaseInfo)newRecordInfo);
            }
        }
        if (!baseCollection.isEmpty()) {
            CostBearCalSchemeRecordFactory.getLocalInstance(ctx).updateBatchData(baseCollection);
        }
    }

    protected void deleteCmpItemAccountBillRecordMlCurrency(Context ctx, String billIds) throws BOSException, EASBizException {
        String delete = "where accountBillID in ('" + billIds + "')";
        CmpItemAccountBillRecordMlCurrencyFactory.getLocalInstance(ctx).delete(delete);
    }

    protected void deleteOptionalField(Context ctx, String billIds) throws BOSException, EASBizException {
        StringBuffer delete = new StringBuffer();
        delete.append("where id in ( '" + billIds + "' )");
        OptionalFieldFactory.getLocalInstance(ctx).delete(delete.toString());
    }
}

