/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.AbstractTaxUnitDataPermControllerBean;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class TaxUnitDataPermControllerBean
extends AbstractTaxUnitDataPermControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.TaxUnitDataPermControllerBean");

    @Override
    protected Set _getExistPermPersonId(Context ctx) throws BOSException {
        Set<Object> existPersonIdSet = new LinkedHashSet();
        String sql = "select p.FPersonID as PID from T_HR_STaxUnitDataPerm as p where p.FpermType='1' and p.FIsPersonPerm=1";
        existPersonIdSet = this.execSqlAndGetIdSet(ctx, sql);
        return existPersonIdSet;
    }

    @Override
    protected Set _getExistPermPersonIdByPersonId(Context ctx, Set personIdSet) throws BOSException {
        Set<Object> existPersonIdSet = new HashSet();
        String personIdStr = this.convertSetToSqlString(personIdSet);
        String sql = "select p.FPersonID as PID from T_HR_STaxUnitDataPerm as p where p.FpermType='1' and p.FIsPersonPerm=1 and p.FPersonID in (" + personIdStr + ")";
        existPersonIdSet = this.execSqlAndGetIdSet(ctx, sql);
        return existPersonIdSet;
    }

    private Set<String> execSqlAndGetIdSet(Context ctx, String sql) {
        LinkedHashSet<String> existPersonIdSet = new LinkedHashSet<String>();
        String personId = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                personId = rs.getString("PID");
                existPersonIdSet.add(personId);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return existPersonIdSet;
    }

    @Override
    @Deprecated
    protected Set _getExistPermRoleId(Context ctx) throws BOSException {
        Set<Object> existIdSet = new LinkedHashSet();
        String sql = "select p.FRoleId as PID from T_HR_STaxUnitDataPerm as p where p.FpermType='2' ";
        existIdSet = this.execSqlAndGetIdSet(ctx, sql);
        return existIdSet;
    }

    @Override
    @Deprecated
    protected Set _getExistPermRoleIdByRoleId(Context ctx, Set roleIdSet) throws BOSException {
        Set<Object> existIdSet = new HashSet();
        String idStr = this.convertSetToSqlString(roleIdSet);
        String sql = "select p.FRoleId as PID from T_HR_STaxUnitDataPerm as p where p.FpermType='2' and p.FRoleId in (" + idStr + ")";
        existIdSet = this.execSqlAndGetIdSet(ctx, sql);
        return existIdSet;
    }

    @Override
    protected Map _getPersonPermTaxUnitByPersonId(Context ctx, Set personIdSet) throws BOSException {
        LinkedHashMap<String, HashSet<String>> resultMap = new LinkedHashMap<String, HashSet<String>>();
        if (personIdSet == null || personIdSet.size() == 0) {
            return resultMap;
        }
        String personInRange = this.convertSetToSqlString(personIdSet);
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(" SELECT perm.FpersonId as PID,perm.FTaxUnitID as TID");
        strBuffer.append(" FROM T_HR_STaxUnitDataPerm perm ");
        strBuffer.append(" where perm.FPersonID in (" + personInRange + ")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strBuffer.toString());
        try {
            while (rs.next()) {
                String personId = rs.getString("PID");
                String taxUnitId = rs.getString("TID");
                HashSet<String> taxUnitIdSet = (HashSet<String>)resultMap.get(personId);
                if (taxUnitIdSet == null || taxUnitIdSet.size() == 0) {
                    taxUnitIdSet = new HashSet<String>();
                    taxUnitIdSet.add(taxUnitId);
                } else {
                    taxUnitIdSet.add(taxUnitId);
                }
                resultMap.put(personId, taxUnitIdSet);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return resultMap;
    }

    @Override
    protected Map _getPersonPermTaxUnitByUserId(Context ctx, Set userIdSet) throws BOSException {
        LinkedHashMap<String, HashSet<String>> resultMap = new LinkedHashMap<String, HashSet<String>>();
        if (userIdSet == null || userIdSet.size() == 0) {
            return resultMap;
        }
        String range = this.convertSetToSqlString(userIdSet);
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(" SELECT u.fid as UID,perm.FTaxUnitID as TID");
        strBuffer.append(" FROM T_HR_STaxUnitDataPerm perm ");
        strBuffer.append(" inner join T_PM_USER u on perm.FPersonid=u.FPersonId");
        strBuffer.append(" where perm.FpermType='1' and perm.FIsPersonPerm=1 and u.Fid in (" + range + ")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strBuffer.toString());
        try {
            while (rs.next()) {
                String uId = rs.getString("UID");
                String taxUnitId = rs.getString("TID");
                HashSet<String> taxUnitIdSet = (HashSet<String>)resultMap.get(uId);
                if (taxUnitIdSet == null || taxUnitIdSet.size() == 0) {
                    taxUnitIdSet = new HashSet<String>();
                    taxUnitIdSet.add(taxUnitId);
                } else {
                    taxUnitIdSet.add(taxUnitId);
                }
                resultMap.put(uId, taxUnitIdSet);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return resultMap;
    }

    @Override
    @Deprecated
    protected Map _getRolePermTaxUnitByRoleId(Context ctx, Set roleIdSet) throws BOSException {
        LinkedHashMap resultMap = new LinkedHashMap();
        return resultMap;
    }

    @Override
    protected Set _getAllPermTaxUnitByPersonId(Context ctx, String personId) throws BOSException {
        HashSet<String> taxUnitIdSet = new HashSet<String>();
        if (StringUtils.isBlank((CharSequence)personId)) {
            return taxUnitIdSet;
        }
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(" SELECT perm.FTaxUnitID as TID");
        strBuffer.append(" FROM T_HR_STaxUnitDataPerm perm ");
        strBuffer.append(" where perm.FpermType='1' and perm.FIsPersonPerm=1 and perm.FPersonID = '" + personId + "'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strBuffer.toString());
        try {
            while (rs.next()) {
                String taxUnitId = rs.getString("TID");
                taxUnitIdSet.add(taxUnitId);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return taxUnitIdSet;
    }

    private String convertSetToSqlString(Set<String> personIdSet) {
        String result = "";
        StringBuffer sbr = new StringBuffer();
        if (personIdSet != null && personIdSet.size() > 0) {
            for (String personId : personIdSet) {
                sbr.append("'" + personId + "',");
            }
            result = sbr.toString();
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }
}

