/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.agentIntegrate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.emp.BankInfo;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CmpAgentPayBillEntryInfo;
import com.kingdee.shr.compensation.CmpAgentPayBillException;
import com.kingdee.shr.compensation.CmpAgentPayBillFactory;
import com.kingdee.shr.compensation.CmpAgentPayBillInfo;
import com.kingdee.shr.compensation.CmpAgentPayBillSchemeInfo;
import com.kingdee.shr.compensation.CmpCalTableInfo;
import com.kingdee.shr.compensation.CmpItemInfo;
import com.kingdee.shr.compensation.app.agentIntegrate.AbstractCmpAgentPayBillCreating;
import com.kingdee.shr.compensation.app.agentIntegrate.CmpAgentSource;
import com.kingdee.shr.compensation.app.agentIntegrate.CmpITType;
import com.kingdee.shr.compensation.exception.PersonCmpFacadeException;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CmpAgentPayBillMultiCurK3Creating
extends AbstractCmpAgentPayBillCreating {
    protected String optionalCompany = null;

    @Override
    public void create(Context ctx, Map param) throws BOSException, EASBizException {
        this.initPayBillInfo(ctx, param);
        AbstractCmpAgentPayBillCreating.EntryGroups entryGroups = this.buildPayBillEntry(ctx, param);
        if (StringUtils.isNotEmpty((CharSequence)entryGroups.getErrorMsg())) {
            throw new CmpAgentPayBillException(CmpAgentPayBillException.EXCEPTION12, new Object[]{entryGroups.getErrorMsg()});
        }
        if (entryGroups.getCmpEntrysGroup().isEmpty()) {
            throw new PersonCmpFacadeException(PersonCmpFacadeException.CREATEFAIL);
        }
        for (String key : entryGroups.getCmpEntrysGroup().keySet()) {
            CmpAgentPayBillInfo cmpPayBillInfo = this.buildCmpPayBill(ctx, param, entryGroups.getCmpItemGroup().get(key), entryGroups.getCurrencyGroup().get(key));
            this.fillSplitInfo(cmpPayBillInfo, key);
            cmpPayBillInfo.setBusinessName(entryGroups.getOptionalCompanyMap().get(key));
            cmpPayBillInfo.put("entry", (Object)entryGroups.getCmpEntrysGroup().get(key));
            this.putPayBillSumAmount(cmpPayBillInfo, entryGroups, key);
            CmpAgentPayBillFactory.getLocalInstance(ctx).save((CoreBaseInfo)cmpPayBillInfo);
        }
    }

    @Override
    public void initPayOrg(Context ctx, Map param) throws BOSException, EASBizException {
        CmpItemInfo optionalCompanyField;
        if (this.hasCmpAgentPayBillSchemeInfo() && (optionalCompanyField = this.getCmpAgentPayBillSchemeInfo().getOptionalCompanyField()) != null) {
            this.optionalCompany = "cmp_ctb.s" + optionalCompanyField.getFieldSn();
        }
    }

    @Override
    protected CmpAgentPayBillInfo buildCmpPayBill(Context ctx, Map param, CmpItemInfo cmpItemInfo, String currencyId) throws EASBizException, BOSException {
        CmpAgentPayBillInfo info = super.buildCmpPayBill(ctx, param, cmpItemInfo, currencyId);
        CalSchemeInfo calSchemeInfo = (CalSchemeInfo)param.get("calSchemeInfo");
        info.setCalCurrency(calSchemeInfo.getCurrency());
        return info;
    }

    @Override
    protected void buildBillMark(CmpAgentPayBillInfo info) {
        info.setITType(CmpITType.K3);
        info.setAgentSource(CmpAgentSource.MultiCur);
    }

    @Override
    protected AbstractCmpAgentPayBillCreating.EntryGroups buildPayBillEntry(Context ctx, Map param) throws BOSException, EASBizException {
        AbstractCmpAgentPayBillCreating.EntryGroups entryGroups = new AbstractCmpAgentPayBillCreating.EntryGroups();
        String calTableName = (String)param.get("calTableName");
        List listData = (List)param.get("listData");
        CmpAgentPayBillEntryInfo cmpEntryInfo = null;
        for (int i = 0; i < listData.size(); ++i) {
            Map data = (Map)listData.get(i);
            List<Object> calTableList = this.getCalTableMap().get((String)data.get(calTableName + ".id"));
            BigDecimal giveAmount = new BigDecimal(data.get("gv_cmpaccres.giveamount") == null ? "0" : data.get("gv_cmpaccres.giveamount").toString());
            if (giveAmount == null || giveAmount.compareTo(BigDecimal.ZERO) <= 0) {
                entryGroups.setErrorMsg(EASResource.getString((String)"com.kingdee.shr.compensation.resource.MessageResource", (String)"label12", (Locale)ctx.getLocale()));
                return entryGroups;
            }
            PersonInfo personInfo = (PersonInfo)calTableList.get(0);
            CmpItemInfo cmpItem = this.getCalSchemeItemMap().get(data.get("gv_cmpitem.id")).getCmpItem();
            if (this.getExistPers().contains(personInfo.getId().toString() + "~" + cmpItem.getId().toString())) {
                entryGroups.setErrorMsg(EASResource.getString((String)"com.kingdee.shr.compensation.resource.MessageResource", (String)"label13", (Locale)ctx.getLocale()));
                return entryGroups;
            }
            cmpEntryInfo = new CmpAgentPayBillEntryInfo();
            BOSUuid cmpAgentPayBillEntryId = BOSUuid.create((BOSObjectType)cmpEntryInfo.getBOSType());
            cmpEntryInfo.setPerson(personInfo);
            cmpEntryInfo.setPersonNum(personInfo.getNumber());
            cmpEntryInfo.setPersonName(personInfo.getName());
            cmpEntryInfo.setAmount(giveAmount);
            cmpEntryInfo.setAdminOrg((AdminOrgUnitInfo)calTableList.get(1));
            cmpEntryInfo.setCmpCalOrg((AdminOrgUnitInfo)calTableList.get(2));
            cmpEntryInfo.setHrOrgUnit((HROrgUnitInfo)calTableList.get(3));
            cmpEntryInfo.setIsSuccess(false);
            cmpEntryInfo.setUseDefault((Boolean)data.get(calTableName + ".usedefault"));
            cmpEntryInfo.setId(cmpAgentPayBillEntryId);
            cmpEntryInfo.setCmpItemName(cmpItem.getName());
            cmpEntryInfo.setCmpItem(cmpItem);
            BigDecimal amount = new BigDecimal(data.get("gv_cmpaccres.amount") == null ? "0" : data.get("gv_cmpaccres.amount").toString());
            cmpEntryInfo.setCalAmount(amount);
            BigDecimal exchangerate = data.get("gv_cmpaccres.exchangerate") == null ? null : new BigDecimal(data.get("gv_cmpaccres.exchangerate").toString());
            cmpEntryInfo.setExchangeRate(exchangerate);
            CmpCalTableInfo calTableInfo = new CmpCalTableInfo();
            if (data.get("cmp_CTB.id") != null) {
                calTableInfo.setId(BOSUuid.read((String)data.get("cmp_CTB.id").toString()));
            }
            cmpEntryInfo.setCmpCalTable(calTableInfo);
            BankInfo bankInfo2 = new BankInfo();
            bankInfo2.setId(BOSUuid.read((String)((String)data.get("gv_bank.id"))));
            cmpEntryInfo.setHrBank(bankInfo2);
            cmpEntryInfo.setBankName((String)data.get("gv_bank.name"));
            cmpEntryInfo.setAccountNum((String)data.get("gv_perbkrec.accountnum"));
            cmpEntryInfo.setRecProvince((String)data.get("gv_perbkrec.province"));
            cmpEntryInfo.setRecCity((String)data.get("gv_perbkrec.city"));
            String accountName = (String)data.get("gv_perbkrec.accountname");
            accountName = CmpStrUtil.isEmpty(accountName) ? (String)data.get("cmp_person.name") : accountName;
            cmpEntryInfo.setAccountName(accountName);
            AbstractCmpAgentPayBillCreating.AmountCombie ac = new AbstractCmpAgentPayBillCreating.AmountCombie(giveAmount, amount);
            String splitField = this.getSplitFieldKey(data, param, entryGroups);
            entryGroups.putOptionalCompanyMap(splitField, (String)data.get(this.optionalCompany));
            entryGroups.putCmpEntrysGroup(splitField, cmpEntryInfo);
            entryGroups.putCmpItemGroup(splitField, cmpItem);
            entryGroups.putCurrencyGroup(splitField, (String)data.get("gv_currency.id"));
            entryGroups.putSumAmountValue(splitField, ac);
        }
        return entryGroups;
    }

    @Override
    protected String getPayOrgSplitKey(Map<String, Object> data, Map param, AbstractCmpAgentPayBillCreating.EntryGroups entryGroups) throws EASBizException {
        CmpAgentPayBillSchemeInfo schemeInfo = this.getCmpAgentPayBillSchemeInfo();
        if (schemeInfo != null && schemeInfo.getOptionalCompanyField() != null) {
            return this.getOptionalPayOrgSplitKey(data, entryGroups);
        }
        return "";
    }

    @Override
    protected String getOptionalPayOrgSplitKey(Map<String, Object> data, AbstractCmpAgentPayBillCreating.EntryGroups entryGroups) throws EASBizException {
        return "@@" + data.get(this.optionalCompany);
    }

    @Override
    protected String getCurrencySplitInfo(Map<String, Object> data, AbstractCmpAgentPayBillCreating.EntryGroups entryGroups) throws EASBizException {
        return (String)data.get("gv_currency.name");
    }
}

