/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.agentIntegrate.remoteCallXKQJUtil;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.InteSystemEnum;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.compensation.app.agentIntegrate.remoteCallXKQJUtil.AdminOrgMappingDTO;
import com.kingdee.shr.compensation.app.agentIntegrate.remoteCallXKQJUtil.CurrencyMappingDTO;
import com.kingdee.shr.compensation.app.agentIntegrate.remoteCallXKQJUtil.XKQJAgentPayBillInfo;
import com.kingdee.shr.inte.cq.CallCQAPIService;
import com.kingdee.shr.inte.cq.bean.APIAndCallInfo;
import com.kingdee.shr.inte.cq.util.InteCQConfigUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.google.common.collect.Lists;

public class CmpRemoteCallXKQJService {
    private static final Logger logger = LoggerFactory.getLogger(CmpRemoteCallXKQJService.class);
    private static final String CMP_ADMIN_MAPPING_CODE = "cmp_admin_mapping";
    private static final String CMP_CURRENCY_CODE = "cmp_currency";
    private static final String CMP_AGENT_SAVE_CODE = "cmp_agent_save";

    private CmpRemoteCallXKQJService() {
    }

    public static List<AdminOrgMappingDTO> getXKQJAdminOrgMapping(Context ctx, List<String> adminOrgArray) throws BOSException, EASBizException {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5f00\u59cb\u8c03\u7528\u661f\u7a7a\u7ec4\u7ec7\u6620\u5c04\u63a5\u53e3\uff1a" + adminOrgArray);
        }
        JSONObject reqJson = new JSONObject();
        reqJson.put("numbers", adminOrgArray);
        reqJson.put("timestamp", (Object)System.currentTimeMillis());
        String result = CallCQAPIService.callNoException((Context)ctx, (InteSystemEnum)InteSystemEnum.XKQJ, (String)CMP_ADMIN_MAPPING_CODE, (String)reqJson.toJSONString());
        CmpRemoteCallXKQJService.checkResult(ctx, CMP_ADMIN_MAPPING_CODE, result);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        JSONArray datas = jsonObject.getJSONArray("data");
        if (datas == null || datas.size() == 0) {
            return null;
        }
        ArrayList adminList = Lists.newArrayList();
        for (int i = 0; i < datas.size(); ++i) {
            adminList.add(AdminOrgMappingDTO.buildOrgMapping(datas.getJSONObject(i)));
        }
        return adminList;
    }

    public static CurrencyMappingDTO getXKQJCurrencyMapping(Context ctx, String currencyNumber) throws BOSException, EASBizException {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5f00\u59cb\u8c03\u7528\u661f\u7a7a\u5e01\u522b\u67e5\u8be2\u63a5\u53e3\uff1a" + currencyNumber);
        }
        JSONObject dataJson = new JSONObject();
        dataJson.put("number", (Object)currencyNumber);
        dataJson.put("enable", (Object)Lists.newArrayList((Object[])new String[]{"1"}));
        JSONObject reqJson = new JSONObject();
        reqJson.put("data", (Object)dataJson);
        reqJson.put("pageNo", (Object)1);
        reqJson.put("pageSize", (Object)10);
        String result = CallCQAPIService.callNoException((Context)ctx, (InteSystemEnum)InteSystemEnum.XKQJ, (String)CMP_CURRENCY_CODE, (String)reqJson.toJSONString());
        CmpRemoteCallXKQJService.checkResult(ctx, CMP_CURRENCY_CODE, result);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        JSONObject data = jsonObject.getJSONObject("data");
        if (data.getJSONArray("rows") == null || data.getJSONArray("rows").isEmpty()) {
            return null;
        }
        JSONArray rows = data.getJSONArray("rows");
        return CurrencyMappingDTO.buildCurrency(rows.getJSONObject(0));
    }

    public static String submitXKQJAgentBill(Context ctx, List<XKQJAgentPayBillInfo> xkqjAgentBill) throws BOSException, EASBizException {
        JSONObject reqData = new JSONObject();
        reqData.put("data", xkqjAgentBill);
        String callResult = CallCQAPIService.callNoException((Context)ctx, (InteSystemEnum)InteSystemEnum.XKQJ, (String)CMP_AGENT_SAVE_CODE, (String)reqData.toJSONString());
        CmpRemoteCallXKQJService.checkResult(ctx, CMP_AGENT_SAVE_CODE, callResult);
        return callResult;
    }

    public static void checkResult(Context ctx, String number, String callResult) throws BOSException, EASBizException {
        HashMap result = JSONUtils.convertJsonToObject((Context)ctx, (String)callResult);
        Object data = result.get("data");
        if (data == null) {
            String errorCode = String.valueOf(result.get("errorCode"));
            String message = String.valueOf(result.get("message"));
            APIAndCallInfo callInfo = InteCQConfigUtil.getCallInfo((Context)ctx, (InteSystemEnum)InteSystemEnum.XKQJ, (String)number);
            InteCQConfigUtil.handlerErrorMsg((String)errorCode, (String)message, (APIAndCallInfo)callInfo);
        }
    }
}

