/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.api.xkqjresovler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.InteSystemEnum;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.CmpItemAccountBillCollection;
import com.kingdee.shr.compensation.CmpItemAccountBillEntryCollection;
import com.kingdee.shr.compensation.CmpItemAccountBillEntryInfo;
import com.kingdee.shr.compensation.CmpItemAccountBillFactory;
import com.kingdee.shr.compensation.CmpItemAccountBillInfo;
import com.kingdee.shr.compensation.CmpItemAccountBillRecordCollection;
import com.kingdee.shr.compensation.CmpItemInfo;
import com.kingdee.shr.compensation.app.agentIntegrate.remoteCallXKQJUtil.AdminOrgMappingDTO;
import com.kingdee.shr.compensation.app.agentIntegrate.remoteCallXKQJUtil.CmpRemoteCallXKQJService;
import com.kingdee.shr.compensation.app.api.xkqjresovler.XKQJPushResult;
import com.kingdee.shr.inte.cq.CallCQAPIService;
import com.kingdee.shr.inte.cq.bean.CQResponseBean;
import com.kingdee.shr.inte.cq.util.InteCQConfigUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class XKQJApiHelper {
    private static XKQJApiHelper instance;
    private static final String FEE_BILL_PUSH = "cmp_fee_save";
    private static final String CMP_ITEM_SYC = "cmp_item_syc";
    private static final String PRE_SHR_TAG = "s-HR_";
    private static Logger logger;

    private XKQJApiHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XKQJApiHelper getInstance() {
        if (instance != null) return instance;
        Class<XKQJApiHelper> clazz = XKQJApiHelper.class;
        synchronized (XKQJApiHelper.class) {
            if (instance != null) return instance;
            instance = new XKQJApiHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String syscItem(Context ctx, String billIDs) throws BOSException, EASBizException {
        Map<String, Object> result = this.assembleItemPushData(ctx, billIDs);
        String jsonData = (String)result.get("jsonData");
        CQResponseBean cqResponseBean = CallCQAPIService.callNoException2Trans((Context)ctx, (InteSystemEnum)InteSystemEnum.XKQJ, (String)CMP_ITEM_SYC, (String)jsonData);
        return this.convertItemResultMessage(ctx, cqResponseBean, (Map)result.get("numberNameMapping"));
    }

    private String convertItemResultMessage(Context ctx, CQResponseBean cqResponseBean, Map<String, String> numberNameMapping) throws BOSException, EASBizException {
        int failCount;
        Map data = (Map)cqResponseBean.getData();
        if (data == null || data.get("result") == null) {
            InteCQConfigUtil.handlerErrorMsg((CQResponseBean)cqResponseBean);
        }
        if ((failCount = Double.valueOf(String.valueOf(data.get("failCount"))).intValue()) == 0) {
            return null;
        }
        List resultMes = (List)data.get("result");
        StringBuilder mes = new StringBuilder();
        int index = 1;
        for (int i = 0; i < resultMes.size(); ++i) {
            String type;
            Map itemMes = (Map)resultMes.get(i);
            boolean billStatus = (Boolean)itemMes.get("billStatus");
            if (billStatus || !"Add".equals(type = (String)itemMes.get("type"))) continue;
            List errors = (List)itemMes.get("errors");
            Map error = (Map)errors.get(0);
            List rowMsg = (List)error.get("rowMsg");
            String errorMes = StringUtils.join((Iterable)rowMsg, (String)";");
            Map itemInfo = (Map)itemMes.get("keys");
            String pushNumber = String.valueOf(itemInfo.get("number"));
            pushNumber = pushNumber.replaceFirst(PRE_SHR_TAG, "");
            String name = numberNameMapping.get(pushNumber);
            mes.append(index++).append("\u3001").append(name).append("(").append(pushNumber).append(")").append(",").append(errorMes).append(";\n\r");
        }
        return mes.toString();
    }

    private Map<String, Object> assembleItemPushData(Context ctx, String billIDs) throws BOSException {
        String l = LocaleUtils.getShortCode((Context)ctx);
        String sql = "select item.FNUMBER ,item.FNAME_" + l + " from T_HR_SCmpItemAccountBill bill inner join t_hr_scalscheme scheme on bill.FCALSCHEMEID = scheme.FID inner join t_hr_scalschemeitem si on si.FCALSCHEMEID = scheme.FID inner join t_hr_scmpitem item on si.FCMPITEMID = item.FID where item.FDATATYPE = 0 and bill.fid in (" + billIDs + ") and FIsCostBear = 1";
        LinkedList itemList = new LinkedList();
        HashMap<String, String> numberNameMapping = new HashMap<String, String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String number = rs.getString("FNUMBER");
                String name = rs.getString("FNAME_" + l);
                numberNameMapping.put(number, name);
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("number", PRE_SHR_TAG + number);
                item.put("name", name);
                item.put("isleaf", true);
                item.put("remark", "\u7531s-HR\u85aa\u916c\u9879\u76ee\u540c\u6b65");
                itemList.add(item);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        HashMap<String, Serializable> pushData = new HashMap<String, Serializable>();
        pushData.put("data", itemList);
        pushData.put("timestamp", Long.valueOf(System.currentTimeMillis()));
        String jsonData = JSONUtils.convertObjectToJson((Context)ctx, pushData);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("jsonData", jsonData);
        result.put("numberNameMapping", numberNameMapping);
        return result;
    }

    public Map<String, XKQJPushResult> submitFinanceSys(Context ctx, String billIDs, String businessDate) throws BOSException, EASBizException {
        String oql = "select id,paymentOrgNumber,currency.number,currency.isoCode,paymentOrgNumber,settementOrgNumber,entries.adminOrg.number,entries.cmpItemRecords.cmpItem.number,entries.amount,entries.remark where id in (" + billIDs + ") order by id,entries.seq";
        CmpItemAccountBillCollection coll = CmpItemAccountBillFactory.getLocalInstance(ctx).getCmpItemAccountBillCollection(oql);
        if (coll.size() == 0) {
            throw new BOSException("bill data error!");
        }
        String jsonData = this.assembleBillPushData(ctx, coll, businessDate);
        CQResponseBean cqResponseBean = CallCQAPIService.callNoException2Trans((Context)ctx, (InteSystemEnum)InteSystemEnum.XKQJ, (String)FEE_BILL_PUSH, (String)jsonData);
        return this.convertBillResult(ctx, cqResponseBean, coll);
    }

    private Map<String, XKQJPushResult> convertBillResult(Context ctx, CQResponseBean cqResponseBean, CmpItemAccountBillCollection coll) throws BOSException, EASBizException {
        Map data = (Map)cqResponseBean.getData();
        if (data == null || data.get("result") == null) {
            InteCQConfigUtil.handlerErrorMsg((CQResponseBean)cqResponseBean);
        }
        List resultMes = (List)data.get("result");
        HashMap<String, XKQJPushResult> resultMap = new HashMap<String, XKQJPushResult>();
        for (int i = 0; i < resultMes.size(); ++i) {
            XKQJPushResult pushResult = new XKQJPushResult();
            CmpItemAccountBillInfo billInfo = coll.get(i);
            pushResult.setBillId(billInfo.getId().toString());
            Map billResult = (Map)resultMes.get(i);
            boolean billStatus = (Boolean)billResult.get("billStatus");
            if (billStatus) {
                String xkqjBillId = (String)billResult.get("id");
                String xkqjBillNumber = (String)billResult.get("number");
                pushResult.setXkqjBillId(xkqjBillId);
                pushResult.setXkqjBillNumber(xkqjBillNumber);
                pushResult.setPushSuccess(billStatus);
            } else {
                List errors = (List)billResult.get("errors");
                Map error = (Map)errors.get(0);
                List rowMsg = (List)error.get("rowMsg");
                String errorMes = StringUtils.join((Iterable)rowMsg, (String)";");
                if (errorMes.length() > 1000) {
                    errorMes = errorMes.substring(0, 1000) + "...";
                }
                pushResult.setPushSuccess(billStatus);
                pushResult.setErrorMes(errorMes);
            }
            resultMap.put(pushResult.getBillId(), pushResult);
        }
        return resultMap;
    }

    private String assembleBillPushData(Context ctx, CmpItemAccountBillCollection coll, String businessDate) throws BOSException {
        ArrayList dataList = new ArrayList();
        for (int i = 0; i < coll.size(); ++i) {
            CmpItemAccountBillInfo billInfo = coll.get(i);
            LinkedHashMap<String, Object> entryBillData = new LinkedHashMap<String, Object>();
            entryBillData.put("billtypeid_number", "ApFin_shr_BT_S");
            entryBillData.put("org_number", billInfo.getSettementOrgNumber());
            entryBillData.put("bizdate", businessDate);
            entryBillData.put("asstacttype", "cas_othercontactunit");
            entryBillData.put("currency_number", billInfo.getCurrency().getNumber());
            entryBillData.put("exratetable_number", "ERT-01");
            entryBillData.put("payorg_number", billInfo.getPaymentOrgNumber());
            entryBillData.put("isincludetax", true);
            entryBillData.put("ispricetotal", false);
            CmpItemAccountBillEntryCollection entries = billInfo.getEntries();
            ArrayList entryDataList = new ArrayList();
            entryBillData.put("detailentry", entryDataList);
            for (int j = 0; j < entries.size(); ++j) {
                BigDecimal amount;
                CmpItemInfo cmpItem;
                CmpItemAccountBillEntryInfo entryInfo = entries.get(j);
                LinkedHashMap<String, Object> entryData = new LinkedHashMap<String, Object>();
                CmpItemAccountBillRecordCollection cmpItemRecords = entryInfo.getCmpItemRecords();
                if (cmpItemRecords != null && cmpItemRecords.size() > 0 && (cmpItem = cmpItemRecords.get(0).getCmpItem()) != null) {
                    entryData.put("expenseitem_number", PRE_SHR_TAG + cmpItem.getNumber());
                }
                if ((amount = entryInfo.getAmount()).compareTo(BigDecimal.ZERO) < 0) {
                    entryData.put("quantity", -1);
                    entryData.put("pricetax", amount.abs());
                } else {
                    entryData.put("quantity", 1);
                    entryData.put("pricetax", amount);
                }
                entryData.put("discountmode", "NULL");
                entryData.put("department_number", entryInfo.getAdminOrg().getNumber());
                entryData.put("e_remark", entryInfo.getRemark());
                entryDataList.add(entryData);
            }
            dataList.add(entryBillData);
        }
        HashMap res = new HashMap();
        res.put("data", dataList);
        return JSONUtils.convertObjectToJson((Context)ctx, res);
    }

    public List<AdminOrgMappingDTO> getAdminOrgMapping(Context ctx, Set<String> orgIds) throws BOSException, EASBizException {
        return CmpRemoteCallXKQJService.getXKQJAdminOrgMapping(ctx, new ArrayList<String>(orgIds));
    }

    static {
        logger = Logger.getLogger(XKQJApiHelper.class);
    }
}

