/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.cache.service.CacheService;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.util.MD5Util;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.cmpdesign.exception.AdjustBillException;
import com.kingdee.shr.compensation.app.budget.AbstractBudgetCalculateFacadeControllerBean;
import com.kingdee.shr.compensation.budget.dto.BudgetCalculateOuterData;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.validaterule.BaseFormulaCollection;
import com.kingdee.shr.validaterule.BaseFormulaFactory;
import com.kingdee.shr.validaterule.BaseFormulaInfo;
import com.kingdee.shr.validaterule.formula.SalaryCalculator2;
import com.kingdee.shr.validaterule.formula.SalaryCalculatorProxy2;
import com.kingdee.shr.validaterule.formula.SalayCalculatorMgr2;
import com.kingdee.shr.validaterule.formula.base.vo.Cell;
import com.kingdee.shr.validaterule.formula.base.vo.ErrRow;
import com.kingdee.shr.validaterule.formula.base.vo.Row;
import com.kingdee.shr.validaterule.formula.base.vo.Sheet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class BudgetCalculateFacadeControllerBean
extends AbstractBudgetCalculateFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(BudgetCalculateFacadeControllerBean.class);
    private String budgeTemplateID = "";

    @Override
    protected Map _calculate(Context ctx, Map param) throws BOSException, EASBizException {
        String calSchemeID = (String)param.get("calSchemeID");
        BudgetCalculateOuterData outerData = (BudgetCalculateOuterData)param.get("outerData");
        outerData.setBudgetSchemeId(calSchemeID);
        List<String> updateIds = outerData.getUpdateIds();
        this.initBudgeTemplateID(ctx, calSchemeID);
        String condition = "select fid from T_HR_SBudgetManage where ";
        condition = null == updateIds || updateIds.size() == 0 ? condition + "1 <> 1 " : condition + " fid in (" + CmpStrUtil.convertListToString(updateIds) + ")";
        BaseFormulaCollection formulaCollection = this.initCalFormula(ctx, calSchemeID);
        Sheet calResult = this.post(ctx, calSchemeID, formulaCollection, condition, outerData, false);
        formulaCollection.clear();
        formulaCollection = this.addVerificationRule(ctx, calSchemeID, formulaCollection);
        Map<String, Map<String, Object>> data = outerData.getData();
        if (null != calResult && null != calResult.getChangeDataList()) {
            List changeDataList = calResult.getChangeDataList();
            for (Row row : changeDataList) {
                String fid = row.getFID();
                Map<String, Object> perOrgData = data.get(fid);
                List cells = row.getCells();
                for (Cell cell : cells) {
                    String column = cell.getColumn();
                    String value = cell.getValue();
                    perOrgData.put(column, value);
                }
            }
        }
        Sheet validateResult = this.post(ctx, calSchemeID, formulaCollection, condition, outerData, true);
        HashMap<String, Sheet> result = new HashMap<String, Sheet>();
        Sheet combineSheet = this.combineSheet(calResult, validateResult);
        result.put("result", combineSheet);
        if (logger.isDebugEnabled()) {
            logger.error((Object)("com.kingdee.shr.compensation.app.budget.BudgetCalculateFacadeControllerBean._calculate(Context, Map)--" + combineSheet));
        }
        return result;
    }

    protected Sheet combineSheet(Sheet calResult, Sheet validateResult) {
        if (null == validateResult) {
            return calResult;
        }
        if (null == calResult) {
            calResult = validateResult;
            List changeDataList = calResult.getChangeDataList();
            Map changeDataIndexMap = calResult.getChangeDataIndexMap();
            block0: for (Row row : changeDataList) {
                String fid = row.getFID();
                List cells = row.getCells();
                for (Cell cell : cells) {
                    String column = cell.getColumn();
                    String value = cell.getValue();
                    if (!"FORWARNCONTENT".equals(column) || StringUtils.isEmpty((CharSequence)value)) continue;
                    ErrRow errRow = new ErrRow(fid, value);
                    calResult.addErrorData(errRow);
                    ((Row)calResult.getChangeDataList().get((Integer)changeDataIndexMap.get(fid))).setCells(null);
                    continue block0;
                }
            }
            return calResult;
        }
        String errMsg = validateResult.getErrMsg();
        if (StringUtils.isEmpty((CharSequence)errMsg)) {
            List errDataList = validateResult.getErrDataList();
            Map changeDataIndexMap = calResult.getChangeDataIndexMap();
            Map errDataIndexMap = calResult.getErrDataIndexMap();
            for (ErrRow errRow : errDataList) {
                String fid = errRow.getFID();
                if (errDataIndexMap.containsKey(fid)) continue;
                calResult.addErrorData(errRow);
                ((Row)calResult.getChangeDataList().get((Integer)changeDataIndexMap.get(fid))).setCells(null);
            }
            List validateRuleResult = validateResult.getChangeDataList();
            for (Row row : validateRuleResult) {
                String fid = row.getFID();
                List cells = row.getCells();
                for (Cell cell : cells) {
                    String column = cell.getColumn();
                    String value = cell.getValue();
                    if (!"FORWARNCONTENT".equals(column) || StringUtils.isEmpty((CharSequence)value) || errDataIndexMap.containsKey(fid)) continue;
                    ErrRow errRow = new ErrRow(fid, value);
                    calResult.addErrorData(errRow);
                    ((Row)calResult.getChangeDataList().get((Integer)changeDataIndexMap.get(fid))).setCells(null);
                }
            }
        } else {
            calResult.setErrMsg(errMsg);
        }
        return calResult;
    }

    protected void initBudgeTemplateID(Context ctx, String budgetSchemeId) throws BOSException {
        String sql = "select FTemplateID from T_HR_SCmpBudgetScheme where fid = '" + budgetSchemeId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                this.budgeTemplateID = rs.getString("FTemplateID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected BaseFormulaCollection initCalFormula(Context ctx, String calSchemeID) throws BOSException, EASBizException {
        BaseFormulaCollection formulaCollection;
        BaseFormulaCollection realFormulaColl = new BaseFormulaCollection();
        StringBuilder sqlBuffer = new StringBuilder();
        sqlBuffer.append(" select id,name,calItem,express,listItem,listFunc,listVar,listTable,sortSn,bigExpress ");
        sqlBuffer.append(" where isCal = 1 and businessRelationConfig.businessId = '").append(this.budgeTemplateID).append("'");
        sqlBuffer.append(" order by sortSn");
        try {
            formulaCollection = BaseFormulaFactory.getLocalInstance((Context)ctx).getBaseFormulaCollection(sqlBuffer.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new AdjustBillException(AdjustBillException.GETFORMULAERR, (Throwable)e);
        }
        int size = formulaCollection.size();
        for (int i = 0; i < size; ++i) {
            BaseFormulaInfo verificationRule = formulaCollection.get(i);
            String express = verificationRule.getExpress();
            String bigExpress = verificationRule.getBigExpress();
            verificationRule.setExpress(express);
            verificationRule.setBigExpress(bigExpress);
            String listItem = verificationRule.getListItem();
            verificationRule.setListItem(listItem);
            realFormulaColl.add(verificationRule);
        }
        return realFormulaColl;
    }

    protected BaseFormulaCollection addVerificationRule(Context ctx, String calSchemeID, BaseFormulaCollection realFormulaColl) throws BOSException {
        StringBuilder sqlBuffer = new StringBuilder();
        String language = ctx.getLocale().getLanguage();
        sqlBuffer.append(" SELECT D.FID,B.FNAME_").append(language).append(" NAME,D.FEXPRESS,D.FBIGEXPRESS,D.FLISTITEM,D.FLISTFUNC,D.FLISTVAR ");
        sqlBuffer.append(" FROM T_HR_SBudgetTempVeriRule A ");
        sqlBuffer.append(" INNER JOIN T_HR_SVERIFICATIONRULE B ON A.FVERIFICATIONRULEID = B.FID ");
        sqlBuffer.append(" INNER JOIN T_HR_SBUSINESSRELATIONCONFIG C ON B.FID = C.FBUSINESSID ");
        sqlBuffer.append(" INNER JOIN T_HR_SBASEFORMULA D ON D.FBUSINESSRELATIONCONFIGID = C.FID ");
        sqlBuffer.append(" WHERE A.FBudgetTemplateID = '").append(this.budgeTemplateID).append("' ");
        sqlBuffer.append(" ORDER BY A.FSORTCODE ");
        IRowSet rowSet = CmpSQLUtil.executeQuery(ctx, sqlBuffer.toString());
        StringBuilder expressBuf = new StringBuilder();
        expressBuf.append("T_HR_SBudgetManage_forwarncontent = \"\" ");
        StringBuilder listVarBuf = new StringBuilder();
        int index = 0;
        int size = rowSet.size();
        try {
            while (rowSet.next()) {
                String id = rowSet.getString("FID");
                String name = rowSet.getString("NAME");
                String express = rowSet.getString("FEXPRESS");
                String bigExpress = rowSet.getString("FBIGEXPRESS");
                String listItem = rowSet.getString("FLISTITEM");
                String listFunc = rowSet.getString("FLISTFUNC");
                String listVar = rowSet.getString("FLISTVAR");
                BaseFormulaInfo verificationRule = new BaseFormulaInfo();
                verificationRule.setId(BOSUuid.read((String)id));
                verificationRule.setName(name);
                verificationRule.setExpress(express);
                verificationRule.setBigExpress(bigExpress);
                verificationRule.setListItem(listItem);
                verificationRule.setListFunc(listFunc);
                verificationRule.setListVar(listVar);
                String var = listVar.split("~")[2].substring(1);
                expressBuf.append(" + (\"\".equals(").append(var).append(") ? \"\" : (").append(var);
                if (index < size - 1) {
                    expressBuf.append(" + \";\"");
                }
                expressBuf.append("))");
                listVarBuf.append(";").append(listVar);
                ++index;
                realFormulaColl.add(verificationRule);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (realFormulaColl.isEmpty()) {
            return realFormulaColl;
        }
        BaseFormulaInfo verificationRule = new BaseFormulaInfo();
        verificationRule.setName(EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.AdjustSalaryApplyResource", (String)"label24", (Locale)ctx.getLocale()));
        verificationRule.setCalItem("forwarncontent");
        verificationRule.setListItem("String~T_HR_SBudgetManage~forwarncontent");
        if (index > 0) {
            verificationRule.setListVar(listVarBuf.toString().replaceFirst(";", ""));
        }
        expressBuf.append(";");
        verificationRule.setExpress(expressBuf.toString());
        realFormulaColl.add(verificationRule);
        return realFormulaColl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Sheet post(Context ctx, String calSchemeID, BaseFormulaCollection formulaCollection, String condition, BudgetCalculateOuterData outerData, boolean isContainsVerification) {
        if (null == formulaCollection || formulaCollection.size() == 0) {
            return null;
        }
        SalaryCalculator2 cal = new SalaryCalculator2();
        SalayCalculatorMgr2.addTask((SalaryCalculator2)cal);
        String uid = cal.getUID();
        try {
            SalaryCalculatorProxy2 cal2 = new SalaryCalculatorProxy2(uid, true);
            cal2.setMainTableName("T_HR_SBudgetManage");
            cal2.setMainTableAlias("MANAGE");
            cal2.setCalCategoryNum("CMP_Budget_001");
            cal2.setSchemeID(calSchemeID);
            cal2.setCtx(ctx);
            cal2.setEndDate(new Date());
            cal2.setCalFormulaColl(formulaCollection);
            cal2.setMainTableRowFilter(condition);
            cal2.setOuterData((Object)outerData);
            cal2.setContainsVerification(isContainsVerification);
            cal2.post();
            Sheet sheet = cal2.getCalResult();
            return sheet;
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NumberFormatException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            SalayCalculatorMgr2.removeTask((String)uid, (String)"");
            String cacheKey = MD5Util.getMD5String((String)(uid + ctx));
            CacheService cacheService = CacheService.getInstance();
            cacheService.hdel("shr.validateruleCache", cacheKey, "BUDGET_MANAGE_TREEDATA_CACHE_KEY");
        }
        return null;
    }
}

