/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.budget;

import com.google.common.collect.Lists;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsHeader;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.compensation.app.budget.AbstractBudgetTemplateSTBItemControllerBean;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateSTBItemCollection;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateSTBItemFactory;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateSTBItemInfo;
import com.kingdee.shr.compensation.app.budget.SchemeDeduConfigCollection;
import com.kingdee.shr.compensation.app.budget.SchemeDeduConfigFactory;
import com.kingdee.shr.compensation.app.budget.SchemeDeduConfigInfo;
import com.kingdee.shr.compensation.app.cmpBudget.BudgetDeductionConfigCollection;
import com.kingdee.shr.compensation.app.cmpBudget.BudgetDeductionConfigFactory;
import com.kingdee.shr.compensation.app.cmpBudget.BudgetDeductionConfigInfo;
import com.kingdee.shr.compensation.pojo.budget.DeductionRule;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class BudgetTemplateSTBItemControllerBean
extends AbstractBudgetTemplateSTBItemControllerBean {
    @Override
    protected BatchMessageTipsHeader _saveList(Context ctx, String templateId, int templateType, String data) throws BOSException {
        List list = (List)JSONUtils.convertJsonToObject((Context)ctx, (String)data, List.class);
        BatchMessageTipsHeader tips = new BatchMessageTipsHeader();
        if (null == list) {
            return tips;
        }
        boolean havingManageData = this.havingManageData(ctx, templateId);
        ArrayList<String> existed = new ArrayList<String>();
        ArrayList allIdList = new ArrayList();
        list.forEach(e -> {
            String id = (String)e.get("id");
            allIdList.add(id);
            if (id != null && !CmpStrUtil.isNumber(id)) {
                existed.add((String)e.get("id"));
            }
        });
        tips.setBillId(String.join((CharSequence)",", allIdList));
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        Map<String, DeductionRule> referredMap = this.initReferenceData(ctx, templateType, existed);
        Map<String, BudgetTemplateSTBItemInfo> dbData = this.loadDBData(ctx, existed);
        String schemeType = this.getSchemeType(ctx, templateType);
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>();
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>();
        ArrayList<Object[]> sortSnParams = new ArrayList<Object[]>();
        int success = 0;
        int failed = 0;
        for (Map map : list) {
            Object[] sortSnParam;
            String id = (String)map.get("id");
            BatchMessageTipsBody body = new BatchMessageTipsBody();
            body.setId(id);
            tips.addResult(body);
            Map cmpBudgetItem = (Map)map.get("cmpBudgetItem");
            Map standingBookItem = (Map)map.get("standingBookItem");
            Map balanceLedgerItem = (Map)map.get("balanceLedgerItem");
            boolean successful = true;
            String msg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label35", (Locale)ctx.getLocale());
            if (havingManageData && this.isModified(dbData, id, cmpBudgetItem, standingBookItem, balanceLedgerItem)) {
                successful = false;
                msg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label36", (Locale)ctx.getLocale());
            } else if (this.isStandingBookItemRepeated(referredMap, standingBookItem, balanceLedgerItem, id)) {
                sortSnParam = new Object[]{this.getSortSn(map), userId, id};
                sortSnParams.add(sortSnParam);
                successful = false;
                msg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label56", (Locale)ctx.getLocale());
            } else if (this.isReferred(referredMap, id) && this.isModified(dbData, id, cmpBudgetItem, standingBookItem, balanceLedgerItem)) {
                sortSnParam = new Object[]{this.getSortSn(map), userId, id};
                sortSnParams.add(sortSnParam);
                successful = false;
                msg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label37", (Locale)ctx.getLocale());
                msg = MessageFormat.format(msg, schemeType, referredMap.get(id).getSchemeName());
            } else if (CmpStrUtil.isNumber(id)) {
                Object[] insertParam = new Object[]{templateId, cmpBudgetItem.get("id"), standingBookItem.get("id"), balanceLedgerItem.get("id"), this.getSortSn(map), userId};
                insertParams.add(insertParam);
            } else {
                Object[] updateParam = new Object[]{cmpBudgetItem.get("id"), standingBookItem.get("id"), balanceLedgerItem.get("id"), this.getSortSn(map), userId, id};
                updateParams.add(updateParam);
            }
            body.setMuitTipsMessage(msg);
            body.setMuitTipsState(successful);
            if (successful) {
                ++success;
                continue;
            }
            ++failed;
        }
        this.saveData(ctx, insertParams, updateParams, sortSnParams);
        tips.setFailureCount(failed);
        tips.setSuccessCount(success);
        return tips;
    }

    private Map<String, BudgetTemplateSTBItemInfo> loadDBData(Context ctx, List<String> existed) throws BOSException {
        if (existed.isEmpty()) {
            return null;
        }
        BudgetTemplateSTBItemCollection collection = BudgetTemplateSTBItemFactory.getLocalInstance(ctx).getBudgetTemplateSTBItemCollection("where id in (" + CmpStrUtil.convertListToString(existed) + ")");
        HashMap<String, BudgetTemplateSTBItemInfo> map = new HashMap<String, BudgetTemplateSTBItemInfo>();
        for (int i = 0; i < collection.size(); ++i) {
            BudgetTemplateSTBItemInfo info = collection.get(i);
            map.put(info.getId().toString(), info);
        }
        return map;
    }

    private boolean isStandingBookItemRepeated(Map<String, DeductionRule> referredMap, Map<String, Object> standingBookItem, Map<String, Object> balanceLedgerItem, String id) {
        if (CmpStrUtil.isNumber(id) || !referredMap.containsKey(id)) {
            for (DeductionRule rule : referredMap.values()) {
                if (rule.getBudgetTemplateSTBItemInfo().getBalanceLedgerItem().getId().toString().equals(balanceLedgerItem.get("id"))) {
                    return true;
                }
                if (!rule.getBudgetTemplateSTBItemInfo().getStandingBookItem().getId().toString().equals(standingBookItem.get("id"))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected BatchMessageTipsHeader _batchDelete(Context ctx, String templateId, int templateType, String billIds) throws BOSException, EASBizException {
        boolean havingManageData = this.havingManageData(ctx, templateId);
        if (havingManageData) {
            throw new EASBizException(new NumericExceptionSubItem("HAVING_BUDGET", EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label29", (Locale)ctx.getLocale())));
        }
        BatchMessageTipsHeader tips = new BatchMessageTipsHeader();
        tips.setBillId(billIds);
        ArrayList ids = Lists.newArrayList((Object[])billIds.split(","));
        Map<String, DeductionRule> referredMap = this.initReferenceData(ctx, templateType, ids);
        Iterator iterator = ids.iterator();
        int success = 0;
        int failed = 0;
        String schemeType = this.getSchemeType(ctx, templateType);
        String sucMsg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label33", (Locale)ctx.getLocale());
        String errMsg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label34", (Locale)ctx.getLocale());
        while (iterator.hasNext()) {
            String id = (String)iterator.next();
            BatchMessageTipsBody body = new BatchMessageTipsBody();
            body.setId(id);
            tips.addResult(body);
            boolean successful = true;
            String msg = sucMsg;
            if (this.isReferred(referredMap, id)) {
                iterator.remove();
                successful = false;
                msg = MessageFormat.format(errMsg, schemeType, referredMap.get(id).getSchemeName());
            }
            body.setMuitTipsMessage(msg);
            body.setMuitTipsState(successful);
            if (successful) {
                ++success;
                continue;
            }
            ++failed;
        }
        this.deleteData(ctx, ids);
        tips.setFailureCount(failed);
        tips.setSuccessCount(success);
        return tips;
    }

    private void deleteData(Context ctx, List<String> ids) throws BOSException {
        if (!ids.isEmpty()) {
            String sql = "delete from T_HR_SBudgetTemplateSTBItem where fid in (" + CmpStrUtil.convertListToString(ids) + ")";
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    private Integer getSortSn(Map<String, Object> map) {
        Object sortSn = map.get("sortSn");
        if (null == sortSn || StringUtils.isEmpty((String)String.valueOf(sortSn))) {
            return null;
        }
        return (int)Double.parseDouble(String.valueOf(sortSn));
    }

    protected void saveData(Context ctx, List<Object[]> insertParams, List<Object[]> updateParams, List<Object[]> sortSnParams) throws BOSException {
        if (!insertParams.isEmpty()) {
            String insertSQL = "insert into T_HR_SBudgetTemplateSTBItem (FTemplateID, FCmpBudgetItemId, FStandingBookItemID, FBalanceLedgerItemID, FSortSn, FIsTemplatePreset, FCreatorId, FCreateTime, Fid) values (?, ?, ?, ?, ?, 0, ?, now(), newBosId('7E8E626E'))";
            DbUtil.executeBatch((Context)ctx, (String)insertSQL, insertParams);
        }
        if (!updateParams.isEmpty()) {
            String updateSQL = "update T_HR_SBudgetTemplateSTBItem set FCmpBudgetItemId = ?, FStandingBookItemID = ?, FBalanceLedgerItemID = ?, FSortSn = ?, FLastUpdateUserId = ?, FLastUpdateTime = now() where fid = ? ";
            DbUtil.executeBatch((Context)ctx, (String)updateSQL, updateParams);
        }
        if (!sortSnParams.isEmpty()) {
            String sortSnSQL = "update T_HR_SBudgetTemplateSTBItem set FSortSn = ?, FLastUpdateUserId = ?, FLastUpdateTime = now() where fid = ? ";
            DbUtil.executeBatch((Context)ctx, (String)sortSnSQL, sortSnParams);
        }
    }

    protected boolean isReferred(Map<String, DeductionRule> referredMap, String id) {
        return referredMap.get(id) != null;
    }

    protected String getSchemeType(Context ctx, int templateType) {
        if (templateType == 2) {
            return EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label30", (Locale)ctx.getLocale());
        }
        if (templateType == 0 || templateType == 1) {
            return EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label31", (Locale)ctx.getLocale());
        }
        return EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label32", (Locale)ctx.getLocale());
    }

    protected Map<String, DeductionRule> initReferenceData(Context ctx, int templateType, List<String> existed) throws BOSException {
        HashMap<String, DeductionRule> referredMap;
        block4: {
            referredMap = new HashMap<String, DeductionRule>();
            if (existed.isEmpty()) break block4;
            if (templateType == 2) {
                String oql = "select cmpBudgetItemRel.id, calScheme.name, cmpBudgetItemRel.cmpBudgetItem.id, cmpBudgetItemRel.cmpBudgetItem.name, cmpBudgetItemRel.standingBookItem.id, cmpBudgetItemRel.standingBookItem.name, cmpBudgetItemRel.balanceLedgerItem.id, cmpBudgetItemRel.balanceLedgerItem.name where cmpBudgetItemRel.id in (" + CmpStrUtil.convertListToString(existed) + ")";
                BudgetDeductionConfigCollection collection = BudgetDeductionConfigFactory.getLocalInstance(ctx).getBudgetDeductionConfigCollection(oql);
                for (int i = 0; i < collection.size(); ++i) {
                    BudgetDeductionConfigInfo info = collection.get(i);
                    DeductionRule deductionRule = new DeductionRule();
                    deductionRule.setSchemeName(info.getCalScheme().getName());
                    deductionRule.setBudgetTemplateSTBItemInfo(info.getCmpBudgetItemRel());
                    referredMap.put(info.getCmpBudgetItemRel().getId().toString(), deductionRule);
                }
            } else {
                String oql = "select templateStbItem.id, calSubmitScheme.name, templateStbItem.cmpBudgetItem.id, templateStbItem.cmpBudgetItem.name, templateStbItem.standingBookItem.id, templateStbItem.standingBookItem.name, templateStbItem.balanceLedgerItem.id, templateStbItem.balanceLedgerItem.name where templateStbItem.id in (" + CmpStrUtil.convertListToString(existed) + ")";
                SchemeDeduConfigCollection collection = SchemeDeduConfigFactory.getLocalInstance(ctx).getSchemeDeduConfigCollection(oql);
                for (int i = 0; i < collection.size(); ++i) {
                    SchemeDeduConfigInfo info = collection.get(i);
                    DeductionRule deductionRule = new DeductionRule();
                    deductionRule.setSchemeName(info.getCalSubmitScheme().getName());
                    deductionRule.setBudgetTemplateSTBItemInfo(info.getTemplateStbItem());
                    referredMap.put(info.getTemplateStbItem().getId().toString(), deductionRule);
                }
            }
        }
        return referredMap;
    }

    protected boolean isModified(Map<String, BudgetTemplateSTBItemInfo> dbData, String id, Map<String, Object> cmpBudgetItem, Map<String, Object> standingBookItem, Map<String, Object> balanceLedgerItem) {
        if (null == dbData) {
            return false;
        }
        BudgetTemplateSTBItemInfo old = dbData.get(id);
        if (null == old) {
            return false;
        }
        return !old.getCmpBudgetItem().getId().toString().equals(cmpBudgetItem.get("id")) || !old.getStandingBookItem().getId().toString().equals(standingBookItem.get("id")) || !old.getBalanceLedgerItem().getId().toString().equals(balanceLedgerItem.get("id"));
    }

    protected boolean havingManageData(Context ctx, String templateId) throws BOSException {
        String sql = "select top 1 bm.fid from T_HR_SBudgetManage bm, T_HR_SCmpBudgetScheme cbs where bm.FBudgetSchemeID = cbs.fid and cbs.FTemplateID = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{templateId});
        return rs.size() > 0;
    }
}

