/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.budget.budgetadjust;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateTypeEnum;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeInfo;
import com.kingdee.shr.compensation.app.budget.budgetadjust.AbstractBudgetAdjustBillControllerBean;
import com.kingdee.shr.compensation.app.budget.budgetadjust.BudgetAdjustBillCollection;
import com.kingdee.shr.compensation.app.budget.budgetadjust.BudgetAdjustBillFactory;
import com.kingdee.shr.compensation.app.budget.budgetadjust.BudgetAdjustBillInfo;
import com.kingdee.shr.compensation.app.budget.budgetadjust.BudgetAdjustEntryCollection;
import com.kingdee.shr.compensation.app.budget.budgetadjust.SubBudgetAdjustEntryCollection;
import com.kingdee.shr.compensation.budget.budgetadjust.bean.BudgetAdjustEntryParam;
import com.kingdee.shr.compensation.budget.budgetadjust.bean.BudgetItemMapInfo;
import com.kingdee.shr.compensation.budget.budgetadjust.bean.BudgetPeriodMapInfo;
import com.kingdee.shr.compensation.budget.budgetadjust.impl.BudgetAdjustEntryHelper;
import com.kingdee.shr.compensation.budget.budgetadjust.impl.BudgetAdjustService;
import com.kingdee.shr.compensation.budget.budgetadjust.impl.BudgetManageHelper;
import com.kingdee.shr.compensation.budget.budgetadjust.impl.BudgetadjustEntryValidateHelper;
import com.kingdee.shr.compensation.budget.budgetadjust.impl.SubBudgetManageHelper;
import com.kingdee.shr.compensation.budget.budgetadjust.util.BudgetAdjustSqlUtils;
import com.kingdee.shr.compensation.exception.BudgetEASBizException;
import com.kingdee.shr.compensation.exception.CmpBasicException;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class BudgetAdjustBillControllerBean
extends AbstractBudgetAdjustBillControllerBean {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.budget.budgetadjust.BudgetAdjustBillControllerBean");
    private final BudgetAdjustService service = new BudgetAdjustService();

    public void _untiCheckBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((CharSequence)billId)) {
            throw new BOSException("billId is null!");
        }
        BudgetAdjustBillInfo billInfo = this.service.getBillInfo(ctx, billId);
        HRBillStateEnum billState = billInfo.getBillState();
        if (billState == null || HRBillStateEnum.AUDITED.compareTo((Object)billState) != 0) {
            throw new BudgetEASBizException(BudgetEASBizException.EXCEPTION21);
        }
        CmpBudgetSchemeInfo schemeInfo = billInfo.getBudgetScheme();
        BudgetAdjustEntryHelper entryHelper = new BudgetAdjustEntryHelper(ctx, billId, schemeInfo);
        try {
            boolean existNewEntryExpenseData = this.service.existNewEntrySnapshot(ctx, billId, schemeInfo);
            if (existNewEntryExpenseData) {
                throw new BudgetEASBizException(BudgetEASBizException.EXCEPTION28);
            }
            BudgetAdjustEntryCollection entryCol = entryHelper.assembleEntryCol();
            SubBudgetAdjustEntryCollection subEntryCol = entryHelper.assembleSubEntryCol(true);
            BudgetItemMapInfo itemMap = entryHelper.getItemMap();
            List<String> colNameHisList = itemMap.getColNameHisList();
            BudgetadjustEntryValidateHelper validateHelper = new BudgetadjustEntryValidateHelper(ctx, schemeInfo);
            validateHelper.saveEntryExpenseValid(entryCol, colNameHisList, subEntryCol);
            boolean existVersionDifferent = this.service.existVersionDifferent(ctx, billId, schemeInfo, false);
            if (existVersionDifferent) {
                throw new BudgetEASBizException(BudgetEASBizException.EXCEPTION14);
            }
            this.doEntryAnti(ctx, billId, schemeInfo);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.updateBillState(ctx, BOSUuid.read((String)billId), HRBillStateEnum.SAVED);
        this.clearAuditor(ctx, billId);
    }

    private void doEntryAnti(Context ctx, String billId, CmpBudgetSchemeInfo schemeInfo) throws BOSException, EASBizException, SQLException {
        this.deleteRelatedEmptyData(ctx, billId);
        this.reversRelatedData(ctx, billId, schemeInfo);
        this.dealBack(ctx, billId);
    }

    public void reversRelatedData(Context ctx, String billId, CmpBudgetSchemeInfo schemeInfo) throws EASBizException, BOSException, SQLException {
        BudgetManageHelper helper = new BudgetManageHelper(ctx, billId, schemeInfo, true);
        helper.update(" and FbackupVersion > -1");
        if (this.service.hasSubEntry(schemeInfo)) {
            SubBudgetManageHelper subHelper = new SubBudgetManageHelper(ctx, billId, schemeInfo, true);
            subHelper.update(" and entry.FbackupVersion > -1");
        }
    }

    public void deleteRelatedEmptyData(Context ctx, String billId) throws BOSException {
        String sql = "select temp.fid from (\nselect fid,row_number() over(partition by FBudgetManageID,FCmpBudgetItemID order by FLastUpdateTime desc) rn \nfrom T_HR_SSubBudgetDifference where FBudgetManageID in (select FBudgetManageID from T_HR_SBudgetAdjustEntry where FBillID = ?)\n) temp where temp.rn = 1\n";
        DbUtil.execute((Context)ctx, (String)("/*dialect*/ delete from T_HR_SSubBudgetDifference where fid in (" + sql + ")"), (Object[])new Object[]{billId});
        sql = "delete from T_HR_SubCmpStandingBook where FSubBudgetQueryID in (select fid from T_HR_SSubBudgetQuery where FBudgetManageID in (select FBudgetManageID from T_HR_SBudgetAdjustEntry where FBackupVersion = -1 and FBillID = ?))";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{billId});
        sql = "delete from T_HR_SCmpStandingBook where FBudgetManageID in (select FBudgetManageID from T_HR_SBudgetAdjustEntry where FBackupVersion = -1 and FBillID = ?)";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{billId});
        sql = "delete from T_HR_SSubBudgetQuery where FBudgetManageID in (select FBudgetManageID from T_HR_SBudgetAdjustEntry where FBackupVersion = -1 and FBillID = ?)";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{billId});
        sql = "delete from T_HR_SSubBudgetManage where FBudgetMangeID in (select FBudgetManageID from T_HR_SBudgetAdjustEntry where FBackupVersion = -1 and FBillID = ?)";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{billId});
        sql = "delete from T_HR_SBudgetManage where fid in (select FBudgetManageID from T_HR_SBudgetAdjustEntry where FBackupVersion = -1 and FBillID = ?)";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{billId});
    }

    public void dealBack(Context ctx, String billId) throws BOSException {
        String sql = "delete from T_HR_SSubBudgetAdjustEntryHis where FEntryID in (select FBudgetManageID from T_HR_SBudgetAdjustEntry where FBillID = ?)";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{billId});
    }

    public IObjectPK _submitEffect(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        BudgetAdjustBillInfo bill = (BudgetAdjustBillInfo)model;
        if (bill.getId() == null) {
            logger.error((Object)"billId is null");
            return null;
        }
        String billId = bill.getId().toString();
        this.submitValidate(ctx, bill, billId);
        BudgetAdjustBillInfo billInfo = this.service.getBillInfo(ctx, billId);
        this.beforeSubmit(ctx, billInfo);
        CmpBudgetSchemeInfo schemeInfo = billInfo.getBudgetScheme();
        this.doSubmitEffect(ctx, billId, schemeInfo);
        this.updateBillState(ctx, BOSUuid.read((String)billId), HRBillStateEnum.AUDITED);
        this.clearAuditor(ctx, billId);
        return new ObjectUuidPK(billId);
    }

    protected String doSubmitEffect(Context ctx, String billId, CmpBudgetSchemeInfo schemeInfo) throws EASBizException, BOSException {
        boolean hasSubEntry = this.service.hasSubEntry(schemeInfo);
        if (hasSubEntry) {
            BudgetPeriodMapInfo subItemMap = this.service.getSubItemMapByScheme(ctx, schemeInfo);
            List<String> budgetPeriodFields = subItemMap.getFieldNameList();
            List<String> budgetPeriodColNames = subItemMap.getColNameList();
            String querySubManageSql = BudgetAdjustSqlUtils.querySubManageSql(budgetPeriodFields, budgetPeriodColNames, "and subentry.FBillId = ? and entry.FBackupVersion > -1");
            IRowSet subManageRs = DbUtil.executeQuery((Context)ctx, (String)querySubManageSql, (Object[])new Object[]{billId});
            ArrayList<Object[]> batchInsertSubEntryHisParams = new ArrayList<Object[]>();
            ArrayList<String> subEntryIds = new ArrayList<String>();
            try {
                while (subManageRs.next()) {
                    subEntryIds.add(subManageRs.getString("entryId"));
                    batchInsertSubEntryHisParams.add(BudgetAdjustSqlUtils.assembleInsertSubEntryHisParams(subManageRs, budgetPeriodColNames).toArray());
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (!subEntryIds.isEmpty()) {
                String delHisSql = "delete from T_HR_SSubBudgetAdjustEntryhis where fentryid in " + CmpStrUtil.concatList(subEntryIds) + "";
                DbUtil.execute((Context)ctx, (String)delHisSql);
            }
            this.executeBatchSql(ctx, BudgetAdjustSqlUtils.assembleInsertSubEntryHisSql(budgetPeriodFields), batchInsertSubEntryHisParams);
        }
        BudgetManageHelper helper = new BudgetManageHelper(ctx, billId, schemeInfo, false);
        try {
            helper.update(null);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (!hasSubEntry) {
            return null;
        }
        SubBudgetManageHelper subHelper = new SubBudgetManageHelper(ctx, billId, schemeInfo, false);
        try {
            subHelper.update(null);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return billId;
    }

    protected void submitValidate(Context ctx, BudgetAdjustBillInfo info, String billId) throws EASBizException, BOSException {
        BudgetAdjustBillCollection billCol = BudgetAdjustBillFactory.getLocalInstance(ctx).getBudgetAdjustBillCollection("select id, billState  where id = '" + billId + "'");
        if (!billCol.isEmpty()) {
            HRBillStateEnum billState = billCol.get(0).getBillState();
            if (billState != null && HRBillStateEnum.SAVED != billState && HRBillStateEnum.SUBMITED != billState) {
                throw new BudgetEASBizException(BudgetEASBizException.EXCEPTION20);
            }
            super.checkHRBillWorkFlowIsEdit(ctx, (HRBillBaseInfo)info, billState);
        }
    }

    protected void executeBatchSql(Context ctx, String executeSql, List<Object[]> executeParams) throws BOSException {
        this.service.executeBatchSql(ctx, executeSql, executeParams);
    }

    protected void beforeSave(Context ctx, BudgetAdjustBillInfo info) throws EASBizException, BOSException {
        HRBillStateEnum oldBillState = null;
        if (info.getId() != null) {
            BudgetAdjustBillCollection billInfoC = this.getBudgetAdjustBillCollection(ctx, "select id,billState where id = '" + info.getId().toString() + "'");
            oldBillState = billInfoC.isEmpty() ? null : billInfoC.get(0).getBillState();
        }
        super.checkHRBillWorkFlowIsEdit(ctx, (HRBillBaseInfo)info, oldBillState);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this.saveOrUpdate(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.saveOrUpdate(ctx, model);
    }

    public IObjectPK saveOrUpdate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK idPk;
        BudgetAdjustBillInfo info = (BudgetAdjustBillInfo)model;
        this.beforeSave(ctx, info);
        if (info.getId() == null || StringUtils.isEmpty((CharSequence)info.getId().toString())) {
            IObjectPK objectPK = this.dealSave(ctx, info);
            info.setId(BOSUuid.read((String)objectPK.toString()));
            idPk = objectPK;
        } else {
            this.dealUpdate(ctx, info);
            idPk = new ObjectUuidPK(info.getId());
        }
        return idPk;
    }

    protected IObjectPK dealUpdate(Context ctx, BudgetAdjustBillInfo info) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(info.getId());
        BudgetAdjustEntryCollection entryCol = info.getEntry();
        SubBudgetAdjustEntryCollection subEntryCol = info.getSubEntry();
        info.put("entry", null);
        info.put("subEntry", null);
        boolean exists = BudgetAdjustBillFactory.getLocalInstance(ctx).exists((IObjectPK)pk);
        if (exists) {
            super.innerUpdate(ctx, (IObjectPK)pk, (IObjectValue)info);
        } else {
            pk = super.innerAddnew(ctx, (IObjectValue)info);
        }
        if (info.getBudgetScheme() == null || info.getBudgetScheme().getId() == null) {
            return pk;
        }
        boolean notValid = info.getBoolean("notValid");
        this.existEnableOrApprovingData(ctx, entryCol, pk.toString(), info.getBudgetScheme().getId().toString(), notValid);
        try {
            BudgetAdjustEntryHelper helper = new BudgetAdjustEntryHelper(ctx, pk.toString(), notValid);
            helper.deleteEntryAndsaveData(entryCol, subEntryCol);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        info.put("entry", (Object)entryCol);
        info.put("subEntry", (Object)subEntryCol);
        return pk;
    }

    protected void existEnableOrApprovingData(Context ctx, BudgetAdjustEntryCollection entryCol, String billId, String budgetSchemeId, boolean notValid) throws BOSException, BudgetEASBizException {
        if (!notValid) {
            List<BudgetAdjustEntryParam> entryParams = BudgetAdjustSqlUtils.assembleBudgetAdjustEntryParam(entryCol);
            try {
                boolean existEnableOrApprovingData = this.service.existEnableOrApprovingData(ctx, billId, budgetSchemeId, entryParams);
                if (existEnableOrApprovingData) {
                    throw new BudgetEASBizException(BudgetEASBizException.EXCEPTION32);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected IObjectPK dealSave(Context ctx, BudgetAdjustBillInfo info) throws EASBizException, BOSException {
        BudgetAdjustEntryCollection entryCol = info.getEntry();
        SubBudgetAdjustEntryCollection subEntryCol = info.getSubEntry();
        boolean notValid = info.getBoolean("notValid");
        info.put("entry", null);
        info.put("subEntry", null);
        IObjectPK objectPK = super.innerAddnew(ctx, (IObjectValue)info);
        if (objectPK == null) {
            logger.error((Object)"objectPK is null!");
            return null;
        }
        if (info.getBudgetScheme() == null || info.getBudgetScheme().getId() == null) {
            return objectPK;
        }
        this.existEnableOrApprovingData(ctx, entryCol, objectPK.toString(), info.getBudgetScheme().getId().toString(), notValid);
        try {
            BudgetAdjustEntryHelper helper = new BudgetAdjustEntryHelper(ctx, objectPK.toString(), notValid);
            helper.deleteEntryAndsaveData(entryCol, subEntryCol);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        info.put("entry", (Object)entryCol);
        info.put("subEntry", (Object)subEntryCol);
        return objectPK;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BudgetAdjustBillInfo info = (BudgetAdjustBillInfo)model;
        if (info.getId() == null) {
            logger.error((Object)"billId is null");
            return null;
        }
        String billId = info.getId().toString();
        this.submitValidate(ctx, info, billId);
        BudgetAdjustBillInfo billInfo = this.service.getBillInfo(ctx, billId);
        this.beforeSubmit(ctx, billInfo);
        BOSUuid id = model.getBOSUuid("id");
        info.setBillState(HRBillStateEnum.SUBMITED);
        super.updateBillState(ctx, id, HRBillStateEnum.SUBMITED);
        return new ObjectUuidPK(id);
    }

    protected void beforeSubmit(Context ctx, BudgetAdjustBillInfo billInfo) throws EASBizException, BOSException {
        String billId = billInfo.getId().toString();
        CmpBudgetSchemeInfo schemeInfo = billInfo.getBudgetScheme();
        try {
            boolean submitValidateRuleError = this.service.submitValidateRuleError(ctx, billId);
            if (submitValidateRuleError) {
                throw new BudgetEASBizException(BudgetEASBizException.EXCEPTION19);
            }
            boolean submitNotEntry = this.service.submitNotEntry(ctx, billId);
            if (submitNotEntry) {
                throw new BudgetEASBizException(BudgetEASBizException.EXCEPTION18);
            }
            boolean existApprovingEntry = this.service.existApprovingEntry(ctx, billId);
            if (existApprovingEntry) {
                throw new BudgetEASBizException(BudgetEASBizException.EXCEPTION15);
            }
            boolean versionDifferent = this.service.existVersionDifferent(ctx, billId, schemeInfo, true);
            if (versionDifferent) {
                throw new BudgetEASBizException(BudgetEASBizException.EXCEPTION13);
            }
            List<String> existDisableErrorList = this.service.existDisableManageData(ctx, "and id in (select FBudgetManageID from T_HR_SBudgetAdjustEntry where FBillID ='" + billId + "')");
            if (existDisableErrorList != null && !existDisableErrorList.isEmpty()) {
                String errorInfo = StringUtils.join(existDisableErrorList, (String)"\u3001 ");
                throw new BudgetEASBizException(BudgetEASBizException.EXCEPTION24, new Object[]{errorInfo});
            }
            BudgetAdjustEntryHelper entryHelper = new BudgetAdjustEntryHelper(ctx, billId, schemeInfo);
            BudgetAdjustEntryCollection entryCol = entryHelper.assembleEntryCol();
            SubBudgetAdjustEntryCollection subEntryCol = entryHelper.assembleSubEntryCol(false);
            BudgetadjustEntryValidateHelper validateHelper = new BudgetadjustEntryValidateHelper(ctx, schemeInfo);
            validateHelper.saveEntryValid(entryCol, subEntryCol);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void _setAudited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        if (billID == null) {
            throw new BOSException("billID is null");
        }
        String billId = billID.toString();
        BudgetAdjustBillInfo billInfo = this.service.getBillInfo(ctx, billId);
        CmpBudgetSchemeInfo schemeInfo = billInfo.getBudgetScheme();
        if (schemeInfo.getTemplate() == null || schemeInfo.getTemplate().getTemplateType() != BudgetTemplateTypeEnum.SALARY_TYPE) {
            try {
                BudgetadjustEntryValidateHelper validateHelper = new BudgetadjustEntryValidateHelper(ctx, schemeInfo, billId);
                validateHelper.saveEntryExpenseValid();
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.doSubmitEffect(ctx, billId, schemeInfo);
        this.updateBillState(ctx, billID, HRBillStateEnum.AUDITED);
        this.clearAuditor(ctx, billId);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.beforeDelete(ctx, pk);
        super._delete(ctx, pk);
    }

    protected void beforeDelete(Context ctx, IObjectPK pk) throws EASBizException {
        try {
            BudgetAdjustBillInfo info = BudgetAdjustBillFactory.getLocalInstance(ctx).getBudgetAdjustBillInfo(pk);
            if (!info.getBillState().equals((Object)HRBillStateEnum.SAVED)) {
                throw new CmpBasicException(CmpBasicException.BILLNOTDEL);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new CmpBasicException(null, e);
        }
    }

    protected void _abortBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        super._abortBizBill(ctx, billId);
        this.clearAuditor(ctx, billId);
    }

    protected void _setAuditEnd(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        super._setAuditEnd(ctx, billID);
        this.clearAuditor(ctx, billID.toString());
    }

    protected void clearAuditor(Context ctx, String billId) throws BOSException, EASBizException {
        DbUtil.execute((Context)ctx, (String)"update T_HR_SBudgetAdjustBill set FAuditorID = null where fid = ?", (Object[])new Object[]{billId});
    }
}

