/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.currencyReport;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CmpCalTableInfo;
import com.kingdee.shr.compensation.app.currencyReport.AbstractCalReportManagerFacadeControllerBean;
import com.kingdee.shr.compensation.app.currencyReport.CalSchemeReportCollection;
import com.kingdee.shr.compensation.app.currencyReport.CalSchemeReportFactory;
import com.kingdee.shr.compensation.app.currencyReport.CalSchemeReportInfo;
import com.kingdee.shr.compensation.app.currencyReport.RepCalState;
import com.kingdee.shr.compensation.app.currencyReport.ReportCurrencySetFactory;
import com.kingdee.shr.compensation.app.currencyReport.ReportCurrencySetInfo;
import com.kingdee.shr.compensation.currency.repCurrency.RepCurrencyManager;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CalReportManagerFacadeControllerBean
extends AbstractCalReportManagerFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.currencyReport.CalReportManagerFacadeControllerBean");

    @Override
    protected Map _cal(Context ctx, Map param) throws BOSException, EASBizException {
        HashMap<String, String> res = new HashMap<String, String>();
        Object billIdsO = param.get("billIds");
        if (CmpStrUtil.isNullOrEmpty(billIdsO)) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label77", (Locale)ctx.getLocale()));
        }
        String billIds = billIdsO.toString();
        List<String> idList = Arrays.asList(billIds.split(","));
        int totalCount = idList.size();
        String sql = "select calscheme,periodYear,periodMonth,calTime,calCurrency,repCurrency,beginDate,endDate where id in (" + CmpStrUtil.convertListToString(idList) + ")";
        CalSchemeReportCollection coll = CalSchemeReportFactory.getLocalInstance(ctx).getCalSchemeReportCollection(sql);
        int actCount = coll.size();
        String mes = MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label78", (Locale)ctx.getLocale()), totalCount, actCount);
        res.put("mes", mes);
        if (actCount == 0) {
            return res;
        }
        try {
            RepCurrencyManager.getInstance().repCurrencyCaculate(ctx, coll);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            throw cause == null ? new BOSException(e.getMessage()) : new BOSException(e.getMessage(), cause);
        }
        return res;
    }

    @Override
    protected void _updateCurrencyReport(Context ctx, Map param, String type) throws BOSException, EASBizException {
        Object[] par;
        Set period;
        Map range = param;
        HashMap importPeriod = null;
        if ("import".equals(type)) {
            importPeriod = (HashMap)range.get("period");
            period = importPeriod.keySet();
        } else {
            period = (Set)range.get("period");
        }
        Set deleteRange = (Set)range.get("range");
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (String s : deleteRange) {
            par = new Object[]{s};
            params.add(par);
        }
        CmpSQLUtil.executeBatch(ctx, "delete from T_HR_SCMPCALTABLEREP where FCalTableID = ?", params);
        ReportCurrencySetInfo reportCurrencySetInfo = ReportCurrencySetFactory.getLocalInstance(ctx).getReportCurrencySetInfo("where id = '6vS7SKM/TBCPlQIB4S/8Uy3awhY='");
        CurrencyInfo currencyInfo = reportCurrencySetInfo.getCurrency();
        CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
        int calCount = 0;
        int repCount = 0;
        int schemeRepCount = 0;
        try {
            for (String s : period) {
                par = s.split("_");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select count(1) as count from T_HR_SCMPCALTABLE where  FCALSCHEMEID = ? and FPERIODYEAR = ? and FPERIODMONTH = ? and FCALTIME = ?", (Object[])par);
                if (rs.next()) {
                    calCount = rs.getInt("count");
                }
                if (calCount == 0) {
                    DbUtil.execute((Context)ctx, (String)"delete from T_HR_SCalSchemeRep where FCALSCHEMEID = ? and FPERIODYEAR = ? and FPERIODMONTH = ? and FCALTIME = ?", (Object[])par);
                    continue;
                }
                if ("import".equals(type) && currencyInfo != null) {
                    rs = DbUtil.executeQuery((Context)ctx, (String)"select count(1) as count from T_HR_SCalSchemeRep where  FCALSCHEMEID = ? and FPERIODYEAR = ? and FPERIODMONTH = ? and FCALTIME = ?", (Object[])par);
                    if (rs.next()) {
                        schemeRepCount = rs.getInt("count");
                    }
                    if (schemeRepCount == 0 && null != importPeriod) {
                        CmpCalTableInfo calTableInfo = (CmpCalTableInfo)importPeriod.get(s);
                        CalSchemeReportInfo calSchemeReportInfo = new CalSchemeReportInfo();
                        calSchemeReportInfo.setCalscheme(calTableInfo.getCalScheme());
                        calSchemeReportInfo.setPeriodYear(calTableInfo.getPeriodYear());
                        calSchemeReportInfo.setPeriodMonth(calTableInfo.getPeriodMonth());
                        calSchemeReportInfo.setCalTime(calTableInfo.getCalTime());
                        calSchemeReportInfo.setCalCurrency(calTableInfo.getCurrency());
                        calSchemeReportInfo.setRepCurrency(currencyInfo);
                        calSchemeReportInfo.setRepCalState(RepCalState.NOT_CALCULATED);
                        calSchemeReportInfo.setBeginDate(calTableInfo.getBeginDate());
                        calSchemeReportInfo.setEndDate(calTableInfo.getEndDate());
                        coreBaseCollection.add((CoreBaseInfo)calSchemeReportInfo);
                        continue;
                    }
                }
                if ((rs = DbUtil.executeQuery((Context)ctx, (String)"select count(1) as count from T_HR_SCMPCALTABLERep where  FCALSCHEMEID = ? and FPERIODYEAR = ? and FPERIODMONTH = ? and FCALTIME = ?", (Object[])par)).next()) {
                    repCount = rs.getInt("count");
                }
                if (calCount > repCount) {
                    DbUtil.execute((Context)ctx, (String)"update T_HR_SCalSchemeRep set FRepCalState = 2 where FRepCalState = 1 and FCALSCHEMEID = ? and FPERIODYEAR = ? and FPERIODMONTH = ? and FCALTIME = ?", (Object[])par);
                    continue;
                }
                if (calCount != repCount) continue;
                DbUtil.execute((Context)ctx, (String)"update T_HR_SCalSchemeRep set FRepCalState = 1 where FRepCalState = 2 and FCALSCHEMEID = ? and FPERIODYEAR = ? and FPERIODMONTH = ? and FCALTIME = ?", (Object[])par);
            }
            if (coreBaseCollection.size() > 0) {
                CalSchemeReportFactory.getLocalInstance(ctx).saveBatchData(coreBaseCollection);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void _backCal(Context ctx) throws BOSException, EASBizException {
        String sql = "select calscheme,periodYear,periodMonth,calTime,calCurrency,repCurrency,beginDate,endDate where repCalState <> 1";
        CalSchemeReportCollection coll = CalSchemeReportFactory.getLocalInstance(ctx).getCalSchemeReportCollection(sql);
        try {
            RepCurrencyManager.getInstance().repCurrencyCaculate(ctx, coll);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }
}

