/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.formula.tax;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.xml.impl.IStateManager;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueCollection;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CmpQueryConfigCollection;
import com.kingdee.shr.compensation.CmpQueryConfigFactory;
import com.kingdee.shr.compensation.app.formula.data.ColumnAttributes;
import com.kingdee.shr.compensation.app.formula.data.DataRow;
import com.kingdee.shr.compensation.app.formula.data.DataSet;
import com.kingdee.shr.compensation.app.formula.data.DataTable;
import com.kingdee.shr.compensation.app.formula.tax.Salary2TaxCalFunction;
import com.kingdee.shr.compensation.app.tax.TaxItemPlanInfo;
import com.kingdee.shr.compensation.app.tax.base.TaxIncomeItemInfo;
import com.kingdee.shr.compensation.secret.SecretUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.FunUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class Salary2TaxCalExecutor
extends Thread {
    private final String mainTableItemKey = "fid";
    private final String mainTableForeignKey = "FPERSONID";
    private String mainTableName = "T_HR_SCmpCalTable";
    private Context ctx;
    private boolean isDataSecret = false;
    private CalSchemeInfo calScheme;
    private TaxItemPlanInfo taxItemPlan;
    private Salary2TaxCalFunction calObj;
    private DataSet dataSet;
    private Set secColSet;
    private Map<String, Object> changeSqlMap = new HashMap<String, Object>();
    private boolean isExecuteFinished = false;
    private static final FunUtils util = new FunUtils();
    private double ext_finishedPer = 0.0;
    private final String maxDotString = "0.0000000000";
    private Map<String, Object> editedItems;

    public Map<String, Object> getChangeSqlList() {
        return this.changeSqlMap;
    }

    public Salary2TaxCalExecutor() {
    }

    public Salary2TaxCalExecutor(String mainTableName, Context ctx, TaxItemPlanInfo taxItemPlan, boolean isDataSecret, CalSchemeInfo calScheme, Salary2TaxCalFunction calObj, DataSet dataSet, Set secColSet, Map<String, Object> editedItems) {
        this.mainTableName = mainTableName;
        this.ctx = ctx;
        this.isDataSecret = isDataSecret;
        this.calScheme = calScheme;
        this.taxItemPlan = taxItemPlan;
        this.calObj = calObj;
        this.dataSet = dataSet;
        this.secColSet = secColSet;
        this.editedItems = editedItems;
    }

    public boolean isExecuteFinished() {
        return this.isExecuteFinished;
    }

    @Override
    public void run() {
        try {
            this.changeSqlMap = this.doExecute();
            this.isExecuteFinished = true;
        }
        catch (Exception e) {
            this.changeSqlMap.put("errMsg", e.getMessage());
            this.changeSqlMap.put("changeSqlList", new ArrayList());
            e.printStackTrace();
            this.isExecuteFinished = true;
        }
    }

    public Map<String, BizEnumValueCollection> getEnumProperty() {
        HashMap<String, BizEnumValueCollection> map = new HashMap<String, BizEnumValueCollection>();
        CmpQueryConfigCollection coll = null;
        try {
            coll = CmpQueryConfigFactory.getLocalInstance(this.ctx).getCmpQueryConfigCollection("select structure.* ");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < coll.size(); ++i) {
            String entityName;
            if (null == coll.get(i).getStructure() || CmpStrUtil.isEmpty(entityName = coll.get(i).getStructure().getEntityName())) continue;
            System.out.println("----enumEntity----" + entityName);
            EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
            if (entityInfo == null || entityInfo.getProperties() == null) {
                System.out.println("----enumEntity not found----" + entityName);
                continue;
            }
            PropertyCollection properties = entityInfo.getProperties();
            for (int k = 0; k < properties.size(); ++k) {
                String dataType;
                PropertyInfo propertyInfo = properties.get(k);
                IStateManager stateManager = propertyInfo.getStateManager();
                if (null == stateManager.getStateValue("dataType") || !"Enum".equalsIgnoreCase(dataType = stateManager.getStateValue("dataType").toString())) continue;
                String dataRef = stateManager.getStateValue("metadataRef").toString();
                BizEnumInfo enumInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getEnum((IMetaDataPK)MetaDataPK.create((String)dataRef));
                BizEnumValueCollection enumValueColl = enumInfo.getEnumValue();
                map.put(entityInfo.getTable().getName().toUpperCase(Locale.ENGLISH) + "_" + propertyInfo.getMappingField().getName().toUpperCase(Locale.ENGLISH), enumValueColl);
            }
        }
        return map;
    }

    private Map<String, Object> doExecute() throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, String> socRecordMap = new HashMap<String, String>();
        String calTableId = null;
        String personId = null;
        DataTable mainTable = this.dataSet.getTables(this.mainTableName);
        HashMap<String, Object> paras = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> submitDataMapList = new ArrayList<Map<String, Object>>();
        ArrayList itemList = new ArrayList();
        HashMap<String, Object> changeSqlMap = new HashMap<String, Object>();
        String errMsg = "";
        changeSqlMap.put("errMsg", errMsg);
        changeSqlMap.put("changeSqlList", new ArrayList());
        changeSqlMap.put("itemList", new ArrayList());
        int rowCount = mainTable.rowCount();
        HashMap<String, String> personMap = new HashMap<String, String>();
        String str = "select calTable.FPersonId as personId, person.FName_l2 as personName from T_HR_SCmpCalTable calTable inner join T_BD_Person person on calTable.FPersonId = person.Fid and calTable.FCalSchemeId = '" + this.calScheme.getId().toString() + "' and calTable.FPeriodYear = " + this.calScheme.getPeriodYear() + " and calTable.FPeriodMonth = " + this.calScheme.getPeriodMonth() + " and calTable.FCalTime = " + this.calScheme.getCalTime();
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)str);
        while (rowSet.next()) {
            personMap.put(rowSet.getString("personId"), rowSet.getString("personName"));
        }
        List<DataRow> datas = mainTable.datas;
        System.out.println("-----------\u8ba1\u7b97\u62fc\u88c5-----begin---");
        int size = datas.size();
        for (int index = 0; index < size; ++index) {
            paras.clear();
            DataRow mtDataRow = mainTable.getRows(index);
            if (mtDataRow == null) continue;
            for (int loop = 0; loop < mtDataRow.columnCount(); ++loop) {
                ColumnAttributes att = mtDataRow.getColumns(loop);
                if (att.getName().equalsIgnoreCase("fid")) {
                    calTableId = (String)mtDataRow.getValue(loop);
                }
                if (att.getName().equalsIgnoreCase("FPERSONID")) {
                    personId = (String)mtDataRow.getValue(loop);
                }
                if (this.isDataSecret && mtDataRow.getValue(loop) != null && this.secColSet.contains(att.getName().toUpperCase(Locale.ENGLISH))) {
                    BigDecimal val = SecretUtil.decode(this.ctx, (BigDecimal)mtDataRow.getValue(loop), personId);
                    paras.put((this.mainTableName + "_" + att.getName()).toUpperCase(Locale.ENGLISH), val);
                    mtDataRow.setValue(loop, (Object)val);
                }
                if (att.isVar()) {
                    paras.put(att.getName().toUpperCase(Locale.ENGLISH), mtDataRow.getValue(loop));
                    continue;
                }
                if (att.getName().contains(".")) continue;
                paras.put((this.mainTableName + "_" + att.getName()).toUpperCase(Locale.ENGLISH), mtDataRow.getValue(loop));
            }
            this.addEditedItem(calTableId, paras);
            try {
                this.calObj.setParamMap(paras);
                this.calObj.getClass().getMethod("calculate", HashMap.class).invoke((Object)this.calObj, paras);
            }
            catch (Exception e) {
                this.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread t, Throwable e) {
                        e.printStackTrace();
                    }
                });
                String calFormulaName = null == e.getMessage() ? e.getCause().toString() : e.getMessage();
                calFormulaName = calFormulaName.substring(calFormulaName.indexOf("{") + 1, calFormulaName.indexOf("}"));
                errMsg = null != personId ? MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label123"), personMap.get(personId), calFormulaName) + "<br>" : EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label124", (Locale)this.ctx.getLocale()) + "<br>" + e;
                changeSqlMap.put("errMsg", errMsg);
                e.printStackTrace();
            }
            String taxPeriodBegin = this.calObj.getTaxPeriodBegin();
            String taxPeriodEnd = this.calObj.getTaxPeriodEnd();
            Map<String, Object> submitDataMap = this.getChangeSql(mtDataRow, paras);
            if (submitDataMap != null && submitDataMap.size() > 0) {
                Date taxPeriodBeginDate = new Date(simpleDateFormat.parse(taxPeriodBegin).getTime());
                Date taxPeriodEndDate = new Date(simpleDateFormat.parse(taxPeriodEnd).getTime());
                submitDataMap.put("FPERIODBEGIN", taxPeriodBeginDate);
                submitDataMap.put("FPERIODEND", taxPeriodEndDate);
                ArrayList itemListTemp = (ArrayList)submitDataMap.get("itemList");
                submitDataMap.remove("itemList");
                submitDataMapList.add(submitDataMap);
                itemList.addAll(itemListTemp);
                changeSqlMap.put("submitDataMapList", submitDataMapList);
                HashSet set = new HashSet(itemList);
                itemList.clear();
                itemList.addAll(set);
                changeSqlMap.put("itemList", itemList);
            }
            this.ext_finishedPer = 50.0 / (double)rowCount * (double)index;
            if (paras.get("socRecordId") == null) continue;
            String calId = (String)paras.get("T_HR_SCMPCALTABLE_FID");
            socRecordMap.put(calId, paras.get("socRecordId").toString());
        }
        Hashtable<String, String> socPayTempDatas = this.dataSet.getSocPayTempDatas();
        changeSqlMap.put("socRecordMap", socRecordMap);
        changeSqlMap.put("socPayTempDatas", socPayTempDatas);
        return changeSqlMap;
    }

    private void addEditedItem(String calTableId, Map<String, Object> paras) {
        if (this.editedItems == null) {
            return;
        }
        Map editedItem = (Map)this.editedItems.get(calTableId);
        if (editedItem != null) {
            for (String key : editedItem.keySet()) {
                paras.put(key, editedItem.get(key));
            }
        }
    }

    public Map<String, Object> getChangeSql(DataRow rw, Map<String, Object> paras) throws EASBizException {
        HashMap<String, Object> submitDataMap = new HashMap<String, Object>();
        ArrayList<String> itemList = new ArrayList<String>();
        String caltableid = (String)rw.getValue("fid");
        String personid = (String)rw.getValue("FPERSONID");
        String schemeID = this.calScheme.getId().toString();
        TaxIncomeItemInfo taxIncomeItem = this.taxItemPlan.getIncomeItem();
        String incomeItemID = null;
        if (null != taxIncomeItem) {
            incomeItemID = taxIncomeItem.getId().toString();
        }
        String taxUnitID = (String)rw.getValue("FTAXUNITID");
        submitDataMap.put("FCMPCALTABLEID", caltableid);
        submitDataMap.put("FPERSONID", personid);
        submitDataMap.put("FCALSCHEMEID", schemeID);
        submitDataMap.put("FTAXUNITID", taxUnitID);
        submitDataMap.put("FINCOMEITEMID", incomeItemID);
        for (Map.Entry<String, Object> entry : paras.entrySet()) {
            String paraName = entry.getKey();
            if (!paraName.toUpperCase(Locale.ENGLISH).startsWith("T_HR_STAXCALINITDETAIL_T")) continue;
            String item = paraName.toUpperCase(Locale.ENGLISH).substring("T_HR_STAXCALINITDETAIL_".length());
            submitDataMap.put(item, entry.getValue());
            if (itemList.contains(item)) continue;
            itemList.add(item);
        }
        submitDataMap.put("itemList", itemList);
        return submitDataMap;
    }

    public boolean isEqual(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if ((a == null || StringUtils.isEmpty((String)a.toString())) && (b == null || StringUtils.isEmpty((String)b.toString()))) {
            return true;
        }
        if (a instanceof String) {
            return a.equals(b);
        }
        if (b instanceof String) {
            return b.equals(a);
        }
        if (a instanceof Double) {
            return a.equals(b);
        }
        if (b instanceof Double) {
            return b.equals(a);
        }
        if (a instanceof Number && b != null && ((Number)a).doubleValue() == ((Number)b).doubleValue()) {
            return true;
        }
        return a == b;
    }

    public double getExt_finishedPer() {
        return this.ext_finishedPer;
    }
}

