/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.incomeTax;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.compensation.IdentityStatusEnume;
import com.kingdee.shr.compensation.PersonStatusEnum;
import com.kingdee.shr.compensation.SubmitStatusEnum;
import com.kingdee.shr.compensation.app.incomeTax.AbstractTaxPersonRecordEntryControllerBean;
import com.kingdee.shr.compensation.app.incomeTax.TaxPersonRecordEntryCollection;
import com.kingdee.shr.compensation.app.incomeTax.TaxPersonRecordEntryFactory;
import com.kingdee.shr.compensation.app.incomeTax.TaxPersonRecordEntryInfo;
import com.kingdee.shr.compensation.app.incomeTax.TaxPersonRecordFactory;
import com.kingdee.shr.compensation.app.tax.TaxUnitInfo;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class TaxPersonRecordEntryControllerBean
extends AbstractTaxPersonRecordEntryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.incomeTax.TaxPersonRecordEntryControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TaxPersonRecordEntryInfo taxPersonRecordEntryInfo = (TaxPersonRecordEntryInfo)model;
        taxPersonRecordEntryInfo.setSubmitStatus(SubmitStatusEnum.NotSubmit);
        taxPersonRecordEntryInfo.setIdentityStatus(IdentityStatusEnume.WaitVerify);
        return super._addnew(ctx, (IObjectValue)taxPersonRecordEntryInfo);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        TaxPersonRecordEntryInfo taxPersonRecordEntryInfo = (TaxPersonRecordEntryInfo)model;
        if (SubmitStatusEnum.HaveSubmit.equals((Object)taxPersonRecordEntryInfo.getSubmitStatus()) || SubmitStatusEnum.SubmitFail.equals((Object)taxPersonRecordEntryInfo.getSubmitStatus())) {
            boolean needUpdate = false;
            TaxPersonRecordEntryInfo dbInfo = this.getTaxPersonRecordEntryInfo(ctx, pk);
            if (!taxPersonRecordEntryInfo.getTaxUnit().getId().equals((Object)dbInfo.getTaxUnit().getId())) {
                needUpdate = true;
            } else if (!needUpdate && taxPersonRecordEntryInfo.getPayerType() != dbInfo.getPayerType()) {
                needUpdate = true;
            } else if (!needUpdate && taxPersonRecordEntryInfo.getPersonStatus() != dbInfo.getPersonStatus()) {
                needUpdate = true;
            } else if (!needUpdate && taxPersonRecordEntryInfo.getEmployedType() != dbInfo.getEmployedType()) {
                needUpdate = true;
            } else if (!needUpdate && taxPersonRecordEntryInfo.getSituation() != dbInfo.getSituation()) {
                needUpdate = true;
            } else if (!needUpdate && !taxPersonRecordEntryInfo.getEmployedDate().equals(dbInfo.getEmployedDate())) {
                needUpdate = true;
            } else if (!needUpdate && taxPersonRecordEntryInfo.getDeductFees() != dbInfo.getDeductFees()) {
                needUpdate = true;
            } else if (!needUpdate) {
                Date departureDate = taxPersonRecordEntryInfo.getDepartureDate();
                Date dbDepartureDate = dbInfo.getDepartureDate();
                if (!(departureDate != null && dbDepartureDate != null && departureDate.equals(dbDepartureDate) || departureDate == null && dbDepartureDate == null)) {
                    needUpdate = true;
                }
            }
            if (needUpdate) {
                taxPersonRecordEntryInfo.setAcceptId(null);
                taxPersonRecordEntryInfo.setSubmitStatus(SubmitStatusEnum.NotSubmit);
                taxPersonRecordEntryInfo.setIdentityStatus(IdentityStatusEnume.WaitVerify);
            }
        }
        super._update(ctx, pk, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        TaxPersonRecordEntryInfo taxPersonRecordEntryInfo = TaxPersonRecordEntryFactory.getLocalInstance(ctx).getTaxPersonRecordEntryInfo(pk);
        super._delete(ctx, pk);
        if (null != taxPersonRecordEntryInfo.getBill()) {
            String oql = "select id where bill.id = '" + taxPersonRecordEntryInfo.getBill().getId().toString() + "'";
            TaxPersonRecordEntryCollection taxPersonRecordEntryCollection = TaxPersonRecordEntryFactory.getLocalInstance(ctx).getTaxPersonRecordEntryCollection(oql);
            if (taxPersonRecordEntryCollection.size() == 0) {
                TaxPersonRecordFactory.getLocalInstance(ctx).delete("where id ='" + taxPersonRecordEntryInfo.getBill().getId().toString() + "'");
            }
        }
    }

    private boolean isExists(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean result = false;
        TaxPersonRecordEntryInfo taxPersonRecordEntryInfo = (TaxPersonRecordEntryInfo)model;
        String id = "";
        TaxUnitInfo taxUnit = taxPersonRecordEntryInfo.getTaxUnit();
        if (null == taxUnit || null == taxUnit.getId()) {
            return result;
        }
        String billId = (String)taxPersonRecordEntryInfo.get("billid");
        if (StringUtils.isEmpty((String)billId)) {
            billId = taxPersonRecordEntryInfo.getBill().getId().toString();
        }
        String oql = "select id,taxUnit.id,taxUnit.name where bill.id = '" + billId + "'";
        if (taxPersonRecordEntryInfo.getId() != null && !StringUtils.isEmpty((String)taxPersonRecordEntryInfo.getId().toString())) {
            id = taxPersonRecordEntryInfo.getId().toString();
            oql = oql + " and id <> '" + id + "'";
        }
        TaxPersonRecordEntryCollection taxPersonRecordEntryCollection = TaxPersonRecordEntryFactory.getLocalInstance(ctx).getTaxPersonRecordEntryCollection(oql);
        TaxPersonRecordEntryInfo temp = null;
        for (int i = 0; i < taxPersonRecordEntryCollection.size(); ++i) {
            temp = taxPersonRecordEntryCollection.get(i);
            if (null == temp.getTaxUnit() || null == temp.getTaxUnit().getId() || !taxUnit.getId().toString().equals(temp.getTaxUnit().getId().toString())) continue;
            throw new BOSException(EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label7", (Locale)ctx.getLocale()) + temp.getTaxUnit().getName() + EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label8", (Locale)ctx.getLocale()));
        }
        if (taxPersonRecordEntryInfo.getPersonStatus().equals((Object)PersonStatusEnum.NotNormal) && null == taxPersonRecordEntryInfo.getDepartureDate()) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label9", (Locale)ctx.getLocale()));
        }
        if (null != taxPersonRecordEntryInfo.getDepartureDate() && !taxPersonRecordEntryInfo.getDepartureDate().after(taxPersonRecordEntryInfo.getEmployedDate())) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label10", (Locale)ctx.getLocale()));
        }
        return result;
    }
}

