/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.integrate.submitPeriod.verify;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.hraux.StateEnum;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.compensation.util.CmpDateUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CmpEmpORelationInfo;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillEntryCollection;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillEntryInfo;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillInfo;
import com.kingdee.shr.compensation.app.integrate.CalShemeTableRelationFactory;
import com.kingdee.shr.compensation.app.integrate.CalShemeTableRelationInfo;
import com.kingdee.shr.compensation.app.integrate.CalSubmitPeriodCollection;
import com.kingdee.shr.compensation.app.integrate.CalSubmitPeriodFactory;
import com.kingdee.shr.compensation.app.integrate.CalSubmitPeriodInfo;
import com.kingdee.shr.compensation.app.integrate.DateTypeEnum;
import com.kingdee.shr.compensation.app.integrate.FrequencyDimensionEnum;
import com.kingdee.shr.compensation.app.integrate.ISubmitPeriod;
import com.kingdee.shr.compensation.app.integrate.SubmitElementInfo;
import com.kingdee.shr.compensation.app.integrate.SubmitPeriodCollection;
import com.kingdee.shr.compensation.app.integrate.SubmitPeriodDetailCollection;
import com.kingdee.shr.compensation.app.integrate.SubmitPeriodDetailInfo;
import com.kingdee.shr.compensation.app.integrate.SubmitPeriodFactory;
import com.kingdee.shr.compensation.exception.SubmitPeriodException;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractSubmitPeriodVerify {
    public static final String JOIN_CHAR = "&&";
    public static final String NEW_LINE_WEB = "<br />";
    public static final String MORE_CHAR = "...";
    public static final String COMMA = ",";
    public static final String BREAKES_LEFT = "(";
    public static final String BREAKES_RIGHT = ")";
    private static final Integer MAX_SHOW_ERROR_COUNT = 5;
    private final SimpleDateFormat sdf_yyyy_MM_dd = new SimpleDateFormat("yyyy-MM-dd");
    private final SimpleDateFormat sdf_yyyy_MM = new SimpleDateFormat("yyyy-MM");

    protected abstract void verify(Context var1, BatchSubmitShemeBillInfo var2) throws EASBizException, BOSException;

    protected String getSubmitPeriodCompareKey(BatchSubmitShemeBillEntryInfo entryInfo, SubmitPeriodDetailInfo detailInfo, CalSubmitPeriodInfo calSubmitPeriod) {
        return this.getSubmitBillEntryBizKey(entryInfo, calSubmitPeriod) + JOIN_CHAR + this.sdf_yyyy_MM_dd.format(detailInfo.getStartDate());
    }

    protected String getSubmitBillEntryBizKey(BatchSubmitShemeBillEntryInfo entryInfo, CalSubmitPeriodInfo calSubmitPeriod) {
        FrequencyDimensionEnum dimension = calSubmitPeriod.getFrequencyDimension();
        StringBuilder keyBuilder = new StringBuilder();
        if (entryInfo.getSubmitElement() != null) {
            keyBuilder.append(entryInfo.getSubmitElement().getId().toString());
            keyBuilder.append(JOIN_CHAR);
        }
        keyBuilder.append(entryInfo.getPerson().getId().toString());
        if (FrequencyDimensionEnum.Person.equals((Object)dimension)) {
            return keyBuilder.toString();
        }
        keyBuilder.append(JOIN_CHAR).append(entryInfo.getAdminOrgUnit().getId().toString());
        if (FrequencyDimensionEnum.Person_AdminOrg.equals((Object)dimension)) {
            return keyBuilder.toString();
        }
        keyBuilder.append(JOIN_CHAR).append(entryInfo.getCmpEmpORelation().getId().toString());
        return keyBuilder.toString();
    }

    protected String getSubmitBillEntryCompareKey(BatchSubmitShemeBillEntryInfo entryInfo, CalSubmitPeriodInfo calSubmitPeriod) {
        return this.getSubmitBillEntryBizKey(entryInfo, calSubmitPeriod) + JOIN_CHAR + this.sdf_yyyy_MM_dd.format(this.getEffectDate(entryInfo));
    }

    protected void verifySingleCalSubmitPeriod(Context ctx, BatchSubmitShemeBillInfo info, BatchSubmitShemeBillEntryCollection entries, CalSubmitPeriodInfo calSubmitPeriod) throws BOSException, EASBizException {
        Map<SubmitPeriodDetailInfo, List<BatchSubmitShemeBillEntryInfo>> periodAndEntrySetMap = this.getPeriodAndEntrySetMap(ctx, entries, calSubmitPeriod);
        Set<String> entryBizKeySet = this.assembleAndGetEntryBizKeySet(info, calSubmitPeriod);
        HashSet<BatchSubmitShemeBillEntryInfo> errorColector = new HashSet<BatchSubmitShemeBillEntryInfo>();
        HashMap<String, Integer> compareKeyAndFrequencyMap = new HashMap<String, Integer>();
        for (SubmitPeriodDetailInfo detailInfo : periodAndEntrySetMap.keySet()) {
            for (BatchSubmitShemeBillEntryInfo entryInfo : periodAndEntrySetMap.get(detailInfo)) {
                if (detailInfo.getStartDate().compareTo(this.getEffectDate(entryInfo)) > 0 || detailInfo.getEndDate().compareTo(this.getEffectDate(entryInfo)) < 0) continue;
                this.verifyAndCoutingEntry(compareKeyAndFrequencyMap, entryInfo, calSubmitPeriod, detailInfo, errorColector);
            }
            BatchSubmitShemeBillEntryCollection cols = this.getSubmitBillEntryColInPeriod(ctx, info, detailInfo);
            for (int j = 0; j < cols.size(); ++j) {
                BatchSubmitShemeBillEntryInfo entryInfo = cols.get(j);
                if (!entryBizKeySet.contains(this.getSubmitBillEntryBizKey(entryInfo, calSubmitPeriod))) continue;
                this.verifyAndCoutingEntry(compareKeyAndFrequencyMap, entryInfo, calSubmitPeriod, detailInfo, errorColector);
            }
        }
        this.handleSubmitPeriodException(errorColector, calSubmitPeriod);
    }

    protected Set<String> assembleAndGetEntryBizKeySet(BatchSubmitShemeBillInfo info, CalSubmitPeriodInfo calSubmitPeriod) {
        HashSet<String> rs = new HashSet<String>();
        BatchSubmitShemeBillEntryCollection enties = info.getEntry();
        for (int i = 0; i < enties.size(); ++i) {
            BatchSubmitShemeBillEntryInfo entry = enties.get(i);
            rs.add(this.getSubmitBillEntryBizKey(entry, calSubmitPeriod));
        }
        return rs;
    }

    private Date getEffectDate(BatchSubmitShemeBillEntryInfo entryInfo) {
        Date effectDate = entryInfo.getEffectDate();
        if (effectDate == null) {
            effectDate = CmpDateUtil.toDate(entryInfo.get("effectday"));
        }
        return effectDate;
    }

    private String getPersonNumber(BatchSubmitShemeBillEntryInfo entryInfo) {
        String number = (String)entryInfo.get("number");
        if (StringUtils.isEmpty((CharSequence)number)) {
            number = entryInfo.getPerson().getNumber();
        }
        return number;
    }

    protected void verifyAndCoutingEntry(Map<String, Integer> compareKeyAndFrequencyMap, BatchSubmitShemeBillEntryInfo entryInfo, CalSubmitPeriodInfo calSubmitPeriod, SubmitPeriodDetailInfo detailInfo, Set<BatchSubmitShemeBillEntryInfo> errorColector) throws BOSException {
        String compareKey = this.getSubmitPeriodCompareKey(entryInfo, detailInfo, calSubmitPeriod);
        int currentFrequency = compareKeyAndFrequencyMap.get(compareKey) == null ? 1 : compareKeyAndFrequencyMap.get(compareKey) + 1;
        compareKeyAndFrequencyMap.put(compareKey, currentFrequency);
        if (currentFrequency > calSubmitPeriod.getFrequency()) {
            errorColector.add(entryInfo);
        }
    }

    protected void handleSubmitPeriodException(Set<BatchSubmitShemeBillEntryInfo> errorColector, CalSubmitPeriodInfo calSubmitPeriod) throws EASBizException {
        if (errorColector.isEmpty()) {
            return;
        }
        HashSet<String> errorMesSet = new HashSet<String>();
        StringBuilder errorMesBuilder = new StringBuilder();
        errorMesBuilder.append(NEW_LINE_WEB);
        for (BatchSubmitShemeBillEntryInfo entry : errorColector) {
            if (errorMesSet.add(this.getSubmitBillEntryBizKey(entry, calSubmitPeriod))) {
                errorMesBuilder.append(entry.getPerson().getName()).append(BREAKES_LEFT).append(this.getPersonNumber(entry)).append(BREAKES_RIGHT).append(COMMA);
            }
            if (errorMesSet.size() != MAX_SHOW_ERROR_COUNT.intValue()) continue;
            errorMesBuilder.deleteCharAt(errorMesBuilder.lastIndexOf(COMMA));
            errorMesBuilder.append(MORE_CHAR);
            break;
        }
        if (errorMesSet.size() < MAX_SHOW_ERROR_COUNT) {
            errorMesBuilder.deleteCharAt(errorMesBuilder.lastIndexOf(COMMA));
        }
        Object[] errorParams = new String[]{errorMesBuilder.toString()};
        throw new SubmitPeriodException(SubmitPeriodException.OUTOFRANGE, errorParams);
    }

    protected CalSubmitPeriodCollection getCalSubmitPeriodCollection(Context ctx, BatchSubmitShemeBillInfo info) throws BOSException {
        EntityViewInfo entryViewInfo = new EntityViewInfo();
        SelectorItemCollection selectorCol = new SelectorItemCollection();
        selectorCol.add("submitPeriod.id");
        selectorCol.add("submitPeriod.type");
        selectorCol.add("submitElement.id");
        selectorCol.add("frequency");
        selectorCol.add("frequencyDimension");
        selectorCol.add("submitScheme.effectDateDisplay");
        entryViewInfo.setSelector(selectorCol);
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("submitScheme", (Object)info.getSubmitScheme().getId().toString());
        filter.appendFilterItem("state", (Object)1);
        filter.getFilterItems().add(new FilterItemInfo("id not in (SELECT FID FROM T_HR_SCalSubmitPeriod WHERE FSubmitPeriodId IS NULL OR FSubmitPeriodId = '')"));
        entryViewInfo.setFilter(filter);
        return CalSubmitPeriodFactory.getLocalInstance(ctx).getCalSubmitPeriodCollection(entryViewInfo);
    }

    protected BatchSubmitShemeBillEntryCollection getSubmitBillEntryColInPeriod(Context ctx, BatchSubmitShemeBillInfo info, SubmitPeriodDetailInfo detailInfo) throws BOSException, EASBizException {
        BatchSubmitShemeBillEntryCollection entryCols = new BatchSubmitShemeBillEntryCollection();
        String submitSchemeId = info.getSubmitScheme().getId().toString();
        String oql = "select billEntryTableName where submitScheme = '%s'";
        CalShemeTableRelationInfo relationInfo = CalShemeTableRelationFactory.getLocalInstance(ctx).getCalShemeTableRelationInfo(String.format(oql, submitSchemeId));
        String sql = "SELECT entry.FPersonId personId,person.FName_" + ctx.getLocale().getLanguage() + " personName,person.FNumber personNumber,entry.FPositionID position,entry.FCmpEmpORelationID cmpEmpORelation,entry.FAdminOrgUnitID adminOrgUnit,entry.FSubmitElementID submitElement FROM " + relationInfo.getBillEntryTableName() + " entry LEFT JOIN T_HR_SBatchSubmitShemeBill bill ON entry.FBillID = bill.FID  LEFT JOIN T_BD_Person person ON entry.FPersonId = person.FID WHERE entry.FEffectDate >= {ts '" + this.sdf_yyyy_MM_dd.format(detailInfo.getStartDate()) + "'} AND entry.FEffectDate <= {ts '" + this.sdf_yyyy_MM_dd.format(detailInfo.getEndDate()) + "'} AND bill.FSubmitSchemeID = '" + info.getSubmitScheme().getId().toString() + "' AND bill.FID <> '" + info.getId().toString() + "' AND bill.FBillState <> " + 4;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                BatchSubmitShemeBillEntryInfo entry = new BatchSubmitShemeBillEntryInfo();
                PositionInfo position = new PositionInfo();
                position.setId(BOSUuid.read((String)rs.getString("position")));
                CmpEmpORelationInfo cmpEmpORelationInfo = new CmpEmpORelationInfo();
                cmpEmpORelationInfo.setId(BOSUuid.read((String)rs.getString("cmpEmpORelation")));
                AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
                adminOrgUnitInfo.setId(BOSUuid.read((String)rs.getString("adminOrgUnit")));
                PersonInfo person = new PersonInfo();
                person.setId(BOSUuid.read((String)rs.getString("personId")));
                person.setName(rs.getString("personName"));
                person.setNumber(rs.getString("personNumber"));
                entry.setPosition(position);
                entry.setCmpEmpORelation(cmpEmpORelationInfo);
                entry.setAdminOrgUnit(adminOrgUnitInfo);
                entry.setPerson(person);
                entryCols.add(entry);
                String submitElementId = rs.getString("submitElement");
                if (StringUtils.isEmpty((CharSequence)submitElementId)) continue;
                SubmitElementInfo submitElementInfo = new SubmitElementInfo();
                submitElementInfo.setId(BOSUuid.read((String)submitElementId));
                entry.setSubmitElement(submitElementInfo);
            }
        }
        catch (UuidException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return entryCols;
    }

    protected Map<SubmitPeriodDetailInfo, List<BatchSubmitShemeBillEntryInfo>> getPeriodAndEntrySetMap(Context ctx, BatchSubmitShemeBillEntryCollection entries, CalSubmitPeriodInfo calSubmitPeriodInfo) throws EASBizException, BOSException {
        HashMap<SubmitPeriodDetailInfo, List<BatchSubmitShemeBillEntryInfo>> periodAndEntrySetMap = new HashMap<SubmitPeriodDetailInfo, List<BatchSubmitShemeBillEntryInfo>>();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("id", (Object)calSubmitPeriodInfo.getSubmitPeriod().getId().toString());
        SubmitPeriodCollection cols = this.getSortedSubmitPeriodByDescCollection(ctx, filter);
        if (cols.size() == 0) {
            return periodAndEntrySetMap;
        }
        ArrayList<SubmitPeriodDetailInfo> popularPeriodList = new ArrayList<SubmitPeriodDetailInfo>();
        SubmitPeriodDetailCollection details = cols.get(0).getEntry();
        if (this.isMonthOfYearFormat(calSubmitPeriodInfo)) {
            details = this.convertAndGetPeriodDetailCol(calSubmitPeriodInfo, details);
        }
        int showErrorCount = 0;
        StringBuilder errorMes = new StringBuilder();
        for (int j = 0; j < entries.size(); ++j) {
            boolean isMatch;
            BatchSubmitShemeBillEntryInfo entry = entries.get(j);
            if (!this.isMatchCondition(calSubmitPeriodInfo, entry) || (isMatch = this.matchPeriodAndAssembleMap(details, popularPeriodList, periodAndEntrySetMap, entry))) continue;
            showErrorCount = this.countAndassembleNoSubmitPeriodErrorMes(ctx, showErrorCount, errorMes, entry, this.isMonthOfYearFormat(calSubmitPeriodInfo));
        }
        if (showErrorCount > 0) {
            Object[] errorParams = new String[]{errorMes.toString()};
            throw new SubmitPeriodException(SubmitPeriodException.FORBIDDENSUBMIT, errorParams);
        }
        return periodAndEntrySetMap;
    }

    private int countAndassembleNoSubmitPeriodErrorMes(Context ctx, int showErrorCount, StringBuilder errorMes, BatchSubmitShemeBillEntryInfo entry, boolean isMonthOfYearFormat) {
        int curShowErrorCount = showErrorCount + 1;
        if (curShowErrorCount < 5) {
            errorMes.append(NEW_LINE_WEB);
            errorMes.append(entry.getPerson().getName()).append(BREAKES_LEFT).append(this.getPersonNumber(entry)).append(BREAKES_RIGHT);
            if (entry.getSubmitElement() != null) {
                errorMes.append(EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitPeriodResource", (String)"label0", (Locale)ctx.getLocale())).append(":").append(entry.getSubmitElement().getName()).append(" ");
            }
            errorMes.append(EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitPeriodResource", (String)"label1", (Locale)ctx.getLocale())).append(":");
            if (isMonthOfYearFormat) {
                errorMes.append(this.sdf_yyyy_MM.format(this.getEffectDate(entry)));
            } else {
                errorMes.append(this.sdf_yyyy_MM_dd.format(this.getEffectDate(entry)));
            }
        }
        if (curShowErrorCount == 5) {
            errorMes.append(MORE_CHAR);
        }
        return curShowErrorCount;
    }

    protected boolean isMatchCondition(CalSubmitPeriodInfo calSubmitPeriodInfo, BatchSubmitShemeBillEntryInfo entry) {
        return true;
    }

    protected SubmitPeriodCollection getSortedSubmitPeriodByDescCollection(Context ctx, FilterInfo filter) throws BOSException {
        ISubmitPeriod instance = SubmitPeriodFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        SorterItemCollection sortCol = new SorterItemCollection();
        SorterItemInfo sorterItemInfo = new SorterItemInfo("entry.startDate");
        sorterItemInfo.setSortType(SortType.DESCEND);
        sortCol.add(sorterItemInfo);
        view.setSorter(sortCol);
        view.setFilter(filter);
        return instance.getSubmitPeriodCollection(view);
    }

    protected boolean matchPeriodAndAssembleMap(SubmitPeriodDetailCollection details, List<SubmitPeriodDetailInfo> popularPeriodList, Map<SubmitPeriodDetailInfo, List<BatchSubmitShemeBillEntryInfo>> periodAndEntrySetMap, BatchSubmitShemeBillEntryInfo entry) throws EASBizException {
        return this.matchPopularPeriodAndAssembleMap(popularPeriodList, periodAndEntrySetMap, entry) || this.matchRestPeriodAndAssembleMap(details, popularPeriodList, periodAndEntrySetMap, entry);
    }

    protected boolean matchPopularPeriodAndAssembleMap(List<SubmitPeriodDetailInfo> popularPeriodList, Map<SubmitPeriodDetailInfo, List<BatchSubmitShemeBillEntryInfo>> periodAndEntrySetMap, BatchSubmitShemeBillEntryInfo entry) {
        for (int k = 0; k < popularPeriodList.size(); ++k) {
            SubmitPeriodDetailInfo detail = popularPeriodList.get(k);
            if (!this.isMatchPeriod(detail, entry)) continue;
            this.assemblePeriodAndEntrySetMap(periodAndEntrySetMap, detail, entry);
            return true;
        }
        return false;
    }

    protected boolean matchRestPeriodAndAssembleMap(SubmitPeriodDetailCollection details, List<SubmitPeriodDetailInfo> popularPeriodList, Map<SubmitPeriodDetailInfo, List<BatchSubmitShemeBillEntryInfo>> periodAndEntrySetMap, BatchSubmitShemeBillEntryInfo entry) throws EASBizException {
        Iterator it = details.iterator();
        while (it.hasNext()) {
            SubmitPeriodDetailInfo detail = (SubmitPeriodDetailInfo)it.next();
            if (!this.isMatchPeriod(detail, entry)) continue;
            if (StateEnum.DISABLE.equals((Object)detail.getState())) {
                Object[] errorParams = new String[]{this.sdf_yyyy_MM_dd.format(detail.getStartDate()), this.sdf_yyyy_MM_dd.format(detail.getEndDate())};
                throw new SubmitPeriodException(SubmitPeriodException.DISABLEDSUBMITPERIOD, errorParams);
            }
            this.assemblePeriodAndEntrySetMap(periodAndEntrySetMap, detail, entry);
            popularPeriodList.add(detail);
            it.remove();
            return true;
        }
        return false;
    }

    protected boolean isMatchPeriod(SubmitPeriodDetailInfo detail, BatchSubmitShemeBillEntryInfo entry) {
        Date effectDate = entry.getEffectDate();
        effectDate = effectDate == null ? CmpDateUtil.toDate(entry.get("effectday")) : effectDate;
        return detail.getStartDate().compareTo(effectDate) <= 0 && detail.getEndDate().compareTo(effectDate) >= 0;
    }

    protected void assemblePeriodAndEntrySetMap(Map<SubmitPeriodDetailInfo, List<BatchSubmitShemeBillEntryInfo>> periodAndEntrySetMap, SubmitPeriodDetailInfo detail, BatchSubmitShemeBillEntryInfo entry) {
        List<BatchSubmitShemeBillEntryInfo> subEntries = periodAndEntrySetMap.get(detail);
        if (subEntries == null) {
            subEntries = new ArrayList<BatchSubmitShemeBillEntryInfo>();
        }
        subEntries.add(entry);
        periodAndEntrySetMap.put(detail, subEntries);
    }

    protected boolean isMonthOfYearFormat(CalSubmitPeriodInfo calSubmitPeriod) {
        return DateTypeEnum.yyyyMM.equals((Object)calSubmitPeriod.getSubmitScheme().getEffectDateDisplay());
    }

    protected SubmitPeriodDetailCollection convertAndGetPeriodDetailCol(CalSubmitPeriodInfo calSubmitPeriodInfo, SubmitPeriodDetailCollection details) {
        if (details == null || details.size() == 0) {
            return details;
        }
        Map<String, Date> monthOfYearAndMaxEndDateMap = this.mergeAndGetMonthOfYearAndMaxEndDateMap(details);
        SubmitPeriodDetailCollection result = this.convert2NewPeriodDetailCollection(monthOfYearAndMaxEndDateMap);
        this.checkAndCorrectOverlapPeriod(result);
        return result;
    }

    protected Map<String, Date> mergeAndGetMonthOfYearAndMaxEndDateMap(SubmitPeriodDetailCollection details) {
        HashMap<String, Date> monthOfYearAndMaxEndDateMap = new HashMap<String, Date>();
        for (int i = 0; i < details.size(); ++i) {
            SubmitPeriodDetailInfo detail = details.get(i);
            if (StateEnum.DISABLE.equals((Object)detail.getState())) continue;
            Date startDate = detail.getStartDate();
            Date endDate = detail.getEndDate();
            String monthOfYearKey = CmpDateUtil.getYear(startDate) + JOIN_CHAR + CmpDateUtil.getActualMonth(startDate);
            if (monthOfYearAndMaxEndDateMap.get(monthOfYearKey) != null && ((Date)monthOfYearAndMaxEndDateMap.get(monthOfYearKey)).compareTo(endDate) >= 0) continue;
            monthOfYearAndMaxEndDateMap.put(monthOfYearKey, endDate);
        }
        return monthOfYearAndMaxEndDateMap;
    }

    protected SubmitPeriodDetailCollection convert2NewPeriodDetailCollection(Map<String, Date> monthOfYearAndMaxEndDateMap) {
        SubmitPeriodDetailCollection result = new SubmitPeriodDetailCollection();
        for (String monthOfYearKey : monthOfYearAndMaxEndDateMap.keySet()) {
            Date startDate = CmpDateUtils.getDate((int)this.getYear(monthOfYearKey), (int)this.getMonth(monthOfYearKey), (int)1);
            Date endDate = CmpDateUtil.getMonthEndDate(monthOfYearAndMaxEndDateMap.get(monthOfYearKey));
            SubmitPeriodDetailInfo detailInfo = new SubmitPeriodDetailInfo();
            detailInfo.setStartDate(startDate);
            detailInfo.setEndDate(endDate);
            detailInfo.setState(StateEnum.ENABLE);
            result.add(detailInfo);
        }
        return result;
    }

    protected void checkAndCorrectOverlapPeriod(SubmitPeriodDetailCollection cos) {
        if (cos == null || cos.size() == 0) {
            return;
        }
        cos.sort("startDate");
        SubmitPeriodDetailInfo previousDetail = cos.get(0);
        for (int i = 1; i < cos.size(); ++i) {
            SubmitPeriodDetailInfo currentDetail = cos.get(i);
            if (currentDetail.getStartDate().compareTo(previousDetail.getEndDate()) <= 0) {
                previousDetail.setEndDate(CmpDateUtil.getAddDate(currentDetail.getStartDate(), -1));
            }
            previousDetail = currentDetail;
        }
    }

    protected int getYear(String monthOfYear) {
        return Integer.parseInt(monthOfYear.substring(0, monthOfYear.indexOf(JOIN_CHAR)));
    }

    protected int getMonth(String monthOfYear) {
        return Integer.parseInt(monthOfYear.substring(monthOfYear.indexOf(JOIN_CHAR) + JOIN_CHAR.length()));
    }
}

