/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.taxCal;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.compensation.app.tax.TaxUnitInfo;
import com.kingdee.shr.compensation.app.taxCal.AbstractDownloadWszmFacadeControllerBean;
import com.kingdee.shr.compensation.app.taxCal.ITaxServiceTaskFacade;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskCatalogEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxPaymentServiceCollection;
import com.kingdee.shr.compensation.app.taxCal.TaxPaymentServiceInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxServiceTaskFacadeFactory;
import com.kingdee.shr.compensation.app.taxCal.vo.WszmResponseVO;
import com.kingdee.shr.compensation.util.Base64Utils;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class DownloadWszmFacadeControllerBean
extends AbstractDownloadWszmFacadeControllerBean {
    private static Logger logger = Logger.getLogger(DownloadWszmFacadeControllerBean.class);

    @Override
    protected void _sendGetWszmTask(Context ctx, TaxPaymentServiceCollection taxPaymentServiceCollection) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        TaxPaymentServiceInfo taxPaymentServiceInfo = taxPaymentServiceCollection.get(0);
        TaxUnitInfo taxUnit = taxPaymentServiceInfo.getTaxUnit();
        paramMap.put("areaid", taxUnit.getAreaCode());
        paramMap.put("nsrsbh", taxUnit.getTaxNumber());
        paramMap.put("djxhid", taxUnit.getRegNumber());
        String userId = taxPaymentServiceInfo.getLastUpdateUser().getId().toString();
        if (StringUtils.isNotEmpty((CharSequence)taxUnit.getDeclPassword())) {
            paramMap.put("sbmm", Base64Utils.decode(taxUnit.getDeclPassword()));
        }
        if (StringUtils.isNotEmpty((CharSequence)taxUnit.getRealPassword())) {
            paramMap.put("smmm", Base64Utils.decode(taxUnit.getRealPassword()));
        }
        paramMap.put("ver", "V2.0.000");
        paramMap.put("yzsmzh", false);
        String period = taxPaymentServiceInfo.getPeriod();
        period = period.contains("-") ? period.replace("-", "") : period;
        period = period.substring(0, 6);
        paramMap.put("sdyf", period);
        paramMap.put("creator", userId);
        paramMap.put("TAXUNITID", taxUnit.getId().toString());
        ArrayList<String> tbTypes = new ArrayList<String>();
        ArrayList<String> taxPaymentServiceIds = new ArrayList<String>();
        for (int i = 0; i <= taxPaymentServiceCollection.size() - 1; ++i) {
            TaxPaymentServiceInfo taxPaymentServiceInfo1 = taxPaymentServiceCollection.get(i);
            tbTypes.add(taxPaymentServiceInfo1.getTbType().getName());
            taxPaymentServiceIds.add(taxPaymentServiceInfo1.getId().toString());
        }
        paramMap.put("bblb", tbTypes.toArray());
        try {
            ITaxServiceTaskFacade taxServiceTaskFacade = TaxServiceTaskFacadeFactory.getLocalInstance(ctx);
            IObjectPK wszmTaskId = taxServiceTaskFacade.addTask(TaxCalTaskCatalogEnum.DownloadWszm, paramMap);
            if (null == wszmTaskId) {
                logger.error((Object)"taxServiceTaskFacade add task failed, wszmTaskId is null");
                return;
            }
            ArrayList<Object[]> updateParamList = new ArrayList<Object[]>();
            String wszmTaskIdStr = wszmTaskId.toString();
            for (String taxPaymentId : taxPaymentServiceIds) {
                Object[] param = new Object[]{wszmTaskIdStr, userId, taxPaymentId};
                updateParamList.add(param);
            }
            String sqlString = "update T_HR_STaxPaymentService set FGetWszmTaskID = ?, FLastUpdateUserID= ?, FLastUpdateTime = " + CmpDateUtil.toKSqlDate(new Date()) + " where fid = ?";
            DbUtil.executeBatch((Context)ctx, (String)sqlString, updateParamList);
        }
        catch (Exception e) {
            logger.error((Object)"send downloading wszm task error: ", (Throwable)e);
        }
    }

    @Override
    protected void _afterDownload(Context ctx, String acceptId, WszmResponseVO wszmResponseVO) throws BOSException {
    }
}

