/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.taxCal;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.compensation.app.incomeTax.IReductionSummaryFacade;
import com.kingdee.shr.compensation.app.incomeTax.ReductionSummaryFacadeFactory;
import com.kingdee.shr.compensation.app.taxCal.AbstractTaxCalInitDetailControllerBean;
import com.kingdee.shr.compensation.app.taxCal.TaxCalDelTypeEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxCalForJSFacadeFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalInitDetailCollection;
import com.kingdee.shr.compensation.app.taxCal.TaxCalInitDetailInfo;
import com.kingdee.shr.compensation.taxCal.VO.TaxCalDeleteVO;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TaxCalInitDetailControllerBean
extends AbstractTaxCalInitDetailControllerBean {
    private static final Logger logger = Logger.getLogger(TaxCalInitDetailControllerBean.class);

    @Override
    protected void _delete(Context ctx, TaxCalDeleteVO param) throws BOSException {
        try {
            Map<String, List<String>> taxUnitMap = param.getSuccMap();
            if (!taxUnitMap.isEmpty()) {
                for (Map.Entry<String, List<String>> entry : taxUnitMap.entrySet()) {
                    TaxCalForJSFacadeFactory.getLocalInstance(ctx).deleteCalData(CmpStrUtil.convertListToString(entry.getValue()), TaxCalDelTypeEnum.DEL_TAX);
                }
            }
            this.deleteDirectly(ctx, param.getDirectlyList(), param.getUserId());
        }
        catch (EASBizException e) {
            logger.error((Object)"TaxCalInitDetailControllerBean delete error: ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    protected void deleteDirectly(Context ctx, List<String> directList, String userId) throws BOSException, EASBizException {
        if (directList.isEmpty()) {
            return;
        }
        CmpInSql<String> cmpInSql = CmpInSqlFactory.getInstance();
        String inCondition = cmpInSql.createInSqlBaseOnFId(ctx, directList);
        String oql = "select cmpCalTable.id, taxUnit.id, periodBegin where id in " + inCondition;
        TaxCalInitDetailCollection collection = this.getTaxCalInitDetailCollection(ctx, oql);
        this._delete(ctx, "where id in " + inCondition);
        ArrayList<String> cmpTableIdList = new ArrayList<String>();
        HashMap<String, Date> taxUnitMap = new HashMap<String, Date>();
        for (int i = 0; i < collection.size(); ++i) {
            TaxCalInitDetailInfo init = collection.get(i);
            cmpTableIdList.add(init.getCmpCalTable().getId().toString());
            taxUnitMap.put(init.getTaxUnit().getId().toString(), init.getPeriodBegin());
        }
        inCondition = cmpInSql.createInSqlBaseOnFId(ctx, cmpTableIdList);
        String inSQL = "select d.fid from t_hr_sCmpCalTable d where d.fid in " + inCondition + " and not exists (select 1 from T_HR_STaxCalInitDetail t where t.fCmpCalTableId = d.fid)";
        String updateSQL = "update t_hr_sCmpCalTable set fCalTaxDataState = 0 where fid in (" + inSQL + ")";
        DbUtil.execute((Context)ctx, (String)updateSQL);
        IReductionSummaryFacade facade = ReductionSummaryFacadeFactory.getLocalInstance(ctx);
        for (Map.Entry entry : taxUnitMap.entrySet()) {
            facade.save((String)entry.getKey(), (Date)entry.getValue(), userId);
        }
        cmpInSql.release(ctx);
    }
}

