/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.timepiece.scheme;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.hraux.StateEnum;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.compensation.app.integrate.CalShemeTableRelationFactory;
import com.kingdee.shr.compensation.app.integrate.CalShemeTableRelationInfo;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeFactory;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeInfo;
import com.kingdee.shr.compensation.app.integrate.DateTypeEnum;
import com.kingdee.shr.compensation.app.integrate.SubmitSchemeType;
import com.kingdee.shr.compensation.app.integrate.TargetType;
import com.kingdee.shr.compensation.app.timepiece.scheme.AbstractTimepieceSchemeControllerBean;
import com.kingdee.shr.compensation.app.timepiece.scheme.SchemeType;
import com.kingdee.shr.compensation.app.timepiece.scheme.TimepieceSchemeFactory;
import com.kingdee.shr.compensation.app.timepiece.scheme.TimepieceSchemeInfo;
import com.kingdee.shr.compensation.service.timepiece.TimepieceCreateTableWithPartitionService;
import com.kingdee.shr.compensation.util.timepiece.TimepieceSchemeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class TimepieceSchemeControllerBean
extends AbstractTimepieceSchemeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.timepiece.scheme.TimepieceSchemeControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TimepieceSchemeInfo info = (TimepieceSchemeInfo)model;
        return this.addnewOrUpdatCtrl(ctx, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.setMultiPropertiesBeforeSave(ctx, model);
        return this.addnewOrUpdatCtrl(ctx, model);
    }

    private IObjectPK addnewOrUpdatCtrl(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TimepieceSchemeInfo info = (TimepieceSchemeInfo)model;
        this.checkCalSubmitScheme(ctx, model);
        this.setUserAndTime(ctx, info);
        Timestamp createTime = TimepieceSchemeUtils.getTime();
        if (info.getCreateTime() == null) {
            info.setCreateTime(createTime);
        }
        SchemeType schemeType = info.getSchemeType();
        CalSubmitSchemeInfo submitScheme = info.getSubmitScheme();
        this.setCalSubmitSchemeInfo(submitScheme, schemeType);
        ObjectUuidPK idPk = null;
        if (info.getId() == null || StringUtils.isEmpty((String)info.getId().toString())) {
            submitScheme.setState(StateEnum.DISABLE);
            info.put("schemeOutDataConfig", null);
            info.put("standardTableConfig", null);
            info.put("sumItemConfig", null);
            idPk = super.innerAddnew(ctx, (IObjectValue)info);
            this.afterAddnewCtrl(ctx, schemeType, submitScheme);
        } else {
            idPk = new ObjectUuidPK(info.getId());
            super.innerUpdate(ctx, (IObjectPK)idPk, (IObjectValue)info);
        }
        return idPk;
    }

    private void setUserAndTime(Context ctx, TimepieceSchemeInfo info) throws BOSException, EASBizException {
        if (info.getCU() == null || info.getCU().getId() == null) {
            CtrlUnitInfo cu = new CtrlUnitInfo();
            cu.setId(BOSUuid.read((String)"11111111-1111-1111-1111-111111111111CCE7AED4"));
            info.setCU(cu);
        }
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        if (info.getCreator() == null) {
            info.setCreator(userInfo);
        }
        Timestamp createTime = TimepieceSchemeUtils.getTime();
        if (info.getCreateTime() == null) {
            info.setCreateTime(createTime);
        }
        info.setLastUpdateUser(userInfo);
        info.setLastUpdateTime(createTime);
    }

    private void afterAddnewCtrl(Context ctx, SchemeType schemeType, CalSubmitSchemeInfo info) throws BOSException, EASBizException {
        String tableName = "";
        if (schemeType.getValue() == 10) {
            tableName = "T_HR_TimepieceBillEntry";
            TimepieceCreateTableWithPartitionService.createTimepieceSchemeBillEntry(ctx, "T_HR_TimepieceBillBaseEntry");
        } else {
            tableName = "T_HR_TimepieceSumBillEntry";
        }
        TimepieceCreateTableWithPartitionService.createTimepieceSchemeBillEntry(ctx, tableName);
        CalShemeTableRelationInfo calShemeTableRelationInfo = new CalShemeTableRelationInfo();
        calShemeTableRelationInfo.setSuffix(0);
        calShemeTableRelationInfo.setBillEntryTableName(tableName);
        calShemeTableRelationInfo.setCalShemeTableName(tableName);
        calShemeTableRelationInfo.setSubmitScheme(info);
        CalShemeTableRelationFactory.getLocalInstance(ctx).addnew(calShemeTableRelationInfo);
    }

    private void setCalSubmitSchemeInfo(CalSubmitSchemeInfo submitScheme, SchemeType schemeType) {
        if (schemeType.getValue() == 10) {
            submitScheme.setSubmitSchemeType(SubmitSchemeType.TIMEPIECE);
            submitScheme.setSubmitTarget(TargetType.person);
            submitScheme.setEffectDateDisplay(DateTypeEnum.yyyyMMdd);
            submitScheme.setIsTeamSubmit(Boolean.TRUE);
            if (submitScheme.getCU() == null || submitScheme.getCU().getId() == null) {
                CtrlUnitInfo cu = new CtrlUnitInfo();
                cu.setId(BOSUuid.read((String)"11111111-1111-1111-1111-111111111111CCE7AED4"));
                submitScheme.setCU(cu);
            }
        } else {
            submitScheme.setSubmitSchemeType(SubmitSchemeType.TIMEPIECESUN);
        }
    }

    private void setMultiPropertiesBeforeSave(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TimepieceSchemeInfo info = (TimepieceSchemeInfo)model;
        if (null != info.getId()) {
            TimepieceSchemeInfo timepieceSchemeInfo = TimepieceSchemeFactory.getLocalInstance(ctx).getTimepieceSchemeInfo(" where id = '" + info.getId().toString() + "'");
            CalSubmitSchemeInfo submitScheme = info.getSubmitScheme();
            submitScheme.setId(timepieceSchemeInfo.getSubmitScheme().getId());
            info.put("schemeOutDataConfig", (Object)timepieceSchemeInfo.getSchemeOutDataConfig());
            info.put("standardTableConfig", (Object)timepieceSchemeInfo.getStandardTableConfig());
            info.put("sumItemConfig", (Object)timepieceSchemeInfo.getSumItemConfig());
        }
    }

    private void checkCalSubmitScheme(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean exists;
        TimepieceSchemeInfo info = (TimepieceSchemeInfo)model;
        SchemeType schemeType = info.getSchemeType();
        CalSubmitSchemeInfo submitScheme = info.getSubmitScheme();
        String id = null;
        if (null != info.getId()) {
            id = null != submitScheme.getId() ? submitScheme.getId().toString() : TimepieceSchemeUtils.getSubmitSchemeId(ctx, info.getId().toString());
        }
        String oql = "select * where (name = '" + submitScheme.getName() + "' or number = '" + submitScheme.getNumber() + "') and submitSchemeType not in ('2','3')  ";
        if (!StringUtils.isEmpty((String)id)) {
            oql = oql + " and id <> '" + id + "'";
        }
        if (exists = CalSubmitSchemeFactory.getLocalInstance(ctx).exists(oql)) {
            throw new EASBizException(new NumericExceptionSubItem("022", MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label73"), submitScheme.getNumber(), submitScheme.getName())));
        }
    }
}

