/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.calculate.interceptor;

import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.app.formula.SalaryCalFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class FuncMethodInterceptor
implements MethodInterceptor {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.calculate.interceptor.FuncMethodInterceptor");

    public Object invoke(MethodInvocation invocation) throws Throwable {
        SalaryCalFunction calFunction = (SalaryCalFunction)invocation.getThis();
        boolean isNeedRecord = true;
        if ("test".equals(calFunction.getType())) {
            isNeedRecord = false;
        }
        if (isNeedRecord) {
            HashMap<String, Object> tempMap = calFunction.getTempMap();
            this.initFuncDefine2NameMapper(calFunction);
            tempMap.put("THIS_KEY_IS_USED_FOR_ANALASIZE_FUNCTION_MEMORY", Boolean.TRUE);
            long startTime = System.currentTimeMillis();
            Object resObj = invocation.proceed();
            long endTime = System.currentTimeMillis();
            long memoryUse = tempMap.containsKey("THIS_VALUE_IS_USED_FOR_ANALASIZE_FUNCTION_MEMORY") ? (Long)tempMap.get("THIS_VALUE_IS_USED_FOR_ANALASIZE_FUNCTION_MEMORY") : 0L;
            tempMap.remove("THIS_KEY_IS_USED_FOR_ANALASIZE_FUNCTION_MEMORY");
            tempMap.remove("THIS_VALUE_IS_USED_FOR_ANALASIZE_FUNCTION_MEMORY");
            this.recordMemoryAndTime(invocation, "CAL_RECORD_MAP_MEMORY", "CAL_RECORD_MAP_MEMORY_FUNC", memoryUse);
            this.recordMemoryAndTime(invocation, "CAL_RECORD_MAP_TIME", "CAL_RECORD_MAP_TIME_FUNC", endTime - startTime);
            this.recordProcessData(invocation, resObj);
            return resObj;
        }
        return invocation.proceed();
    }

    protected void initFuncDefine2NameMapper(SalaryCalFunction calFunction) {
        Map<String, Object> calRecordMap = calFunction.getCalRecordMap();
        if (calRecordMap.containsKey("CAL_RECORD_MAP_FUNCDEFINENAMEMAPPER")) {
            return;
        }
        HashMap<String, String> funcDefine2NameMap = new HashMap<String, String>();
        Context ctx = calFunction.getCtx();
        CalSchemeInfo calScheme = calFunction.getCalScheme();
        try {
            String getFunsSql = "SELECT FListFunc FROM T_HR_SCalFormula where FCALSCHEMEID = ? and FISCAL = 1 order by FSORTSN ";
            String calSchemeId = calScheme.getId().toString();
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)getFunsSql, (Object[])new Object[]{calSchemeId});
            String usedFunc = "";
            StringBuilder builder = new StringBuilder();
            builder.append("'Aq2HyTeyQmu4MxenjAZ/6iQBOWg='");
            while (rowSet.next()) {
                String[] usedFuncArr;
                usedFunc = rowSet.getString("FListFunc");
                if (StringUtils.isEmpty((CharSequence)usedFunc)) continue;
                for (String func : usedFuncArr = usedFunc.split(";")) {
                    builder.append(",'").append(func.split("~")[1]).append("'");
                }
            }
            String shortCode = LocaleUtils.getShortCode((Context)ctx);
            getFunsSql = "SELECT FDEFINE,FNAME_" + shortCode + " NAME FROM T_HR_SformulaFunc where fid in (" + builder.toString() + ")";
            rowSet = DbUtil.executeQuery((Context)ctx, (String)getFunsSql);
            String define = "";
            String name = "";
            while (rowSet.next()) {
                define = rowSet.getString("FDEFINE");
                name = rowSet.getString("NAME");
                funcDefine2NameMap.put(define, name);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        calRecordMap.put("CAL_RECORD_MAP_FUNCDEFINENAMEMAPPER", funcDefine2NameMap);
    }

    protected void recordMemoryAndTime(MethodInvocation invocation, String mainKey, String typeKey, long value) {
        if (value <= 0L) {
            return;
        }
        SalaryCalFunction calFunction = (SalaryCalFunction)invocation.getThis();
        Map<String, Object> calRecordMap = calFunction.getCalRecordMap();
        Map funcDefine2NameMap = (Map)calRecordMap.get("CAL_RECORD_MAP_FUNCDEFINENAMEMAPPER");
        String funcDefine = invocation.getMethod().getName();
        String funcName = (String)funcDefine2NameMap.get(funcDefine);
        Map valueMap = calRecordMap.containsKey(mainKey) ? (Map)calRecordMap.get(mainKey) : new HashMap();
        Map funcTypeMap = valueMap.containsKey(typeKey) ? (Map)valueMap.get(typeKey) : new HashMap();
        long total = 0L;
        if (funcTypeMap.containsKey(funcName)) {
            total = (Long)funcTypeMap.get(funcName);
        }
        funcTypeMap.put(funcName, total + value);
        valueMap.put(typeKey, funcTypeMap);
        calRecordMap.put(mainKey, valueMap);
    }

    protected void recordProcessData(MethodInvocation invocation, Object resObj) {
        SalaryCalFunction calFunction = (SalaryCalFunction)invocation.getThis();
        Map<String, Object> calRecordMap = calFunction.getCalRecordMap();
        Map processDataMap = calRecordMap.containsKey("CAL_RECORD_MAP_PROCESS_DATA") ? (Map)calRecordMap.get("CAL_RECORD_MAP_PROCESS_DATA") : new HashMap();
        Map<String, Object> paramMap = calFunction.getParamMap();
        String mainId = (String)paramMap.get(calFunction.MAIN_ID);
        String curFormulaName = (String)paramMap.get("CURFORMULA");
        Map funcDefine2NameMap = (Map)calRecordMap.get("CAL_RECORD_MAP_FUNCDEFINENAMEMAPPER");
        Map formulaInfoMap = (Map)calRecordMap.get("CAL_RECORD_MAP_FORMULAINFOMAPKEY");
        Map perFormula = (Map)formulaInfoMap.get(curFormulaName);
        String formulaid = (String)perFormula.get("FORMULAID");
        String funcDefine = invocation.getMethod().getName();
        String funcName = (String)funcDefine2NameMap.get(funcDefine);
        Map perProcessData = processDataMap.containsKey(mainId) ? (Map)processDataMap.get(mainId) : new HashMap();
        Map formulaProData = perProcessData.containsKey(formulaid) ? (Map)perProcessData.get(formulaid) : new HashMap();
        Map proDataCalFunMap = formulaProData.containsKey("CAL_RECORD_MAP_PROCESS_DATA_CALFUNCS") ? (Map)formulaProData.get("CAL_RECORD_MAP_PROCESS_DATA_CALFUNCS") : new HashMap();
        List proData = proDataCalFunMap.containsKey(funcName) ? (List)proDataCalFunMap.get(funcName) : new ArrayList();
        Object[] arguments = invocation.getArguments();
        StringBuilder argSb = new StringBuilder();
        for (Object arg : arguments) {
            if (arg instanceof Double) {
                argSb.append(",").append(String.valueOf(arg));
                continue;
            }
            if (!(arg instanceof String)) continue;
            argSb.append(",").append(arg);
        }
        int curSize = proData.size();
        HashMap<String, String> perCalFunProData = new HashMap<String, String>();
        perCalFunProData.put(funcName + "  " + (curSize + 1), (argSb.length() > 0 ? argSb.toString().replaceFirst(",", "") : "") + "--->" + String.valueOf(resObj));
        proData.add(perCalFunProData);
        proDataCalFunMap.put(funcName, proData);
        formulaProData.put("CAL_RECORD_MAP_PROCESS_DATA_CALFUNCS", proDataCalFunMap);
        perProcessData.put(formulaid, formulaProData);
        processDataMap.put(mainId, perProcessData);
        calRecordMap.put("CAL_RECORD_MAP_PROCESS_DATA", processDataMap);
    }
}

