/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.calculate.pt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.CalFormulaInfo;
import com.kingdee.shr.compensation.CmpItemDataDot;
import com.kingdee.shr.compensation.CmpItemInfo;
import com.kingdee.shr.compensation.app.formula.SalaryCalFunction;
import com.kingdee.shr.compensation.calculate.combine.calData.CmpItemService;
import com.kingdee.shr.compensation.calculate.interceptor.CalFormulaInterceptor;
import com.kingdee.shr.compensation.calculate.interceptor.FuncMethodInterceptor;
import com.kingdee.shr.compensation.calculate.pt.ISalaryCalFunmgr;
import com.kingdee.shr.compensation.calculate.pt.MyClassLoader;
import com.kingdee.shr.compensation.calculate.thread.CalInitData;
import com.kingdee.shr.compensation.exception.SalaryException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.JdkRegexpMethodPointcut;

public class AbstractSalaryCalFunMgr
implements ISalaryCalFunmgr {
    private static Logger logger = Logger.getLogger(AbstractSalaryCalFunMgr.class);
    private static String className = "com.kingdee.shr.compensation.app.formula.SalaryCalFunction";
    private static ClassPool pool = null;

    @Override
    public synchronized SalaryCalFunction getInstance(CalInitData initData, List<CalFormulaInfo> formulaList) throws Exception {
        Context ctx = initData.getCtx();
        if (pool == null) {
            AbstractSalaryCalFunMgr.initPool();
        }
        if (pool == null) {
            throw new SalaryException(SalaryException.INITFAIL);
        }
        MyClassLoader classLoader = new MyClassLoader(AbstractSalaryCalFunMgr.class.getClassLoader());
        CtClass funcPt = pool.makeClass(className + "FuncImp", pool.get(className));
        CtClass formulaPt = pool.makeClass(className + "FormulaImp", pool.get(className));
        CtClass pt = pool.makeClass(className + "Imp", pool.get(className));
        StringBuilder mainFunBody = new StringBuilder();
        try {
            Map<String, List<String>> formulaID2DefineMap = AbstractSalaryCalFunMgr.initCalFuncDefines(ctx, formulaList, funcPt);
            AbstractSalaryCalFunMgr.addFieldAndGetSetMethod(funcPt, "funcImp", formulaPt);
            AbstractSalaryCalFunMgr.addFieldAndGetSetMethod(formulaPt, "formulaImp", pt);
            mainFunBody = AbstractSalaryCalFunMgr.ptFormula2FormulaImp(initData, formulaList, formulaPt, formulaID2DefineMap);
            String mainBody = "public void calculate(java.util.HashMap paras){\n";
            mainBody = mainBody + mainFunBody.toString();
            mainBody = mainBody + "}\n";
            AbstractSalaryCalFunMgr.ptNewMethod(mainBody, pt);
            SalaryCalFunction functionImpl = AbstractSalaryCalFunMgr.getAopProxyObject(classLoader, funcPt, new FuncMethodInterceptor(), new String[]{className + "FuncImp.Fun*.*"});
            SalaryCalFunction formulaFuncImp = AbstractSalaryCalFunMgr.getAopProxyObject(classLoader, formulaPt, new CalFormulaInterceptor(), new String[]{className + "FormulaImp.formula*.*"});
            if (null != formulaFuncImp) {
                formulaFuncImp.getClass().getMethod("setFuncImp", Class.forName(className + "FuncImp", false, classLoader)).invoke((Object)formulaFuncImp, functionImpl);
            }
            Class<SalaryCalFunction> clazz = AbstractSalaryCalFunMgr.pt2Class(pt, classLoader);
            SalaryCalFunction salaryCalFunction = null;
            salaryCalFunction = clazz.newInstance();
            salaryCalFunction.getClass().getMethod("setFormulaImp", Class.forName(className + "FormulaImp", false, classLoader)).invoke((Object)salaryCalFunction, formulaFuncImp);
            return salaryCalFunction;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void beforeToPTClass(CtClass pt) throws Exception {
    }

    protected static synchronized void initPool() throws NotFoundException {
        if (pool == null) {
            pool = ClassPool.getDefault();
            pool.importPackage(SalaryCalFunction.class.getPackage().getName());
            pool.importPackage("java.math.BigDecimal");
            pool.importPackage("java.text.SimpleDateFormat");
            pool.importPackage("java.util");
        }
    }

    protected static void addFieldAndGetSetMethod(CtClass fieldType, String fieldName, CtClass pt) {
        try {
            CtField ctFuncImplField = new CtField(fieldType, fieldName, pt);
            pt.addField(ctFuncImplField);
            String methodNameSuf = String.valueOf(fieldName.charAt(0)).toUpperCase() + fieldName.substring(1);
            StringBuilder sb = new StringBuilder();
            sb.append("public ").append(className).append(methodNameSuf).append(" get").append(methodNameSuf).append("(){return ").append(fieldName).append(";}");
            AbstractSalaryCalFunMgr.ptNewMethod(sb.toString(), pt);
            sb = new StringBuilder();
            sb.append("public void set").append(methodNameSuf).append("(").append(className).append(methodNameSuf).append(" ").append(fieldName).append(") {this.").append(fieldName).append(" = ").append(fieldName).append(";}");
            AbstractSalaryCalFunMgr.ptNewMethod(sb.toString(), pt);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected static SalaryCalFunction getAopProxyObject(ClassLoader classLoader, CtClass pt, MethodInterceptor methodInterceptor, String[] pointCutReg) throws Exception {
        SalaryCalFunction proxyResult = null;
        Class<SalaryCalFunction> clazz = AbstractSalaryCalFunMgr.pt2Class(pt, classLoader);
        proxyResult = clazz.newInstance();
        ProxyFactoryBean proxyFactory = new ProxyFactoryBean();
        JdkRegexpMethodPointcut pointcut = new JdkRegexpMethodPointcut();
        pointcut.setPatterns(pointCutReg);
        DefaultPointcutAdvisor aroundAdvisor = new DefaultPointcutAdvisor((Pointcut)pointcut, (Advice)methodInterceptor);
        proxyFactory.addAdvisors(new Advisor[]{aroundAdvisor});
        proxyFactory.setTarget((Object)proxyResult);
        proxyFactory.setProxyClassLoader(classLoader);
        proxyResult = (SalaryCalFunction)proxyFactory.getObject();
        return proxyResult;
    }

    protected static Class<SalaryCalFunction> pt2Class(CtClass pt, ClassLoader classLoader) throws Exception {
        Class clazz;
        try {
            clazz = pt.toClass(classLoader, classLoader.getClass().getProtectionDomain());
        }
        finally {
            AbstractSalaryCalFunMgr.releasePTClass(pt);
        }
        return clazz;
    }

    private static void releasePTClass(CtClass pt) {
        pt.detach();
        pt.defrost();
    }

    protected static void ptNewMethod(String src, CtClass pt) throws CannotCompileException {
        CtMethod ctMethod = CtNewMethod.make((String)src, (CtClass)pt);
        pt.addMethod(ctMethod);
    }

    protected static Map<String, List<String>> initCalFuncDefines(Context ctx, List<CalFormulaInfo> formulaList, CtClass funcPt) throws Exception {
        HashMap<String, List<String>> formulaID2DefineMap = new HashMap<String, List<String>>();
        StringBuffer funs = new StringBuffer();
        funs.append("'Aq2HyTeyQmu4MxenjAZ/6iQBOWg='");
        int size = formulaList.size();
        for (int i = 0; i < size; ++i) {
            CalFormulaInfo formulaInfo = formulaList.get(i);
            String formulaId = formulaInfo.getId().toString();
            String listFuncs = formulaInfo.getListFunc();
            if (listFuncs == null || "".equals(listFuncs.trim())) continue;
            for (String func : listFuncs.split(";")) {
                List funcDefines;
                String[] item = func.split("~");
                String funcName = "'" + item[1] + "'";
                if (funs.indexOf(funcName) == -1) {
                    funs.append((funs.length() > 0 ? "," : "") + funcName);
                }
                if (!(funcDefines = formulaID2DefineMap.containsKey(formulaId) ? (List)formulaID2DefineMap.get(formulaId) : new ArrayList()).contains(item[2])) {
                    funcDefines.add(item[2]);
                }
                formulaID2DefineMap.put(formulaId, funcDefines);
            }
        }
        AbstractSalaryCalFunMgr.ptFunc2FuncImp(ctx, funs, funcPt);
        return formulaID2DefineMap;
    }

    protected static void ptFunc2FuncImp(Context ctx, StringBuffer funs, CtClass funcPt) throws Exception {
        String lanType = LocaleUtils.getShortCode((Context)ctx);
        funs.insert(0, "SELECT FName_" + lanType + ",FDefine,FContent,FReturnType,FParams FROM T_HR_SFormulaFunc WHERE fid IN(");
        funs.append(")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)funs.toString());
        while (rowSet.next()) {
            String content = rowSet.getString("FContent");
            try {
                AbstractSalaryCalFunMgr.ptNewMethod(content, funcPt);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new SalaryException(SalaryException.FUNERROR, new Object[]{"[" + rowSet.getString("FName_" + lanType) + "]"});
            }
        }
    }

    protected static StringBuilder ptFormula2FormulaImp(CalInitData initData, List<CalFormulaInfo> formulaList, CtClass pt, Map<String, List<String>> formulaID2DefineMap) throws SalaryException, SQLException, BOSException {
        StringBuilder mainFunBody = new StringBuilder();
        StringBuffer defineBody = new StringBuffer();
        StringBuffer calBody = new StringBuffer();
        StringBuffer retnBody = new StringBuffer();
        Context ctx = initData.getCtx();
        Locale ctxLocale = ctx.getLocale();
        Map<String, CmpItemInfo> tDotMap = CmpItemService.getItemInfoMap(ctx, initData.getSchemeInfo().getId().toString());
        int size = formulaList.size();
        for (int i = 0; i < size; ++i) {
            String[] item;
            defineBody = new StringBuffer();
            calBody = new StringBuffer();
            CalFormulaInfo formulaInfo = formulaList.get(i);
            String formulaId = formulaInfo.getId().toString();
            String listVars = formulaInfo.getListVar();
            HashMap<String, String> vars = new HashMap<String, String>();
            String listItems = formulaInfo.getListItem();
            String express = formulaInfo.getExpress();
            String bigExpress = formulaInfo.getBigExpress();
            if (!StringUtils.isEmpty((CharSequence)bigExpress)) {
                express = bigExpress;
            }
            if (formulaID2DefineMap.containsKey(formulaId)) {
                List<String> funcDefines = formulaID2DefineMap.get(formulaId);
                for (String string : funcDefines) {
                    if ("FunGetRound".equals(string)) continue;
                    express = express.replace(string + "(", "funcImp." + string + "(");
                }
            }
            String name = formulaInfo.getName();
            String calItem = formulaInfo.getCalItem() == null ? null : formulaInfo.getCalItem().toUpperCase();
            calBody.append("try{").append("\r\n");
            retnBody = new StringBuffer();
            if (express == null || "".equals(express)) continue;
            if (express != null && !"".equals(express)) {
                express = AbstractSalaryCalFunMgr.recoedLocimalJudement(express);
                calBody.append(express).append("\r\n");
            }
            if (listVars != null && !"".equals(listVars.trim())) {
                for (String var : listVars.split(";")) {
                    item = var.split("~");
                    String varName = item[2].substring(1);
                    if (defineBody.indexOf(item[2].substring(1) + ' ') != -1) continue;
                    if (item[0].equals("0")) {
                        defineBody.append("java.math.BigDecimal " + varName + " = getBigVal(paras.get(\"" + varName + "\"));").append("\r\n");
                        vars.put(varName, "double");
                        continue;
                    }
                    defineBody.append("String " + varName + " = toString(paras.get(\"" + varName + "\"));").append("\r\n");
                    vars.put(varName, "String");
                }
            }
            defineBody.append("paras.put(\"CALITEM\",\"" + calItem + "\");").append("\r\n");
            StringBuffer stringBuffer = new StringBuffer();
            if (null != listItems) {
                for (String listItem : listItems.split(";")) {
                    item = listItem.split("~");
                    String clm = item.length > 3 ? item[1] + "_" + item[3] + "_" + item[2] : item[1] + "_" + item[2];
                    if ("double".equals(item[0])) {
                        if ("T_HR_SCmpCalTable".equalsIgnoreCase(item[1]) && null != tDotMap.get(item[2].toUpperCase())) {
                            calBody.append("if(paras.get(\"" + item[2].toUpperCase() + "_edited\")!=null){").append("\r\n");
                            calBody.append(clm + "=getBigVal(paras.get(\"" + item[2].toUpperCase() + "_edited\"));}").append("\r\n");
                        }
                    } else if ("T_HR_SCmpCalTable".equalsIgnoreCase(item[1])) {
                        calBody.append("if(paras.get(\"" + item[2].toUpperCase() + "_edited\")!=null){").append("\r\n");
                        calBody.append(clm + "=toString(paras.get(\"" + item[2].toUpperCase() + "_edited\"));}").append("\r\n");
                    }
                    if (defineBody.indexOf(" " + clm + " ") >= 0) continue;
                    defineBody.append(("double".equals(item[0]) ? "java.math.BigDecimal" : item[0]) + " " + clm + "=null;").append("\r\n");
                    defineBody.append("if(paras.get(\"" + item[2].toUpperCase() + "_edited\")==null){").append("\r\n");
                    defineBody.append(clm + " = ").append("\r\n");
                    if ("double".equals(item[0])) {
                        defineBody.append("getBigVal(paras.get(\"" + clm.toUpperCase() + "\"));").append("\r\n");
                        defineBody.append("}else{" + clm + "=getBigVal(paras.get(\"" + item[2].toUpperCase() + "_edited\"));}").append("\r\n");
                        CmpItemDataDot cmpItemDataDot = !tDotMap.containsKey(item[2].toUpperCase()) ? CmpItemDataDot.DOT_TWO : tDotMap.get(item[2].toUpperCase()).getDataDot();
                        retnBody.append("if(null != " + clm + "){");
                        retnBody.append(clm + " = " + clm + ".setScale(" + cmpItemDataDot.getValue() + ", java.math.BigDecimal.ROUND_HALF_UP);");
                        retnBody.append("}");
                        retnBody.append("paras.put(\"" + clm.toUpperCase() + "\",getBigVal(" + clm + "));").append("\r\n");
                        continue;
                    }
                    if ("String".equals(item[0])) {
                        defineBody.append("toString(paras.get(\"" + clm.toUpperCase() + "\"));").append("\r\n");
                        defineBody.append("}else{" + clm + "=toString(paras.get(\"" + item[2].toUpperCase() + "_edited\"));}").append("\r\n");
                        retnBody.append("paras.put(\"" + clm.toUpperCase() + "\"," + clm + ");").append("\r\n");
                        continue;
                    }
                    defineBody.append("toString(paras.get(\"" + clm.toUpperCase() + "\"));").append("\r\n");
                }
            }
            if (vars.size() > 0) {
                for (Map.Entry var : vars.entrySet()) {
                    String varName = (String)var.getKey();
                    if (((String)var.getValue()).equals("double")) {
                        retnBody.append("paras.put(\"" + varName + "\",getBigVal(" + varName + "));").append("\r\n");
                        continue;
                    }
                    retnBody.append("paras.put(\"" + varName + "\"," + varName + ");").append("\r\n");
                }
            }
            calBody.append(stringBuffer);
            if (express == null || "".equals(express)) continue;
            calBody.append("} catch (Exception e){e.printStackTrace();throw new RuntimeException(\"[" + name + "]\");}").append("\r\n");
            StringBuffer sb = new StringBuffer();
            sb.append("public void formula" + i + "(java.util.HashMap paras){").append("\r\n");
            sb.append(defineBody).append("\r\n");
            sb.append(calBody).append("\r\n");
            sb.append(retnBody).append("\r\n");
            sb.append("}").append("\r\n");
            String formulaName = formulaInfo.getName();
            String formulaNameL1 = formulaInfo.getName(com.kingdee.util.LocaleUtils.locale_L1);
            String formulaNameL2 = formulaInfo.getName(com.kingdee.util.LocaleUtils.locale_L2);
            String formulaNameL3 = formulaInfo.getName(com.kingdee.util.LocaleUtils.locale_L3);
            formulaName = !StringUtils.isEmpty((CharSequence)formulaName) ? formulaName : (!StringUtils.isEmpty((CharSequence)formulaNameL1) ? formulaNameL1 : (!StringUtils.isEmpty((CharSequence)formulaNameL2) ? formulaNameL2 : formulaNameL3));
            try {
                AbstractSalaryCalFunMgr.ptNewMethod(sb.toString().replace("FunGetRound(", "funcImp.FunGetRound("), pt);
                mainFunBody.append("paras.put(\"CURFORMULA\",\"" + formulaName + "\");").append("\r\n");
                mainFunBody.append("paras.put(\"ISLASTFORMULA\",\"" + (size == i + 1) + "\");").append("\r\n");
                mainFunBody.append("formulaImp.formula" + i + "(paras);").append("\r\n");
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new SalaryException(SalaryException.FORMULAFROMATERROR, new Object[]{"[" + formulaName + "]"});
            }
        }
        return mainFunBody;
    }

    private static String recoedLocimalJudement(String express) {
        StringBuilder str = new StringBuilder();
        int index = 1;
        if (!express.contains("if")) {
            return express;
        }
        String[] arr = express.split("\\{");
        int length = arr.length;
        for (String s : arr) {
            if (index == length) {
                str.append(s);
            } else {
                str.append(s + "{paras.put(\"" + "LOGICMAN_INDEX" + "\",\"" + index + "\");");
            }
            ++index;
        }
        return str.toString();
    }
}

