/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.calculate.thread.log;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.util.json.JSONUtils;
import com.kingdee.shr.compensation.app.calculate.CmpCalStatisFactory;
import com.kingdee.shr.compensation.app.calculate.CmpCalStatisInfo;
import com.kingdee.shr.compensation.app.calculate.CmpCalTaskBaseInfo;
import com.kingdee.shr.compensation.calculate.helper.CalculateTool;
import com.kingdee.shr.compensation.calculate.thread.CalInitData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SalaryCalculatorLog
implements Runnable {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.calculate.thread.log.SalaryCalculatorLog");
    private CalInitData initData;
    private Map<String, Object> logDataMap = new HashMap<String, Object>();

    public SalaryCalculatorLog(CalInitData calInitData, Map<String, Object> logDataMap) {
        this.initData = calInitData;
        this.logDataMap.putAll(logDataMap);
    }

    @Override
    public void run() {
        try {
            this.saveResourceStatisticsEntry();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void saveResourceStatistics() throws BOSException {
        CmpCalStatisInfo logInfo = new CmpCalStatisInfo();
        CmpCalTaskBaseInfo baseInfo = new CmpCalTaskBaseInfo();
        baseInfo.setId(BOSUuid.read((String)this.initData.getTaskBaseId()));
        logInfo.setTaskBase(baseInfo);
        logInfo.setId(BOSUuid.read((String)this.logDataMap.get("CAL_RECORD_MAP_STATISTICS_KEY").toString()));
        logInfo.setFunMemory(CalculateTool.getResourceStatistics(this.logDataMap, "CAL_RECORD_MAP_MEMORY", "CAL_RECORD_MAP_MEMORY_FUNC"));
        logInfo.setSchemeMemory(CalculateTool.getResourceStatistics(this.logDataMap, "CAL_RECORD_MAP_MEMORY", "CAL_RECORD_MAP_MEMORY_INITDATA"));
        logInfo.setResultMemory(CalculateTool.getResourceStatistics(this.logDataMap, "CAL_RECORD_MAP_MEMORY", "CAL_RECORD_MAP_MEMORY_CALRESULT"));
        logInfo.setFunTime(CalculateTool.getResourceStatistics(this.logDataMap, "CAL_RECORD_MAP_TIME", "CAL_RECORD_MAP_TIME_FUNC"));
        logInfo.setSchemeTime(CalculateTool.getResourceStatistics(this.logDataMap, "CAL_RECORD_MAP_TIME", "CAL_RECORD_MAP_TIME_SCHEMEINIT"));
        logInfo.setFormulaTime(CalculateTool.getResourceStatistics(this.logDataMap, "CAL_RECORD_MAP_TIME", "CAL_RECORD_MAP_TIME_FORMULA"));
        logInfo.setResultTime(CalculateTool.getResourceStatistics(this.logDataMap, "CAL_RECORD_MAP_TIME_SAVERESULT", "CAL_RECORD_MAP_TIME_SAVERESULT_CAL"));
        logInfo.setOtherTime(CalculateTool.getResourceStatistics(this.logDataMap, "CAL_RECORD_MAP_TIME_SAVERESULT", "CAL_RECORD_MAP_TIME_SAVERESULT_OTHER"));
        try {
            CmpCalStatisFactory.getLocalInstance(this.initData.getCtx()).save(logInfo);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage());
        }
    }

    private void saveResourceStatisticsEntry() throws BOSException {
        String cmpCalStatisId = this.logDataMap.get("CAL_RECORD_MAP_STATISTICS_KEY").toString();
        String insertSql = "INSERT INTO T_HR_SCMPCALSTATISENTRY(FID, FCMPCALTABLEID, FCMPCALSTATISID, FDATA) VALUES(?, ?, ?, ?)";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        Map processMap = (Map)this.logDataMap.get("CAL_RECORD_MAP_PROCESS_DATA");
        if (null == processMap || processMap.size() < 1) {
            return;
        }
        for (Map.Entry entry : processMap.entrySet()) {
            Object[] param = new Object[]{BOSUuid.create((String)"6012C662").toString(), entry.getKey(), cmpCalStatisId, JSONUtils.convertObjectToJson((Context)this.initData.getCtx(), entry.getValue())};
            paramsList.add(param);
        }
        DbUtil.executeBatch((Context)this.initData.getCtx(), (String)insertSql, paramsList);
        this.logDataMap.remove("CAL_RECORD_MAP_PROCESS_DATA");
    }
}

