/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.cmpBudget.validatecal;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.FilterUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.shr.compensation.app.calculate.validate.CmpCalResultValidateParam;
import com.kingdee.shr.validaterule.CmpItemDataDot;
import com.kingdee.shr.validaterule.formula.base.data.ColumnAttributes;
import com.kingdee.shr.validaterule.formula.base.data.DataSet;
import com.kingdee.shr.validaterule.formula.base.data.DataTable;
import com.kingdee.shr.validaterule.formula.base.impl.CalculatorBusinessDataCommon;
import com.kingdee.shr.validaterule.formula.base.vo.InitCalData;
import com.kingdee.shr.validaterule.util.FunUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmpBudgetCalculatorBusinessDataCommon
extends CalculatorBusinessDataCommon {
    private static final Logger logger = LoggerFactory.getLogger(CmpBudgetCalculatorBusinessDataCommon.class);

    public Map<String, Object> getAllCnSnMap(Context ctx, String schemeID) throws BOSException {
        String language = ctx.getLocale().getLanguage();
        StringBuilder builder = new StringBuilder();
        builder.append(" SELECT  b.fid ITEMID, b.FieldSn FIELDSN,b.fname_" + language + " ITEMNAME ");
        builder.append(" ,b.FDATADOT,b.FDATATYPE,b.FIELDSN,b.FDATALENGTH,1 as INX ");
        builder.append(" FROM T_HR_SCalScheme calScheme ");
        builder.append(" inner join T_HR_SBudgetTemplateItem btItem on calScheme.FBudgetTemplateID = btItem.FTEMPLATEID  ");
        builder.append(" inner join T_HR_SCmpBudgetItem b on btItem.FBUDGETITEMID  = b.fid  ");
        builder.append(" where calScheme.fId = ? ");
        builder.append(" union ");
        builder.append(" SELECT  b.fid ITEMID, b.FieldSn FIELDSN,b.fname_" + language + " ITEMNAME ");
        builder.append(" ,b.FDATADOT,b.FDATATYPE,b.FIELDSN,b.FDATALENGTH,2 as INX ");
        builder.append(" FROM T_HR_SCalScheme calScheme ");
        builder.append(" inner join T_HR_SBudgetTemplateSTBItem a  on calScheme.FBudgetTemplateID = a.FTemplateID   ");
        builder.append(" inner join T_HR_SStandingBookItem b on a.FSTANDINGBOOKITEMID  = b.FID   ");
        builder.append(" where calScheme.fId = ? ");
        builder.append(" union ");
        builder.append(" SELECT  b.fid ITEMID, b.FieldSn FIELDSN,b.fname_" + language + " ITEMNAME ");
        builder.append(" ,b.FDATADOT,b.FDATATYPE,b.FIELDSN,b.FDATALENGTH,2 as INX ");
        builder.append(" FROM T_HR_SCalScheme calScheme ");
        builder.append(" inner join T_HR_SBudgetTemplateSTBItem a  on calScheme.FBudgetTemplateID = a.FTemplateID  ");
        builder.append(" inner join T_HR_SStandingBookItem b on a.FBALANCELEDGERITEMID =b.FID  ");
        builder.append(" where calScheme.fId = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)builder.toString(), (Object[])new Object[]{schemeID, schemeID, schemeID});
        ArrayList<String> sn = new ArrayList<String>();
        ArrayList<String> cn = new ArrayList<String>();
        HashMap<String, CmpItemDataDot> dataDotMap = new HashMap<String, CmpItemDataDot>();
        HashMap<String, Integer> dataTypeMap = new HashMap<String, Integer>();
        HashMap<String, String> idItemMap = new HashMap<String, String>();
        HashMap<String, Integer> strItemLenMap = new HashMap<String, Integer>();
        try {
            while (rs.next()) {
                CmpItemDataDot dataDot = CmpItemDataDot.getEnum((int)rs.getInt("FDATADOT"));
                Integer dataType = rs.getInt("FDATATYPE");
                String name = rs.getString("ITEMNAME");
                String fieldSn = rs.getString("FIELDSN");
                int inx = rs.getInt("INX");
                fieldSn = (inx == 1 ? "t" : "s") + fieldSn;
                sn.add(fieldSn);
                cn.add(name);
                dataDotMap.put(fieldSn, dataDot);
                dataTypeMap.put(fieldSn, dataType);
                if (dataType == 1) {
                    strItemLenMap.put(fieldSn, rs.getInt("FDATALENGTH"));
                }
                idItemMap.put(fieldSn.toUpperCase(Locale.ENGLISH), rs.getString("ITEMID"));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("sn", sn);
        res.put("cn", cn);
        res.put("dataDotMap", dataDotMap);
        res.put("dataTypeMap", dataTypeMap);
        res.put("fieldSnAndId", idItemMap);
        res.put("strLengthMap", strItemLenMap);
        return res;
    }

    public DataSet initCalData(InitCalData initCalData) throws EASBizException {
        ColumnAttributes[] allColumns;
        String mainTableName;
        Map assTable;
        String assTableV = (String)(assTable = initCalData.getAssTable()).get(mainTableName = initCalData.getMainTableName());
        assTable.put(mainTableName, null == assTableV ? mainTableName + ".T1" : assTableV + "," + mainTableName + ".T1");
        DataSet dataSet = super.initCalData(initCalData);
        DataTable table = dataSet.getTables(0);
        for (ColumnAttributes columnAttributes : allColumns = table.getAllColumns()) {
            String name = columnAttributes.getName();
            if (!"standingBook.fid".equalsIgnoreCase(name) && !"subCmpStandingBook.fid".equalsIgnoreCase(name)) continue;
            columnAttributes.setReturn(true);
        }
        return dataSet;
    }

    protected String buildDataSetSql(InitCalData initCalData) throws Exception {
        Map outerData = (Map)initCalData.getOuterData();
        CmpCalResultValidateParam param = (CmpCalResultValidateParam)outerData.get("param");
        String period = param.getPeriod();
        String filterSql = "manage.id in (" + initCalData.getCondition() + ")";
        if (!StringUtils.isEmpty((String)period)) {
            filterSql = filterSql + " and subBudgetQuery.period = '" + period + "'";
        }
        FilterInfo filter = new FilterInfo(filterSql);
        SqlParam sqlParam = new SqlParam();
        Map<String, String> selectMapping = this.buildSelector(initCalData);
        sqlParam.setSelectMapping(selectMapping);
        sqlParam.setFilterInfo(filter);
        sqlParam.setSortStr("manage.id");
        sqlParam.setScheme(initCalData.getConfigNum());
        sqlParam.setFilterDate(initCalData.getEndDate());
        sqlParam.setHistoryMode(false);
        sqlParam.setIgnoreNowDateFilter(true);
        String sql = FilterUtil.getSql((Context)initCalData.getCtx(), (SqlParam)sqlParam);
        return sql;
    }

    protected Map<String, String> buildSelector(InitCalData initCalData) throws BOSException {
        HashMap<String, String> selectMapping = new HashMap<String, String>();
        String mainTableAlias = initCalData.getMainTableAlias();
        selectMapping.put(mainTableAlias + ".id", "fid");
        selectMapping.put("standingBook.id", "standingBook.fid");
        selectMapping.put("subCmpStandingBook.id", "subCmpStandingBook.fid");
        selectMapping.put("subBudgetQuery.id", "subBudgetQuery.fid");
        Map assTable = initCalData.getAssTable();
        Set entrySet = assTable.entrySet();
        Iterator it = entrySet.iterator();
        String tableName = "";
        String field = "";
        String strucNum = "";
        String entityName = "";
        String tableField = "";
        String columns = "";
        String column = "";
        String[] tableArr = null;
        String[] columnArr = null;
        StructureConfigInfo structureInfo = null;
        Context ctx = initCalData.getCtx();
        Map structMap = FunUtils.getCmpStructureMapByNum((Context)ctx, (String)initCalData.getConfigNum());
        Map properties = null;
        Map.Entry next = null;
        String mainTableName = initCalData.getMainTableName();
        while (it.hasNext()) {
            int i;
            next = it.next();
            tableArr = ((String)next.getKey()).split("~");
            tableName = tableArr[0];
            if ((mainTableName.equals(tableName) || "T_HR_SCmpStandingBook".equals(tableName) || "T_HR_SubCmpStandingBook".equalsIgnoreCase(tableName)) && tableArr.length == 1) {
                columns = (String)assTable.get(tableName);
                if (null == columns) {
                    columns = (String)assTable.get(tableName + "~" + initCalData.getMainTableAlias());
                }
                columnArr = columns.split(",");
                String tableAlias = mainTableName.equals(tableName) ? mainTableAlias : ("T_HR_SCmpStandingBook".equals(tableName) ? "standingBook" : "subCmpStandingBook");
                for (i = 0; i < columnArr.length; ++i) {
                    column = tableAlias + "." + columnArr[i].split("\\.")[1];
                    selectMapping.put(column, column);
                }
                continue;
            }
            strucNum = tableArr[1];
            structureInfo = (StructureConfigInfo)structMap.get(strucNum);
            if (structureInfo == null) continue;
            entityName = structureInfo.getEntityName();
            properties = FunUtils.getProperties((Context)ctx, (String)entityName);
            field = (String)next.getValue();
            String[] singleField = field.split(",");
            for (i = 0; i < singleField.length; ++i) {
                field = singleField[i];
                tableField = field.split("\\.")[1];
                field = ((PropertyInfo)properties.get(tableField)).getName();
                if (selectMapping.containsKey(strucNum + "." + field)) continue;
                selectMapping.put(strucNum + "." + field, strucNum + "." + tableField);
            }
        }
        return selectMapping;
    }
}

