/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.dataplatform.budget.bashboard;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeCollection;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeFactory;
import com.kingdee.shr.compensation.app.budget.SubBalanceTypeEnum;
import java.sql.Date;
import java.sql.SQLException;

public abstract class BudgetTools {
    public static final String ORG_ALIAS = "adminOrgUnit";
    public static final String BUDGET_PREFIX = "T";
    public static final String BOOK_PREFIX = "S";

    public static String getCurrentPeriod(Context ctx, String templateId, String adminOrgUnitId, int year, Date currentDate) throws BOSException {
        String period = null;
        String sql = " select qu.FPeriod  from T_HR_SSubBudgetQuery qu  inner join T_HR_SBudgetManage man on qu.FBudgetManageID = man.fid  inner join T_HR_SCmpBudgetScheme sch on man.FBudgetSchemeID = sch.fid  where sch.FTemplateID = ? and man.FBudgetYear = ?  and qu.FEffectDate <= ? and qu.FExpiryDate >= ?";
        Object[] param = new Object[]{templateId, year, currentDate, currentDate};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
        try {
            if (rowSet.next()) {
                period = rowSet.getString(1);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return period;
    }

    public static int getCurrentYear(Context ctx, String templateId, Date currentDate) throws BOSException {
        int year = 0;
        String sql = " select scheme.FBudgetYear   from T_HR_SBudgetTemplate budget  inner join T_HR_SCmpBudgetScheme scheme on scheme.FTemplateID = budget.fid  where budget.fid = ? and scheme.FEffectDate <= ? and scheme.FExpiryDate >= ? ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{templateId, currentDate, currentDate});
        try {
            while (rowSet.next()) {
                year = rowSet.getInt(1);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return year;
    }

    public static SubBalanceTypeEnum getPeriodEnum(Context ctx, String templateId, int year) throws BOSException {
        String oql = "where template.id = '" + templateId + "' and budgetYear = " + year;
        CmpBudgetSchemeCollection coll = CmpBudgetSchemeFactory.getLocalInstance(ctx).getCmpBudgetSchemeCollection(oql);
        if (coll.size() < 1) {
            return SubBalanceTypeEnum.YEAR_TOTAL;
        }
        return coll.get(0).getSubBalanceTypeEnum();
    }
}

