/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.dataplatform.budgetstatistic.dataservice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.dataservice.BaseCmpBudgetAmountDataQueryService;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.dto.AdminOrgUnitYearBudgetAmountDTO;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.dto.BudgetItemBoard;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.dto.BudgetItemDTO;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CmpBudgetOrgDetailAmountDataQueryService
extends BaseCmpBudgetAmountDataQueryService {
    @Override
    protected boolean isChildOrg() {
        return false;
    }

    @Override
    protected List<Map<String, Object>> assembleRowData(Context ctx, Object detailDataObj) throws BOSException {
        LinkedList<Map<String, Object>> rows = new LinkedList<Map<String, Object>>();
        Map detailData = (Map)detailDataObj;
        AdminOrgUnitYearBudgetAmountDTO amountDTO = (AdminOrgUnitYearBudgetAmountDTO)detailData.get(this.getBudgetServiceParam().getAdminOrg().getLongNumber());
        Map<BudgetItemDTO, BudgetItemBoard> budgetItemBoardMap = amountDTO.getBudgetItemBoardMap();
        String goodState = EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label52", (Locale)ctx.getLocale());
        String warringState = EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label53", (Locale)ctx.getLocale());
        String overState = EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label54", (Locale)ctx.getLocale());
        budgetItemBoardMap.forEach((key, value) -> {
            HashMap<String, Object> row = new HashMap<String, Object>();
            row.put("budgetItemName", key.getName());
            value.valueOperation();
            BigDecimal allAmount = value.getAllAmount();
            BigDecimal realUsedAmount = value.getRealUsedAmount();
            BigDecimal diffAmount = allAmount.subtract(realUsedAmount);
            BigDecimal pValue = BigDecimal.ZERO;
            String state = "";
            if (allAmount.compareTo(BigDecimal.ZERO) > 0) {
                pValue = realUsedAmount.divide(allAmount, 4, 4).multiply(new BigDecimal(100));
                state = pValue.compareTo(new BigDecimal(80)) < 0 ? goodState : (pValue.compareTo(new BigDecimal(100)) <= 0 ? warringState : overState);
            }
            row.put("state", state);
            row.put("budgetAmount", allAmount);
            row.put("usedAmount", realUsedAmount);
            row.put("diffAmount", diffAmount);
            row.put("percent", pValue.setScale(2, 4) + "%");
            rows.add(row);
        });
        return rows;
    }
}

