/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.intelligent.execution;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.classloader.MsfClassLoaderFactory;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.bizmanage.PersonBURelationInfo;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelCatalogCollection;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelCatalogFactory;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelCatalogInfo;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelRuleInfo;
import com.kingdee.shr.compensation.app.intelligent.ICmpIntelCatalog;
import com.kingdee.shr.compensation.helper.CalSchemeBizHelper;
import com.kingdee.shr.compensation.intelligent.util.CmpIntelligentExecuteUtil;
import com.kingdee.shr.compensation.intelligent.util.CmpIntelligentUtil;
import com.kingdee.shr.compensation.intelligent.util.CmpProgressHelper;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.util.ReflectionUtils;

public class CmpIntelExecutor {
    protected static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.intelligent.execution.CmpIntelExecutor");
    private Context ctx;
    private CmpProgressHelper progressHelper = null;
    private boolean debug = false;

    public void execute(Map<String, Object> param) throws EASBizException {
        ArrayList ruleIds = (ArrayList)param.get("ruleIds");
        String ruleId = "";
        int size = ruleIds.size();
        for (int i = 0; i < size; ++i) {
            ruleId = (String)ruleIds.get(i);
            this.doExecute(ruleId);
        }
    }

    public void executeNew(Map<String, Object> param) throws EASBizException {
        ArrayDeque ruleIds = (ArrayDeque)param.get("ruleIds");
        String ruleId = "";
        while (ruleIds.size() > 0) {
            ruleId = (String)ruleIds.poll();
            this.doExecute(ruleId);
        }
    }

    private void doExecute(String ruleId) throws EASBizException {
        String currentCatalogName = "";
        String msg = "";
        this.beforeExecute(ruleId, null);
        int beforeNum = this.getExcuteRuleNum(this.ctx, ruleId);
        this.progressHelper.setRuleId(ruleId);
        this.progressHelper.setIndex(0);
        int index = 0;
        String jianzhi = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpIntelResource", (String)"label93", (Locale)LocaleUtils.locale_l2);
        String paramSql = " and ( affairActionReason.id  not IN (SELECT FID FROM T_HR_AffairActionReason WHERE (FLONGNUMBER LIKE '03%' OR  FLONGNUMBER LIKE '01%') and FName_l2 not like  '" + jianzhi + "%' )  OR affairActionReason.id IS NULL )";
        try {
            HashMap<String, Object> cacheMap = new HashMap<String, Object>();
            CmpIntelRuleInfo ruleInfo = CmpIntelligentUtil.getRuleInfoByRuleId(this.ctx, ruleId);
            String hrOrgId = ruleInfo.getHrOrgUnit().getId().toString();
            Timestamp effectDate = ruleInfo.getEffectDate();
            String effectDateKsqlStr = CmpDateUtil.toKSqlDate(effectDate);
            Map<String, CalSchemeInfo> calSchemeMap = CalSchemeBizHelper.getCalSchemeMap(this.ctx, null);
            Map<String, EmpPosOrgRelationInfo> empPosOrgReMap = CmpIntelligentUtil.getEmpPosOrgReMap(this.ctx);
            Map<String, PersonBURelationInfo> personConfirmWithBuMap = CmpIntelligentUtil.personConfirmWithBuMap(this.ctx, hrOrgId);
            Map<String, String> orgLongNumberMap = CmpIntelligentUtil.getOrgLongNumberMap(this.ctx);
            Map<String, List<String>> bizParamHrIDMap = CmpIntelligentUtil.getParamHrOrgUnitListByBizManage(this.ctx);
            cacheMap.put("hrOrgId", hrOrgId);
            cacheMap.put("debug", this.isDebug());
            cacheMap.put("calSchemeMap", calSchemeMap);
            cacheMap.put("empPosOrgReMap", empPosOrgReMap);
            cacheMap.put("personConfirmWithBuMap", personConfirmWithBuMap);
            cacheMap.put("orgLongNumberMap", orgLongNumberMap);
            cacheMap.put("effectDate", effectDateKsqlStr);
            cacheMap.put("bizParamHrIDMap", bizParamHrIDMap);
            cacheMap.put("paramSql", paramSql);
            ICmpIntelCatalog cmpIntelCatalog = CmpIntelCatalogFactory.getLocalInstance(this.ctx);
            String oql = "select id, name, implement, index order by index";
            CmpIntelCatalogCollection catalogColl = cmpIntelCatalog.getCmpIntelCatalogCollection(oql);
            int catalogSize = catalogColl.size();
            if (catalogSize > 0) {
                String className = "";
                String catalogId = "";
                Method executeMethod = null;
                Method setCtxMethod = null;
                Method setRuleMethod = null;
                CmpIntelCatalogInfo catalogInfo = null;
                Class clazz = null;
                Object executer = null;
                int size = catalogColl.size();
                for (int i = 0; i < size; ++i) {
                    catalogInfo = catalogColl.get(i);
                    catalogId = catalogInfo.getId().toString();
                    className = catalogInfo.getImplement();
                    currentCatalogName = catalogInfo.getName();
                    clazz = MsfClassLoaderFactory.forName((String)className);
                    executeMethod = ReflectionUtils.findMethod((Class)clazz, (String)"execute");
                    if (executeMethod == null) {
                        msg = "class: " + className + " not find " + "execute" + "method or parameter is wrong";
                        throw new EASBizException(new NumericExceptionSubItem("001", msg));
                    }
                    setCtxMethod = ReflectionUtils.findMethod((Class)clazz, (String)"setCtx", (Class[])new Class[]{Context.class});
                    if (setCtxMethod == null) {
                        msg = "class " + className + "not find" + "setCtx" + "method or parameter is wrong";
                        throw new EASBizException(new NumericExceptionSubItem("002", msg));
                    }
                    setRuleMethod = ReflectionUtils.findMethod((Class)clazz, (String)"setRuleId", (Class[])new Class[]{String.class});
                    if (setRuleMethod == null) {
                        msg = "class " + className + "not find" + "setRuleId" + "method or parameter is wrong";
                        throw new EASBizException(new NumericExceptionSubItem("003", msg));
                    }
                    Method setCacheMapMethod = ReflectionUtils.findMethod((Class)clazz, (String)"setCacheMap", (Class[])new Class[]{Map.class});
                    if (setCacheMapMethod == null) {
                        msg = "class " + className + "not find" + "setCacheMap" + "method or parameter is wrong";
                        throw new EASBizException(new NumericExceptionSubItem("004", msg));
                    }
                    Method setCatalogMethod = ReflectionUtils.findMethod((Class)clazz, (String)"setCatalogId", (Class[])new Class[]{String.class});
                    if (setCatalogMethod == null) {
                        msg = "class " + className + "not find" + "setCatalogId" + "method or parameter is wrong";
                        throw new EASBizException(new NumericExceptionSubItem("005", msg));
                    }
                    executer = clazz.newInstance();
                    ReflectionUtils.invokeMethod((Method)setCtxMethod, executer, (Object[])new Object[]{this.ctx});
                    ReflectionUtils.invokeMethod((Method)setRuleMethod, executer, (Object[])new Object[]{ruleId});
                    ReflectionUtils.invokeMethod((Method)setCatalogMethod, executer, (Object[])new Object[]{catalogId});
                    ReflectionUtils.invokeMethod((Method)setCacheMapMethod, executer, (Object[])new Object[]{cacheMap});
                    ReflectionUtils.invokeMethod((Method)executeMethod, executer);
                    if (++index >= catalogSize) continue;
                    this.progressHelper.setIndex(index);
                }
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            msg = currentCatalogName + "Exception occurred during execution. Please check the log for detailed error information for analysis";
            throw new EASBizException(new NumericExceptionSubItem("005", msg));
        }
        finally {
            this.updateExecuteState(ruleId, 0);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("index", index);
        params.put("beforeNum", beforeNum);
        this.afterExecute(ruleId, params);
    }

    protected void beforeExecute(String ruleId, Map<String, Object> params) {
        this.updateExecuteState(ruleId, 1);
    }

    protected void afterExecute(String ruleId, Map<String, Object> params) {
        String filter = "cmpIntelRule = '" + ruleId + "'";
        int beforeNum = (Integer)params.get("beforeNum");
        int index = (Integer)params.get("index");
        int afterNum = this.getExcuteRuleNum(this.ctx, ruleId);
        int count = afterNum - beforeNum;
        this.updateExecuteLog(ruleId, count);
        this.progressHelper.setIndex(index);
    }

    private void updateExecuteState(String ruleId, int state) {
        String updateSql = "update T_HR_SCmpIntelExecutionLog set FExecuteState=? where FCmpIntelRuleID=?";
        try {
            DbUtil.execute((Context)this.ctx, (String)updateSql, (Object[])new Object[]{state, ruleId});
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void updateExecuteLog(String ruleId, int count) {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        String updateSql = "update T_HR_SCmpIntelExecutionLog set FLatestNum=" + count + ", flastUpdateTime=now() where FCmpIntelRuleID='" + ruleId + "'";
        try {
            DbUtil.execute((Context)this.ctx, (String)updateSql);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private int getExcuteRuleNum(Context ctx, String ruleId) {
        int matchDateNum = CmpIntelligentExecuteUtil.getMatchDataCountNew(ctx, ruleId);
        int syncOrgPositionNum = CmpIntelligentExecuteUtil.getSyncOrgPositionDataCount(ctx, ruleId);
        int num = matchDateNum + syncOrgPositionNum;
        return num;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public CmpProgressHelper getProgressHelper() {
        return this.progressHelper;
    }

    public void setProgressHelper(CmpProgressHelper progressHelper) {
        this.progressHelper = progressHelper;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

