/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.intelligent.execution;

import com.google.common.collect.Lists;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.org.HRJobInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.CalSchemeCollection;
import com.kingdee.shr.compensation.CalSchemeFactory;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CmpCalTableCollection;
import com.kingdee.shr.compensation.CmpCalTableFactory;
import com.kingdee.shr.compensation.CmpCalTableInfo;
import com.kingdee.shr.compensation.CmpPeriodTypeEnum;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelBizType;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelCatalogInfo;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelRuleInfo;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelState;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelSynOrgPositionFactory;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelSynOrgPositionInfo;
import com.kingdee.shr.compensation.app.intelligent.HandleTypeEnum;
import com.kingdee.shr.compensation.helper.CmpConstants;
import com.kingdee.shr.compensation.intelligent.dto.PbuConfirmFilter;
import com.kingdee.shr.compensation.intelligent.dto.json.CmpSyncOrgPositionBean;
import com.kingdee.shr.compensation.intelligent.dto.json.CustomFilter;
import com.kingdee.shr.compensation.intelligent.dto.json.PersonRange;
import com.kingdee.shr.compensation.intelligent.dto.json.Scheme;
import com.kingdee.shr.compensation.intelligent.dto.json.SysOrgPosition;
import com.kingdee.shr.compensation.intelligent.execution.ICmpIntelligentExecution;
import com.kingdee.shr.compensation.intelligent.util.CmpIntelligentFilterUtil;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.SQLHandleUtil;
import com.kingdee.shr.compensation.util.SqlUtil;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.util.CollectionUtils;
import shaded.com.google.common.collect.Maps;

public class CmpSyncOrgPositionExecution
implements ICmpIntelligentExecution {
    protected String bizManageType = "CMP02";
    protected String bizManageTypeId = "fVa9WCKmTEWBgtswxQH45gB4WXA=";
    protected String detail = "";
    protected boolean hasDate = false;
    protected String ruleId;
    protected String catalogId;
    protected String entity;
    protected Context ctx;
    protected Map<String, Object> cacheMap;
    protected boolean debug = false;
    protected java.util.Date dateNow;
    protected static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.intelligent.CmpSyncOrgPositionExecution");
    private static final String TMP_TABLE_SCALSCHEME = "T_HR_SCalScheme";
    private static final String TMP_FID_FIELD_BASE_ON = "FID";
    private static final String TMP_TABLE_SCMPCALTABLE = "T_HR_SCmpCalTable";

    @Override
    public void execute() {
        try {
            CoreBaseCollection coll = this.buildMatchData();
            if (coll.size() == 0) {
                return;
            }
            IObjectPK[] obj = CmpIntelSynOrgPositionFactory.getLocalInstance(this.ctx).addnewBatchData(coll);
            this.updateWrongPosition(coll);
            this.afterExecute(coll);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            logger.error((Object)("CmpSyncOrgPositionExecution execute EASBizException:" + e.getMessage()));
        }
        catch (BOSException e) {
            e.printStackTrace();
            logger.error((Object)("CmpSyncOrgPositionExecution execute BOSException:" + e.getMessage()));
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("CmpSyncOrgPositionExecution execute Exception:" + e.getMessage()));
        }
    }

    protected void afterExecute(CoreBaseCollection coll) {
    }

    protected void updateWrongPosition(CoreBaseCollection coll) throws BOSException {
        HashSet<String> idList = new HashSet<String>();
        int updateState = 3;
        for (int i = 0; i < coll.size(); ++i) {
            CmpIntelSynOrgPositionInfo info = (CmpIntelSynOrgPositionInfo)coll.get(i);
            idList.add(info.getCmpCalTable().getId().toString());
        }
        CmpInSql cmpInSql = CmpInSqlFactory.getInstance();
        String schemeIds = cmpInSql.createInSql(this.ctx, idList, TMP_TABLE_SCMPCALTABLE, TMP_FID_FIELD_BASE_ON);
        String sql = " update T_HR_SCmpCalTable calTable set FEmpState = " + updateState + " where calTable.FEmpState = 2  and calTable.Fid in " + schemeIds + " and exists (select 1 from T_HR_SCmpEmpORelation cmpEmp where calTable.FCmpEmpORelationID = cmpEmp.FId)";
        DbUtil.execute((Context)this.ctx, (String)sql);
    }

    protected CoreBaseCollection buildMatchData() throws BOSException, EASBizException, SQLException {
        this.initNowDate();
        List<CmpSyncOrgPositionBean> entrys = CmpIntelligentFilterUtil.getCmpSyncOrgPositionBean(this.ctx, this.ruleId, this.catalogId);
        CoreBaseCollection matchDatas = new CoreBaseCollection();
        if (entrys.size() == 0) {
            return matchDatas;
        }
        CmpIntelRuleInfo ruleInfo = new CmpIntelRuleInfo();
        ruleInfo.setId(BOSUuid.read((String)this.ruleId));
        CmpIntelCatalogInfo catalogInfo = new CmpIntelCatalogInfo();
        catalogInfo.setId(BOSUuid.read((String)this.catalogId));
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            List<Scheme> schemeList;
            CmpSyncOrgPositionBean orgPositionEntry = entrys.get(i);
            if (orgPositionEntry == null || CollectionUtils.isEmpty(schemeList = orgPositionEntry.getScheme())) continue;
            String schemeIds = this.getSchemeIds(schemeList);
            SysOrgPosition sysOrgPosition = orgPositionEntry.getSysOrgPosition();
            String customCondition = this.getCustomCondition(orgPositionEntry, schemeIds);
            if (this.debug) {
                logger.error((Object)(" calUpdatePersonHasAction customCondition : " + customCondition));
            }
            Map<String, CalSchemeInfo> schemeInfoMap = this.getSchemeMap(schemeIds);
            for (int j = 0; j < schemeList.size(); ++j) {
                CoreBaseCollection currentMatchDatas;
                CalSchemeInfo info;
                Scheme scheme = schemeList.get(j);
                if (scheme == null || StringUtils.isEmpty((CharSequence)scheme.getId()) || (info = schemeInfoMap.get(scheme.getId())) == null) continue;
                if (this.debug) {
                    logger.error((Object)(" calUpdatePersonHasAction begin : " + info.getName()));
                }
                if ((currentMatchDatas = this.calUpdatePersonHasAction(sysOrgPosition, info, customCondition)) == null || currentMatchDatas.isEmpty()) continue;
                matchDatas.addCollection(currentMatchDatas);
                if (!this.debug) continue;
                logger.error((Object)(" calUpdatePersonHasAction over : " + info.getName() + currentMatchDatas.size()));
            }
        }
        return matchDatas;
    }

    private void initNowDate() {
        String dateStr = CmpDateUtil.getDateStr(new java.util.Date());
        try {
            this.dateNow = CmpDateUtil.parseDate(dateStr);
        }
        catch (ParseException e) {
            logger.error((Object)("initNowDate : " + e.getMessage()));
            e.printStackTrace();
        }
    }

    private String getSchemeIds(List<Scheme> schemeList) throws BOSException {
        ArrayList list = Lists.newArrayList();
        for (Scheme scheme : schemeList) {
            if (scheme == null || StringUtils.isEmpty((CharSequence)scheme.getId())) continue;
            list.add(scheme.getId());
        }
        CmpInSql cmpInSql = CmpInSqlFactory.getInstance();
        return cmpInSql.createInSql(this.ctx, list, TMP_TABLE_SCALSCHEME, TMP_FID_FIELD_BASE_ON);
    }

    protected String getCustomCondition(CmpSyncOrgPositionBean orgPositionEntry, String schemeIds) {
        PersonRange personRange = orgPositionEntry.getPersonRange();
        CustomFilter customFilter = null;
        if (null != personRange) {
            customFilter = personRange.getCustomFilter();
        }
        List<PbuConfirmFilter> conditions = null;
        String conditionText = "";
        if (customFilter != null) {
            conditionText = customFilter.getConditionText();
            conditions = customFilter.getConditions();
        }
        if (!StringUtils.isEmpty((CharSequence)conditionText) && !CollectionUtils.isEmpty(conditions)) {
            String filter = " \"SYNC_CTB\".FCalSchemeID in " + schemeIds;
            return CmpIntelligentFilterUtil.getSyncOrgPositionOtherFilter(this.ctx, customFilter, filter);
        }
        return "";
    }

    protected Map<String, CalSchemeInfo> getSchemeMap(String schemeIds) throws BOSException {
        HashMap map = Maps.newHashMap();
        if (StringUtils.isEmpty((CharSequence)schemeIds)) {
            return map;
        }
        String oql = String.format(" where id in %s ", schemeIds);
        CalSchemeCollection collection = CalSchemeFactory.getLocalInstance(this.ctx).getCalSchemeCollection(oql);
        if (collection == null || collection.isEmpty()) {
            return map;
        }
        for (int i = 0; i < collection.size(); ++i) {
            CalSchemeInfo info = collection.get(i);
            if (info == null || info.getId() == null) continue;
            map.put(info.getId().toString(), info);
        }
        return map;
    }

    public CoreBaseCollection calUpdatePersonHasAction(SysOrgPosition sysOrgPosition, CalSchemeInfo calSchemeInfo, String customCondition) throws BOSException, SQLException, EASBizException {
        String orgRangeSql = "";
        boolean isSyncOutOfPerm = sysOrgPosition.getIsSys();
        String syncPosiAndOrgPeriod = sysOrgPosition.getSyncPosiAndOrgPeriod();
        String syncEmpTypePeriod = sysOrgPosition.getSyncEmpTypePeriod();
        String syncPosiAndOrgDayString = sysOrgPosition.getSyncPosiAndOrgDay();
        int syncPosiAndOrgDay = Integer.parseInt(syncPosiAndOrgDayString);
        String syncEmpTypeDayString = sysOrgPosition.getSyncEmpTypeDay();
        int syncEmpTypeDay = Integer.parseInt(syncEmpTypeDayString);
        CmpPeriodTypeEnum periodType = calSchemeInfo.getCmpPeriodType();
        java.util.Date empTypeActualDate = this.getTypeActualDateByPeriodType(syncEmpTypePeriod, syncEmpTypeDay, calSchemeInfo, periodType);
        java.util.Date orgPosiActualDate = this.getPosiActualDateByPeriodType(syncPosiAndOrgPeriod, syncPosiAndOrgDay, calSchemeInfo, periodType);
        String msg = this.getOrgPositionAndEmpTypeMsg(syncPosiAndOrgPeriod, orgPosiActualDate, syncEmpTypePeriod, empTypeActualDate);
        String filterSql = this.getFilterSql(calSchemeInfo, customCondition);
        if (this.debug) {
            logger.error((Object)("calUpdatePersonHasAction filterSql:" + filterSql));
            logger.error((Object)("calUpdatePersonHasAction msg:" + msg));
        }
        String needUpdateRealEndDateSql = this.getNeedUpdateRealEndDateTempSql(calSchemeInfo);
        if (this.debug) {
            logger.error((Object)("calUpdatePersonHasAction needUpdateRealEndDateSql:" + needUpdateRealEndDateSql));
        }
        if (!isSyncOutOfPerm) {
            orgRangeSql = this.getOrgRange(calSchemeInfo.getAdminOrgUnit().getId().toString());
            if (this.debug) {
                logger.error((Object)("calUpdatePersonHasAction orgRangeSql:" + orgRangeSql));
            }
        }
        HashSet<String> fidList = new HashSet<String>();
        Map<String, CmpIntelSynOrgPositionInfo> synOrgPosMap = this.initSynOrgPosMap(filterSql, fidList, msg);
        this.syncCmpEmpOrelation(filterSql, orgPosiActualDate, orgRangeSql);
        this.syncCalRealEndDate(needUpdateRealEndDateSql, orgRangeSql, synOrgPosMap, fidList);
        this.syncOrgPosi(filterSql, isSyncOutOfPerm, orgRangeSql, synOrgPosMap, fidList, orgPosiActualDate);
        this.syncEmpType(filterSql, empTypeActualDate, isSyncOutOfPerm, orgRangeSql, synOrgPosMap, fidList);
        CoreBaseCollection collection = this.getCmpIntelSynOrgPosition(synOrgPosMap, fidList);
        if (this.debug) {
            logger.error((Object)("calUpdatePersonHasAction fidList.Size_coll.size_initMap.size:" + fidList.size() + "___" + collection.size() + "___" + synOrgPosMap.size()));
        }
        return collection;
    }

    private String getOrgPositionAndEmpTypeMsg(String syncPosiAndOrgPeriod, java.util.Date orgPosiActualDate, String syncEmpTypePeriod, java.util.Date empTypeActualDate) {
        String msg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpIntelResource", (String)"label97", (Locale)this.ctx.getLocale());
        String lastPeriod = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpIntelResource", (String)"label95", (Locale)this.ctx.getLocale());
        String currentPeriod = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpIntelResource", (String)"label96", (Locale)this.ctx.getLocale());
        String posiAndOrgPeriod = "";
        String empTypePeriod = "";
        Calendar posiCalendar = Calendar.getInstance();
        Calendar empTypeCalendar = Calendar.getInstance();
        posiCalendar.setTime(orgPosiActualDate);
        empTypeCalendar.setTime(empTypeActualDate);
        posiAndOrgPeriod = CmpConstants.SYNC_LAST_PERIOD.equals(syncPosiAndOrgPeriod) ? lastPeriod : currentPeriod;
        empTypePeriod = CmpConstants.SYNC_LAST_PERIOD.equals(syncEmpTypePeriod) ? lastPeriod : currentPeriod;
        int syncPosiAndOrgDay = posiCalendar.get(5);
        int syncEmpTypeDay = empTypeCalendar.get(5);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String posiAndOrgStr = df.format(orgPosiActualDate);
        String empTypeStr = df.format(empTypeActualDate);
        return String.format(msg, posiAndOrgPeriod, syncPosiAndOrgDay, posiAndOrgStr, empTypePeriod, syncEmpTypeDay, empTypeStr);
    }

    private String getOrgRange(String adminOrgUnitId) throws BOSException, SQLException {
        String tempTableName = "";
        if (StringUtils.isEmpty((CharSequence)adminOrgUnitId)) {
            return tempTableName;
        }
        String sqlLongNumber = "select flongNumber from T_ORG_ADMIN where fid = '" + adminOrgUnitId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sqlLongNumber);
        String longNumber = "";
        while (rs.next()) {
            longNumber = rs.getString("flongNumber");
        }
        if (StringUtils.isEmpty((CharSequence)longNumber)) {
            return tempTableName;
        }
        String sql = "select distinct FID from T_ORG_ADMIN where FlongNumber like '" + longNumber + "%'";
        tempTableName = SQLHandleUtil.createTempTableName(this.ctx);
        String createTableSQL = "SELECT t.FID  into " + tempTableName + " from (" + sql + ") t";
        CmpSQLUtil.execute(this.ctx, createTableSQL);
        return tempTableName;
    }

    private CoreBaseCollection getCmpIntelSynOrgPosition(Map<String, CmpIntelSynOrgPositionInfo> synOrgPosMap, Set<String> fidList) throws EASBizException, BOSException {
        CoreBaseCollection collection = new CoreBaseCollection();
        for (Map.Entry<String, CmpIntelSynOrgPositionInfo> map : synOrgPosMap.entrySet()) {
            CmpIntelSynOrgPositionInfo info;
            if (!fidList.contains(map.getKey()) || !this.checkNeedShow(info = map.getValue())) continue;
            collection.add((CoreBaseInfo)info);
        }
        return collection;
    }

    protected boolean checkNeedShow(CmpIntelSynOrgPositionInfo info) {
        boolean empOrgRelationFlag = this.checkEmpOrgRelation(info);
        boolean employeeTypeFlag = this.checkEmployeeType(info);
        boolean realEndDateFlag = this.checkRealEndDate(info);
        boolean adminOrgFlag = this.checkAdminOrg(info);
        boolean positionFlag = this.checkPosition(info);
        boolean hRJobFlag = this.checkHRJob(info);
        return empOrgRelationFlag || employeeTypeFlag || realEndDateFlag || adminOrgFlag || positionFlag || hRJobFlag;
    }

    protected Map<String, CmpIntelSynOrgPositionInfo> initSynOrgPosMap(String filterSql, Set<String> fidList, String msg) throws BOSException {
        HashMap<String, CmpIntelSynOrgPositionInfo> map = new HashMap<String, CmpIntelSynOrgPositionInfo>();
        String tempTableName = SQLHandleUtil.createTempTableName(this.ctx);
        String createTableSQL = "SELECT t.FID  into " + tempTableName + " FROM (" + filterSql + ") t";
        CmpSQLUtil.execute(this.ctx, createTableSQL);
        String oql = "select id, empPosOrgRelation,employeeType, realEndDate,person,hrOrgUnit,CU, adminOrgUnit, position,job   where id in ( select fid from " + tempTableName + ")";
        CmpCalTableCollection collection = CmpCalTableFactory.getLocalInstance(this.ctx).getCmpCalTableCollection(oql);
        long now = System.currentTimeMillis();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)this.ctx);
        for (int i = 0; i < collection.size(); ++i) {
            CmpCalTableInfo calInfo = collection.get(i);
            fidList.add(calInfo.getId().toString());
            CmpIntelSynOrgPositionInfo info = new CmpIntelSynOrgPositionInfo();
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            info.setCmpCalTable(calInfo);
            info.setOldEmpOrgRelation(calInfo.getEmpPosOrgRelation());
            info.setOldEmployeeType(calInfo.getEmployeeType());
            info.setOldRealEndDate(calInfo.getRealEndDate());
            info.setNewEmpOrgRelation(calInfo.getEmpPosOrgRelation());
            info.setNewEmployeeType(calInfo.getEmployeeType());
            info.setNewRealEndDate(calInfo.getRealEndDate());
            info.setPbuConfirm(null);
            info.setPbuRelation(null);
            CmpIntelCatalogInfo logInfo = new CmpIntelCatalogInfo();
            logInfo.setId(BOSUuid.read((String)this.catalogId));
            info.setCmpIntelCatalog(logInfo);
            info.setCmpIntelFilterData(null);
            info.setState(CmpIntelState.CONFIRMED);
            java.util.Date date = new java.util.Date();
            info.setEffdt(date);
            info.setHandleDate(this.dateNow);
            info.setMsg(msg, com.kingdee.util.LocaleUtils.locale_l1);
            info.setMsg(msg, com.kingdee.util.LocaleUtils.locale_l2);
            info.setMsg(msg, com.kingdee.util.LocaleUtils.locale_l3);
            info.setParse(null);
            info.setHandleType(HandleTypeEnum.AUTO);
            CmpIntelRuleInfo ruleInfo = new CmpIntelRuleInfo();
            ruleInfo.setId(BOSUuid.read((String)this.ruleId));
            info.setCmpIntelRule(ruleInfo);
            info.setIsHandled(true);
            info.setConfirmSeq(0);
            info.setCustomParam(null);
            info.setPerson(calInfo.getPerson());
            info.setChangeDate(date);
            info.setHrOrgUnit(calInfo.getHrOrgUnit());
            info.setBizType(CmpIntelBizType.CMP);
            info.setCreator(userInfo);
            info.setCreateTime(new Timestamp(now));
            info.setLastUpdateUser(userInfo);
            info.setLastUpdateTime(new Timestamp(now));
            info.setCU(calInfo.getCU());
            info.setNewAdminOrg(calInfo.getAdminOrgUnit());
            info.setOldAdminOrg(calInfo.getAdminOrgUnit());
            info.setNewPosition(calInfo.getPosition());
            info.setOldPosition(calInfo.getPosition());
            info.setNewHRJob(calInfo.getJob());
            info.setOldHRJob(calInfo.getJob());
            map.put(calInfo.getId().toString(), info);
        }
        return map;
    }

    private String getFilterSql(CalSchemeInfo calSchemeInfo, String customCondition) throws BOSException {
        String filterSql = this.getNeedUpdateRealEndDateSql(calSchemeInfo);
        if (StringUtils.isNotEmpty((CharSequence)customCondition)) {
            filterSql = filterSql + " and calTable.fid not in (" + customCondition + ")";
        }
        return this.insertTempTable(filterSql);
    }

    private String getNeedUpdateRealEndDateTempSql(CalSchemeInfo calSchemeInfo) throws BOSException {
        String filterSql = this.getNeedUpdateRealEndDateSql(calSchemeInfo);
        return this.insertTempTable(filterSql);
    }

    private String getNeedUpdateRealEndDateSql(CalSchemeInfo calSchemeInfo) throws BOSException {
        String cmpSchemeId = calSchemeInfo.getId().toString();
        int year = calSchemeInfo.getPeriodYear();
        int month = calSchemeInfo.getPeriodMonth();
        int calTime = calSchemeInfo.getCalTime();
        String filterSql = "select calTable.Fid from t_hr_scmpcaltable calTable  inner join T_HR_ScmpEmpORelation relation on calTable.FCmpEmpORelationID = relation.Fid  inner join t_hr_spersoncmp personCmp on relation.FPersonCmpID = personCmp.Fid and calTable.FHrOrgUnitID = personCmp.FHROrgUnitID  where calTable.FCALSCHEMEID = '" + cmpSchemeId + "' and calTable.FCALSTATE in (1 , 4)  and calTable.FPeriodYear = " + year + " and calTable.FPeriodMonth = " + month + " and calTable.FCalTime = " + calTime;
        return filterSql;
    }

    private String insertTempTable(String filterSql) throws BOSException {
        String tempTableName = SQLHandleUtil.createTempTableName(this.ctx);
        String createTableSQL = "SELECT t.FID  into " + tempTableName + " FROM (" + filterSql + ") t";
        CmpSQLUtil.execute(this.ctx, createTableSQL);
        String sql = " select * from " + tempTableName;
        return sql;
    }

    private java.util.Date getPosiActualDateByPeriodType(String syncPosiAndOrgPeriod, int syncPosiAndOrgDay, CalSchemeInfo calSchemeInfo, CmpPeriodTypeEnum periodType) {
        CalSchemeInfo posiAndOrgScheme = (CalSchemeInfo)calSchemeInfo.clone();
        Calendar posiAndOrgCal = Calendar.getInstance();
        posiAndOrgCal.setTime(posiAndOrgScheme.getEndDate());
        boolean syncPosiAndOrgDayFlg = false;
        int lastDay = posiAndOrgCal.get(5);
        if (periodType != CmpPeriodTypeEnum.halfmonth) {
            if (lastDay < syncPosiAndOrgDay) {
                syncPosiAndOrgDay = lastDay;
                syncPosiAndOrgDayFlg = true;
            }
            posiAndOrgCal.set(5, syncPosiAndOrgDay);
        }
        if (CmpConstants.SYNC_LAST_PERIOD.equals(syncPosiAndOrgPeriod)) {
            if (periodType == CmpPeriodTypeEnum.month) {
                posiAndOrgCal.add(2, -1);
            } else if (periodType == CmpPeriodTypeEnum.quarter) {
                posiAndOrgCal.add(2, -3);
            } else if (periodType == CmpPeriodTypeEnum.half) {
                posiAndOrgCal.add(2, -6);
            } else if (periodType == CmpPeriodTypeEnum.yeay) {
                posiAndOrgCal.add(1, -1);
            } else if (periodType == CmpPeriodTypeEnum.halfmonth) {
                Calendar tmpCal = Calendar.getInstance();
                tmpCal.setTime(posiAndOrgScheme.getBeginDate());
                tmpCal.add(5, -1);
                java.util.Date lastEndate = tmpCal.getTime();
                tmpCal.setTime(posiAndOrgScheme.getEndDate());
                posiAndOrgScheme.setEndDate(lastEndate);
                tmpCal.add(2, -1);
                tmpCal.add(5, 1);
                posiAndOrgScheme.setBeginDate(tmpCal.getTime());
                posiAndOrgCal.setTime(posiAndOrgScheme.getEndDate());
            }
            if (syncPosiAndOrgDayFlg && periodType != CmpPeriodTypeEnum.halfmonth) {
                this.setCalendarLastDay(posiAndOrgCal);
            }
        }
        if (periodType == CmpPeriodTypeEnum.halfmonth) {
            if (syncPosiAndOrgDay == 32) {
                posiAndOrgCal.setTime(posiAndOrgScheme.getEndDate());
            } else if (posiAndOrgScheme.getEndDate().getDate() > posiAndOrgScheme.getBeginDate().getDate()) {
                posiAndOrgCal.set(5, syncPosiAndOrgDay);
                if (!posiAndOrgCal.getTime().after(posiAndOrgScheme.getEndDate()) && posiAndOrgCal.getTime().before(posiAndOrgScheme.getBeginDate())) {
                    // empty if block
                }
            } else if (syncPosiAndOrgDay <= posiAndOrgScheme.getEndDate().getDate() || syncPosiAndOrgDay >= posiAndOrgScheme.getBeginDate().getDate()) {
                if (syncPosiAndOrgDay < posiAndOrgScheme.getEndDate().getDate()) {
                    posiAndOrgCal.set(5, syncPosiAndOrgDay);
                } else if (syncPosiAndOrgDay >= posiAndOrgScheme.getBeginDate().getDate()) {
                    posiAndOrgCal.setTime(posiAndOrgScheme.getBeginDate());
                    int maxNum = posiAndOrgCal.getActualMaximum(5);
                    if (syncPosiAndOrgDay > maxNum) {
                        syncPosiAndOrgDay = maxNum;
                    }
                    posiAndOrgCal.set(5, syncPosiAndOrgDay);
                }
            }
        }
        java.util.Date orgPosiActualDate = posiAndOrgCal.getTime();
        return orgPosiActualDate;
    }

    private java.util.Date getTypeActualDateByPeriodType(String syncEmpTypePeriod, int syncEmpTypeDay, CalSchemeInfo calSchemeInfo, CmpPeriodTypeEnum periodType) {
        CalSchemeInfo empTypeScheme = (CalSchemeInfo)calSchemeInfo.clone();
        Calendar empTypeCal = Calendar.getInstance();
        empTypeCal.setTime(empTypeScheme.getEndDate());
        boolean syncEmpTypeDayFlg = false;
        int lastDay = empTypeCal.get(5);
        if (periodType != CmpPeriodTypeEnum.halfmonth) {
            if (lastDay < syncEmpTypeDay) {
                syncEmpTypeDay = lastDay;
                syncEmpTypeDayFlg = true;
            }
            empTypeCal.set(5, syncEmpTypeDay);
        }
        if (CmpConstants.SYNC_LAST_PERIOD.equals(syncEmpTypePeriod)) {
            if (periodType == CmpPeriodTypeEnum.month) {
                empTypeCal.add(2, -1);
            } else if (periodType == CmpPeriodTypeEnum.quarter) {
                empTypeCal.add(2, -3);
            } else if (periodType == CmpPeriodTypeEnum.half) {
                empTypeCal.add(2, -6);
            } else if (periodType == CmpPeriodTypeEnum.yeay) {
                empTypeCal.add(1, -1);
            } else if (periodType == CmpPeriodTypeEnum.halfmonth) {
                Calendar tmpCal = Calendar.getInstance();
                tmpCal.setTime(empTypeScheme.getBeginDate());
                tmpCal.add(5, -1);
                java.util.Date lastEndate = tmpCal.getTime();
                tmpCal.setTime(empTypeScheme.getEndDate());
                empTypeScheme.setEndDate(lastEndate);
                tmpCal.add(2, -1);
                tmpCal.add(5, 1);
                empTypeScheme.setBeginDate(tmpCal.getTime());
                empTypeCal.setTime(empTypeScheme.getEndDate());
            }
            if (syncEmpTypeDayFlg && periodType != CmpPeriodTypeEnum.halfmonth) {
                this.setCalendarLastDay(empTypeCal);
            }
        }
        if (periodType == CmpPeriodTypeEnum.halfmonth) {
            if (syncEmpTypeDay == 32) {
                empTypeCal.setTime(empTypeScheme.getEndDate());
            } else if (empTypeScheme.getEndDate().getDate() > empTypeScheme.getBeginDate().getDate()) {
                empTypeCal.set(5, syncEmpTypeDay);
                if (!empTypeCal.getTime().after(empTypeScheme.getEndDate()) && empTypeCal.getTime().before(empTypeScheme.getBeginDate())) {
                    // empty if block
                }
            } else if (syncEmpTypeDay <= empTypeScheme.getEndDate().getDate() || syncEmpTypeDay >= empTypeScheme.getBeginDate().getDate()) {
                if (syncEmpTypeDay < empTypeScheme.getEndDate().getDate()) {
                    empTypeCal.set(5, syncEmpTypeDay);
                } else if (syncEmpTypeDay >= empTypeScheme.getBeginDate().getDate()) {
                    empTypeCal.setTime(empTypeScheme.getBeginDate());
                    int maxNum = empTypeCal.getActualMaximum(5);
                    if (syncEmpTypeDay > maxNum) {
                        syncEmpTypeDay = maxNum;
                    }
                    empTypeCal.set(5, syncEmpTypeDay);
                }
            }
        }
        java.util.Date empTypeActualDate = empTypeCal.getTime();
        return empTypeActualDate;
    }

    private void syncCmpEmpOrelation(String filterSql, java.util.Date date, String orgRangeSql) throws BOSException, SQLException {
        String cmpEmpSql = this.getSelectCmpEmpSql(filterSql, date, orgRangeSql);
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)cmpEmpSql.toString());
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        Object[] param = new Object[2];
        String calId = "";
        String cmpEmpId = "";
        String useDefault = "";
        String cmpEmpoRelationId = "";
        HashSet<String> calIds = new HashSet<String>();
        HashSet<String> sameValueList = new HashSet<String>();
        while (rs.next()) {
            cmpEmpId = rs.getString("cmpEmpId");
            calId = rs.getString("calId");
            useDefault = rs.getString("FUseDefault");
            cmpEmpoRelationId = rs.getString("fcmpemporelationid");
            if (calIds.contains(calId) || sameValueList.contains(calId)) continue;
            if (StringUtils.isEmpty((CharSequence)cmpEmpoRelationId) && StringUtils.isEmpty((CharSequence)cmpEmpId) || !StringUtils.isEmpty((CharSequence)cmpEmpoRelationId) && cmpEmpoRelationId.equals(cmpEmpId)) {
                sameValueList.add(calId);
                continue;
            }
            calIds.add(calId);
            param = new Object[]{cmpEmpId, useDefault, calId};
            paramsList.add(param);
        }
        String updateSql = "update t_hr_scmpcaltable set fcmpemporelationid=?, FUseDefault=? where fid=?";
        if (!CollectionUtils.isEmpty(paramsList)) {
            DbUtil.executeBatch((Context)this.ctx, (String)updateSql.toString(), paramsList);
        }
    }

    private String getSelectCmpEmpSql(String filterSql, java.util.Date date, String orgRangeSql) {
        java.util.Date beginDate = CmpDateUtil.getAddDate(date, 1);
        StringBuilder cmpEmpSql = new StringBuilder();
        cmpEmpSql.append(" select calTable.fid calId,  cmpEmp.fid cmpEmpId,cmpEmp.FUseDefault,calTable.Fcmpemporelationid fcmpemporelationid ").append("\r\n");
        cmpEmpSql.append(" from t_hr_scmpcaltable calTable ").append("\r\n");
        cmpEmpSql.append(" left join t_hr_spersoncmp personCmp on calTable.fpersonid=personCmp.fpersonid ").append("\r\n");
        cmpEmpSql.append(" and calTable.FHRORGUNITID=personCmp.fhrorgunitid ").append("\r\n");
        cmpEmpSql.append(" left join T_HR_SCmpEmpORelation cmpEmp on personCmp.fid=cmpEmp.FPersonCmpId ").append("\r\n");
        cmpEmpSql.append(" left join T_HR_EmpOrgRelation empPos on empPos.fid=cmpEmp.femporgrelationid ").append("\r\n");
        cmpEmpSql.append(" where calTable.FCALUPDATETYPE = 1 AND calTable.fid in (").append(filterSql).append(") \r\n");
        cmpEmpSql.append(" and empPos.FAssignType=1 and cmpEmp.FEFFECTDATE <").append(CmpDateUtil.toKSqlDate(beginDate));
        if (CmpStrUtil.isNotEmpty(orgRangeSql)) {
            cmpEmpSql.append(" and ( exists (select 1 from ").append(orgRangeSql).append(" temp where empPos.FAdminOrgID = temp.Fid").append(") or cmpEmp.FUseDefault = 0)");
        }
        cmpEmpSql.append(" order by empPos.FStartDateTime desc ");
        return cmpEmpSql.toString();
    }

    private void syncCalRealEndDate(String needUpdateRealEndDateSql, String orgRangeSql, Map<String, CmpIntelSynOrgPositionInfo> synOrgPosMap, Set<String> fidList) throws BOSException, SQLException {
        StringBuilder selectSql = new StringBuilder();
        selectSql.append(" SELECT tt.fid, tt.cmpEmpDate,tt.fRealEndDate FROM ( SELECT calTable.FID, calTable.FRealEndDate fRealEndDate,case when relation.FLEFFECTDATE>calTable.fenddate then calTable.fenddate else relation.FLEFFECTDATE end cmpEmpDate FROM t_hr_scmpcaltable calTable");
        selectSql.append(" left join T_HR_SCmpEmpORelation relation on calTable.FCMPEMPORELATIONID = relation.FId ");
        selectSql.append(" where  calTable.fid in(").append(needUpdateRealEndDateSql).append(") and exists (select 1 from T_HR_SCmpEmpORelation where fid = caltable.FCMPEMPORELATIONID) ");
        if (CmpStrUtil.isNotEmpty(orgRangeSql)) {
            selectSql.append(" and ").append(" exists (select 1 from " + orgRangeSql + " temp where calTable.FAdminOrgUnitID = temp.Fid)");
        }
        selectSql.append(" ) tt where tt.fRealEndDate != tt.cmpEmpDate").append("\r\n");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)selectSql.toString());
        boolean existFlag = false;
        while (rs.next()) {
            String fid;
            if (!existFlag) {
                existFlag = true;
            }
            if (!synOrgPosMap.containsKey(fid = rs.getString("fid"))) continue;
            Date realEndDate = rs.getDate("cmpEmpDate");
            CmpIntelSynOrgPositionInfo info = synOrgPosMap.get(fid);
            info.setNewRealEndDate(realEndDate);
            synOrgPosMap.put(fid, info);
            fidList.add(fid);
        }
        if (existFlag) {
            StringBuilder sb = new StringBuilder();
            sb.append("   update t_hr_scmpcaltable calTable set FRealEndDate = ").append("\r\n");
            sb.append(" ( ").append("\r\n");
            sb.append(" select case when FLEFFECTDATE>calTable.fenddate then calTable.fenddate else FLEFFECTDATE end cmpEmpDate ").append("\r\n");
            sb.append(" from T_HR_SCmpEmpORelation ").append("\r\n");
            sb.append("  where fid=caltable.FCMPEMPORELATIONID").append("\r\n");
            sb.append("  ) where calTable.fid in(").append(needUpdateRealEndDateSql).append(") and exists (select 1 from T_HR_SCmpEmpORelation where fid = caltable.FCMPEMPORELATIONID)").append("\r\n");
            DbUtil.execute((Context)this.ctx, (String)sb.toString());
        }
    }

    private String getUpdateOrgPosSql(String filterSql, boolean isSyncOutOfPerm, String orgRangeSql, java.util.Date date) {
        StringBuffer str = new StringBuffer();
        java.util.Date beginDate = CmpDateUtil.getAddDate(date, 1);
        str.append(" select TT.FPERSONID personId, TT.FHRORGUNITID hrOrgUnit ,TT.FPERIODYEAR periodYear ,TT.FPERIODMONTH periodMonth ,TT.FCALTIME calTime ,TT.FCMPCALORGID oldCmpCalOrgId,TT.FJOBID oldJobId,TT.FPOSITIONID oldPositionId, TT.FEMPLOYEETYPEID oldTypeId, TT.FREALENDDATE realEndDate,TT.FEMPPOSORGRELATIONID oldEmpOrgRelationId, org.fid ADMINORGUNITID,treeHis.flongnumber longNumber,positionHis.FHISTORYRELATEID POSITIONID, ").append("\r\n");
        str.append("   hrJob.fid POSITIONJOBID, emp.fid EMPORGRELATIONID, TT.fid CALID ").append("\r\n");
        str.append("   from T_HR_SCMPCALTABLE TT  ").append("\r\n");
        str.append("   left join T_HR_SCmpEmpORelation cmpEmp on TT.FCMPEMPORELATIONID=cmpEmp.fid ").append("\r\n");
        str.append("   left join T_HR_EMPORGRELATION emp on cmpEmp.FEmpOrgRelationID = emp.FID ").append("\r\n");
        str.append("   left JOIN T_ORG_ADMIN org ON emp.FADMINORGID = org.FID ").append("\r\n");
        str.append("   left JOIN T_ORG_ADMINORGTREEHIS treeHis ON org.FID = treeHis.FADMINORGID ").append("\r\n");
        str.append("    AND treeHis.FEFFDT<= emp.fleffdt AND treeHis.FLEFFDT>= emp.fleffdt ").append("\r\n");
        str.append("   left JOIN T_ORG_POSITIONHIS positionHis ON positionHis.FHISTORYRELATEID=emp.FPOSITIONID ").append("\r\n");
        str.append("    AND positionHis.FEFFDT<= emp.fleffdt AND positionHis.FLEFFDT>= emp.fleffdt ").append("\r\n");
        str.append("   LEFT JOIN T_ORG_JOB orgJob ON orgJob.FID = positionHis.FJOBID  ").append("\r\n");
        str.append("   LEFT JOIN T_HR_HRJOB hrJob ON orgJob.FID = hrJob.FJOBID  ").append("\r\n");
        str.append("  WHERE TT.FID IN (").append(filterSql).append(") AND TT.FCALUPDATETYPE = 1  ").append("\r\n");
        str.append("  and cmpEmp.FEFFECTDATE <").append(CmpDateUtil.toKSqlDate(beginDate)).append("\r\n");
        if (!isSyncOutOfPerm) {
            str.append(" and ( exists (select 1 from ").append(orgRangeSql).append(" temp where org.fid = temp.Fid ) or cmpEmp.FUseDefault = 0 )");
        }
        return str.toString();
    }

    private void syncOrgPosi(String filterSql, boolean isSyncOutOfPerm, String orgRangeSql, Map<String, CmpIntelSynOrgPositionInfo> synOrgPosMap, Set<String> fidList, java.util.Date date) throws BOSException, SQLException {
        String updateSql = "update T_HR_SCmpCalTable set FAdminOrgUnitID = ?,FLongNumber = ?,FCostBearOrgID = ?,FPositionID = ?,FJobID = ?,FEmpPosOrgRelationID = ? where fid = ? ";
        String customFilter = " and (TT.FEmpPosOrgRelationID!=emp.fid or (TT.FEmpPosOrgRelationID is null and emp.fid is not null) or TT.FAdminOrgUnitID!=emp.FADMINORGID or TT.FPositionID!=emp.FPOSITIONID) ";
        String selectSql = this.getUpdateOrgPosSql(filterSql, isSyncOutOfPerm, orgRangeSql, date);
        selectSql = selectSql + customFilter;
        ArrayList<Object[]> executeBatchParamList = new ArrayList<Object[]>();
        IRowSet rowSet = SqlUtil.executeQuery(this.ctx, selectSql);
        while (rowSet.next()) {
            Object[] executeBatchParam = new Object[]{rowSet.getString("ADMINORGUNITID"), rowSet.getString("LONGNUMBER"), rowSet.getString("ADMINORGUNITID"), rowSet.getString("POSITIONID"), rowSet.getString("POSITIONJOBID"), rowSet.getString("EMPORGRELATIONID"), rowSet.getString("CALID")};
            executeBatchParamList.add(executeBatchParam);
            String callId = rowSet.getString("CALID");
            if (!synOrgPosMap.containsKey(callId)) continue;
            CmpIntelSynOrgPositionInfo info = synOrgPosMap.get(callId);
            EmpPosOrgRelationInfo relationInfo = null;
            if (!StringUtils.isEmpty((CharSequence)rowSet.getString("EMPORGRELATIONID"))) {
                relationInfo = new EmpPosOrgRelationInfo();
                relationInfo.setId(BOSUuid.read((String)rowSet.getString("EMPORGRELATIONID")));
            }
            info.setNewEmpOrgRelation(relationInfo);
            AdminOrgUnitInfo unitInfo = null;
            if (!StringUtils.isEmpty((CharSequence)rowSet.getString("ADMINORGUNITID"))) {
                unitInfo = new AdminOrgUnitInfo();
                unitInfo.setId(BOSUuid.read((String)rowSet.getString("ADMINORGUNITID")));
            }
            info.setNewAdminOrg(unitInfo);
            PositionInfo position = null;
            if (!StringUtils.isEmpty((CharSequence)rowSet.getString("POSITIONID"))) {
                position = new PositionInfo();
                position.setId(BOSUuid.read((String)rowSet.getString("POSITIONID")));
            }
            info.setNewPosition(position);
            HRJobInfo job = null;
            if (!StringUtils.isEmpty((CharSequence)rowSet.getString("POSITIONJOBID"))) {
                job = new HRJobInfo();
                job.setId(BOSUuid.read((String)rowSet.getString("POSITIONJOBID")));
            }
            info.setNewHRJob(job);
            fidList.add(callId);
        }
        if (!CollectionUtils.isEmpty(executeBatchParamList)) {
            SqlUtil.executeBatch(this.ctx, updateSql, executeBatchParamList);
        }
    }

    private void syncEmpType(String filterSql, java.util.Date actualDate, boolean isSyncOutOfPerm, String orgRangeSql, Map<String, CmpIntelSynOrgPositionInfo> synOrgPosMap, Set<String> fidList) throws BOSException, SQLException {
        String updateSql = "update T_HR_SCmpCalTable set FEmployeeTypeID = ? where fid = ? ";
        String customFilter = "";
        String selectSql = this.getUpdateEmployeeTypeSql(actualDate, filterSql, isSyncOutOfPerm, orgRangeSql);
        selectSql = selectSql + customFilter;
        selectSql = selectSql + " order by empLaborHis.fstartdatetime desc";
        ArrayList<Object[]> executeBatchParamList = new ArrayList<Object[]>();
        IRowSet rowSet = SqlUtil.executeQuery(this.ctx, selectSql);
        String calId = "";
        String calEmpType = "";
        String employTypeId = "";
        HashSet<String> calIds = new HashSet<String>();
        ArrayList<String> syncFailedPerson = new ArrayList<String>();
        String personName = "";
        while (rowSet.next()) {
            Object[] executeBatchParam = new Object[2];
            calId = rowSet.getString("calId");
            employTypeId = rowSet.getString("employTypeId");
            calEmpType = rowSet.getString("calEmpType");
            if (calIds.contains(calId)) continue;
            calIds.add(calId);
            if (null == employTypeId) {
                personName = rowSet.getString("personName");
                syncFailedPerson.add(personName);
                continue;
            }
            if (null != employTypeId && employTypeId.equals(calEmpType)) continue;
            executeBatchParam[0] = employTypeId;
            executeBatchParam[1] = calId;
            executeBatchParamList.add(executeBatchParam);
            if (!synOrgPosMap.containsKey(calId)) continue;
            CmpIntelSynOrgPositionInfo info = synOrgPosMap.get(calId);
            EmployeeTypeInfo typeInfo = new EmployeeTypeInfo();
            typeInfo.setId(BOSUuid.read((String)employTypeId));
            info.setNewEmployeeType(typeInfo);
            synOrgPosMap.put(calId, info);
            fidList.add(calId);
        }
        if (!CollectionUtils.isEmpty(executeBatchParamList)) {
            SqlUtil.executeBatch(this.ctx, updateSql, executeBatchParamList);
        }
    }

    private String getUpdateEmployeeTypeSql(java.util.Date endDate, String filterSql, boolean isSyncOutOfPerm, String orgRangeSql) {
        String sqlDate = CmpDateUtil.toKSqlDate(endDate);
        StringBuffer str = new StringBuffer();
        String sqlDateAdd1 = CmpDateUtil.toKSqlDate(CmpDateUtil.getAddDate(endDate, 1));
        String l = LocaleUtils.getShortCode((Context)this.ctx);
        str.append(" select calTable.fid calId,empType.fid employTypeId, calTable.FEmployeeTypeID calEmpType,person.fname_" + l + " personName  ").append("\r\n");
        str.append("   from T_HR_SCMPCALTABLE calTable ").append("\r\n");
        str.append("   left join T_HR_EMPLABORRELATIONHIS empLaborHis on calTable.fpersonid=empLaborHis.fpersonid ").append("\r\n");
        str.append("   left join T_HR_BDEMPLOYEETYPE empType on empType.fid=empLaborHis.flaborrelationstateid ").append("\r\n");
        str.append("   inner join T_BD_PERSON person on calTable.fpersonid=person.fid ").append("\r\n");
        str.append("  where calTable.fid in (").append(filterSql).append(") and calTable.FCALUPDATETYPE=1 ").append("\r\n");
        str.append("    and empLaborHis.fstartdatetime<").append(sqlDateAdd1).append(" and empLaborHis.fenddatetime>=").append(sqlDate).append(" ").append("\r\n");
        if (!isSyncOutOfPerm) {
            str.append(" and exists (select 1 from ").append(orgRangeSql).append(" temp where calTable.fadminorgunitid = temp.fid").append(")\r\n ");
        }
        return str.toString();
    }

    private boolean checkHRJob(CmpIntelSynOrgPositionInfo info) {
        boolean hRJobFlag = false;
        hRJobFlag = info.getOldHRJob() == null && info.getNewHRJob() == null ? false : (info.getOldHRJob() == null && info.getNewHRJob() != null ? true : (info.getOldHRJob() != null && info.getNewHRJob() == null ? true : !info.getOldHRJob().getId().toString().equals(String.valueOf(info.getNewHRJob().getId()))));
        return hRJobFlag;
    }

    private boolean checkPosition(CmpIntelSynOrgPositionInfo info) {
        boolean positionFlag = false;
        positionFlag = info.getOldPosition() == null && info.getNewPosition() == null ? false : (info.getOldPosition() == null && info.getNewPosition() != null ? true : (info.getOldPosition() != null && info.getNewPosition() == null ? true : !info.getOldPosition().getId().toString().equals(String.valueOf(info.getNewPosition().getId()))));
        return positionFlag;
    }

    private boolean checkAdminOrg(CmpIntelSynOrgPositionInfo info) {
        boolean adminOrgFlag = false;
        adminOrgFlag = info.getOldAdminOrg() == null && info.getNewAdminOrg() == null ? false : (info.getOldAdminOrg() == null && info.getNewAdminOrg() != null ? true : (info.getOldAdminOrg() != null && info.getNewAdminOrg() == null ? true : !info.getOldAdminOrg().getId().toString().equals(String.valueOf(info.getNewAdminOrg().getId()))));
        return adminOrgFlag;
    }

    private boolean checkRealEndDate(CmpIntelSynOrgPositionInfo info) {
        boolean realEndDateFlag = false;
        realEndDateFlag = info.getOldRealEndDate() == null && info.getNewRealEndDate() == null ? false : (info.getOldRealEndDate() == null && info.getNewRealEndDate() != null ? true : (info.getOldRealEndDate() != null && info.getNewRealEndDate() == null ? true : info.getOldRealEndDate().compareTo(info.getNewRealEndDate()) != 0));
        return realEndDateFlag;
    }

    private boolean checkEmployeeType(CmpIntelSynOrgPositionInfo info) {
        boolean employeeTypeFlag = false;
        employeeTypeFlag = info.getOldEmployeeType() == null && info.getNewEmployeeType() == null ? false : (info.getOldEmployeeType() == null && info.getNewEmployeeType() != null ? true : (info.getOldEmployeeType() != null && info.getNewEmployeeType() == null ? true : !info.getOldEmployeeType().getId().toString().equals(info.getNewEmployeeType().getId().toString())));
        return employeeTypeFlag;
    }

    private boolean checkEmpOrgRelation(CmpIntelSynOrgPositionInfo info) {
        boolean empOrgRelationFlag = false;
        empOrgRelationFlag = info.getOldEmpOrgRelation() == null && info.getNewEmpOrgRelation() == null ? false : (info.getOldEmpOrgRelation() == null && info.getNewEmpOrgRelation() != null ? true : (info.getOldEmpOrgRelation() != null && info.getNewEmpOrgRelation() == null ? true : !info.getOldEmpOrgRelation().getId().toString().equals(String.valueOf(info.getNewEmpOrgRelation().getId()))));
        return empOrgRelationFlag;
    }

    private void setCalendarLastDay(Calendar calendar) {
        calendar.set(5, calendar.getActualMaximum(5));
    }

    public String getBizManageType() {
        return this.bizManageType;
    }

    public void setBizManageType(String bizManageType) {
        this.bizManageType = bizManageType;
    }

    public String getBizManageTypeId() {
        return this.bizManageTypeId;
    }

    public void setBizManageTypeId(String bizManageTypeId) {
        this.bizManageTypeId = bizManageTypeId;
    }

    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public boolean isHasDate() {
        return this.hasDate;
    }

    public void setHasDate(boolean hasDate) {
        this.hasDate = hasDate;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public void setCatalogId(String catalogId) {
        this.catalogId = catalogId;
    }

    public String getEntity() {
        return this.entity;
    }

    public void setEntity(String entity) {
        this.entity = entity;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public Map<String, Object> getCacheMap() {
        return this.cacheMap;
    }

    public void setCacheMap(Map<String, Object> cacheMap) {
        this.cacheMap = cacheMap;
        this.debug = (Boolean)cacheMap.get("debug");
    }
}

