/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.intelligent.resolve;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelFilterInfo;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelFilterType;
import com.kingdee.shr.compensation.intelligent.dto.MatchEntry;
import com.kingdee.shr.compensation.intelligent.dto.SmartMatchSet;
import com.kingdee.shr.compensation.intelligent.dto.json.CustomFilter;
import com.kingdee.shr.compensation.intelligent.translator.CmpIntelligentFilterStore;
import com.kingdee.shr.compensation.intelligent.translator.CmpIntelligentTranslatorStore;
import com.kingdee.shr.compensation.intelligent.translator.ICmpFilterTrans;
import com.kingdee.shr.compensation.intelligent.util.CmpIntelligentFilterUtil;
import com.kingdee.shr.compensation.intelligent.util.CmpIntelligentUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import java.util.HashMap;
import java.util.Map;

public class CmpIntelligentResolve {
    private static final CmpIntelligentResolve cmpIntelligentResolve = new CmpIntelligentResolve();

    private CmpIntelligentResolve() {
    }

    public static CmpIntelligentResolve getInstance() {
        return cmpIntelligentResolve;
    }

    public SmartMatchSet getMatchSet(String jsonStr) {
        SmartMatchSet smartMatchSet = new SmartMatchSet();
        smartMatchSet = CmpIntelligentUtil.getJsonObj(jsonStr, smartMatchSet);
        return smartMatchSet;
    }

    public Map<String, Object> getEntryFilterData(Context ctx, String sourceEntity, MatchEntry matchEntry) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String entryId = matchEntry.getEntryId();
        Map<String, Object> originMap = matchEntry.getOrigin();
        Map<String, Object> targetMap = matchEntry.getTarget();
        Map<String, Object> originValueMap = this.parseFilterData(ctx, sourceEntity, originMap);
        Map<String, Object> targetValueMap = this.parseFilterData(ctx, sourceEntity, targetMap);
        result.put("entryId", entryId);
        result.put("origin", originValueMap);
        result.put("target", targetValueMap);
        return result;
    }

    private Map<String, Object> parseFilterData(Context ctx, String sourceEntity, Map<String, Object> filterData) {
        Map<String, Object> filterMap = this.getFilterMap(ctx);
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, String> orgLongNumberMap = CmpIntelligentUtil.getOrgLongNumberMap(ctx);
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        customParam.put("longNumberMap", orgLongNumberMap);
        customParam.put("tableName", "t_org_admin");
        CmpIntelligentTranslatorStore translatorStore = CmpIntelligentTranslatorStore.getInstance();
        CmpIntelFilterType type = null;
        String field = "";
        String keyWord = "";
        String key = "";
        Object value = null;
        CmpIntelFilterInfo filterInfo = null;
        ICmpFilterTrans translator = null;
        for (Map.Entry<String, Object> entry : filterData.entrySet()) {
            keyWord = entry.getKey();
            value = entry.getValue();
            if (CmpStrUtil.isNullOrEmpty(value)) continue;
            if (keyWord.equals("customFilter")) {
                CustomFilter customFilter = (CustomFilter)JSONObject.parseObject((String)JSONObject.toJSONString((Object)value), CustomFilter.class);
                if (customFilter == null) continue;
                String customCondition = CmpIntelligentFilterUtil.getOtherFilterNew(ctx, customFilter, null);
                result.put(keyWord, " id in ( " + customCondition + " ) ");
                continue;
            }
            if (keyWord.equals("wrapDate") || keyWord.equals("loseDate")) {
                result.put(keyWord, value);
                continue;
            }
            key = sourceEntity + "_" + keyWord;
            if (!filterMap.containsKey(key)) {
                result.put(keyWord, value);
                continue;
            }
            filterInfo = (CmpIntelFilterInfo)filterMap.get(key);
            field = filterInfo.getField();
            type = filterInfo.getType();
            translator = translatorStore.getTranslator(type.getName());
            if (type.equals((Object)CmpIntelFilterType.TREE)) {
                translator.setParam(customParam);
            }
            value = translator.translate(field, JSONObject.toJSONString((Object)value));
            result.put(keyWord, value);
        }
        return result;
    }

    private Map<String, Object> getFilterMap(Context ctx) {
        CmpIntelligentFilterStore filterStore = new CmpIntelligentFilterStore(ctx);
        Map<String, Object> filterMap = filterStore.getFilterMap();
        return filterMap;
    }
}

