/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.intelligent.validate;

import com.kingdee.bos.Context;
import com.kingdee.shr.compensation.intelligent.validate.AbstractCmpIntelValidator;
import com.kingdee.shr.compensation.intelligent.validate.AdjPersonDecreaseValidator;
import com.kingdee.shr.compensation.intelligent.validate.AdjPersonIncreaseValidator;
import com.kingdee.shr.compensation.intelligent.validate.CmpPersonDecreaseValidator;
import com.kingdee.shr.compensation.intelligent.validate.CmpPersonIncreaseValidator;
import com.kingdee.shr.compensation.intelligent.validate.CmpSchemeDecreasePersonValidator;
import com.kingdee.shr.compensation.intelligent.validate.CmpSchemeIncreasePersonValidator;
import com.kingdee.shr.compensation.intelligent.validate.CmpSyncOrgPositionValidator;
import com.kingdee.shr.compensation.intelligent.validate.CmpSystemPersonValidator;
import com.kingdee.shr.compensation.intelligent.validate.SocPersonDecreaseValidator;
import com.kingdee.shr.compensation.intelligent.validate.SocPersonIncreaseValidator;
import com.kingdee.shr.compensation.intelligent.validate.TaxUnitSyncPersonValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class CmpIntelValidatorExecutor {
    private Map<String, AbstractCmpIntelValidator> validatorMap = new HashMap<String, AbstractCmpIntelValidator>();
    private Map<String, List<String>> entryMap = new HashMap<String, List<String>>();
    private List<String> errorMsgList = new ArrayList<String>();

    public CmpIntelValidatorExecutor() {
        this.addValidator("dXnEoek1PUu9j27Ok50pOQB4WXA=", new CmpPersonIncreaseValidator());
        this.addValidator("MYXgmMrPNE+71jarE7cMAgB4WXA=", new CmpPersonDecreaseValidator());
        this.addValidator("ecnRgrVrakexjc9fhpQpwwB4WXA=", new SocPersonIncreaseValidator());
        this.addValidator("4zLXKaEJukGwTPFYcVyZlQB4WXA=", new SocPersonDecreaseValidator());
        this.addValidator("zICC5+gl8kG0Opqki7xwlQB4WXA=", new AdjPersonIncreaseValidator());
        this.addValidator("j1VYuzP+dkGCCfiC5xjJoQB4WXA=", new AdjPersonDecreaseValidator());
        this.addValidator("bhO18GJPsUGlp1aMQNubhAB4WXA=", new CmpSystemPersonValidator());
        this.addValidator("zAOYO3uW+E+4twZ3xNBPrgB4WXA=", new CmpSchemeIncreasePersonValidator());
        this.addValidator("UF3MyIHT8EaBGOoGPuo7GwB4WXA=", new CmpSchemeDecreasePersonValidator());
        this.addValidator("fVa9WCKmTEWBgtswxQH45gB4WXA=", new CmpSyncOrgPositionValidator());
        this.addValidator("wus2oLDetUG53juFxau19wB4WXA=", new TaxUnitSyncPersonValidator());
    }

    public void addValidator(String calalogId, AbstractCmpIntelValidator validator) {
        this.validatorMap.put(calalogId, validator);
    }

    public void addEntryData(String calalogId, String entryData) {
        if (!StringUtils.isEmpty((CharSequence)calalogId)) {
            List<String> entryDataList = this.entryMap.get(calalogId);
            if (entryDataList == null) {
                entryDataList = new ArrayList<String>();
            }
            entryDataList.add(entryData);
            this.entryMap.put(calalogId, entryDataList);
        }
    }

    public List<String> executeValidatorTask(Context ctx) {
        if (CollectionUtils.isEmpty(this.entryMap)) {
            return this.errorMsgList;
        }
        block0: for (Map.Entry<String, AbstractCmpIntelValidator> entrySet : this.validatorMap.entrySet()) {
            String calalogId = entrySet.getKey();
            AbstractCmpIntelValidator iCmpIntelValidator = entrySet.getValue();
            List<String> entryList = this.entryMap.get(calalogId);
            if (CollectionUtils.isEmpty(entryList) || iCmpIntelValidator == null) continue;
            for (String entryData : entryList) {
                String calalogName = iCmpIntelValidator.doValidate(entryData, ctx);
                if (StringUtils.isEmpty((CharSequence)calalogName)) continue;
                this.errorMsgList.add(calalogName);
                continue block0;
            }
        }
        return this.errorMsgList;
    }
}

